/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IICProxy;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.localhandlers.ILocalHandlerProvider;
import blusunrize.immersiveengineering.api.wires.localhandlers.IWorldTickable;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LocalWireNetwork
implements IWorldTickable {
    private final GlobalWireNetwork globalNet;
    private final Map<ConnectionPoint, Collection<Connection>> connections = new HashMap<ConnectionPoint, Collection<Connection>>();
    private final Map<BlockPos, IImmersiveConnectable> connectors = new HashMap<BlockPos, IImmersiveConnectable>();
    private final Map<ResourceLocation, LocalNetworkHandler> handlers = new Object2ObjectArrayMap();
    final Map<ResourceLocation, Multiset<ILocalHandlerProvider>> handlerUsers = new HashMap<ResourceLocation, Multiset<ILocalHandlerProvider>>();
    private List<Runnable> runNextTick = new ArrayList<Runnable>();
    private boolean isValid = true;

    public LocalWireNetwork(CompoundNBT subnet, GlobalWireNetwork globalNet) {
        this(globalNet);
        ListNBT proxies = subnet.func_150295_c("proxies", 10);
        for (INBT b : proxies) {
            IICProxy proxy = IICProxy.readFromNBT(((CompoundNBT)b).func_74775_l("proxy"));
            for (INBT p : ((CompoundNBT)b).func_150295_c("points", 10)) {
                ConnectionPoint point = new ConnectionPoint((CompoundNBT)p);
                this.addConnector(point, proxy);
            }
        }
        ListNBT wires = subnet.func_150295_c("wires", 10);
        for (INBT b : wires) {
            Connection wire = new Connection((CompoundNBT)b);
            if (this.connectors.containsKey(wire.getEndA().getPosition()) && this.connectors.containsKey(wire.getEndB().getPosition())) {
                this.addConnection(wire);
                continue;
            }
            WireLogger.logger.error("Wire from {} to {}, but connector points are {}", (Object)wire.getEndA(), (Object)wire.getEndB(), this.connectors);
        }
    }

    public LocalWireNetwork(GlobalWireNetwork globalNet) {
        this.globalNet = globalNet;
    }

    public CompoundNBT writeToNBT() {
        ListNBT wires = new ListNBT();
        for (ConnectionPoint p : this.connections.keySet()) {
            for (Connection conn : this.connections.get(p)) {
                if (!conn.isPositiveEnd(p)) continue;
                wires.add((Object)conn.toNBT());
            }
        }
        CompoundNBT ret = new CompoundNBT();
        ret.func_218657_a("wires", (INBT)wires);
        HashMultimap connsByBlock = HashMultimap.create();
        for (ConnectionPoint cp : this.connections.keySet()) {
            connsByBlock.put((Object)cp.getPosition(), (Object)cp);
        }
        ListNBT proxies = new ListNBT();
        for (BlockPos p : this.connectors.keySet()) {
            IImmersiveConnectable iic = this.connectors.get(p);
            IICProxy proxy = null;
            if (iic instanceof IICProxy) {
                proxy = (IICProxy)iic;
            } else if (iic instanceof TileEntity) {
                proxy = new IICProxy((TileEntity)iic);
            }
            if (proxy == null) continue;
            CompoundNBT complete = new CompoundNBT();
            complete.func_218657_a("proxy", (INBT)proxy.writeToNBT());
            ListNBT cps = new ListNBT();
            for (ConnectionPoint cp : connsByBlock.get((Object)p)) {
                cps.add((Object)cp.createTag());
            }
            complete.func_218657_a("points", (INBT)cps);
            proxies.add((Object)complete);
        }
        ret.func_218657_a("proxies", (INBT)proxies);
        return ret;
    }

    public Collection<BlockPos> getConnectors() {
        return Collections.unmodifiableCollection(this.connectors.keySet());
    }

    public IImmersiveConnectable getConnector(BlockPos pos) {
        assert (this.connectors.containsKey(pos));
        return this.connectors.get(pos);
    }

    public Collection<Connection> getConnections(BlockPos at) {
        return this.getConnections(new ConnectionPoint(at, 0));
    }

    public Collection<Connection> getConnections(ConnectionPoint at) {
        Collection<Connection> conns = this.connections.get(at);
        if (conns != null) {
            return Collections.unmodifiableCollection(conns);
        }
        return ImmutableSet.of();
    }

    void addConnector(ConnectionPoint p, IImmersiveConnectable iic) {
        Preconditions.checkState((!this.connections.containsKey(p) ? 1 : 0) != 0);
        this.connections.put(p, new ArrayList());
        if (!this.connectors.containsKey(p.getPosition())) {
            this.loadConnector(p.getPosition(), iic, true);
        } else {
            Preconditions.checkState((this.getConnector(p) == iic ? 1 : 0) != 0);
            this.addRequestedHandlers(iic);
        }
    }

    void loadConnector(BlockPos p, IImmersiveConnectable iic, boolean adding) {
        IImmersiveConnectable existingIIC = this.connectors.get(p);
        if (adding) {
            Preconditions.checkState((existingIIC == null ? 1 : 0) != 0);
        } else {
            Preconditions.checkState((boolean)(existingIIC instanceof IICProxy), (Object)("Loading connector with current IIC " + existingIIC));
        }
        this.connectors.put(p, iic);
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            if (!this.connections.containsKey(cp)) continue;
            this.addRequestedHandlers(iic);
            for (LocalNetworkHandler h : this.handlers.values()) {
                h.onConnectorLoaded(cp, iic);
            }
        }
    }

    void unloadConnector(BlockPos p) {
        IImmersiveConnectable iic = this.connectors.get(p);
        Preconditions.checkState((iic != null ? 1 : 0) != 0);
        Preconditions.checkState((!(iic instanceof IICProxy) ? 1 : 0) != 0);
        for (LocalNetworkHandler h : this.handlers.values()) {
            h.onConnectorUnloaded(p, iic);
        }
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            if (!this.connections.containsKey(cp)) continue;
            this.removeHandlersFor(iic);
        }
        this.connectors.put(p, new IICProxy((TileEntity)iic));
    }

    LocalWireNetwork merge(LocalWireNetwork other) {
        LocalWireNetwork result = new LocalWireNetwork(this.globalNet);
        for (LocalWireNetwork net : new LocalWireNetwork[]{this, other}) {
            result.connectors.putAll(net.connectors);
            result.connections.putAll(net.connections);
        }
        result.handlers.putAll(other.handlers);
        other.handlerUsers.forEach((rl, h) -> result.handlerUsers.put((ResourceLocation)rl, (Multiset<ILocalHandlerProvider>)HashMultiset.create((Iterable)h)));
        WireLogger.logger.info("Merging {} and {}", result.handlerUsers, this.handlerUsers);
        for (Map.Entry entry : this.handlers.entrySet()) {
            result.handlers.merge((ResourceLocation)entry.getKey(), (LocalNetworkHandler)entry.getValue(), LocalNetworkHandler::merge);
            result.handlerUsers.merge((ResourceLocation)entry.getKey(), (Multiset<ILocalHandlerProvider>)HashMultiset.create((Iterable)((Iterable)this.handlerUsers.get(entry.getKey()))), (BiFunction<Multiset<ILocalHandlerProvider>, Multiset<ILocalHandlerProvider>, Multiset<ILocalHandlerProvider>>)((BiFunction<Multiset, Multiset, Multiset>)(a, b) -> {
                a.addAll((Collection)b);
                return a;
            }));
            WireLogger.logger.info("Merged {} to {}", entry.getKey(), (Object)result.handlers.get(entry.getKey()));
        }
        WireLogger.logger.info("Result: {}", result.handlerUsers);
        for (Map.Entry entry : result.handlers.entrySet()) {
            ((LocalNetworkHandler)entry.getValue()).setLocalNet(result);
        }
        return result;
    }

    void removeConnection(Connection c) {
        for (ConnectionPoint end : new ConnectionPoint[]{c.getEndA(), c.getEndB()}) {
            boolean success = false;
            Collection<Connection> conns = this.connections.get(end);
            if (conns != null) {
                success = conns.remove(c);
            }
            if (success) continue;
            WireLogger.logger.error("Failed to remove {} from {}", (Object)c, (Object)c.getEndB());
        }
        for (ConnectionPoint end : new ConnectionPoint[]{c.getEndA(), c.getEndB()}) {
            IImmersiveConnectable connector = this.connectors.get(end.getPosition());
            if (connector == null) continue;
            connector.removeCable(c, end);
        }
        for (LocalNetworkHandler h : this.handlers.values()) {
            h.onConnectionRemoved(c);
        }
        this.removeHandlersFor(c.type);
    }

    void removeConnector(BlockPos p) {
        IImmersiveConnectable iic = this.connectors.get(p);
        if (iic == null) {
            for (ConnectionPoint point : this.getConnectionPoints()) {
                if (!point.getPosition().equals((Object)p)) continue;
                WireLogger.logger.info("Cancelling, but connections {} at {} still exist!", this.connections.get(point), (Object)point);
            }
            WireLogger.logger.info("Cancelled");
            return;
        }
        for (ConnectionPoint point : iic.getConnectionPoints()) {
            if (!this.connections.containsKey(point)) continue;
            this.removeHandlersFor(iic);
            for (Connection c : this.getConnections(point)) {
                ConnectionPoint other = c.getOtherEnd(point);
                Collection<Connection> connsOther = this.connections.get(other);
                if (connsOther == null) continue;
                connsOther.remove(c);
            }
            this.connections.remove(point);
        }
        this.connectors.remove(p);
        for (LocalNetworkHandler h : this.handlers.values()) {
            h.onConnectorRemoved(p, iic);
        }
    }

    void addConnection(Connection conn) {
        IImmersiveConnectable connA = this.connectors.get(conn.getEndA().getPosition());
        Preconditions.checkNotNull((Object)connA, (Object)conn.getEndA().getPosition());
        IImmersiveConnectable connB = this.connectors.get(conn.getEndB().getPosition());
        Preconditions.checkNotNull((Object)connB, (Object)conn.getEndB().getPosition());
        if (this.connections.get(conn.getEndA()).stream().anyMatch(c -> c.getOtherEnd(conn.getEndA()).equals(conn.getEndB()))) {
            WireLogger.logger.error("Tried to add a duplicate connection from {} ({}) to {} ({})", (Object)conn.getEndA(), (Object)connA, (Object)conn.getEndB(), (Object)connB);
            return;
        }
        this.connections.get(conn.getEndA()).add(conn);
        this.connections.get(conn.getEndB()).add(conn);
        for (LocalNetworkHandler h : this.handlers.values()) {
            h.onConnectionAdded(conn);
        }
        this.addRequestedHandlers(conn.type);
    }

    private void removeHandlersFor(ILocalHandlerProvider iic) {
        for (ResourceLocation loc : iic.getRequestedHandlers()) {
            Preconditions.checkState((boolean)this.handlers.containsKey(loc), (Object)("Expected to find handler for " + loc + "(provided by " + iic + ")"));
            Multiset<ILocalHandlerProvider> providers = this.getProvidersFor(loc);
            Preconditions.checkState((boolean)providers.contains((Object)iic), (Object)("Expected to find handler " + iic + " for " + loc + ". Found: " + providers));
            providers.remove((Object)iic);
            WireLogger.logger.info("Removing {} from handlers for {}. Remaining: {}", (Object)iic, (Object)loc, providers);
            if (!providers.isEmpty()) continue;
            WireLogger.logger.info("Removing: {}", (Object)loc);
            this.handlers.remove(loc);
            this.handlerUsers.remove(loc);
        }
    }

    private void addRequestedHandlers(ILocalHandlerProvider provider) {
        for (ResourceLocation loc : provider.getRequestedHandlers()) {
            this.getProvidersFor(loc).add((Object)provider);
            if (!this.handlers.containsKey(loc)) {
                this.handlers.put(loc, LocalNetworkHandler.createHandler(loc, this));
            }
            WireLogger.logger.info("Adding handler {} for {}", (Object)loc, (Object)provider);
        }
    }

    private Multiset<ILocalHandlerProvider> getProvidersFor(ResourceLocation rl) {
        return this.handlerUsers.computeIfAbsent(rl, rl_ -> HashMultiset.create());
    }

    public Collection<ConnectionPoint> getConnectionPoints() {
        return this.connections.keySet();
    }

    Collection<LocalWireNetwork> split() {
        HashSet<ConnectionPoint> toVisit = new HashSet<ConnectionPoint>(this.getConnectionPoints());
        ArrayList<LocalWireNetwork> ret = new ArrayList<LocalWireNetwork>();
        while (!toVisit.isEmpty()) {
            Iterator tmpIt = toVisit.iterator();
            Collection<ConnectionPoint> inComponent = this.getConnectedComponent((ConnectionPoint)tmpIt.next(), toVisit);
            if (toVisit.size() == 0 && ret.size() == 0) break;
            LocalWireNetwork newNet = new LocalWireNetwork(this.globalNet);
            for (ConnectionPoint p : inComponent) {
                newNet.addConnector(p, this.connectors.get(p.getPosition()));
            }
            for (ConnectionPoint p : inComponent) {
                for (Connection c : this.getConnections(p)) {
                    if (!c.isPositiveEnd(p)) continue;
                    newNet.addConnection(c);
                }
            }
            ret.add(newNet);
            WireLogger.logger.info("Subnet after split: {}, users {}", (Object)newNet, newNet.handlerUsers);
        }
        WireLogger.logger.info("Split net! Now {} nets: {}", (Object)ret.size(), ret);
        return ret;
    }

    private Collection<ConnectionPoint> getConnectedComponent(ConnectionPoint start, Set<ConnectionPoint> unvisited) {
        ArrayDeque<ConnectionPoint> open = new ArrayDeque<ConnectionPoint>();
        ArrayList<ConnectionPoint> inComponent = new ArrayList<ConnectionPoint>();
        open.push(start);
        unvisited.remove(start);
        while (!open.isEmpty()) {
            ConnectionPoint curr = (ConnectionPoint)open.pop();
            inComponent.add(curr);
            for (Connection c : this.getConnections(curr)) {
                ConnectionPoint otherEnd = c.getOtherEnd(curr);
                if (!unvisited.contains(otherEnd)) continue;
                unvisited.remove(otherEnd);
                open.push(otherEnd);
            }
        }
        return inComponent;
    }

    public String toString() {
        return "Connectors: " + this.connectors + ", connections: " + this.connections;
    }

    public IImmersiveConnectable getConnector(ConnectionPoint cp) {
        return this.getConnector(cp.getPosition());
    }

    public GlobalWireNetwork getGlobal() {
        return this.globalNet;
    }

    @Override
    public void update(World w) {
        for (LocalNetworkHandler handler : this.handlers.values()) {
            if (!(handler instanceof IWorldTickable)) continue;
            ((IWorldTickable)((Object)handler)).update(w);
        }
        List<Runnable> toRun = this.runNextTick;
        this.runNextTick = new ArrayList<Runnable>();
        for (Runnable r : toRun) {
            r.run();
        }
    }

    @Nullable
    public <T extends LocalNetworkHandler> T getHandler(ResourceLocation name, Class<T> type) {
        LocalNetworkHandler p = this.handlers.get(name);
        if (p == null) {
            return null;
        }
        if (type.isInstance(p)) {
            return (T)p;
        }
        return null;
    }

    public Collection<LocalNetworkHandler> getAllHandlers() {
        return this.handlers.values();
    }

    public void addAsFutureTask(Runnable r) {
        this.runNextTick.add(r);
    }

    void removeCP(ConnectionPoint cp) {
        for (Connection c : this.getConnections(cp).toArray(new Connection[0])) {
            this.removeConnection(c);
        }
        this.connections.remove(cp);
        boolean hasMoreAtSameBlock = true;
        for (ConnectionPoint cp2 : this.connections.keySet()) {
            if (!cp.getPosition().equals((Object)cp2.getPosition())) continue;
            hasMoreAtSameBlock = false;
            break;
        }
        if (hasMoreAtSameBlock) {
            this.removeConnector(cp.getPosition());
        }
    }

    public void setInvalid() {
        this.isValid = false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isValid(ConnectionPoint cp) {
        return this.isValid && this.connections.containsKey(cp);
    }
}

