/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class NetHandlerCapability {
    @CapabilityInject(value=GlobalWireNetwork.class)
    public static Capability<GlobalWireNetwork> NET_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(GlobalWireNetwork.class, (Capability.IStorage)new Capability.IStorage<GlobalWireNetwork>(){

            public INBT writeNBT(Capability<GlobalWireNetwork> capability, GlobalWireNetwork instance, Direction side) {
                return instance.writeToNBT();
            }

            public void readNBT(Capability<GlobalWireNetwork> capability, GlobalWireNetwork instance, Direction side, INBT nbt) {
                instance.readFromNBT((CompoundNBT)nbt);
            }
        }, () -> {
            throw new IllegalStateException("Can not create global wire network without a world");
        });
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundNBT> {
        private final GlobalWireNetwork net;
        private final LazyOptional<GlobalWireNetwork> netOpt;

        public Provider(World w) {
            this.net = new GlobalWireNetwork(w);
            this.netOpt = CapabilityUtils.constantOptional(this.net);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == NET_CAPABILITY) {
                return this.netOpt.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return this.net.writeToNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.net.readFromNBT(nbt);
        }
    }
}

