/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.localhandlers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.ICollisionHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class WireDamageHandler
extends LocalNetworkHandler
implements ICollisionHandler {
    public static final ResourceLocation ID = new ResourceLocation("immersiveengineering", "wire_damage");
    private static final double KNOCKBACK_PER_DAMAGE = 10.0;

    public WireDamageHandler(LocalWireNetwork net) {
        super(net);
    }

    @Override
    public void onCollided(LivingEntity e, BlockPos pos, WireCollisionData.CollisionInfo info) {
        WireType wType = info.conn.type;
        if (!(wType instanceof IShockingWire)) {
            return;
        }
        EnergyTransferHandler energyHandler = this.getEnergyHandler();
        if (energyHandler == null) {
            return;
        }
        IShockingWire shockWire = (IShockingWire)((Object)wType);
        double extra = shockWire.getDamageRadius();
        AxisAlignedBB eAabb = e.func_174813_aQ();
        AxisAlignedBB includingExtra = eAabb.func_186662_g(extra).func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        boolean endpointsInEntity = includingExtra.func_72318_a(info.intersectA) || includingExtra.func_72318_a(info.intersectB);
        Optional rayRes = endpointsInEntity ? Optional.empty() : includingExtra.func_216365_b(info.intersectA, info.intersectB);
        Map<ConnectionPoint, EnergyTransferHandler.EnergyConnector> sources = energyHandler.getSources();
        if (!sources.isEmpty() && (endpointsInEntity || rayRes.isPresent())) {
            IEDamageSources.ElectricDamageSource dmg;
            Object2IntMap<ConnectionPoint> available = this.getAvailableEnergy(sources);
            HashMap<Object, EnergyTransferHandler.Path> paths = new HashMap<Object, EnergyTransferHandler.Path>();
            int totalAvailable = 0;
            ConnectionPoint target = info.conn.getEndA();
            for (Object2IntMap.Entry entry : available.object2IntEntrySet()) {
                EnergyTransferHandler.Path path = energyHandler.getPath((ConnectionPoint)entry.getKey(), target);
                if (path == null) continue;
                totalAvailable = (int)((double)totalAvailable + (double)entry.getIntValue() * (1.0 - path.loss));
                paths.put(entry.getKey(), path);
            }
            float maxPossibleDamage = shockWire.getDamageAmount((Entity)e, info.conn, totalAvailable = Math.min(totalAvailable, shockWire.getTransferRate()));
            if (maxPossibleDamage > 0.0f && (dmg = IEDamageSources.causeWireDamage(maxPossibleDamage, shockWire.getElectricSource())).apply((Entity)e)) {
                float actualDamage = dmg.dmg;
                Vec3d v = e.func_70040_Z();
                ApiUtils.knockbackNoSource(e, (double)actualDamage / 10.0, v.field_72450_a, v.field_72449_c);
                double factor = actualDamage / maxPossibleDamage;
                Object2DoubleMap<Connection> transferred = energyHandler.getTransferredNextTick();
                for (Object2IntMap.Entry entry : available.object2IntEntrySet()) {
                    EnergyTransferHandler.Path path = (EnergyTransferHandler.Path)paths.get(entry.getKey());
                    int availableFromSource = entry.getIntValue();
                    double energyFromSource = (double)availableFromSource * factor;
                    EnergyTransferHandler.EnergyConnector source = sources.get(entry.getKey());
                    source.extractEnergy(MathHelper.func_76143_f((double)energyFromSource));
                    for (Connection c : path.conns) {
                        transferred.mergeDouble((Object)c, energyFromSource, Double::sum);
                    }
                }
            }
        }
    }

    private Object2IntMap<ConnectionPoint> getAvailableEnergy(Map<ConnectionPoint, EnergyTransferHandler.EnergyConnector> sources) {
        Object2IntOpenHashMap ret = new Object2IntOpenHashMap();
        for (Map.Entry<ConnectionPoint, EnergyTransferHandler.EnergyConnector> c : sources.entrySet()) {
            int energy = c.getValue().getAvailableEnergy();
            if (energy <= 0) continue;
            ret.put((Object)c.getKey(), energy);
        }
        return ret;
    }

    private EnergyTransferHandler getEnergyHandler() {
        return this.net.getHandler(EnergyTransferHandler.ID, EnergyTransferHandler.class);
    }

    @Override
    public LocalNetworkHandler merge(LocalNetworkHandler other) {
        return this;
    }

    @Override
    public void onConnectorLoaded(ConnectionPoint p, IImmersiveConnectable iic) {
    }

    @Override
    public void onConnectorUnloaded(BlockPos p, IImmersiveConnectable iic) {
    }

    @Override
    public void onConnectorRemoved(BlockPos p, IImmersiveConnectable iic) {
    }

    @Override
    public void onConnectionAdded(Connection c) {
    }

    @Override
    public void onConnectionRemoved(Connection c) {
    }

    public static interface IShockingWire
    extends EnergyTransferHandler.IEnergyWire {
        public double getDamageRadius();

        public IElectricEquipment.ElectricSource getElectricSource();

        default public float getDamageAmount(Entity e, Connection c, int energy) {
            return 0.0f;
        }
    }
}

