/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.redstone;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import blusunrize.immersiveengineering.api.wires.redstone.IRedstoneConnector;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class RedstoneNetworkHandler
extends LocalNetworkHandler {
    public static final ResourceLocation ID = new ResourceLocation("immersiveengineering", "redstone");
    private byte[] values = new byte[16];

    public RedstoneNetworkHandler(LocalWireNetwork net) {
        super(net);
    }

    @Override
    public LocalNetworkHandler merge(LocalNetworkHandler other) {
        if (!(other instanceof RedstoneNetworkHandler)) {
            return new RedstoneNetworkHandler(this.net);
        }
        RedstoneNetworkHandler otherRS = (RedstoneNetworkHandler)other;
        RedstoneNetworkHandler ret = new RedstoneNetworkHandler(this.net);
        for (int i = 0; i < 16; ++i) {
            ret.values[i] = (byte)Math.max(this.values[i], otherRS.values[i]);
        }
        return ret;
    }

    @Override
    public void onConnectorLoaded(ConnectionPoint newCP, IImmersiveConnectable iic) {
        if (!(iic instanceof IRedstoneConnector)) {
            return;
        }
        this.net.addAsFutureTask(() -> {
            IRedstoneConnector rsConn = (IRedstoneConnector)iic;
            rsConn.updateInput(this.values, newCP);
            for (ConnectionPoint cp : this.net.getConnectionPoints()) {
                IImmersiveConnectable here = this.net.getConnector(cp);
                if (!(here instanceof IRedstoneConnector)) continue;
                ((IRedstoneConnector)here).onChange(cp, this);
            }
        });
    }

    public void updateValues() {
        IImmersiveConnectable here;
        this.values = new byte[16];
        for (ConnectionPoint cp : this.net.getConnectionPoints()) {
            here = this.net.getConnector(cp);
            if (!(here instanceof IRedstoneConnector)) continue;
            ((IRedstoneConnector)here).updateInput(this.values, cp);
        }
        for (ConnectionPoint cp : this.net.getConnectionPoints()) {
            here = this.net.getConnector(cp);
            if (!(here instanceof IRedstoneConnector)) continue;
            ((IRedstoneConnector)here).onChange(cp, this);
        }
    }

    @Override
    public void onConnectorUnloaded(BlockPos p, IImmersiveConnectable iic) {
        this.updateValues();
    }

    @Override
    public void onConnectorRemoved(BlockPos p, IImmersiveConnectable iic) {
        this.updateValues();
    }

    @Override
    public void onConnectionAdded(Connection c) {
    }

    @Override
    public void onConnectionRemoved(Connection c) {
    }

    @Override
    public void setLocalNet(LocalWireNetwork net) {
        super.setLocalNet(net);
        for (ConnectionPoint cp : net.getConnectionPoints()) {
            IImmersiveConnectable here = net.getConnector(cp);
            if (!(here instanceof IRedstoneConnector)) continue;
            ((IRedstoneConnector)here).onChange(cp, this);
        }
    }

    public byte getValue(int redstoneChannel) {
        return this.values[redstoneChannel];
    }
}

