/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.utils;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IICProxy;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.CatenaryTracer;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class WireUtils {
    public static Connection getConnectionMovedThrough(World world, LivingEntity e) {
        Vec3d start = e.func_174824_e(0.0f);
        Vec3d end = e.func_174824_e(1.0f);
        return WireUtils.raytraceWires(world, start, end, null);
    }

    public static Connection raytraceWires(World world, Vec3d start, Vec3d end, @Nullable Connection ignored) {
        GlobalWireNetwork global = GlobalWireNetwork.getNetwork(world);
        WireCollisionData collisionData = global.getCollisionData();
        AtomicReference ret = new AtomicReference();
        AtomicDouble minDistSq = new AtomicDouble(Double.POSITIVE_INFINITY);
        Utils.rayTrace(start, end, world, pos -> {
            Collection<WireCollisionData.CollisionInfo> infoAtPos = collisionData.getCollisionInfo((BlockPos)pos);
            for (WireCollisionData.CollisionInfo wireInfo : infoAtPos) {
                Connection c = wireInfo.conn;
                if (c.equals(ignored)) continue;
                Vec3d startRelative = start.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
                Vec3d across = wireInfo.intersectB.func_178788_d(wireInfo.intersectA);
                double t = Utils.getCoeffForMinDistance(startRelative, wireInfo.intersectA, across);
                Vec3d closest = wireInfo.intersectA.func_72441_c((t = MathHelper.func_151237_a((double)t, (double)0.0, (double)1.0)) * across.field_72450_a, t * across.field_72448_b, t * across.field_72449_c);
                double distSq = closest.func_72436_e(startRelative);
                if (!(distSq < minDistSq.get())) continue;
                ret.set(c);
                minDistSq.set(distSq);
            }
        });
        return (Connection)ret.get();
    }

    public static boolean preventsConnection(World worldIn, BlockPos pos, BlockState state, Vec3d a, Vec3d b) {
        for (AxisAlignedBB aabb : state.func_196952_d((IBlockReader)worldIn, pos).func_197756_d()) {
            if (!(aabb = aabb.func_186662_g(1.0E-5)).func_72318_a(a) && !aabb.func_72318_a(b) && !aabb.func_216365_b(a, b).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static Set<BlockPos> findObstructingBlocks(World world, Connection conn, Set<BlockPos> ignore) {
        TileEntity teA = world.func_175625_s(conn.getEndA().getPosition());
        TileEntity teB = world.func_175625_s(conn.getEndB().getPosition());
        HashSet<BlockPos> obstructions = new HashSet<BlockPos>();
        if (teA instanceof IImmersiveConnectable && teB instanceof IImmersiveConnectable) {
            Vec3d start = ((IImmersiveConnectable)teA).getConnectionOffset(conn, conn.getEndA());
            Vec3d end = ((IImmersiveConnectable)teB).getConnectionOffset(conn, conn.getEndB());
            ApiUtils.raytraceAlongCatenaryRelative(conn, p -> {
                if (!ignore.contains(p.getLeft())) {
                    BlockState state = world.func_180495_p((BlockPos)p.getLeft());
                    if (ApiUtils.preventsConnection(world, (BlockPos)p.getLeft(), state, (Vec3d)p.getMiddle(), (Vec3d)p.getRight())) {
                        obstructions.add((BlockPos)p.getLeft());
                    }
                }
            }, p -> {}, start, end.func_178787_e(new Vec3d((Vec3i)conn.getEndB().getPosition().func_177973_b((Vec3i)conn.getEndA().getPosition()))));
        }
        return obstructions;
    }

    public static WireType getWireTypeFromNBT(CompoundNBT tag, String key) {
        return WireType.getValue(tag.func_74779_i(key));
    }

    public static void raytraceAlongCatenary(Connection conn, LocalWireNetwork net, Consumer<Triple<BlockPos, Vec3d, Vec3d>> in, Consumer<Triple<BlockPos, Vec3d, Vec3d>> close) {
        Vec3d vStart = WireUtils.getVecForIICAt(net, conn.getEndA(), conn, false);
        Vec3d vEnd = WireUtils.getVecForIICAt(net, conn.getEndB(), conn, true);
        WireUtils.raytraceAlongCatenaryRelative(conn, in, close, vStart, vEnd);
    }

    public static void raytraceAlongCatenaryRelative(Connection conn, Consumer<Triple<BlockPos, Vec3d, Vec3d>> in, Consumer<Triple<BlockPos, Vec3d, Vec3d>> close, Vec3d vStart, Vec3d vEnd) {
        conn.generateCatenaryData(vStart, vEnd);
        BlockPos offset = conn.getEndA().getPosition();
        WireUtils.raytraceAlongCatenary(conn.getCatenaryData(), offset, in, close);
    }

    public static void raytraceAlongCatenary(Connection.CatenaryData data, BlockPos offset, Consumer<Triple<BlockPos, Vec3d, Vec3d>> in, Consumer<Triple<BlockPos, Vec3d, Vec3d>> close) {
        CatenaryTracer ct = new CatenaryTracer(data, offset);
        ct.calculateIntegerIntersections();
        ct.forEachSegment(segment -> {
            if (segment.inBlock) {
                in.accept((Triple<BlockPos, Vec3d, Vec3d>)new ImmutableTriple((Object)segment.mainPos, (Object)segment.relativeSegmentStart, (Object)segment.relativeSegmentEnd));
            } else {
                close.accept((Triple<BlockPos, Vec3d, Vec3d>)new ImmutableTriple((Object)segment.mainPos, (Object)segment.relativeSegmentStart, (Object)segment.relativeSegmentEnd));
            }
        });
    }

    public static Vec3d[] getConnectionCatenary(Vec3d start, Vec3d end, double slack) {
        int vertices = 17;
        double dx = end.field_72450_a - start.field_72450_a;
        double dy = end.field_72448_b - start.field_72448_b;
        double dz = end.field_72449_c - start.field_72449_c;
        double dw = Math.sqrt(dx * dx + dz * dz);
        double k = Math.sqrt(dx * dx + dy * dy + dz * dz) * slack;
        double l = 0.0;
        for (int limiter = 0; limiter < 300; ++limiter) {
            if (!(Math.sinh(l += 0.01) / l >= Math.sqrt(k * k - dy * dy) / dw)) continue;
        }
        double a = dw / 2.0 / l;
        double offsetX = (0.0 + dw - a * Math.log((k + dy) / (k - dy))) * 0.5;
        double offsetY = (dy + 0.0 - k * Math.cosh(l) / Math.sinh(l)) * 0.5;
        Vec3d[] vex = new Vec3d[18];
        vex[0] = new Vec3d(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        for (int i = 1; i < 17; ++i) {
            float posRelative = (float)i / 17.0f;
            double x = 0.0 + dx * (double)posRelative;
            double z = 0.0 + dz * (double)posRelative;
            double y = a * Math.cosh((dw * (double)posRelative - offsetX) / a) + offsetY;
            vex[i] = new Vec3d(start.field_72450_a + x, start.field_72448_b + y, start.field_72449_c + z);
        }
        vex[17] = new Vec3d(end.field_72450_a, end.field_72448_b, end.field_72449_c);
        return vex;
    }

    @Deprecated
    public static IImmersiveConnectable toIIC(Object object, World world) {
        return WireUtils.toIIC(object, world, true);
    }

    @Deprecated
    public static IImmersiveConnectable toIIC(Object object, World world, boolean allowProxies) {
        if (object instanceof IImmersiveConnectable) {
            return (IImmersiveConnectable)object;
        }
        if (object instanceof BlockPos) {
            BlockPos pos = (BlockPos)object;
            if (world != null && (allowProxies || world.func_175667_e(pos))) {
                return GlobalWireNetwork.getNetwork(world).getLocalNet(pos).getConnector(pos);
            }
        }
        return null;
    }

    public static Vec3d getVecForIICAt(LocalWireNetwork net, ConnectionPoint pos, Connection conn, boolean fromOtherEnd) {
        Vec3d offset = Vec3d.field_186680_a;
        IImmersiveConnectable iicPos = net.getConnector(pos.getPosition());
        Preconditions.checkArgument((!(iicPos instanceof IICProxy) ? 1 : 0) != 0);
        if (iicPos != null) {
            offset = iicPos.getConnectionOffset(conn, pos);
        }
        if (fromOtherEnd) {
            BlockPos posA = pos.getPosition();
            BlockPos posB = conn.getOtherEnd(pos).getPosition();
            offset = offset.func_72441_c((double)(posA.func_177958_n() - posB.func_177958_n()), (double)(posA.func_177956_o() - posB.func_177956_o()), (double)(posA.func_177952_p() - posB.func_177952_p()));
        }
        return offset;
    }

    public static BlockPos toBlockPos(Object object) {
        if (object instanceof BlockPos) {
            return (BlockPos)object;
        }
        if (object instanceof TileEntity) {
            return ((TileEntity)object).func_174877_v();
        }
        if (object instanceof IICProxy) {
            return ((IICProxy)object).getPos();
        }
        return null;
    }

    public static Connection getTargetConnection(World world, PlayerEntity player, Connection ignored, double maxDistance) {
        Vec3d look = player.func_70040_Z();
        Vec3d start = player.func_174824_e(1.0f);
        Vec3d end = start.func_178787_e(look.func_186678_a(maxDistance));
        return WireUtils.raytraceWires(world, start, end, ignored);
    }

    public static void moveConnectionEnd(Connection conn, ConnectionPoint currEnd, ConnectionPoint newEnd, World world) {
        ConnectionPoint fixedPos = conn.getOtherEnd(currEnd);
        GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(world);
        globalNet.removeConnection(conn);
        globalNet.addConnection(new Connection(conn.type, fixedPos, newEnd));
    }
}

