/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.IWireCoil;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WirecoilUtils;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.font.IEFontRender;
import blusunrize.immersiveengineering.client.fx.FractalParticle;
import blusunrize.immersiveengineering.client.gui.BlastFurnaceScreen;
import blusunrize.immersiveengineering.client.gui.RevolverScreen;
import blusunrize.immersiveengineering.client.render.tile.AutoWorkbenchRenderer;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.wooden.TurntableTileEntity;
import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.EarmuffsItem;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.items.FluorescentTubeItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import blusunrize.immersiveengineering.common.network.MessageMagnetEquip;
import blusunrize.immersiveengineering.common.network.MessageRequestBlockUpdate;
import blusunrize.immersiveengineering.common.network.MessageRevolverRotate;
import blusunrize.immersiveengineering.common.network.MessageScrollwheelItem;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.sound.IEMuffledSound;
import blusunrize.immersiveengineering.common.util.sound.IEMuffledTickableSound;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.commons.lang3.tuple.Pair;

public class ClientEventHandler
implements ISelectiveResourceReloadListener {
    private boolean shieldToggleButton = false;
    private int shieldToggleTimer = 0;
    private static final String[] BULLET_TOOLTIP = new String[]{"  IE ", "  AMMO ", "  HERE ", "  -- "};
    public static final Map<Connection, Pair<Collection<BlockPos>, AtomicInteger>> FAILED_CONNECTIONS = new HashMap<Connection, Pair<Collection<BlockPos>, AtomicInteger>>();
    private static final float[][] quarterRotationArrowCoords = new float[][]{{0.375f, 0.0f}, {0.5f, -0.125f}, {0.4375f, -0.125f}, {0.4375f, -0.25f}, {0.25f, -0.4375f}, {0.0f, -0.4375f}, {0.0f, -0.3125f}, {0.1875f, -0.3125f}, {0.3125f, -0.1875f}, {0.3125f, -0.125f}, {0.25f, -0.125f}};
    private static final float[][] quarterRotationArrowQuads = new float[][]{quarterRotationArrowCoords[5], quarterRotationArrowCoords[6], quarterRotationArrowCoords[4], quarterRotationArrowCoords[7], quarterRotationArrowCoords[3], quarterRotationArrowCoords[8], quarterRotationArrowCoords[2], quarterRotationArrowCoords[9], quarterRotationArrowCoords[1], quarterRotationArrowCoords[10], quarterRotationArrowCoords[0], quarterRotationArrowCoords[0]};
    private static final float[][] halfRotationArrowCoords = new float[][]{{0.375f, 0.0f}, {0.5f, -0.125f}, {0.4375f, -0.125f}, {0.4375f, -0.25f}, {0.25f, -0.4375f}, {-0.25f, -0.4375f}, {-0.4375f, -0.25f}, {-0.4375f, -0.0625f}, {-0.3125f, -0.0625f}, {-0.3125f, -0.1875f}, {-0.1875f, -0.3125f}, {0.1875f, -0.3125f}, {0.3125f, -0.1875f}, {0.3125f, -0.125f}, {0.25f, -0.125f}};
    private static final float[][] halfRotationArrowQuads = new float[][]{halfRotationArrowCoords[7], halfRotationArrowCoords[8], halfRotationArrowCoords[6], halfRotationArrowCoords[9], halfRotationArrowCoords[5], halfRotationArrowCoords[10], halfRotationArrowCoords[4], halfRotationArrowCoords[11], halfRotationArrowCoords[3], halfRotationArrowCoords[12], halfRotationArrowCoords[2], halfRotationArrowCoords[13], halfRotationArrowCoords[1], halfRotationArrowCoords[14], halfRotationArrowCoords[0], halfRotationArrowCoords[0]};
    private static final float[][] arrowCoords = new float[][]{{0.0f, 0.375f}, {0.3125f, 0.0625f}, {0.125f, 0.0625f}, {0.125f, -0.375f}, {-0.125f, -0.375f}, {-0.125f, 0.0625f}, {-0.3125f, 0.0625f}};

    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            ImmersiveEngineering.proxy.clearRenderCaches();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.player != null && event.player == ClientUtils.mc().func_175606_aa() && event.phase == TickEvent.Phase.END) {
            ItemStack held;
            if (this.shieldToggleTimer > 0) {
                --this.shieldToggleTimer;
            }
            if (ClientProxy.keybind_magnetEquip.func_151470_d() && !this.shieldToggleButton) {
                if (this.shieldToggleTimer <= 0) {
                    this.shieldToggleTimer = 7;
                } else {
                    PlayerEntity player = event.player;
                    ItemStack held2 = player.func_184586_b(Hand.OFF_HAND);
                    if (!held2.func_190926_b() && held2.func_77973_b() instanceof IEShieldItem) {
                        if (((IEShieldItem)held2.func_77973_b()).getUpgrades(held2).func_74767_n("magnet") && ((IEShieldItem)held2.func_77973_b()).getUpgrades(held2).func_74764_b("prevSlot")) {
                            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageMagnetEquip(-1));
                        }
                    } else {
                        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                            ItemStack s = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                            if (s.func_190926_b() || !(s.func_77973_b() instanceof IEShieldItem) || !((IEShieldItem)s.func_77973_b()).getUpgrades(s).func_74767_n("magnet")) continue;
                            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageMagnetEquip(i));
                        }
                    }
                }
            }
            if (this.shieldToggleButton != ClientUtils.mc().field_71474_y.field_74368_y.func_151470_d()) {
                this.shieldToggleButton = ClientUtils.mc().field_71474_y.field_74368_y.func_151470_d();
            }
            if (!ClientProxy.keybind_chemthrowerSwitch.func_197986_j() && ClientProxy.keybind_chemthrowerSwitch.func_151468_f() && (held = event.player.func_184586_b(Hand.MAIN_HAND)).func_77973_b() instanceof IEItemInterfaces.IScrollwheel) {
                ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageScrollwheelItem(true));
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        FAILED_CONNECTIONS.entrySet().removeIf(entry -> ((AtomicInteger)((Pair)entry.getValue()).getValue()).decrementAndGet() <= 0);
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        ItemStack powerpack;
        ItemStack earmuffs;
        event.getItemStack();
        if (event.getItemStack().func_190926_b()) {
            return;
        }
        event.getItemStack().getCapability(CapabilityShader.SHADER_CAPABILITY).ifPresent(wrapper -> {
            ItemStack shader = wrapper.getShaderItem();
            if (!shader.func_190926_b()) {
                event.getToolTip().add(shader.func_200301_q().func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY)));
            }
        });
        Style gray = new Style().func_150238_a(TextFormatting.GRAY);
        if (ItemNBTHelper.hasKey(event.getItemStack(), "IE:Earmuffs") && !(earmuffs = ItemNBTHelper.getItemStack(event.getItemStack(), "IE:Earmuffs")).func_190926_b()) {
            event.getToolTip().add(earmuffs.func_200301_q().func_150255_a(gray));
        }
        if (ItemNBTHelper.hasKey(event.getItemStack(), "IE:Powerpack") && !(powerpack = ItemNBTHelper.getItemStack(event.getItemStack(), "IE:Powerpack")).func_190926_b()) {
            event.getToolTip().add(powerpack.func_200301_q().func_150255_a(gray));
            event.getToolTip().add(new StringTextComponent(EnergyHelper.getEnergyStored((ICapabilityProvider)powerpack) + "/" + EnergyHelper.getMaxEnergyStored((ICapabilityProvider)powerpack) + " IF").func_150255_a(gray));
        }
        if (ClientUtils.mc().field_71462_r != null && ClientUtils.mc().field_71462_r instanceof BlastFurnaceScreen && BlastFurnaceFuel.isValidBlastFuel(event.getItemStack())) {
            event.getToolTip().add(new TranslationTextComponent("desc.immersiveengineering.info.blastFuelTime", new Object[]{BlastFurnaceFuel.getBlastFuelTime(event.getItemStack())}).func_150255_a(gray));
        }
        if (((Boolean)IEConfig.GENERAL.tagTooltips.get()).booleanValue() && event.getFlags().func_194127_a()) {
            for (ResourceLocation oid : ItemTags.func_199903_a().func_199913_a((Object)event.getItemStack().func_77973_b())) {
                event.getToolTip().add(new StringTextComponent(oid.toString()).func_150255_a(gray));
            }
        }
        if (event.getItemStack().func_77973_b() instanceof IEItemInterfaces.IBulletContainer) {
            for (String s : BULLET_TOOLTIP) {
                event.getToolTip().add(new StringTextComponent(s));
            }
        }
    }

    @SubscribeEvent
    public void onRenderTooltip(RenderTooltipEvent.PostText event) {
        NonNullList<ItemStack> bullets;
        ItemStack stack = event.getStack();
        if (stack.func_77973_b() instanceof IEItemInterfaces.IBulletContainer && (bullets = ((IEItemInterfaces.IBulletContainer)stack.func_77973_b()).getBullets(stack, true)) != null) {
            int bulletAmount = ((IEItemInterfaces.IBulletContainer)stack.func_77973_b()).getBulletCount(stack);
            int line = event.getLines().size() - Utils.findSequenceInList(event.getLines(), BULLET_TOOLTIP, (a, b) -> b.endsWith((String)a));
            int currentX = event.getX();
            int currentY = line > 0 ? event.getY() + (event.getHeight() + 1 - line * 10) : event.getY() - 42;
            MatrixStack transform = new MatrixStack();
            transform.func_227860_a_();
            transform.func_227861_a_((double)currentX, (double)currentY, 700.0);
            transform.func_227862_a_(0.5f, 0.5f, 1.0f);
            RevolverScreen.drawExternalGUI(bullets, bulletAmount, transform);
        }
    }

    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        if (event.getSound() == null) {
            return;
        }
        event.getSound().func_184365_d();
        if (!EarmuffsItem.affectedSoundCategories.contains(event.getSound().func_184365_d().func_187948_a())) {
            return;
        }
        if (ClientUtils.mc().field_71439_g != null && !ClientUtils.mc().field_71439_g.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
            ItemStack earmuffs = ClientUtils.mc().field_71439_g.func_184582_a(EquipmentSlotType.HEAD);
            if (ItemNBTHelper.hasKey(earmuffs, "IE:Earmuffs")) {
                earmuffs = ItemNBTHelper.getItemStack(earmuffs, "IE:Earmuffs");
            }
            if (!earmuffs.func_190926_b() && IEItems.Misc.earmuffs == earmuffs.func_77973_b() && !ItemNBTHelper.getBoolean(earmuffs, "IE:Earmuffs:Cat_" + event.getSound().func_184365_d().func_187948_a())) {
                BlockPos pos;
                for (String blacklist : (List)IEConfig.TOOLS.earDefenders_SoundBlacklist.get()) {
                    if (blacklist == null || !blacklist.equalsIgnoreCase(event.getSound().func_147650_b().toString())) continue;
                    return;
                }
                if (event.getSound() instanceof ITickableSound) {
                    event.setResultSound((ISound)new IEMuffledTickableSound((ITickableSound)event.getSound(), EarmuffsItem.getVolumeMod(earmuffs)));
                } else {
                    event.setResultSound((ISound)new IEMuffledSound(event.getSound(), EarmuffsItem.getVolumeMod(earmuffs)));
                }
                if (event.getSound().func_184365_d() == SoundCategory.RECORDS && ClientUtils.mc().field_71438_f.field_147593_P.containsKey(pos = new BlockPos((double)event.getSound().func_147649_g(), (double)event.getSound().func_147654_h(), (double)event.getSound().func_147651_i()))) {
                    ClientUtils.mc().field_71438_f.field_147593_P.put(pos, event.getResultSound());
                }
            }
        }
    }

    private void renderObstructingBlocks(MatrixStack transform, IRenderTypeBuffer buffers) {
        IVertexBuilder baseBuilder = buffers.getBuffer(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
        TransformingVertexBuilder builder = new TransformingVertexBuilder(baseBuilder);
        builder.setColor(1.0f, 0.0f, 0.0f, 0.5f);
        for (Map.Entry<Connection, Pair<Collection<BlockPos>, AtomicInteger>> entry : FAILED_CONNECTIONS.entrySet()) {
            for (BlockPos obstruction : (Collection)entry.getValue().getKey()) {
                transform.func_227860_a_();
                transform.func_227861_a_((double)obstruction.func_177958_n(), (double)obstruction.func_177956_o(), (double)obstruction.func_177952_p());
                float eps = 0.001f;
                ClientUtils.renderBox(builder, transform, -0.001f, -0.001f, -0.001f, 1.001f, 1.001f, 1.001f);
                transform.func_227865_b_();
            }
        }
    }

    @SubscribeEvent
    public void onRenderItemFrame(RenderItemInFrameEvent event) {
        BlueprintCraftingRecipe[] recipes;
        double playerDistanceSq;
        if (event.getItem().func_77973_b() instanceof EngineersBlueprintItem && (playerDistanceSq = ClientUtils.mc().field_71439_g.func_70068_e((Entity)event.getEntityItemFrame())) < 1000.0 && (recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(event.getItem(), "blueprint"))).length > 0) {
            AutoWorkbenchRenderer.BlueprintLines blueprint;
            int i = event.getEntityItemFrame().func_82333_j();
            BlueprintCraftingRecipe recipe = recipes[i % recipes.length];
            AutoWorkbenchRenderer.BlueprintLines blueprintLines = blueprint = recipe == null ? null : AutoWorkbenchRenderer.getBlueprintDrawable(recipe, event.getEntityItemFrame().func_130014_f_());
            if (blueprint != null) {
                MatrixStack transform = event.getMatrix();
                transform.func_227860_a_();
                IRenderTypeBuffer buffer = event.getBuffers();
                transform.func_227863_a_(new Quaternion(0.0f, 0.0f, (float)(-i * 45), true));
                transform.func_227861_a_(-0.5, 0.5, -0.001);
                IVertexBuilder builder = buffer.getBuffer(IERenderTypes.getGui(IEDataGenerator.rl("textures/models/blueprint_frame.png")));
                ClientUtils.drawTexturedRect(builder, transform, 0.125f, -0.875f, 0.75f, 0.75f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f);
                float lineWidth = playerDistanceSq < 3.0 ? 3.0f : (playerDistanceSq < 25.0 ? 2.0f : (playerDistanceSq < 40.0 ? 1.0f : 0.5f));
                transform.func_227861_a_(0.75, -0.25, -0.002);
                float scale = 0.0375f / ((float)blueprint.getTextureScale() / 16.0f);
                transform.func_227862_a_(-scale, -scale, scale);
                blueprint.draw(lineWidth, transform, buffer);
                transform.func_227865_b_();
                event.setCanceled(true);
            }
        }
    }

    private static void handleSubtitleOffset(boolean pre) {
        float offset = 0.0f;
        ClientPlayerEntity player = ClientUtils.mc().field_71439_g;
        for (Hand hand : Hand.values()) {
            if (player.func_184586_b(hand).func_190926_b()) continue;
            Item equipped = player.func_184586_b(hand).func_77973_b();
            if (equipped instanceof RevolverItem || equipped instanceof SpeedloaderItem) {
                offset = 50.0f;
                continue;
            }
            if (equipped instanceof DrillItem || equipped instanceof ChemthrowerItem || equipped instanceof BuzzsawItem) {
                offset = 50.0f;
                continue;
            }
            if (!(equipped instanceof RailgunItem) && !(equipped instanceof IEShieldItem)) continue;
            offset = 20.0f;
        }
        if (offset != 0.0f) {
            if (pre) {
                offset *= -1.0f;
            }
            GlStateManager.func_227688_c_((float)0.0f, (float)offset, (float)0.0f);
        }
    }

    @SubscribeEvent
    public void onRenderOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.SUBTITLES) {
            ClientEventHandler.handleSubtitleOffset(true);
        }
        if (ZoomHandler.isZooming && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            if (ZoomHandler.isZooming) {
                ZoomHandler.IZoomTool tool;
                float[] steps;
                IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                MatrixStack transform = new MatrixStack();
                transform.func_227860_a_();
                int width = ClientUtils.mc().func_228018_at_().func_198107_o();
                int height = ClientUtils.mc().func_228018_at_().func_198087_p();
                int resMin = Math.min(width, height);
                float offsetX = (float)(width - resMin) / 2.0f;
                float offsetY = (float)(height - resMin) / 2.0f;
                if (resMin == width) {
                    ClientUtils.drawColouredRect(0, 0, width, (int)offsetY + 1, -16777216, (IRenderTypeBuffer)buffers, transform);
                    ClientUtils.drawColouredRect(0, (int)offsetY + resMin, width, (int)offsetY + 1, -16777216, (IRenderTypeBuffer)buffers, transform);
                } else {
                    ClientUtils.drawColouredRect(0, 0, (int)offsetX + 1, height, -16777216, (IRenderTypeBuffer)buffers, transform);
                    ClientUtils.drawColouredRect((int)offsetX + resMin, 0, (int)offsetX + 1, height, -16777216, (IRenderTypeBuffer)buffers, transform);
                }
                transform.func_227861_a_((double)offsetX, (double)offsetY, 0.0);
                IVertexBuilder builder = buffers.getBuffer(IERenderTypes.getGui(IEDataGenerator.rl("textures/gui/scope.png")));
                ClientUtils.drawTexturedRect(builder, transform, 0.0f, 0.0f, resMin, resMin, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
                builder = buffers.getBuffer(IERenderTypes.getGui(IEDataGenerator.rl("textures/gui/hud_elements.png")));
                ClientUtils.drawTexturedRect(builder, transform, 0.8515625f * (float)resMin, 0.25f * (float)resMin, 0.09375f * (float)resMin, 0.5f * (float)resMin, 1.0f, 1.0f, 1.0f, 1.0f, 0.25f, 0.34375f, 0.375f, 0.875f);
                ItemStack equipped = ClientUtils.mc().field_71439_g.func_184586_b(Hand.MAIN_HAND);
                if (!equipped.func_190926_b() && equipped.func_77973_b() instanceof ZoomHandler.IZoomTool && (steps = (tool = (ZoomHandler.IZoomTool)equipped.func_77973_b()).getZoomSteps(equipped, (PlayerEntity)ClientUtils.mc().field_71439_g)) != null && steps.length > 1) {
                    int curStep = -1;
                    float dist = 0.0f;
                    float totalOffset = 0.0f;
                    float stepLength = 118.0f / (float)steps.length;
                    float stepOffset = (stepLength - 7.0f) / 2.0f;
                    transform.func_227861_a_((double)(0.87109375f * (float)resMin), (double)(0.25f * (float)resMin), 0.0);
                    transform.func_227861_a_(0.0, (double)((5.0f + stepOffset) / 256.0f * (float)resMin), 0.0);
                    for (int i = 0; i < steps.length; ++i) {
                        ClientUtils.drawTexturedRect(builder, transform, 0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 1.0f, 1.0f, 1.0f, 1.0f, 0.34375f, 0.375f, 0.375f, 0.40234375f);
                        transform.func_227861_a_(0.0, (double)(stepLength / 256.0f * (float)resMin), 0.0);
                        totalOffset += stepLength;
                        if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                        curStep = i;
                        dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
                    }
                    transform.func_227861_a_(0.0, (double)(-totalOffset / 256.0f * (float)resMin), 0.0);
                    if (curStep < steps.length) {
                        transform.func_227861_a_((double)(0.0234375f * (float)resMin), (double)((float)curStep * stepLength / 256.0f * (float)resMin), 0.0);
                        ClientUtils.drawTexturedRect(builder, transform, 0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 1.0f, 1.0f, 1.0f, 1.0f, 0.34375f, 0.3828125f, 0.40234375f, 0.4296875f);
                        ClientUtils.font().func_228079_a_(1.0f / steps[curStep] + "x", (float)((int)(0.0625f * (float)resMin)), 0.0f, 0xFFFFFF, true, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffers, false, 0, 0xF000F0);
                        transform.func_227861_a_((double)(-0.0234375f * (float)resMin), (double)((float)(-curStep) * stepLength / 256.0f * (float)resMin), 0.0);
                    }
                    transform.func_227861_a_(0.0, (double)(-((5.0f + stepOffset) / 256.0f * (float)resMin)), 0.0);
                    transform.func_227861_a_((double)(-0.87109375f * (float)resMin), (double)(-0.25f * (float)resMin), 0.0);
                }
                transform.func_227861_a_((double)(-offsetX), (double)(-offsetY), 0.0);
                buffers.func_228461_a_();
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlayPost(RenderGameOverlayEvent.Post event) {
        int scaledWidth = ClientUtils.mc().func_228018_at_().func_198107_o();
        int scaledHeight = ClientUtils.mc().func_228018_at_().func_198087_p();
        if (event.getType() == RenderGameOverlayEvent.ElementType.SUBTITLES) {
            ClientEventHandler.handleSubtitleOffset(false);
        }
        if (ClientUtils.mc().field_71439_g != null && event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            ClientPlayerEntity player = ClientUtils.mc().field_71439_g;
            MatrixStack transform = new MatrixStack();
            int rightOffset = 0;
            if (ClientUtils.mc().field_71474_y.field_186717_N) {
                rightOffset += 100;
            }
            for (Hand hand : Hand.values()) {
                CompoundNBT upgrades;
                if (player.func_184586_b(hand).func_190926_b()) continue;
                IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                ItemStack equipped = player.func_184586_b(hand);
                if (ItemStack.func_179545_c((ItemStack)new ItemStack((IItemProvider)IEItems.Tools.voltmeter), (ItemStack)equipped) || equipped.func_77973_b() instanceof IWireCoil) {
                    if (WirecoilUtils.hasWireLink(equipped)) {
                        int max;
                        RayTraceResult rtr;
                        double d;
                        WirecoilUtils.WireLink link = WirecoilUtils.WireLink.readFromItem(equipped);
                        BlockPos pos = link.cp.getPosition();
                        String s = I18n.func_135052_a((String)"desc.immersiveengineering.info.attachedTo", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
                        int col = WireType.ELECTRUM.getColour(null);
                        if (equipped.func_77973_b() instanceof IWireCoil && (d = (rtr = ClientUtils.mc().field_71476_x) instanceof BlockRayTraceResult ? ((BlockRayTraceResult)rtr).func_216350_a().func_218140_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true) : player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) > (double)((max = ((IWireCoil)equipped.func_77973_b()).getWireType(equipped).getMaxLength()) * max)) {
                            col = 0xDD3333;
                        }
                        ClientUtils.font().func_228079_a_(s, (float)(scaledWidth / 2 - ClientUtils.font().func_78256_a(s) / 2), (float)(scaledHeight - ForgeIngameGui.left_height - 20), col, true, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                    }
                } else if (equipped.func_77973_b() == IEItems.Misc.fluorescentTube) {
                    String s = I18n.func_135052_a((String)"desc.immersiveengineering.info.colour", (Object[])new Object[]{"#" + FluorescentTubeItem.hexColorString(equipped)});
                    ClientUtils.font().func_228079_a_(s, (float)(scaledWidth / 2 - ClientUtils.font().func_78256_a(s) / 2), (float)(scaledHeight - ForgeIngameGui.left_height - 20), FluorescentTubeItem.getRGBInt(equipped, 1.0f), true, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                } else if (equipped.func_77973_b() instanceof RevolverItem || equipped.func_77973_b() instanceof SpeedloaderItem) {
                    NonNullList<ItemStack> bullets = ((IEItemInterfaces.IBulletContainer)equipped.func_77973_b()).getBullets(equipped, true);
                    if (bullets != null) {
                        float cdMax;
                        int cd;
                        float cooldown;
                        int bulletAmount = ((IEItemInterfaces.IBulletContainer)equipped.func_77973_b()).getBulletCount(equipped);
                        HandSide side = hand == Hand.MAIN_HAND ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
                        boolean right = side == HandSide.RIGHT;
                        float dx = right ? (float)(scaledWidth - 32 - 48) : 48.0f;
                        float dy = scaledHeight - 64;
                        transform.func_227860_a_();
                        transform.func_227860_a_();
                        transform.func_227861_a_((double)dx, (double)dy, 0.0);
                        transform.func_227862_a_(0.5f, 0.5f, 1.0f);
                        RevolverScreen.drawExternalGUI(bullets, bulletAmount, transform);
                        transform.func_227865_b_();
                        if (equipped.func_77973_b() instanceof RevolverItem && (cooldown = 1.0f - (float)(cd = ((RevolverItem)equipped.func_77973_b()).getShootCooldown(equipped)) / (cdMax = (float)((RevolverItem)equipped.func_77973_b()).getMaxShootCooldown(equipped))) > 0.0f) {
                            transform.func_227861_a_((double)(scaledWidth / 2 + (right ? 1 : -6)), (double)(scaledHeight / 2 - 7), 0.0);
                            float h1 = (double)cooldown > 0.33 ? 0.5f : cooldown * 1.5f;
                            float h2 = cooldown;
                            float x2 = (double)cooldown < 0.75 ? 1.0f : 4.0f * (1.0f - cooldown);
                            float uMin = (88.0f + (right ? 0.0f : 7.0f * x2)) / 256.0f;
                            float uMax = (88.0f + (right ? 7.0f * x2 : 0.0f)) / 256.0f;
                            float vMin1 = (112.0f + (right ? h1 : h2) * 15.0f) / 256.0f;
                            float vMin2 = (112.0f + (right ? h2 : h1) * 15.0f) / 256.0f;
                            IVertexBuilder builder = buffer.getBuffer(IERenderTypes.getGui(IEDataGenerator.rl("textures/gui/hud_elements.png")));
                            Matrix4f mat = transform.func_227866_c_().func_227870_a_();
                            builder.func_227888_a_(mat, (right ? 0.0f : 1.0f - x2) * 7.0f, 15.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMin, 0.49609375f).func_181675_d();
                            builder.func_227888_a_(mat, (right ? x2 : 1.0f) * 7.0f, 15.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, 0.49609375f).func_181675_d();
                            builder.func_227888_a_(mat, (right ? x2 : 1.0f) * 7.0f, (right ? h2 : h1) * 15.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, vMin2).func_181675_d();
                            builder.func_227888_a_(mat, (right ? 0.0f : 1.0f - x2) * 7.0f, (right ? h1 : h2) * 15.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMin, vMin1).func_181675_d();
                        }
                        transform.func_227865_b_();
                    }
                } else if (equipped.func_77973_b() instanceof RailgunItem) {
                    int duration = 72000 - (player.func_184587_cr() && player.func_184600_cs() == hand ? player.func_184605_cv() : 0);
                    int chargeTime = ((RailgunItem)equipped.func_77973_b()).getChargeTime(equipped);
                    int chargeLevel = duration < 72000 ? Math.min(99, (int)((float)duration / (float)chargeTime * 100.0f)) : 0;
                    float scale = 2.0f;
                    transform.func_227860_a_();
                    transform.func_227861_a_((double)(scaledWidth - rightOffset - 80), (double)(scaledHeight - 30), 0.0);
                    transform.func_227862_a_(scale, scale, 1.0f);
                    ClientProxy.nixieFont.func_228079_a_((chargeLevel < 10 ? "0" : "") + chargeLevel, 0.0f, 0.0f, 0xFF9900, true, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                    transform.func_227865_b_();
                } else if (equipped.func_77973_b() instanceof DrillItem || equipped.func_77973_b() instanceof ChemthrowerItem || equipped.func_77973_b() instanceof BuzzsawItem) {
                    boolean drill = equipped.func_77973_b() instanceof DrillItem;
                    boolean buzzsaw = equipped.func_77973_b() instanceof BuzzsawItem;
                    IVertexBuilder builder = buffer.getBuffer(IERenderTypes.getGui(IEDataGenerator.rl("textures/gui/hud_elements.png")));
                    float dx = scaledWidth - rightOffset - 16;
                    float dy = scaledHeight;
                    transform.func_227860_a_();
                    transform.func_227861_a_((double)dx, (double)dy, 0.0);
                    int w = 31;
                    int h = 62;
                    float uMin = 0.69921875f;
                    float uMax = 0.8203125f;
                    float vMin = 0.03515625f;
                    float vMax = 0.27734375f;
                    ClientUtils.drawTexturedRect(builder, transform, -24.0f, -68.0f, w, h, 1.0f, 1.0f, 1.0f, 1.0f, uMin, uMax, vMin, vMax);
                    transform.func_227861_a_(-23.0, -37.0, 0.0);
                    LazyOptional handlerOpt = FluidUtil.getFluidHandler((ItemStack)equipped);
                    handlerOpt.ifPresent(arg_0 -> ClientEventHandler.lambda$onRenderOverlayPost$3(drill, (PlayerEntity)player, hand, transform, builder, equipped, buffer, buzzsaw, arg_0));
                    transform.func_227865_b_();
                } else if (equipped.func_77973_b() instanceof IEShieldItem && !(upgrades = ((IEShieldItem)equipped.func_77973_b()).getUpgrades(equipped)).isEmpty()) {
                    IVertexBuilder builder = buffer.getBuffer(IERenderTypes.getGui(IEDataGenerator.rl("textures/gui/hud_elements.png")));
                    boolean boundLeft = player.func_184591_cq() == HandSide.RIGHT == (hand == Hand.OFF_HAND);
                    float dx = boundLeft ? 16.0f : (float)(scaledWidth - 16 - 64);
                    float dy = scaledHeight;
                    transform.func_227860_a_();
                    transform.func_227861_a_((double)dx, (double)dy, 0.0);
                    ClientUtils.drawTexturedRect(builder, transform, 0.0f, -22.0f, 64.0f, 22.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.25f, 0.6875f, 0.7734375f);
                    if (upgrades.func_74767_n("flash")) {
                        ClientUtils.drawTexturedRect(builder, transform, 11.0f, -38.0f, 16.0f, 16.0f, 0.04296875f, 1.0f, 1.0f, 1.0f, 1.0f, 0.10546875f, 0.625f, 0.6875f);
                        if (upgrades.func_74764_b("flash_cooldown")) {
                            float h = (float)upgrades.func_74762_e("flash_cooldown") / 40.0f * 16.0f;
                            ClientUtils.drawTexturedRect(builder, transform, 11.0f, -22.0f - h, 16.0f, h, 1.0f, 1.0f, 1.0f, 1.0f, 0.04296875f, 0.10546875f, (214.0f - h) / 256.0f, 0.8359375f);
                        }
                    }
                    if (upgrades.func_74767_n("shock")) {
                        ClientUtils.drawTexturedRect(builder, transform, 40.0f, -38.0f, 12.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.15625f, 0.203125f, 0.625f, 0.6875f);
                        if (upgrades.func_74764_b("shock_cooldown")) {
                            float h = (float)upgrades.func_74762_e("shock_cooldown") / 40.0f * 16.0f;
                            ClientUtils.drawTexturedRect(builder, transform, 40.0f, -22.0f - h, 12.0f, h, 1.0f, 1.0f, 1.0f, 1.0f, 0.15625f, 0.203125f, (214.0f - h) / 256.0f, 0.8359375f);
                        }
                    }
                    transform.func_227865_b_();
                }
                if (equipped.func_77973_b() == IEItems.Tools.voltmeter) {
                    RayTraceResult rrt = ClientUtils.mc().field_71476_x;
                    IFluxReceiver receiver = null;
                    Direction side = null;
                    if (rrt instanceof BlockRayTraceResult) {
                        BlockRayTraceResult mop = (BlockRayTraceResult)rrt;
                        TileEntity tileEntity = player.field_70170_p.func_175625_s(mop.func_216350_a());
                        if (tileEntity instanceof IFluxReceiver) {
                            receiver = (IFluxReceiver)tileEntity;
                        }
                        side = mop.func_216354_b();
                        if (player.field_70170_p.func_82737_E() % 20L == 0L) {
                            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageRequestBlockUpdate(mop.func_216350_a()));
                        }
                    } else if (rrt instanceof EntityRayTraceResult && ((EntityRayTraceResult)rrt).func_216348_a() instanceof IFluxReceiver) {
                        receiver = (IFluxReceiver)((EntityRayTraceResult)rrt).func_216348_a();
                    }
                    if (receiver != null) {
                        String[] text = new String[]{};
                        int maxStorage = receiver.getMaxEnergyStored(side);
                        int storage = receiver.getEnergyStored(side);
                        if (maxStorage > 0) {
                            text = I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{"<br>" + Utils.toScientificNotation(storage, "0##", 100000) + " / " + Utils.toScientificNotation(maxStorage, "0##", 100000)}).split("<br>");
                        }
                        int col = (Boolean)IEConfig.GENERAL.nixietubeFont.get() != false ? 0xFF9900 : 0xFFFFFF;
                        int i = 0;
                        RenderSystem.enableBlend();
                        for (String s : text) {
                            if (s == null) continue;
                            s = s.trim();
                            int w = ClientProxy.nixieFontOptional.func_78256_a(s);
                            ClientProxy.nixieFontOptional.func_228079_a_(s, scaledWidth / 2 - w / 2, scaledHeight / 2 - 4 - text.length * (ClientProxy.nixieFontOptional.getFontHeight() + 2) + i++ * (ClientProxy.nixieFontOptional.getFontHeight() + 2), col, false, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                        }
                        RenderSystem.disableBlend();
                    }
                }
                buffer.func_228461_a_();
            }
            if (ClientUtils.mc().field_71476_x != null) {
                World world;
                MapData mapData;
                ItemStack frameItem;
                boolean hammer = !player.func_184586_b(Hand.MAIN_HAND).func_190926_b() && Utils.isHammer(player.func_184586_b(Hand.MAIN_HAND));
                RayTraceResult mop = ClientUtils.mc().field_71476_x;
                ItemFrameEntity frameEntity = null;
                if (mop instanceof EntityRayTraceResult && ((EntityRayTraceResult)mop).func_216348_a() instanceof ItemFrameEntity) {
                    frameEntity = (ItemFrameEntity)((EntityRayTraceResult)mop).func_216348_a();
                } else if (mop instanceof BlockRayTraceResult) {
                    BlockPos pos = ((BlockRayTraceResult)mop).func_216350_a();
                    Direction face = ((BlockRayTraceResult)mop).func_216354_b();
                    TileEntity tileEntity = player.field_70170_p.func_175625_s(pos);
                    if (tileEntity instanceof IEBlockInterfaces.IBlockOverlayText) {
                        IEBlockInterfaces.IBlockOverlayText overlayBlock = (IEBlockInterfaces.IBlockOverlayText)tileEntity;
                        String[] text = overlayBlock.getOverlayText((PlayerEntity)ClientUtils.mc().field_71439_g, mop, hammer);
                        boolean useNixie = overlayBlock.useNixieFont((PlayerEntity)ClientUtils.mc().field_71439_g, mop);
                        if (text != null && text.length > 0) {
                            IEFontRender font = useNixie ? ClientProxy.nixieFontOptional : ClientUtils.font();
                            int col = useNixie && (Boolean)IEConfig.GENERAL.nixietubeFont.get() != false ? 0xFF9900 : 0xFFFFFF;
                            int i = 0;
                            IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                            for (String s : text) {
                                if (s == null) continue;
                                float f = scaledWidth / 2 + 8;
                                int n = scaledHeight / 2 + 8;
                                int n2 = i++;
                                ((Object)((Object)font)).getClass();
                                font.func_228079_a_(s, f, n + n2 * 9, col, true, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                            }
                            buffer.func_228461_a_();
                        }
                    } else {
                        List list = player.field_70170_p.func_175647_a(ItemFrameEntity.class, new AxisAlignedBB(pos.func_177972_a(face)), entity -> entity != null && entity.func_174811_aO() == face);
                        if (list.size() == 1) {
                            frameEntity = (ItemFrameEntity)list.get(0);
                        }
                    }
                }
                if (frameEntity != null && (frameItem = frameEntity.func_82335_i()).func_77973_b() == Items.field_151098_aY && ItemNBTHelper.hasKey(frameItem, "Decorations", 9) && (mapData = FilledMapItem.func_195950_a((ItemStack)frameItem, (World)(world = frameEntity.func_130014_f_()))) != null) {
                    FontRenderer font = ClientUtils.font();
                    mapData.func_176054_a((double)world.func_72912_H().func_76079_c(), (double)world.func_72912_H().func_76074_e(), (int)mapData.field_76197_d);
                    int mapScale = 1 << mapData.field_76197_d;
                    float mapRotation = (float)(frameEntity.func_82333_j() % 4) * 1.5708f;
                    Vec3d hitVec = mop.func_216347_e().func_178788_d(new Vec3d((Vec3i)frameEntity.func_174857_n()));
                    Direction frameDir = frameEntity.func_174811_aO();
                    double cursorH = 0.0;
                    double cursorV = 0.0;
                    switch (frameDir) {
                        case DOWN: {
                            cursorH = hitVec.field_72450_a;
                            cursorV = 1.0 - hitVec.field_72449_c;
                            break;
                        }
                        case UP: {
                            cursorH = hitVec.field_72450_a;
                            cursorV = hitVec.field_72449_c;
                            break;
                        }
                        case NORTH: {
                            cursorH = 1.0 - hitVec.field_72450_a;
                            cursorV = 1.0 - hitVec.field_72448_b;
                            break;
                        }
                        case SOUTH: {
                            cursorH = hitVec.field_72450_a;
                            cursorV = 1.0 - hitVec.field_72448_b;
                            break;
                        }
                        case WEST: {
                            cursorH = hitVec.field_72449_c;
                            cursorV = 1.0 - hitVec.field_72448_b;
                            break;
                        }
                        case EAST: {
                            cursorH = 1.0 - hitVec.field_72449_c;
                            cursorV = 1.0 - hitVec.field_72448_b;
                        }
                    }
                    cursorH *= 128.0;
                    cursorV *= 128.0;
                    ListNBT minerals = null;
                    double lastDist = Double.MAX_VALUE;
                    ListNBT nbttaglist = frameItem.func_77978_p().func_150295_c("Decorations", 10);
                    for (INBT inbt : nbttaglist) {
                        CompoundNBT tagCompound = (CompoundNBT)inbt;
                        String id = tagCompound.func_74779_i("id");
                        if (!id.startsWith("ie:coresample_") || !tagCompound.func_74764_b("minerals")) continue;
                        double sampleX = tagCompound.func_74769_h("x");
                        double sampleZ = tagCompound.func_74769_h("z");
                        float f = (float)(sampleX - (double)mapData.field_76201_a) / (float)mapScale;
                        float f1 = (float)(sampleZ - (double)mapData.field_76199_b) / (float)mapScale;
                        byte b0 = (byte)((double)(f * 2.0f) + 0.5);
                        byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
                        Vec3d mapPos = new Vec3d(0.0, (double)b1, (double)b0);
                        mapPos = mapPos.func_178789_a(mapRotation);
                        double offsetH = mapPos.field_72449_c / 2.0 + 64.0;
                        double dH = cursorH - offsetH;
                        double offsetV = mapPos.field_72448_b / 2.0 + 64.0;
                        double dV = cursorV - offsetV;
                        double dist = dH * dH + dV * dV;
                        if (!(dist < 10.0) || !(dist < lastDist)) continue;
                        lastDist = dist;
                        minerals = tagCompound.func_150295_c("minerals", 8);
                    }
                    if (minerals != null) {
                        for (int i = 0; i < minerals.size(); ++i) {
                            MineralMix mix = MineralMix.mineralList.get(new ResourceLocation(minerals.func_150307_f(i)));
                            if (mix == null) continue;
                            String string = I18n.func_135052_a((String)mix.getTranslationKey(), (Object[])new Object[0]);
                            float f = scaledWidth / 2 + 8;
                            int n = scaledHeight / 2 + 8;
                            font.getClass();
                            font.func_175063_a(string, f, (float)(n + i * 9), 0xFFFFFF);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onFogUpdate(EntityViewRenderEvent.RenderFogEvent event) {
        Entity e = event.getInfo().func_216773_g();
        if (e instanceof LivingEntity && ((LivingEntity)e).func_70644_a(IEPotions.flashed)) {
            EffectInstance effect = ((LivingEntity)e).func_70660_b(IEPotions.flashed);
            int timeLeft = effect.func_76459_b();
            float saturation = Math.max(0.25f, 1.0f - (float)timeLeft / (float)(80 + 40 * effect.func_76458_c()));
            float f1 = -2.5f + 15.0f * saturation;
            if (timeLeft < 20) {
                f1 += event.getFarPlaneDistance() / 4.0f * (1.0f - (float)timeLeft / 20.0f);
            }
            RenderSystem.fogStart((float)(0.25f * f1));
            RenderSystem.fogEnd((float)f1);
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            RenderSystem.setupNvFogDistance();
        }
    }

    @SubscribeEvent
    public void onFogColourUpdate(EntityViewRenderEvent.FogColors event) {
        Entity e = event.getInfo().func_216773_g();
        if (e instanceof LivingEntity && ((LivingEntity)e).func_70644_a(IEPotions.flashed)) {
            event.setRed(1.0f);
            event.setGreen(1.0f);
            event.setBlue(1.0f);
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        ClientPlayerEntity player = ClientUtils.mc().field_71439_g;
        if (!player.func_184586_b(Hand.MAIN_HAND).func_190926_b() && player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof ZoomHandler.IZoomTool) {
            if (player.func_225608_bj_() && player.field_70122_E) {
                ItemStack equipped = player.func_184586_b(Hand.MAIN_HAND);
                ZoomHandler.IZoomTool tool = (ZoomHandler.IZoomTool)equipped.func_77973_b();
                if (tool.canZoom(equipped, (PlayerEntity)player)) {
                    if (!ZoomHandler.isZooming) {
                        float[] steps = tool.getZoomSteps(equipped, (PlayerEntity)player);
                        if (steps != null && steps.length > 0) {
                            int curStep = -1;
                            float dist = 0.0f;
                            for (int i = 0; i < steps.length; ++i) {
                                if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                                curStep = i;
                                dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
                            }
                            ZoomHandler.fovZoom = steps[curStep];
                        }
                        ZoomHandler.isZooming = true;
                    }
                    event.setNewfov(ZoomHandler.fovZoom);
                } else if (ZoomHandler.isZooming) {
                    ZoomHandler.isZooming = false;
                }
            } else if (ZoomHandler.isZooming) {
                ZoomHandler.isZooming = false;
            }
        } else if (ZoomHandler.isZooming) {
            ZoomHandler.isZooming = false;
        }
        if (player.func_70660_b(IEPotions.concreteFeet) != null) {
            event.setNewfov(1.0f);
        }
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollEvent event) {
        ClientPlayerEntity player;
        if (event.getScrollDelta() != 0.0 && ClientUtils.mc().field_71462_r == null && (player = ClientUtils.mc().field_71439_g) != null && !player.func_184586_b(Hand.MAIN_HAND).func_190926_b() && player.func_225608_bj_()) {
            float[] steps;
            ZoomHandler.IZoomTool tool;
            ItemStack equipped = player.func_184586_b(Hand.MAIN_HAND);
            if (equipped.func_77973_b() instanceof ZoomHandler.IZoomTool && (tool = (ZoomHandler.IZoomTool)equipped.func_77973_b()).canZoom(equipped, (PlayerEntity)player) && (steps = tool.getZoomSteps(equipped, (PlayerEntity)player)) != null && steps.length > 0) {
                int curStep = -1;
                float dist = 0.0f;
                for (int i = 0; i < steps.length; ++i) {
                    if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                    curStep = i;
                    dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
                }
                int newStep = curStep + (event.getScrollDelta() > 0.0 ? -1 : 1);
                if (newStep >= 0 && newStep < steps.length) {
                    ZoomHandler.fovZoom = steps[newStep];
                }
                event.setCanceled(true);
            }
            if (((Boolean)IEConfig.TOOLS.chemthrower_scroll.get()).booleanValue() && equipped.func_77973_b() instanceof IEItemInterfaces.IScrollwheel) {
                ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageScrollwheelItem(event.getScrollDelta() < 0.0));
                event.setCanceled(true);
            }
            if (equipped.func_77973_b() instanceof RevolverItem) {
                ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageRevolverRotate(event.getScrollDelta() < 0.0));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void renderAdditionalBlockBounds(DrawHighlightEvent event) {
        if (event.getTarget().func_216346_c() == RayTraceResult.Type.BLOCK) {
            ItemStack head;
            Direction side;
            ItemStack stack;
            MatrixStack transform = event.getMatrix();
            IRenderTypeBuffer buffer = event.getBuffers();
            BlockRayTraceResult rtr = (BlockRayTraceResult)event.getTarget();
            BlockPos pos = rtr.func_216350_a();
            Vec3d renderView = event.getInfo().func_216785_c();
            transform.func_227860_a_();
            transform.func_227861_a_(-renderView.field_72450_a, -renderView.field_72448_b, -renderView.field_72449_c);
            transform.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            Entity player = event.getInfo().func_216773_g();
            float f1 = 0.002f;
            TileEntity tile = player.field_70170_p.func_175625_s(rtr.func_216350_a());
            ItemStack itemStack = stack = player instanceof LivingEntity ? ((LivingEntity)player).func_184586_b(Hand.MAIN_HAND) : ItemStack.field_190927_a;
            if (Utils.isHammer(stack) && tile instanceof TurntableTileEntity) {
                TurntableTileEntity turntableTile = (TurntableTileEntity)tile;
                side = rtr.func_216354_b();
                Direction facing = turntableTile.getFacing();
                if (side.func_176740_k() != facing.func_176740_k()) {
                    transform.func_227860_a_();
                    transform.func_227861_a_(0.5, 0.5, 0.5);
                    ClientUtils.toModelRotation(side).func_225615_b_().push(transform);
                    transform.func_227863_a_(new Quaternion(-90.0f, 0.0f, 0.0f, true));
                    Rotation rotation = turntableTile.getRotationFromSide(side);
                    boolean cw180 = rotation == Rotation.CLOCKWISE_180;
                    double angle = cw180 ? (double)(player.field_70173_aa % 40) / 20.0 : (double)(player.field_70173_aa % 80) / 40.0;
                    double stepDistance = (double)(cw180 ? 2 : 4) * Math.PI;
                    angle = -(angle - Math.sin(angle * stepDistance) / stepDistance) * Math.PI;
                    ClientEventHandler.drawCircularRotationArrows(buffer, transform, (float)angle, rotation == Rotation.COUNTERCLOCKWISE_90, cw180);
                    transform.func_227865_b_();
                    transform.func_227865_b_();
                }
            }
            World world = player.field_70170_p;
            if (!stack.func_190926_b() && ConveyorHandler.conveyorBlocks.containsValue(Block.func_149634_a((Item)stack.func_77973_b())) && rtr.func_216354_b().func_176740_k() == Direction.Axis.Y) {
                side = rtr.func_216354_b();
                VoxelShape shape = world.func_180495_p(pos).func_196951_e((IBlockReader)world, pos);
                AxisAlignedBB targetedBB = null;
                if (!shape.func_197766_b()) {
                    targetedBB = shape.func_197752_a();
                }
                IRenderTypeBuffer buffers = event.getBuffers();
                float[][] points = new float[4][];
                if (side.func_176740_k() == Direction.Axis.Y) {
                    float y = (float)(targetedBB == null ? 0.0 : (side == Direction.DOWN ? targetedBB.field_72338_b - (double)f1 : targetedBB.field_72337_e + (double)f1));
                    points[0] = new float[]{0.0f - f1, y, 0.0f - f1};
                    points[1] = new float[]{1.0f + f1, y, 1.0f + f1};
                    points[2] = new float[]{0.0f - f1, y, 1.0f + f1};
                    points[3] = new float[]{1.0f + f1, y, 0.0f - f1};
                } else if (side.func_176740_k() == Direction.Axis.Z) {
                    float z = (float)(targetedBB == null ? 0.0 : (side == Direction.NORTH ? targetedBB.field_72339_c - (double)f1 : targetedBB.field_72334_f + (double)f1));
                    points[0] = new float[]{1.0f + f1, 1.0f + f1, z};
                    points[1] = new float[]{0.0f - f1, 0.0f - f1, z};
                    points[2] = new float[]{0.0f - f1, 1.0f + f1, z};
                    points[3] = new float[]{1.0f + f1, 0.0f - f1, z};
                } else {
                    float x = (float)(targetedBB == null ? 0.0 : (side == Direction.WEST ? targetedBB.field_72340_a - (double)f1 : targetedBB.field_72336_d + (double)f1));
                    points[0] = new float[]{x, 1.0f + f1, 1.0f + f1};
                    points[1] = new float[]{x, 0.0f - f1, 0.0f - f1};
                    points[2] = new float[]{x, 1.0f + f1, 0.0f - f1};
                    points[3] = new float[]{x, 0.0f - f1, 1.0f + f1};
                }
                Matrix4f mat = transform.func_227866_c_().func_227870_a_();
                IVertexBuilder lineBuilder = buffers.getBuffer(IERenderTypes.TRANSLUCENT_LINES);
                for (float[] point : points) {
                    lineBuilder.func_227888_a_(mat, point[0], point[1], point[2]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                }
                lineBuilder.func_227888_a_(mat, points[0][0], points[0][1], points[0][2]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                lineBuilder.func_227888_a_(mat, points[2][0], points[2][1], points[2][2]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                lineBuilder.func_227888_a_(mat, points[1][0], points[1][1], points[1][2]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                lineBuilder.func_227888_a_(mat, points[3][0], points[3][1], points[3][2]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                lineBuilder.func_227888_a_(mat, points[0][0], points[0][1], points[0][2]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                float xFromMid = side.func_176740_k() == Direction.Axis.X ? 0.0f : (float)rtr.func_216347_e().field_72450_a - (float)pos.func_177958_n() - 0.5f;
                float yFromMid = side.func_176740_k() == Direction.Axis.Y ? 0.0f : (float)rtr.func_216347_e().field_72448_b - (float)pos.func_177956_o() - 0.5f;
                float zFromMid = side.func_176740_k() == Direction.Axis.Z ? 0.0f : (float)rtr.func_216347_e().field_72449_c - (float)pos.func_177952_p() - 0.5f;
                float max = Math.max(Math.abs(yFromMid), Math.max(Math.abs(xFromMid), Math.abs(zFromMid)));
                Vec3d dir = new Vec3d(max == Math.abs(xFromMid) ? (double)Math.signum(xFromMid) : 0.0, max == Math.abs(yFromMid) ? (double)Math.signum(yFromMid) : 0.0, max == Math.abs(zFromMid) ? (double)Math.signum(zFromMid) : 0.0);
                ClientEventHandler.drawBlockOverlayArrow(mat, buffers, dir, side, targetedBB);
            }
            transform.func_227865_b_();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof DrillItem && ((DrillItem)stack.func_77973_b()).isEffective(world.func_180495_p(rtr.func_216350_a()).func_185904_a()) && !(head = ((DrillItem)stack.func_77973_b()).getHead(stack)).func_190926_b() && player instanceof PlayerEntity) {
                ImmutableList<BlockPos> blocks = ((IDrillHead)head.func_77973_b()).getExtraBlocksDug(head, world, (PlayerEntity)player, event.getTarget());
                ClientEventHandler.drawAdditionalBlockbreak(event, (PlayerEntity)player, event.getPartialTicks(), blocks);
            }
        }
    }

    public static void drawCircularRotationArrows(IRenderTypeBuffer buffer, MatrixStack transform, float rotation, boolean flip, boolean halfCircle) {
        int i;
        Matrix4f mat;
        int arrowId;
        int[] vertexOrder;
        float[][] rotationArrowQuads;
        float[][] rotationArrowCoords;
        transform.func_227860_a_();
        transform.func_227861_a_(0.0, 0.502, 0.0);
        if (halfCircle) {
            rotationArrowCoords = halfRotationArrowCoords;
            rotationArrowQuads = halfRotationArrowQuads;
        } else {
            rotationArrowCoords = quarterRotationArrowCoords;
            rotationArrowQuads = quarterRotationArrowQuads;
        }
        if (flip) {
            transform.func_227863_a_(new Quaternion(0.0f, -rotation, 0.0f, false));
            transform.func_227862_a_(1.0f, 1.0f, -1.0f);
            vertexOrder = new int[]{2, 3, 1, 0};
        } else {
            transform.func_227863_a_(new Quaternion(0.0f, rotation, 0.0f, false));
            vertexOrder = new int[]{0, 1, 3, 2};
        }
        transform.func_227860_a_();
        IVertexBuilder builder = buffer.getBuffer(IERenderTypes.LINES);
        for (arrowId = 0; arrowId < 2; ++arrowId) {
            mat = transform.func_227866_c_().func_227870_a_();
            for (i = 0; i <= rotationArrowCoords.length; ++i) {
                float[] p = rotationArrowCoords[i % rotationArrowCoords.length];
                if (i > 0) {
                    builder.func_227888_a_(mat, p[0], 0.0f, p[1]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                }
                if (i == rotationArrowCoords.length) continue;
                builder.func_227888_a_(mat, p[0], 0.0f, p[1]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
            }
            transform.func_227863_a_(new Quaternion(0.0f, 180.0f, 0.0f, true));
        }
        transform.func_227865_b_();
        transform.func_227860_a_();
        builder = buffer.getBuffer(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
        for (arrowId = 0; arrowId < 2; ++arrowId) {
            mat = transform.func_227866_c_().func_227870_a_();
            i = 0;
            while (i + 3 < rotationArrowQuads.length) {
                for (int offset : vertexOrder) {
                    float[] p = rotationArrowQuads[i + offset];
                    builder.func_227888_a_(mat, p[0], 0.0f, p[1]).func_227885_a_(Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.4f).func_181675_d();
                }
                i += 2;
            }
            transform.func_227863_a_(new Quaternion(0.0f, 180.0f, 0.0f, true));
        }
        transform.func_227865_b_();
        transform.func_227865_b_();
    }

    public static void drawBlockOverlayArrow(Matrix4f transform, IRenderTypeBuffer buffers, Vec3d directionVec, Direction side, AxisAlignedBB targetedBB) {
        Vec3d[] translatedPositions = new Vec3d[arrowCoords.length];
        Matrix4 mat = new Matrix4();
        Vec3d defaultDir = side.func_176740_k() == Direction.Axis.Y ? new Vec3d(0.0, 0.0, 1.0) : new Vec3d(0.0, 1.0, 0.0);
        directionVec = directionVec.func_72432_b();
        double angle = Math.acos(defaultDir.func_72430_b(directionVec));
        Vec3d axis = defaultDir.func_72431_c(directionVec);
        mat.rotate(angle, axis.field_72450_a, axis.field_72448_b, axis.field_72449_c);
        if (side.func_176740_k() == Direction.Axis.Z) {
            mat.rotate(1.5707963267948966, 1.0, 0.0, 0.0).rotate(Math.PI, 0.0, 1.0, 0.0);
        } else if (side.func_176740_k() == Direction.Axis.X) {
            mat.rotate(1.5707963267948966, 0.0, 0.0, 1.0).rotate(1.5707963267948966, 0.0, 1.0, 0.0);
        }
        for (int i = 0; i < translatedPositions.length; ++i) {
            Vec3d vec = mat.apply(new Vec3d((double)arrowCoords[i][0], 0.0, (double)arrowCoords[i][1])).func_72441_c(0.5, 0.5, 0.5);
            if (targetedBB != null) {
                vec = new Vec3d(side == Direction.WEST ? targetedBB.field_72340_a - 0.002 : (side == Direction.EAST ? targetedBB.field_72336_d + 0.002 : vec.field_72450_a), side == Direction.DOWN ? targetedBB.field_72338_b - 0.002 : (side == Direction.UP ? targetedBB.field_72337_e + 0.002 : vec.field_72448_b), side == Direction.NORTH ? targetedBB.field_72339_c - 0.002 : (side == Direction.SOUTH ? targetedBB.field_72334_f + 0.002 : vec.field_72449_c));
            }
            translatedPositions[i] = vec;
        }
        IVertexBuilder triBuilder = buffers.getBuffer(IERenderTypes.TRANSLUCENT_TRIANGLES);
        Vec3d center = translatedPositions[0];
        for (int i = 2; i < translatedPositions.length; ++i) {
            Vec3d point = translatedPositions[i];
            Vec3d prevPoint = translatedPositions[i - 1];
            for (Vec3d p : new Vec3d[]{center, prevPoint, point}) {
                triBuilder.func_227888_a_(transform, (float)p.field_72450_a, (float)p.field_72448_b, (float)p.field_72449_c).func_227885_a_(Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.4f).func_181675_d();
            }
        }
        IVertexBuilder lineBuilder = buffers.getBuffer(IERenderTypes.TRANSLUCENT_LINES);
        for (int i = 0; i <= translatedPositions.length; ++i) {
            Vec3d point = translatedPositions[i % translatedPositions.length];
            int max = i == 0 || i == translatedPositions.length ? 1 : 2;
            for (int j = 0; j < max; ++j) {
                lineBuilder.func_227888_a_(transform, (float)point.field_72450_a, (float)point.field_72448_b, (float)point.field_72449_c).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
            }
        }
    }

    public static void drawAdditionalBlockbreak(DrawHighlightEvent ev, PlayerEntity player, float partialTicks, Collection<BlockPos> blocks) {
        Vec3d renderView = ev.getInfo().func_216785_c();
        for (BlockPos pos : blocks) {
            ev.getContext().func_228429_a_(ev.getMatrix(), ev.getBuffers().getBuffer(RenderType.func_228659_m_()), (Entity)player, renderView.field_72450_a, renderView.field_72448_b, renderView.field_72449_c, pos, ClientUtils.mc().field_71441_e.func_180495_p(pos));
        }
        MatrixStack transform = ev.getMatrix();
        transform.func_227860_a_();
        transform.func_227861_a_(-renderView.field_72450_a, -renderView.field_72448_b, -renderView.field_72449_c);
        PlayerController controllerMP = ClientUtils.mc().field_71442_b;
        if (controllerMP.field_78778_j) {
            ClientUtils.drawBlockDamageTexture(transform, ev.getBuffers(), (Entity)player, partialTicks, player.field_70170_p, blocks);
        }
        transform.func_227865_b_();
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        float partial = event.getPartialTicks();
        MatrixStack transform = event.getMatrixStack();
        transform.func_227860_a_();
        Vec3d renderView = ClientUtils.mc().field_71460_t.func_215316_n().func_216785_c();
        transform.func_227861_a_(-renderView.field_72450_a, -renderView.field_72448_b, -renderView.field_72449_c);
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        if (!FractalParticle.PARTICLE_FRACTAL_DEQUE.isEmpty()) {
            ArrayList<Pair> renders = new ArrayList<Pair>();
            for (FractalParticle fractalParticle : FractalParticle.PARTICLE_FRACTAL_DEQUE) {
                for (Map.Entry entry : fractalParticle.render(partial, transform)) {
                    boolean added = false;
                    for (Map.Entry entry2 : renders) {
                        if (!((RenderType)entry2.getKey()).equals(entry.getKey())) continue;
                        ((List)entry2.getValue()).add(entry.getValue());
                        added = true;
                        break;
                    }
                    if (added) continue;
                    renders.add(Pair.of(entry.getKey(), new ArrayList(ImmutableList.of(entry.getValue()))));
                }
            }
            for (Map.Entry entry : renders) {
                IVertexBuilder bb = buffers.getBuffer((RenderType)entry.getKey());
                for (Consumer render : (List)entry.getValue()) {
                    render.accept(bb);
                }
            }
            FractalParticle.PARTICLE_FRACTAL_DEQUE.clear();
        }
        if (!FAILED_CONNECTIONS.isEmpty()) {
            IVertexBuilder builder = buffers.getBuffer(IERenderTypes.CHUNK_MARKER);
            for (Map.Entry entry : FAILED_CONNECTIONS.entrySet()) {
                Connection conn = (Connection)entry.getKey();
                transform.func_227860_a_();
                transform.func_227861_a_((double)conn.getEndA().getX(), (double)conn.getEndA().getY(), (double)conn.getEndA().getZ());
                Matrix4f matrix4f = transform.func_227866_c_().func_227870_a_();
                int time = ((AtomicInteger)((Pair)entry.getValue()).getValue()).get();
                float alpha = (float)Math.min((2.0 + Math.sin((double)time * Math.PI / 40.0)) / 3.0, (double)((float)time / 20.0f));
                Vec3d vec3d = conn.getPoint(0.0, conn.getEndA());
                for (int i = 0; i < 16; ++i) {
                    void var13_28;
                    builder.func_227888_a_(matrix4f, (float)var13_28.field_72450_a, (float)var13_28.field_72448_b, (float)var13_28.field_72449_c).func_227885_a_(1.0f, 0.0f, 0.0f, alpha).func_181675_d();
                    alpha = (float)Math.min((2.0 + Math.sin((double)(time + (i + 1) * 8) * Math.PI / 40.0)) / 3.0, (double)((float)time / 20.0f));
                    Vec3d next = conn.getPoint((double)(i + 1) / 16.0, conn.getEndA());
                    builder.func_227888_a_(matrix4f, (float)next.field_72450_a, (float)next.field_72448_b, (float)next.field_72449_c).func_227885_a_(1.0f, 0.0f, 0.0f, alpha).func_181675_d();
                    Vec3d vec3d2 = next;
                }
                transform.func_227865_b_();
            }
            this.renderObstructingBlocks(transform, (IRenderTypeBuffer)buffers);
        }
        transform.func_227865_b_();
        buffers.func_228461_a_();
    }

    @SubscribeEvent
    public void onClientDeath(LivingDeathEvent event) {
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre event) {
        if (event.getEntity().getPersistentData().func_74764_b("headshot")) {
            ClientEventHandler.enableHead(event.getRenderer(), false);
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post event) {
        if (event.getEntity().getPersistentData().func_74764_b("headshot")) {
            ClientEventHandler.enableHead(event.getRenderer(), true);
        }
    }

    private static void enableHead(LivingRenderer renderer, boolean shouldEnable) {
        EntityModel m = renderer.func_217764_d();
        if (m instanceof IHasHead) {
            ((IHasHead)m).func_205072_a().field_78806_j = shouldEnable;
        }
    }

    private static /* synthetic */ void lambda$onRenderOverlayPost$3(boolean drill, PlayerEntity player, Hand hand, MatrixStack transform, IVertexBuilder builder, ItemStack equipped, IRenderTypeBuffer.Impl buffer, boolean buzzsaw, IFluidHandlerItem handler) {
        int capacity = -1;
        if (handler.getTanks() > 0) {
            capacity = handler.getTankCapacity(0);
        }
        if (capacity > 0) {
            FluidStack fuel = handler.getFluidInTank(0);
            int amount = fuel.getAmount();
            if (!drill && player.func_184587_cr() && player.func_184600_cs() == hand) {
                int use = player.func_184612_cw();
                amount -= use * (Integer)IEConfig.TOOLS.chemthrower_consumption.get();
            }
            float cap = capacity;
            float angle = 83.0f - (float)(166 * amount) / cap;
            transform.func_227860_a_();
            transform.func_227863_a_(new Quaternion(0.0f, 0.0f, angle, true));
            ClientUtils.drawTexturedRect(builder, transform, 6.0f, -2.0f, 24.0f, 4.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.35546875f, 0.48046875f, 0.3125f, 0.33984375f);
            transform.func_227865_b_();
            transform.func_227861_a_(23.0, 37.0, 0.0);
            if (drill) {
                ClientUtils.drawTexturedRect(builder, transform, -54.0f, -73.0f, 66.0f, 72.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.421875f, 0.6796875f, 0.015625f, 0.296875f);
                ItemStack head = ((DrillItem)equipped.func_77973_b()).getHead(equipped);
                if (!head.func_190926_b()) {
                    ClientUtils.renderItemWithOverlayIntoGUI((IRenderTypeBuffer)buffer, transform, head, -51, -45);
                }
            } else if (buzzsaw) {
                ClientUtils.drawTexturedRect(builder, transform, -54.0f, -73.0f, 66.0f, 72.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.421875f, 0.6796875f, 0.015625f, 0.296875f);
                ItemStack blade = ((BuzzsawItem)equipped.func_77973_b()).getSawblade(equipped);
                if (!blade.func_190926_b()) {
                    ClientUtils.renderItemWithOverlayIntoGUI((IRenderTypeBuffer)buffer, transform, blade, -51, -45);
                }
            } else {
                ClientUtils.drawTexturedRect(builder, transform, -41.0f, -73.0f, 53.0f, 72.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.03125f, 0.23828125f, 0.015625f, 0.296875f);
                boolean ignite = ChemthrowerItem.isIgniteEnable(equipped);
                ClientUtils.drawTexturedRect(builder, transform, -32.0f, -43.0f, 12.0f, 12.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.2578125f, 0.3046875f, (float)(ignite ? 21 : 9) / 256.0f, (float)(ignite ? 33 : 21) / 256.0f);
                ClientUtils.drawTexturedRect(builder, transform, -100.0f, -20.0f, 64.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.25f, 0.296875f, 0.359375f);
                if (!fuel.isEmpty()) {
                    String name = ClientUtils.font().func_78269_a(fuel.getDisplayName().func_150254_d(), 50).trim();
                    ClientUtils.font().func_228079_a_(name, (float)(-68 - ClientUtils.font().func_78256_a(name) / 2), -15.0f, 0, false, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                }
            }
        }
    }
}

