/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.client.models.SmartLightingQuad;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.fluids.IEFluid;
import blusunrize.immersiveengineering.common.util.sound.IETileSound;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.MatrixApplyingVertexBuilder;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.EnderChestBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.apache.commons.compress.utils.IOUtils;

public class ClientUtils {
    static HashMap<String, ResourceLocation> resourceMap = new HashMap();
    public static TextureAtlasSprite[] destroyBlockIcons = new TextureAtlasSprite[10];
    private static final Vec3d fadingOffset = new Vec3d((double)1.0E-4f, (double)1.0E-4f, (double)1.0E-4f);
    private static float[] alphaFirst2Fading = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    private static float[] alphaNoFading = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[][] quadCoords = new float[4][3];
    private static final int[][] neighbourBrightness = new int[2][6];
    private static final float[][] normalizationFactors = new float[2][8];

    public static Tessellator tes() {
        return Tessellator.func_178181_a();
    }

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static void bindTexture(String path) {
        ClientUtils.mc().func_110434_K().func_110577_a(ClientUtils.getResource(path));
    }

    public static void bindAtlas() {
        ClientUtils.mc().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
    }

    public static ResourceLocation getResource(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return rl;
    }

    public static TextureAtlasSprite getSprite(ResourceLocation rl) {
        return ClientUtils.mc().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(rl);
    }

    public static FontRenderer font() {
        return ClientUtils.mc().field_71466_p;
    }

    public static float partialTicks() {
        return ClientUtils.mc().func_184121_ak();
    }

    public static BufferedImage readBufferedImage(InputStream imageStream) throws IOException {
        BufferedImage bufferedimage;
        try {
            bufferedimage = ImageIO.read(imageStream);
        }
        finally {
            IOUtils.closeQuietly((Closeable)imageStream);
        }
        return bufferedimage;
    }

    public static FontRenderer unicodeFontRender() {
        return ClientUtils.mc().func_211500_ak().func_211504_a(new ResourceLocation("immersiveengineering", "unicode"));
    }

    public static String fomatTimestamp(long timestamp, TimestampFormat format) {
        String s = "";
        for (TimestampFormat core : TimestampFormat.coreValues) {
            if (!format.containsFormat(core) || timestamp < core.getTickCut()) continue;
            s = s + I18n.func_135052_a((String)("desc.immersiveengineering.info." + core.getLocalKey()), (Object[])new Object[]{Long.toString(timestamp / core.getTickCut())});
            timestamp %= core.getTickCut();
        }
        if (s.isEmpty()) {
            for (int i = TimestampFormat.coreValues.length - 1; i >= 0; --i) {
                if (!format.containsFormat(TimestampFormat.coreValues[i])) continue;
                s = I18n.func_135052_a((String)("desc.immersiveengineering.info." + TimestampFormat.coreValues[i].getLocalKey()), (Object[])new Object[]{0});
                break;
            }
        }
        return s;
    }

    public static int getDarkenedTextColour(int colour) {
        int r = (colour >> 16 & 0xFF) / 4;
        int g = (colour >> 8 & 0xFF) / 4;
        int b = (colour & 0xFF) / 4;
        return r << 16 | g << 8 | b;
    }

    public static IETileSound generatePositionedIESound(SoundEvent soundEvent, float volume, float pitch, boolean repeat, int delay, BlockPos pos) {
        IETileSound sound = new IETileSound(soundEvent, volume, pitch, repeat, delay, pos, ISound.AttenuationType.LINEAR, SoundCategory.BLOCKS);
        sound.evaluateVolume();
        ClientUtils.mc().func_147118_V().func_147682_a((ISound)sound);
        return sound;
    }

    public static List<ModelRenderer> copyModelRenderers(Model model, List<ModelRenderer> oldRenderers) {
        return oldRenderers;
    }

    public static void handleBipedRotations(BipedModel model, Entity entity) {
        if (!((Boolean)IEConfig.GENERAL.fancyItemHolding.get()).booleanValue()) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            for (Hand hand : Hand.values()) {
                boolean right;
                ItemStack heldItem = player.func_184586_b(hand);
                if (heldItem.func_190926_b()) continue;
                boolean bl = right = hand == Hand.MAIN_HAND == (player.func_184591_cq() == HandSide.RIGHT);
                if (heldItem.func_77973_b() instanceof RevolverItem) {
                    if (right) {
                        model.field_178723_h.field_78795_f = -1.39626f + model.field_78116_c.field_78795_f;
                        model.field_178723_h.field_78796_g = -0.08726f + model.field_78116_c.field_78796_g;
                        continue;
                    }
                    model.field_178724_i.field_78795_f = -1.39626f + model.field_78116_c.field_78795_f;
                    model.field_178724_i.field_78796_g = 0.08726f + model.field_78116_c.field_78796_g;
                    continue;
                }
                if (heldItem.func_77973_b() instanceof DrillItem || heldItem.func_77973_b() instanceof ChemthrowerItem) {
                    if (right) {
                        model.field_178724_i.field_78795_f = -0.87266f;
                        model.field_178724_i.field_78796_g = 0.5236f;
                        continue;
                    }
                    model.field_178723_h.field_78795_f = -0.87266f;
                    model.field_178723_h.field_78796_g = -0.5236f;
                    continue;
                }
                if (heldItem.func_77973_b() instanceof BuzzsawItem) {
                    if (right) {
                        model.field_178724_i.field_78795_f = -0.87266f;
                        model.field_178724_i.field_78796_g = 0.78539f;
                        continue;
                    }
                    model.field_178723_h.field_78795_f = -0.87266f;
                    model.field_178723_h.field_78796_g = -0.78539f;
                    continue;
                }
                if (!(heldItem.func_77973_b() instanceof RailgunItem)) continue;
                if (right) {
                    model.field_178723_h.field_78795_f = -0.87266f;
                    continue;
                }
                model.field_178724_i.field_78795_f = -0.87266f;
            }
        }
    }

    public static void drawBlockDamageTexture(MatrixStack matrix, IRenderTypeBuffer buffers, Entity entityIn, float partialTicks, World world, Collection<BlockPos> blocks) {
        int progress = (int)(Minecraft.func_71410_x().field_71442_b.field_78770_f * 10.0f) - 1;
        if (progress < 0 || progress >= ModelBakery.field_229320_k_.size()) {
            return;
        }
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        for (BlockPos blockpos : blocks) {
            BlockState iblockstate;
            boolean hasBreak;
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
            IVertexBuilder worldRendererIn = buffers.getBuffer((RenderType)ModelBakery.field_229320_k_.get(progress));
            worldRendererIn = new MatrixApplyingVertexBuilder(worldRendererIn, matrix.func_227866_c_());
            Block block = world.func_180495_p(blockpos).func_177230_c();
            TileEntity te = world.func_175625_s(blockpos);
            boolean bl = hasBreak = block instanceof ChestBlock || block instanceof EnderChestBlock || block instanceof AbstractSignBlock || block instanceof SkullBlock;
            if (!hasBreak) {
                boolean bl2 = hasBreak = te != null && te.canRenderBreaking();
            }
            if (!hasBreak && (iblockstate = world.func_180495_p(blockpos)).func_185904_a() != Material.field_151579_a) {
                blockrendererdispatcher.func_228792_a_(iblockstate, blockpos, (ILightReader)world, matrix, worldRendererIn);
            }
            matrix.func_227865_b_();
        }
    }

    public static void drawColouredRect(int x, int y, int w, int h, int colour) {
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        ClientUtils.drawColouredRect(x, y, w, h, colour, (IRenderTypeBuffer)buffers, new MatrixStack());
        buffers.func_228461_a_();
    }

    public static void drawColouredRect(int x, int y, int w, int h, int colour, IRenderTypeBuffer buffers, MatrixStack transform) {
        Matrix4f mat = transform.func_227866_c_().func_227870_a_();
        IVertexBuilder worldrenderer = buffers.getBuffer(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
        worldrenderer.func_227888_a_(mat, (float)x, (float)(y + h), 0.0f).func_225586_a_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF).func_181675_d();
        worldrenderer.func_227888_a_(mat, (float)(x + w), (float)(y + h), 0.0f).func_225586_a_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF).func_181675_d();
        worldrenderer.func_227888_a_(mat, (float)(x + w), (float)y, 0.0f).func_225586_a_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF).func_181675_d();
        worldrenderer.func_227888_a_(mat, (float)x, (float)y, 0.0f).func_225586_a_(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF).func_181675_d();
    }

    public static void drawGradientRect(int x0, int y0, int x1, int y1, int colour0, int colour1) {
        float alpha0 = (float)(colour0 >> 24 & 0xFF) / 255.0f;
        float blue0 = (float)(colour0 >> 16 & 0xFF) / 255.0f;
        float green0 = (float)(colour0 >> 8 & 0xFF) / 255.0f;
        float red0 = (float)(colour0 & 0xFF) / 255.0f;
        float alpha1 = (float)(colour1 >> 24 & 0xFF) / 255.0f;
        float blue1 = (float)(colour1 >> 16 & 0xFF) / 255.0f;
        float green1 = (float)(colour1 >> 8 & 0xFF) / 255.0f;
        float red1 = (float)(colour1 & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_225582_a_((double)x1, (double)y0, 0.0).func_227885_a_(blue0, green0, red0, alpha0).func_181675_d();
        worldrenderer.func_225582_a_((double)x0, (double)y0, 0.0).func_227885_a_(blue0, green0, red0, alpha0).func_181675_d();
        worldrenderer.func_225582_a_((double)x0, (double)y1, 0.0).func_227885_a_(blue1, green1, red1, alpha1).func_181675_d();
        worldrenderer.func_225582_a_((double)x1, (double)y1, 0.0).func_227885_a_(blue1, green1, red1, alpha1).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawTexturedRect(IVertexBuilder builder, MatrixStack transform, float x, float y, float w, float h, float r, float g, float b, float alpha, float u0, float u1, float v0, float v1) {
        Matrix4f mat = transform.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(mat, x, y + h, 0.0f).func_227885_a_(r, g, b, alpha).func_225583_a_(u0, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(1.0f, 1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, x + w, y + h, 0.0f).func_227885_a_(r, g, b, alpha).func_225583_a_(u1, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(1.0f, 1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, x + w, y, 0.0f).func_227885_a_(r, g, b, alpha).func_225583_a_(u1, v0).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(1.0f, 1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, x, y, 0.0f).func_227885_a_(r, g, b, alpha).func_225583_a_(u0, v0).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(1.0f, 1.0f, 1.0f).func_181675_d();
    }

    public static void drawTexturedRect(IVertexBuilder builder, MatrixStack transform, int x, int y, int w, int h, float picSize, int u0, int u1, int v0, int v1) {
        ClientUtils.drawTexturedRect(builder, transform, x, y, w, h, 1.0f, 1.0f, 1.0f, 1.0f, (float)u0 / picSize, (float)u1 / picSize, (float)v0 / picSize, (float)v1 / picSize);
    }

    public static void drawRepeatedFluidSpriteGui(IRenderTypeBuffer buffer, MatrixStack transform, FluidStack fluid, float x, float y, float w, float h) {
        RenderType renderType = IERenderTypes.getGui(PlayerContainer.field_226615_c_);
        IVertexBuilder builder = buffer.getBuffer(renderType);
        ClientUtils.drawRepeatedFluidSprite(builder, transform, fluid, x, y, w, h);
    }

    public static void drawRepeatedFluidSprite(IVertexBuilder builder, MatrixStack transform, FluidStack fluid, float x, float y, float w, float h) {
        TextureAtlasSprite sprite = ClientUtils.getSprite(fluid.getFluid().getAttributes().getStillTexture(fluid));
        int col = fluid.getFluid().getAttributes().getColor(fluid);
        int iW = sprite.func_94211_a();
        int iH = sprite.func_94216_b();
        if (iW > 0 && iH > 0) {
            ClientUtils.drawRepeatedSprite(builder, transform, x, y, w, h, iW, iH, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h(), (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, 1.0f);
        }
    }

    public static void drawRepeatedSprite(IVertexBuilder builder, MatrixStack transform, float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float alpha) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientUtils.drawTexturedRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), iconWidth, iconHeight, r, g, b, alpha, uMin, uMax, vMin, vMax);
            }
            ClientUtils.drawTexturedRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), iconWidth, leftoverH, r, g, b, alpha, uMin, uMax, vMin, vMin + iconVDif * leftoverHf);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientUtils.drawTexturedRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, iconHeight, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMax);
            }
            ClientUtils.drawTexturedRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf);
        }
    }

    public static void drawSlot(int x, int y, int w, int h) {
        ClientUtils.drawSlot(x, y, w, h, 255);
    }

    public static void drawSlot(int x, int y, int w, int h, int alpha) {
        ClientUtils.drawColouredRect(x + 8 - w / 2, y + 8 - h / 2 - 1, w, 1, (alpha << 24) + 0x373737);
        ClientUtils.drawColouredRect(x + 8 - w / 2 - 1, y + 8 - h / 2 - 1, 1, h + 1, (alpha << 24) + 0x373737);
        ClientUtils.drawColouredRect(x + 8 - w / 2, y + 8 - h / 2, w, h, (alpha << 24) + 0x8B8B8B);
        ClientUtils.drawColouredRect(x + 8 - w / 2, y + 8 + h / 2, w + 1, 1, (alpha << 24) + 0xFFFFFF);
        ClientUtils.drawColouredRect(x + 8 + w / 2, y + 8 - h / 2, 1, h, (alpha << 24) + 0xFFFFFF);
    }

    public static void drawDarkSlot(int x, int y, int w, int h) {
        ClientUtils.drawColouredRect(x + 8 - w / 2, y + 8 - h / 2 - 1, w, 1, 0x77222222);
        ClientUtils.drawColouredRect(x + 8 - w / 2 - 1, y + 8 - h / 2 - 1, 1, h + 1, 0x77222222);
        ClientUtils.drawColouredRect(x + 8 - w / 2, y + 8 - h / 2, w, h, 0x77111111);
        ClientUtils.drawColouredRect(x + 8 - w / 2, y + 8 + h / 2, w + 1, 1, 0x77999999);
        ClientUtils.drawColouredRect(x + 8 + w / 2, y + 8 - h / 2, 1, h, 0x77999999);
    }

    public static void drawHoveringText(List<ITextComponent> list, int x, int y, FontRenderer font, int xSize, int ySize) {
        ArrayList<String> textTooltip = new ArrayList<String>(list.size());
        for (ITextComponent c : list) {
            textTooltip.add(c.func_150254_d());
        }
        GuiUtils.drawHoveringText(textTooltip, (int)x, (int)y, (int)xSize, (int)ySize, (int)-1, (FontRenderer)font);
    }

    public static void handleGuiTank(IFluidTank tank, int x, int y, int w, int h, int oX, int oY, int oW, int oH, int mX, int mY, String originalTexture, List<ITextComponent> tooltip) {
        ClientUtils.handleGuiTank(tank.getFluid(), tank.getCapacity(), x, y, w, h, oX, oY, oW, oH, mX, mY, originalTexture, tooltip);
    }

    public static void handleGuiTank(FluidStack fluid, int capacity, int x, int y, int w, int h, int oX, int oY, int oW, int oH, int mX, int mY, String originalTexture, List<ITextComponent> tooltip) {
        if (tooltip == null) {
            RenderSystem.pushMatrix();
            IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            MatrixStack transform = new MatrixStack();
            if (fluid != null && fluid.getFluid() != null) {
                int fluidHeight = (int)((float)h * ((float)fluid.getAmount() / (float)capacity));
                ClientUtils.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)buffer, transform, fluid, x, y + h - fluidHeight, w, fluidHeight);
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            int xOff = (w - oW) / 2;
            int yOff = (h - oH) / 2;
            RenderType renderType = IERenderTypes.getGui(new ResourceLocation(originalTexture));
            ClientUtils.drawTexturedRect(buffer.getBuffer(renderType), transform, x + xOff, y + yOff, oW, oH, 256.0f, oX, oX + oW, oY, oY + oH);
            buffer.func_228462_a_(renderType);
            RenderSystem.popMatrix();
        } else if (mX >= x && mX < x + w && mY >= y && mY < y + h) {
            ClientUtils.addFluidTooltip(fluid, tooltip, capacity);
        }
    }

    public static void addFluidTooltip(FluidStack fluid, List<ITextComponent> tooltip, int tankCapacity) {
        if (!fluid.isEmpty()) {
            tooltip.add(fluid.getDisplayName().func_150255_a(new Style().func_150238_a(fluid.getFluid().getAttributes().getRarity((FluidStack)fluid).field_77937_e)));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("gui.immersiveengineering.empty", new Object[0]));
        }
        if (fluid.getFluid() instanceof IEFluid) {
            ((IEFluid)fluid.getFluid()).addTooltipInfo(fluid, null, tooltip);
        }
        if (ClientUtils.mc().field_71474_y.field_82882_x && !fluid.isEmpty()) {
            if (!Screen.hasShiftDown()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.holdShiftForInfo", new Object[0]));
            } else {
                Style darkGray = new Style().func_150238_a(TextFormatting.DARK_GRAY);
                tooltip.add(new StringTextComponent("Fluid Registry: " + fluid.getFluid().getRegistryName()).func_150255_a(darkGray));
                tooltip.add(new StringTextComponent("Density: " + fluid.getFluid().getAttributes().getDensity(fluid)).func_150255_a(darkGray));
                tooltip.add(new StringTextComponent("Temperature: " + fluid.getFluid().getAttributes().getTemperature(fluid)).func_150255_a(darkGray));
                tooltip.add(new StringTextComponent("Viscosity: " + fluid.getFluid().getAttributes().getViscosity(fluid)).func_150255_a(darkGray));
                tooltip.add(new StringTextComponent("NBT Data: " + fluid.getTag()).func_150255_a(darkGray));
            }
        }
        Style gray = new Style().func_150238_a(TextFormatting.GRAY);
        if (tankCapacity > 0) {
            tooltip.add(new StringTextComponent(fluid.getAmount() + "/" + tankCapacity + "mB").func_150255_a(gray));
        } else {
            tooltip.add(new StringTextComponent(fluid.getAmount() + "mB").func_150255_a(gray));
        }
    }

    public static Quaternion degreeToQuaterion(double x, double y, double z) {
        x = Math.toRadians(x);
        y = Math.toRadians(y);
        z = Math.toRadians(z);
        Quaternion qYaw = new Quaternion(0.0f, (float)Math.sin(y / 2.0), 0.0f, (float)Math.cos(y / 2.0));
        Quaternion qPitch = new Quaternion((float)Math.sin(x / 2.0), 0.0f, 0.0f, (float)Math.cos(x / 2.0));
        Quaternion qRoll = new Quaternion(0.0f, 0.0f, (float)Math.sin(z / 2.0), (float)Math.cos(z / 2.0));
        Quaternion quat = qYaw;
        quat.func_195890_a(qRoll);
        quat.func_195890_a(qPitch);
        return quat;
    }

    public static List<BakedQuad>[] convertConnectionFromBlockstate(BlockPos here, Set<Connection.RenderData> data, TextureAtlasSprite t) {
        List[] ret = new List[]{new ArrayList(), new ArrayList()};
        if (data == null) {
            return ret;
        }
        Vec3d dir = Vec3d.field_186680_a;
        Vec3d cross = Vec3d.field_186680_a;
        Vec3d up = new Vec3d(0.0, 1.0, 0.0);
        for (Connection.RenderData connData : data) {
            int color = connData.color;
            float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
            if (rgb[3] == 0.0f) {
                rgb[3] = 1.0f;
            }
            float radius = (float)(connData.type.getRenderDiameter() / 2.0);
            for (int i = 1; i < connData.pointsToRender; ++i) {
                boolean vertical;
                boolean fading = i == connData.pointsToRender - 1 && connData.pointsToRender <= 16;
                List curr = ret[fading ? 1 : 0];
                int j = i - 1;
                Vec3d current = connData.getPoint(i);
                Vec3d previous = connData.getPoint(j);
                if (fading) {
                    current = current.func_178787_e(fadingOffset);
                    previous = previous.func_178787_e(fadingOffset);
                }
                boolean bl = vertical = current.field_72450_a == previous.field_72450_a && current.field_72449_c == previous.field_72449_c;
                if (!vertical) {
                    dir = current.func_178788_d(previous);
                    cross = up.func_72431_c(dir);
                    cross = cross.func_186678_a((double)radius / cross.func_72433_c());
                } else {
                    cross = new Vec3d((double)radius, 0.0, 0.0);
                }
                Vec3d[] vertices = new Vec3d[]{current.func_178787_e(cross), current.func_178788_d(cross), previous.func_178788_d(cross), previous.func_178787_e(cross)};
                curr.add(ClientUtils.createSmartLightingBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.DOWN, t, rgb, false, fading ? alphaFirst2Fading : alphaNoFading, here));
                curr.add(ClientUtils.createSmartLightingBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.UP, t, rgb, true, fading ? alphaFirst2Fading : alphaNoFading, here));
                if (!vertical) {
                    cross = dir.func_72431_c(cross);
                    cross = cross.func_186678_a((double)radius / cross.func_72433_c());
                } else {
                    cross = new Vec3d(0.0, 0.0, (double)radius);
                }
                vertices = new Vec3d[]{current.func_178787_e(cross), current.func_178788_d(cross), previous.func_178788_d(cross), previous.func_178787_e(cross)};
                curr.add(ClientUtils.createSmartLightingBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.WEST, t, rgb, false, fading ? alphaFirst2Fading : alphaNoFading, here));
                curr.add(ClientUtils.createSmartLightingBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.EAST, t, rgb, true, fading ? alphaFirst2Fading : alphaNoFading, here));
            }
        }
        return ret;
    }

    public static int getVertexCountForSide(ConnectionPoint start, Connection conn, int totalPoints) {
        ArrayList<Integer> crossings = new ArrayList<Integer>();
        Vec3d lastPoint = conn.getPoint(0.0, start);
        for (int i = 1; i <= totalPoints; ++i) {
            Vec3d current = conn.getPoint((double)i / (double)totalPoints, start);
            if (ClientUtils.crossesChunkBoundary(current, lastPoint, start.getPosition())) {
                crossings.add(i);
            }
            lastPoint = current;
        }
        int index = crossings.size() / 2;
        boolean greater = conn.isPositiveEnd(start);
        if (crossings.size() % 2 == 0 && greater) {
            --index;
        }
        if (crossings.size() > 0) {
            return (Integer)crossings.get(index) + (greater ? 1 : 2);
        }
        return greater ? totalPoints + 1 : 0;
    }

    public static Vec3d[] applyMatrixToVertices(TransformationMatrix matrix, Vec3d ... vertices) {
        if (matrix == null) {
            return vertices;
        }
        Vec3d[] ret = new Vec3d[vertices.length];
        for (int i = 0; i < ret.length; ++i) {
            Vector4f vec = new Vector4f((float)vertices[i].field_72450_a, (float)vertices[i].field_72448_b, (float)vertices[i].field_72449_c, 1.0f);
            matrix.transformPosition(vec);
            vec.func_229375_f_();
            ret[i] = new Vec3d((double)vec.func_195910_a(), (double)vec.func_195913_b(), (double)vec.func_195914_c());
        }
        return ret;
    }

    public static Set<BakedQuad> createBakedBox(Vec3d from, Vec3d to, Matrix4 matrix, Function<Direction, TextureAtlasSprite> textureGetter, float[] colour) {
        return ClientUtils.createBakedBox(from, to, matrix, Direction.NORTH, textureGetter, colour);
    }

    public static Set<BakedQuad> createBakedBox(Vec3d from, Vec3d to, Matrix4 matrix, Direction facing, Function<Direction, TextureAtlasSprite> textureGetter, float[] colour) {
        return ClientUtils.createBakedBox(from, to, matrix, facing, vertices -> vertices, textureGetter, colour);
    }

    @Nonnull
    public static Set<BakedQuad> createBakedBox(Vec3d from, Vec3d to, Matrix4 matrixIn, Direction facing, Function<Vec3d[], Vec3d[]> vertexTransformer, Function<Direction, TextureAtlasSprite> textureGetter, float[] colour) {
        Vec3d v2;
        int i;
        TransformationMatrix matrix = matrixIn.toTransformationMatrix();
        HashSet<BakedQuad> quads = new HashSet<BakedQuad>();
        if (vertexTransformer == null) {
            vertexTransformer = v -> v;
        }
        Vec3d[] vertices = new Vec3d[]{new Vec3d(from.field_72450_a, from.field_72448_b, from.field_72449_c), new Vec3d(from.field_72450_a, from.field_72448_b, to.field_72449_c), new Vec3d(to.field_72450_a, from.field_72448_b, to.field_72449_c), new Vec3d(to.field_72450_a, from.field_72448_b, from.field_72449_c)};
        TextureAtlasSprite sprite = textureGetter.apply(Direction.DOWN);
        if (sprite != null) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.DOWN, facing), sprite, new double[]{from.field_72450_a * 16.0, 16.0 - from.field_72449_c * 16.0, to.field_72450_a * 16.0, 16.0 - to.field_72449_c * 16.0}, colour, true));
        }
        for (i = 0; i < vertices.length; ++i) {
            v2 = vertices[i];
            vertices[i] = new Vec3d(v2.field_72450_a, to.field_72448_b, v2.field_72449_c);
        }
        sprite = textureGetter.apply(Direction.UP);
        if (sprite != null) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.UP, facing), sprite, new double[]{from.field_72450_a * 16.0, from.field_72449_c * 16.0, to.field_72450_a * 16.0, to.field_72449_c * 16.0}, colour, false));
        }
        vertices = new Vec3d[]{new Vec3d(to.field_72450_a, to.field_72448_b, from.field_72449_c), new Vec3d(to.field_72450_a, from.field_72448_b, from.field_72449_c), new Vec3d(from.field_72450_a, from.field_72448_b, from.field_72449_c), new Vec3d(from.field_72450_a, to.field_72448_b, from.field_72449_c)};
        sprite = textureGetter.apply(Direction.NORTH);
        if (sprite != null) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.NORTH, facing), sprite, new double[]{from.field_72450_a * 16.0, 16.0 - to.field_72448_b * 16.0, to.field_72450_a * 16.0, 16.0 - from.field_72448_b * 16.0}, colour, false));
        }
        for (i = 0; i < vertices.length; ++i) {
            v2 = vertices[i];
            vertices[i] = new Vec3d(v2.field_72450_a, v2.field_72448_b, to.field_72449_c);
        }
        sprite = textureGetter.apply(Direction.SOUTH);
        if (sprite != null) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.SOUTH, facing), sprite, new double[]{to.field_72450_a * 16.0, 16.0 - to.field_72448_b * 16.0, from.field_72450_a * 16.0, 16.0 - from.field_72448_b * 16.0}, colour, true));
        }
        vertices = new Vec3d[]{new Vec3d(from.field_72450_a, to.field_72448_b, to.field_72449_c), new Vec3d(from.field_72450_a, from.field_72448_b, to.field_72449_c), new Vec3d(from.field_72450_a, from.field_72448_b, from.field_72449_c), new Vec3d(from.field_72450_a, to.field_72448_b, from.field_72449_c)};
        sprite = textureGetter.apply(Direction.WEST);
        if (sprite != null) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.WEST, facing), sprite, new double[]{to.field_72449_c * 16.0, 16.0 - to.field_72448_b * 16.0, from.field_72449_c * 16.0, 16.0 - from.field_72448_b * 16.0}, colour, true));
        }
        for (i = 0; i < vertices.length; ++i) {
            v2 = vertices[i];
            vertices[i] = new Vec3d(to.field_72450_a, v2.field_72448_b, v2.field_72449_c);
        }
        sprite = textureGetter.apply(Direction.EAST);
        if (sprite != null) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(Direction.EAST, facing), sprite, new double[]{16.0 - to.field_72449_c * 16.0, 16.0 - to.field_72448_b * 16.0, 16.0 - from.field_72449_c * 16.0, 16.0 - from.field_72448_b * 16.0}, colour, false));
        }
        return quads;
    }

    public static BakedQuad createBakedQuad(VertexFormat format, Vec3d[] vertices, Direction facing, TextureAtlasSprite sprite, float[] colour, boolean invert, float[] alpha) {
        return ClientUtils.createBakedQuad(format, vertices, facing, sprite, new double[]{0.0, 0.0, 16.0, 16.0}, colour, invert, alpha);
    }

    public static BakedQuad createSmartLightingBakedQuad(VertexFormat format, Vec3d[] vertices, Direction facing, TextureAtlasSprite sprite, float[] colour, boolean invert, float[] alpha, BlockPos base) {
        return ClientUtils.createBakedQuad(format, vertices, facing, sprite, new double[]{0.0, 0.0, 16.0, 16.0}, colour, invert, alpha, true, base);
    }

    public static BakedQuad createBakedQuad(VertexFormat format, Vec3d[] vertices, Direction facing, TextureAtlasSprite sprite, double[] uvs, float[] colour, boolean invert) {
        return ClientUtils.createBakedQuad(format, vertices, facing, sprite, uvs, colour, invert, alphaNoFading);
    }

    public static BakedQuad createBakedQuad(VertexFormat format, Vec3d[] vertices, Direction facing, TextureAtlasSprite sprite, double[] uvs, float[] colour, boolean invert, float[] alpha) {
        return ClientUtils.createBakedQuad(format, vertices, facing, sprite, uvs, colour, invert, alpha, false, null);
    }

    public static BakedQuad createBakedQuad(VertexFormat format, Vec3d[] vertices, Direction facing, TextureAtlasSprite sprite, double[] uvs, float[] colour, boolean invert, float[] alpha, boolean smartLighting, BlockPos basePos) {
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(facing);
        builder.setApplyDiffuseLighting(true);
        Vec3d faceNormal = new Vec3d(facing.func_176730_m());
        int vId = invert ? 3 : 0;
        int u = vId > 1 ? 2 : 0;
        ClientUtils.putVertexData(format, builder, vertices[vId], faceNormal, uvs[u], uvs[1], sprite, colour, alpha[vId]);
        vId = invert ? 2 : 1;
        u = vId > 1 ? 2 : 0;
        ClientUtils.putVertexData(format, builder, vertices[vId], faceNormal, uvs[u], uvs[3], sprite, colour, alpha[vId]);
        vId = invert ? 1 : 2;
        u = vId > 1 ? 2 : 0;
        ClientUtils.putVertexData(format, builder, vertices[vId], faceNormal, uvs[u], uvs[3], sprite, colour, alpha[vId]);
        vId = invert ? 0 : 3;
        u = vId > 1 ? 2 : 0;
        ClientUtils.putVertexData(format, builder, vertices[vId], faceNormal, uvs[u], uvs[1], sprite, colour, alpha[vId]);
        BakedQuad tmp = builder.build();
        return smartLighting ? new SmartLightingQuad(tmp.func_178209_a(), -1, facing, sprite, basePos) : tmp;
    }

    public static void putVertexData(VertexFormat format, BakedQuadBuilder builder, Vec3d pos, Vec3d faceNormal, double u, double v, TextureAtlasSprite sprite, float[] colour, float alpha) {
        block6: for (int e = 0; e < format.func_227894_c_().size(); ++e) {
            switch (((VertexFormatElement)format.func_227894_c_().get(e)).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c});
                    continue block6;
                }
                case COLOR: {
                    float d = 1.0f;
                    builder.put(e, new float[]{d * colour[0], d * colour[1], d * colour[2], 1.0f * colour[3] * alpha});
                    continue block6;
                }
                case UV: {
                    if (((VertexFormatElement)format.func_227894_c_().get(e)).func_177367_b() == VertexFormatElement.Type.FLOAT) {
                        if (sprite == null) {
                            sprite = ClientUtils.getMissingSprite();
                        }
                        builder.put(e, new float[]{sprite.func_94214_a(u), sprite.func_94207_b(v)});
                        continue block6;
                    }
                    builder.put(e, new float[]{0.0f, 0.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)faceNormal.func_82615_a(), (float)faceNormal.func_82617_b(), (float)faceNormal.func_82616_c()});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private static TextureAtlasSprite getMissingSprite() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(MissingTextureSprite.func_195675_b());
    }

    public static boolean crossesChunkBoundary(Vec3d start, Vec3d end, BlockPos offset) {
        if (ClientUtils.crossesChunkBorderSingleDim(start.field_72450_a, end.field_72450_a, offset.func_177958_n())) {
            return true;
        }
        if (ClientUtils.crossesChunkBorderSingleDim(start.field_72448_b, end.field_72448_b, offset.func_177956_o())) {
            return true;
        }
        return ClientUtils.crossesChunkBorderSingleDim(start.field_72449_c, end.field_72449_c, offset.func_177952_p());
    }

    private static boolean crossesChunkBorderSingleDim(double a, double b, int offset) {
        return (int)Math.floor(a + (double)offset) >> 4 != (int)Math.floor(b + (double)offset) >> 4;
    }

    public static ResourceLocation getSideTexture(@Nonnull ItemStack stack, Direction side) {
        IBakedModel model = ClientUtils.mc().func_175599_af().func_184393_a(stack, null, null);
        return ClientUtils.getSideTexture(model, side, null);
    }

    public static ResourceLocation getSideTexture(@Nonnull BlockState state, Direction side) {
        IBakedModel model = ClientUtils.mc().func_175602_ab().func_184389_a(state);
        return ClientUtils.getSideTexture(model, side, state);
    }

    public static ResourceLocation getSideTexture(@Nonnull IBakedModel model, Direction side, @Nullable BlockState state) {
        List quads = model.func_200117_a(state, side, Utils.RAND);
        if (quads == null || quads.isEmpty()) {
            quads = model.func_200117_a(state, null, Utils.RAND);
        }
        if (quads == null || quads.isEmpty()) {
            return null;
        }
        return ((BakedQuad)quads.get(0)).func_187508_a().func_195668_m();
    }

    public static Vector4f pulseRGBAlpha(Vector4f rgba, int tickrate, float min, float max) {
        float f_alpha = (float)(ClientUtils.mc().field_71439_g.field_70173_aa % (tickrate * 2)) / (float)tickrate;
        if (f_alpha > 1.0f) {
            f_alpha = 2.0f - f_alpha;
        }
        return new Vector4f(rgba.func_195910_a(), rgba.func_195913_b(), rgba.func_195914_c(), MathHelper.func_76131_a((float)f_alpha, (float)min, (float)max));
    }

    public static void renderBox(IVertexBuilder wr, double x0, double y0, double z0, double x1, double y1, double z1) {
        ClientUtils.renderBox(wr, new MatrixStack(), (float)x0, (float)y0, (float)z0, (float)x1, (float)y1, (float)z1);
    }

    public static void renderBox(IVertexBuilder wr, MatrixStack m, float x0, float y0, float z0, float x1, float y1, float z1) {
        Matrix4f transform = m.func_227866_c_().func_227870_a_();
        wr.func_227888_a_(transform, x0, y0, z1).func_181675_d();
        wr.func_227888_a_(transform, x1, y0, z1).func_181675_d();
        wr.func_227888_a_(transform, x1, y1, z1).func_181675_d();
        wr.func_227888_a_(transform, x0, y1, z1).func_181675_d();
        wr.func_227888_a_(transform, x0, y1, z0).func_181675_d();
        wr.func_227888_a_(transform, x1, y1, z0).func_181675_d();
        wr.func_227888_a_(transform, x1, y0, z0).func_181675_d();
        wr.func_227888_a_(transform, x0, y0, z0).func_181675_d();
        wr.func_227888_a_(transform, x0, y0, z0).func_181675_d();
        wr.func_227888_a_(transform, x1, y0, z0).func_181675_d();
        wr.func_227888_a_(transform, x1, y0, z1).func_181675_d();
        wr.func_227888_a_(transform, x0, y0, z1).func_181675_d();
        wr.func_227888_a_(transform, x0, y1, z1).func_181675_d();
        wr.func_227888_a_(transform, x1, y1, z1).func_181675_d();
        wr.func_227888_a_(transform, x1, y1, z0).func_181675_d();
        wr.func_227888_a_(transform, x0, y1, z0).func_181675_d();
        wr.func_227888_a_(transform, x0, y0, z0).func_181675_d();
        wr.func_227888_a_(transform, x0, y0, z1).func_181675_d();
        wr.func_227888_a_(transform, x0, y1, z1).func_181675_d();
        wr.func_227888_a_(transform, x0, y1, z0).func_181675_d();
        wr.func_227888_a_(transform, x1, y1, z0).func_181675_d();
        wr.func_227888_a_(transform, x1, y1, z1).func_181675_d();
        wr.func_227888_a_(transform, x1, y0, z1).func_181675_d();
        wr.func_227888_a_(transform, x1, y0, z0).func_181675_d();
    }

    public static void renderTexturedBox(BufferBuilder wr, float x0, float y0, float z0, float x1, float y1, float z1, TextureAtlasSprite tex, boolean yForV) {
        throw new UnsupportedOperationException();
    }

    public static void renderTexturedBox(IVertexBuilder wr, MatrixStack stack, float x0, float y0, float z0, float x1, float y1, float z1, TextureAtlasSprite tex, boolean yForV) {
        float minU = tex.func_94214_a((double)(x0 * 16.0f));
        float maxU = tex.func_94214_a((double)(x1 * 16.0f));
        float minV = tex.func_94207_b((double)((yForV ? y1 : z0) * 16.0f));
        float maxV = tex.func_94207_b((double)((yForV ? y0 : z1) * 16.0f));
        ClientUtils.renderTexturedBox(wr, stack, x0, y0, z0, x1, y1, z1, minU, minV, maxU, maxV);
    }

    public static void renderTexturedBox(BufferBuilder wr, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1) {
        throw new UnsupportedOperationException();
    }

    public static void renderTexturedBox(IVertexBuilder wr, MatrixStack stack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1) {
        Matrix4f mat = stack.func_227866_c_().func_227870_a_();
        Matrix3f nMat = stack.func_227866_c_().func_227872_b_();
        float normalX = 0.0f;
        float normalY = 0.0f;
        float normalZ = 1.0f;
        ClientUtils.putVertex(wr, stack, x0, y0, z1, u0, v0, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x1, y0, z1, u1, v0, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x1, y1, z1, u1, v1, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x0, y1, z1, u0, v1, normalX, normalY, normalZ);
        normalZ = -1.0f;
        ClientUtils.putVertex(wr, stack, x0, y1, z0, u0, v0, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x1, y1, z0, u1, v0, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x1, y0, z0, u1, v1, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x0, y0, z0, u0, v1, normalX, normalY, normalZ);
        normalZ = 0.0f;
        normalY = -1.0f;
        ClientUtils.putVertex(wr, stack, x0, y0, z0, u0, v0, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x1, y0, z0, u1, v0, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x1, y0, z1, u1, v1, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x0, y0, z1, u0, v1, normalX, normalY, normalZ);
        normalY = 1.0f;
        ClientUtils.putVertex(wr, stack, x0, y1, z1, u0, v0, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x1, y1, z1, u1, v0, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x1, y1, z0, u1, v1, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x0, y1, z0, u0, v1, normalX, normalY, normalZ);
        normalY = 0.0f;
        normalX = -1.0f;
        ClientUtils.putVertex(wr, stack, x0, y0, z0, u0, v0, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x0, y0, z1, u1, v0, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x0, y1, z1, u1, v1, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x0, y1, z0, u0, v1, normalX, normalY, normalZ);
        normalX = 1.0f;
        ClientUtils.putVertex(wr, stack, x1, y1, z0, u0, v0, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x1, y1, z1, u1, v0, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x1, y0, z1, u1, v1, normalX, normalY, normalZ);
        ClientUtils.putVertex(wr, stack, x1, y0, z0, u0, v1, normalX, normalY, normalZ);
    }

    public static int findOffset(VertexFormat vf, VertexFormatElement.Usage u, VertexFormatElement.Type t) {
        int offset = 0;
        for (VertexFormatElement element : vf.func_227894_c_()) {
            if (element.func_177375_c() == u && element.func_177367_b() == t) {
                Preconditions.checkState((offset % 4 == 0 ? 1 : 0) != 0);
                return offset / 4;
            }
            offset += element.func_177368_f();
        }
        throw new IllegalStateException();
    }

    public static int findTextureOffset(VertexFormat vf) {
        return ClientUtils.findOffset(vf, VertexFormatElement.Usage.UV, VertexFormatElement.Type.FLOAT);
    }

    public static int findPositionOffset(VertexFormat vf) {
        return ClientUtils.findOffset(vf, VertexFormatElement.Usage.POSITION, VertexFormatElement.Type.FLOAT);
    }

    private static void putVertex(IVertexBuilder b, MatrixStack mat, float x, float y, float z, float u, float v, float nX, float nY, float nZ) {
        b.func_227888_a_(mat.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u, v).func_225587_b_(0, 0).func_227887_a_(mat.func_227866_c_().func_227872_b_(), nX, nY, nZ).func_181675_d();
    }

    public static int intFromRgb(float[] rgb) {
        int ret = (int)(255.0f * rgb[0]);
        ret = (ret << 8) + (int)(255.0f * rgb[1]);
        ret = (ret << 8) + (int)(255.0f * rgb[2]);
        return ret;
    }

    public static void renderModelTESRFancy(List<BakedQuad> quads, IVertexBuilder renderer, World world, BlockPos pos, boolean useCached, int color, int light) {
        if (((Boolean)IEConfig.GENERAL.disableFancyTESR.get()).booleanValue()) {
            ClientUtils.renderModelTESRFast(quads, renderer, new MatrixStack(), world.func_226659_b_(pos, 0), color);
        } else {
            if (!useCached) {
                for (Direction f : Direction.field_199792_n) {
                    int val = WorldRenderer.func_228421_a_((ILightReader)world, (BlockPos)pos.func_177972_a(f));
                    ClientUtils.neighbourBrightness[0][f.func_176745_a()] = val >> 16 & 0xFF;
                    ClientUtils.neighbourBrightness[1][f.func_176745_a()] = val & 0xFF;
                }
                for (int type = 0; type < 2; ++type) {
                    for (int i = 0; i < 8; ++i) {
                        float sSquared = 0.0f;
                        sSquared = (i & 1) != 0 ? (sSquared += ClientUtils.scaledSquared(neighbourBrightness[type][5], 255.0f)) : (sSquared += ClientUtils.scaledSquared(neighbourBrightness[type][4], 255.0f));
                        sSquared = (i & 2) != 0 ? (sSquared += ClientUtils.scaledSquared(neighbourBrightness[type][1], 255.0f)) : (sSquared += ClientUtils.scaledSquared(neighbourBrightness[type][0], 255.0f));
                        sSquared = (i & 4) != 0 ? (sSquared += ClientUtils.scaledSquared(neighbourBrightness[type][3], 255.0f)) : (sSquared += ClientUtils.scaledSquared(neighbourBrightness[type][2], 255.0f));
                        ClientUtils.normalizationFactors[type][i] = (float)Math.sqrt(sSquared);
                    }
                }
            }
            int[] rgba = new int[]{255, 255, 255, 255};
            if (color >= 0) {
                rgba[0] = color >> 16 & 0xFF;
                rgba[1] = color >> 8 & 0xFF;
                rgba[2] = color & 0xFF;
            }
            for (BakedQuad quad : quads) {
                int[] vData = quad.func_178209_a();
                VertexFormat format = DefaultVertexFormats.field_176600_a;
                int size = format.func_181719_f();
                int uvOffset = ClientUtils.findTextureOffset(format);
                int posOffset = ClientUtils.findPositionOffset(format);
                for (int i = 0; i < 4; ++i) {
                    ClientUtils.quadCoords[i][0] = Float.intBitsToFloat(vData[size * i + posOffset]);
                    ClientUtils.quadCoords[i][1] = Float.intBitsToFloat(vData[size * i + posOffset + 1]);
                    ClientUtils.quadCoords[i][2] = Float.intBitsToFloat(vData[size * i + posOffset + 2]);
                }
                Vec3d side1 = new Vec3d((double)(quadCoords[1][0] - quadCoords[3][0]), (double)(quadCoords[1][1] - quadCoords[3][1]), (double)(quadCoords[1][2] - quadCoords[3][2]));
                Vec3d side2 = new Vec3d((double)(quadCoords[2][0] - quadCoords[0][0]), (double)(quadCoords[2][1] - quadCoords[0][1]), (double)(quadCoords[2][2] - quadCoords[0][2]));
                Vec3d normal = side1.func_72431_c(side2);
                normal = normal.func_72432_b();
                int l1 = ClientUtils.getLightValue(neighbourBrightness[1], normalizationFactors[1], light & 0xFF, normal);
                int l2 = ClientUtils.getLightValue(neighbourBrightness[0], normalizationFactors[0], light >> 16 & 0xFF, normal);
                for (int i = 0; i < 4; ++i) {
                    renderer.func_225582_a_((double)quadCoords[i][0], (double)quadCoords[i][1], (double)quadCoords[i][2]).func_225586_a_(rgba[0], rgba[1], rgba[2], rgba[3]).func_225583_a_(Float.intBitsToFloat(vData[size * i + uvOffset]), Float.intBitsToFloat(vData[size * i + uvOffset + 1])).func_225587_b_(l1, l2).func_225584_a_((float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c).func_181675_d();
                }
            }
        }
    }

    private static int getLightValue(int[] neighbourBrightness, float[] normalizationFactors, int localBrightness, Vec3d normal) {
        double sideBrightness;
        byte type = 0;
        if (normal.field_72450_a > 0.0) {
            sideBrightness = normal.field_72450_a * (double)neighbourBrightness[5];
            type = (byte)(type | 1);
        } else {
            sideBrightness = -normal.field_72450_a * (double)neighbourBrightness[4];
        }
        if (normal.field_72448_b > 0.0) {
            sideBrightness += normal.field_72448_b * (double)neighbourBrightness[1];
            type = (byte)(type | 2);
        } else {
            sideBrightness += -normal.field_72448_b * (double)neighbourBrightness[0];
        }
        if (normal.field_72449_c > 0.0) {
            sideBrightness += normal.field_72449_c * (double)neighbourBrightness[3];
            type = (byte)(type | 4);
        } else {
            sideBrightness += -normal.field_72449_c * (double)neighbourBrightness[2];
        }
        return (int)(((double)localBrightness + sideBrightness / (double)normalizationFactors[type]) / 2.0);
    }

    private static float scaledSquared(int val, float scale) {
        return (float)val / scale * ((float)val / scale);
    }

    public static void renderModelTESRFast(List<BakedQuad> quads, IVertexBuilder renderer, MatrixStack transform, int light) {
        ClientUtils.renderModelTESRFast(quads, renderer, transform, -1, light);
    }

    public static void renderModelTESRFast(List<BakedQuad> quads, IVertexBuilder renderer, MatrixStack transform, int color, int light) {
        int[] rgba = new int[]{255, 255, 255, 255};
        if (color >= 0) {
            rgba[0] = color >> 16 & 0xFF;
            rgba[1] = color >> 8 & 0xFF;
            rgba[2] = color & 0xFF;
        }
        VertexFormat format = DefaultVertexFormats.field_176600_a;
        int size = format.func_181719_f();
        int uv = ClientUtils.findTextureOffset(format);
        int position = ClientUtils.findPositionOffset(format);
        int normal = ClientUtils.findOffset(format, VertexFormatElement.Usage.NORMAL, VertexFormatElement.Type.BYTE);
        for (BakedQuad quad : quads) {
            int[] vData = quad.func_178209_a();
            for (int i = 0; i < 4; ++i) {
                int normalPacked = vData[size * i + normal];
                float normalX = (float)(normalPacked & 0xFF) / 255.0f;
                float normalY = (float)(normalPacked >> 8 & 0xFF) / 255.0f;
                float normalZ = (float)(normalPacked >> 16 & 0xFF) / 255.0f;
                renderer.func_227888_a_(transform.func_227866_c_().func_227870_a_(), Float.intBitsToFloat(vData[size * i + position]), Float.intBitsToFloat(vData[size * i + position + 1]), Float.intBitsToFloat(vData[size * i + position + 2])).func_225586_a_(rgba[0], rgba[1], rgba[2], rgba[3]).func_225583_a_(Float.intBitsToFloat(vData[size * i + uv]), Float.intBitsToFloat(vData[size * i + uv + 1])).func_227886_a_(light).func_227887_a_(transform.func_227866_c_().func_227872_b_(), normalX, normalY, normalZ).func_181675_d();
            }
        }
    }

    public static void setLightmapDisabled(boolean disabled) {
        throw new UnsupportedOperationException();
    }

    public static void toggleLightmap(boolean pre, boolean disabled) {
        throw new UnsupportedOperationException();
    }

    public static boolean isSneakKeyPressed() {
        if (Minecraft.func_71410_x().field_71474_y == null) {
            return false;
        }
        KeyBinding keybind = Minecraft.func_71410_x().field_71474_y.field_228046_af_;
        InputMappings.Input keyCode = keybind.getKey();
        if (keyCode.func_197938_b() == InputMappings.Type.KEYSYM && keyCode.func_197937_c() != InputMappings.field_197958_a.func_197937_c()) {
            return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)keyCode.func_197937_c());
        }
        return false;
    }

    public static TransformationMatrix rotateTo(Direction d) {
        return new TransformationMatrix(null).blockCornerToCenter().compose(ClientUtils.toModelRotation(d).func_225615_b_()).blockCenterToCorner();
    }

    public static ModelRotation toModelRotation(Direction d) {
        switch (d) {
            case DOWN: {
                return ModelRotation.X90_Y0;
            }
            case UP: {
                return ModelRotation.X270_Y0;
            }
            case NORTH: {
                return ModelRotation.X0_Y0;
            }
            case SOUTH: {
                return ModelRotation.X0_Y180;
            }
            case WEST: {
                return ModelRotation.X0_Y270;
            }
            case EAST: {
                return ModelRotation.X0_Y90;
            }
        }
        throw new IllegalArgumentException(String.valueOf(d));
    }

    public static void renderItemWithOverlayIntoGUI(IRenderTypeBuffer buffer, MatrixStack transform, ItemStack stack, int x, int y) {
        transform.func_227860_a_();
        transform.func_227861_a_((double)x, (double)y, 100.0);
        transform.func_227861_a_(8.0, 8.0, 0.0);
        transform.func_227862_a_(1.0f, -1.0f, 1.0f);
        transform.func_227862_a_(16.0f, 16.0f, 16.0f);
        ClientUtils.mc().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GUI, 0xF000F0, OverlayTexture.field_229196_a_, transform, buffer);
        transform.func_227865_b_();
    }

    public static enum TimestampFormat {
        D,
        H,
        M,
        S,
        MS,
        HMS,
        HM,
        DHMS,
        DHM,
        DH;

        static TimestampFormat[] coreValues;

        public boolean containsFormat(TimestampFormat format) {
            return this.toString().contains(format.toString());
        }

        public long getTickCut() {
            return this == D ? 1728000L : (this == H ? 72000L : (this == M ? 1200L : (this == S ? 20L : 1L)));
        }

        public String getLocalKey() {
            return this == D ? "day" : (this == H ? "hour" : (this == M ? "minute" : (this == S ? "second" : "")));
        }

        static {
            coreValues = new TimestampFormat[]{D, H, M, S};
        }
    }
}

