/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.ManualElementBlueprint;
import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.energy.ThermoelectricHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.multiblocks.ManualElementMultiblock;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.client.manual.IEManualInstance;
import blusunrize.immersiveengineering.client.manual.ShaderManualElement;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.lib.manual.ManualElementItem;
import blusunrize.lib.manual.ManualElementTable;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.TextSplitter;
import blusunrize.lib.manual.Tree;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class IEManual {
    public static void initManual() {
        ManualHelper.ieManualInstance = new IEManualInstance();
        IEManualInstance ieMan = ManualHelper.getManual();
        ieMan.registerSpecialElement(new ResourceLocation("immersiveengineering", "blueprint"), s -> {
            ItemStack[] stacks;
            if (JSONUtils.func_151202_d((JsonObject)s, (String)"recipes")) {
                JsonArray arr = s.get("recipes").getAsJsonArray();
                stacks = new ItemStack[arr.size()];
                for (int i = 0; i < stacks.length; ++i) {
                    stacks[i] = CraftingHelper.getItemStack((JsonObject)arr.get(i).getAsJsonObject(), (boolean)true);
                }
            } else {
                JsonElement recipe = s.get("recipe");
                Preconditions.checkArgument((boolean)recipe.isJsonObject());
                stacks = new ItemStack[]{CraftingHelper.getItemStack((JsonObject)recipe.getAsJsonObject(), (boolean)true)};
            }
            return new ManualElementBlueprint(ieMan, stacks);
        });
        ieMan.registerSpecialElement(new ResourceLocation("immersiveengineering", "multiblock"), s -> {
            ResourceLocation name = ManualUtils.getLocationForManual(JSONUtils.func_151200_h((JsonObject)s, (String)"name"), ieMan);
            MultiblockHandler.IMultiblock mb = MultiblockHandler.getByUniqueName(name);
            if (mb == null) {
                throw new NullPointerException("Multiblock " + name + " does not exist");
            }
            return new ManualElementMultiblock(ieMan, mb);
        });
    }

    public static void addIEManualEntries() {
        IEManualInstance ieMan = ManualHelper.getManual();
        Tree.InnerNode<ResourceLocation, ManualEntry> generalCat = ieMan.getRoot().getOrCreateSubnode(new ResourceLocation("immersiveengineering", ManualHelper.CAT_GENERAL), 0);
        Tree.InnerNode<ResourceLocation, ManualEntry> constructionCat = ieMan.getRoot().getOrCreateSubnode(new ResourceLocation("immersiveengineering", ManualHelper.CAT_CONSTRUCTION), 10);
        Tree.InnerNode<ResourceLocation, ManualEntry> energyCat = ieMan.getRoot().getOrCreateSubnode(new ResourceLocation("immersiveengineering", ManualHelper.CAT_ENERGY), 20);
        Tree.InnerNode<ResourceLocation, ManualEntry> toolsCat = ieMan.getRoot().getOrCreateSubnode(new ResourceLocation("immersiveengineering", ManualHelper.CAT_TOOLS), 30);
        Tree.InnerNode<ResourceLocation, ManualEntry> machinesCat = ieMan.getRoot().getOrCreateSubnode(new ResourceLocation("immersiveengineering", ManualHelper.CAT_MACHINES), 40);
        Tree.InnerNode<ResourceLocation, ManualEntry> heavyMachinesCat = ieMan.getRoot().getOrCreateSubnode(new ResourceLocation("immersiveengineering", ManualHelper.CAT_HEAVYMACHINES), 50);
        ieMan.addEntry(energyCat, new ResourceLocation("immersiveengineering", "wiring"));
        ieMan.addEntry(energyCat, new ResourceLocation("immersiveengineering", "generator"));
        ieMan.addEntry(energyCat, new ResourceLocation("immersiveengineering", "breaker"));
        ieMan.addEntry(energyCat, new ResourceLocation("immersiveengineering", "current_transformer"));
        ieMan.addEntry(energyCat, new ResourceLocation("immersiveengineering", "redstone_wire"));
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder.addSpecialElement("values", 0, IEManual.addDynamicTable(() -> ThermoelectricHandler.getThermalValuesSorted(true), "K"));
        builder.readFromFile(new ResourceLocation("immersiveengineering", "thermoelectric"));
        ieMan.addEntry(energyCat, builder.create());
        ieMan.addEntry(energyCat, new ResourceLocation("immersiveengineering", "diesel_generator"));
        ieMan.addEntry(energyCat, new ResourceLocation("immersiveengineering", "lightning_rod"));
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "introduction"));
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "hemp"));
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "ores"));
        builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder.readFromFile(new ResourceLocation("immersiveengineering", "minerals"));
        Function<TextSplitter, String[]> parsedContent = builder.getContent;
        builder.setContent(textSplitter -> {
            String[] text = (String[])parsedContent.apply((TextSplitter)textSplitter);
            text[2] = text[2] + IEManual.getMineralVeinTexts(textSplitter);
            return text;
        });
        ieMan.addEntry(generalCat, builder.create());
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "alloys"));
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "components"));
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "plates"));
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "craftingtable"));
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "workbench"));
        ResourceLocation blueprints = new ResourceLocation("immersiveengineering", "blueprints");
        ieMan.addEntry(generalCat, blueprints);
        ieMan.hideEntry(blueprints);
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "alloykiln"));
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "cokeoven"));
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "crude_blast_furnace"));
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "improved_blast_furnace"));
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "graphite"));
        ieMan.addEntry(generalCat, new ResourceLocation("immersiveengineering", "shader"));
        ieMan.addEntry(constructionCat, new ResourceLocation("immersiveengineering", "treated_wood"));
        ieMan.addEntry(constructionCat, new ResourceLocation("immersiveengineering", "multiblocks"));
        ieMan.addEntry(constructionCat, new ResourceLocation("immersiveengineering", "balloon"));
        ieMan.addEntry(constructionCat, new ResourceLocation("immersiveengineering", "crate"));
        ieMan.addEntry(constructionCat, new ResourceLocation("immersiveengineering", "barrel"));
        ieMan.addEntry(constructionCat, new ResourceLocation("immersiveengineering", "metalconstruction"));
        ieMan.addEntry(constructionCat, new ResourceLocation("immersiveengineering", "metal_barrel"));
        ieMan.addEntry(constructionCat, new ResourceLocation("immersiveengineering", "concrete"));
        ieMan.addEntry(constructionCat, new ResourceLocation("immersiveengineering", "lighting"));
        ieMan.addEntry(constructionCat, new ResourceLocation("immersiveengineering", "silo"));
        ieMan.addEntry(constructionCat, new ResourceLocation("immersiveengineering", "tank"));
        ieMan.addEntry(toolsCat, new ResourceLocation("immersiveengineering", "toolbox"));
        ieMan.addEntry(toolsCat, new ResourceLocation("immersiveengineering", "jerrycan"));
        ieMan.addEntry(toolsCat, new ResourceLocation("immersiveengineering", "ear_defenders"));
        ieMan.addEntry(toolsCat, new ResourceLocation("immersiveengineering", "buzzsaw"));
        ieMan.addEntry(toolsCat, new ResourceLocation("immersiveengineering", "mining_drill"));
        ieMan.addEntry(toolsCat, new ResourceLocation("immersiveengineering", "maintenance_kit"));
        ieMan.addEntry(toolsCat, new ResourceLocation("immersiveengineering", "shield"));
        ieMan.addEntry(toolsCat, new ResourceLocation("immersiveengineering", "revolver"));
        ieMan.addEntry(toolsCat, new ResourceLocation("immersiveengineering", "bullets"));
        ieMan.addEntry(toolsCat, new ResourceLocation("immersiveengineering", "chemthrower"));
        ieMan.addEntry(toolsCat, new ResourceLocation("immersiveengineering", "skyhook"));
        ieMan.addEntry(toolsCat, new ResourceLocation("immersiveengineering", "powerpack"));
        ieMan.addEntry(toolsCat, new ResourceLocation("immersiveengineering", "railgun"));
        ieMan.addEntry(machinesCat, new ResourceLocation("immersiveengineering", "conveyors"));
        ieMan.addEntry(machinesCat, new ResourceLocation("immersiveengineering", "item_router"));
        ieMan.addEntry(machinesCat, new ResourceLocation("immersiveengineering", "item_batcher"));
        ieMan.addEntry(machinesCat, new ResourceLocation("immersiveengineering", "turntable"));
        ieMan.addEntry(machinesCat, new ResourceLocation("immersiveengineering", "fluid_transport"));
        ieMan.addEntry(machinesCat, new ResourceLocation("immersiveengineering", "fluid_router"));
        ieMan.addEntry(machinesCat, new ResourceLocation("immersiveengineering", "external_heater"));
        ieMan.addEntry(machinesCat, new ResourceLocation("immersiveengineering", "charging_station"));
        ieMan.addEntry(machinesCat, new ResourceLocation("immersiveengineering", "garden_cloche"));
        ieMan.addEntry(machinesCat, new ResourceLocation("immersiveengineering", "tesla_coil"));
        ieMan.addEntry(machinesCat, new ResourceLocation("immersiveengineering", "razor_wire"));
        ieMan.addEntry(machinesCat, new ResourceLocation("immersiveengineering", "turrets"));
        ieMan.addEntry(heavyMachinesCat, new ResourceLocation("immersiveengineering", "metal_press"));
        ieMan.addEntry(heavyMachinesCat, new ResourceLocation("immersiveengineering", "crusher"));
        ieMan.addEntry(heavyMachinesCat, new ResourceLocation("immersiveengineering", "assembler"));
        ManualEntry.ManualEntryBuilder builder2 = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder2.addSpecialElement("list", 0, IEManual.addDynamicTable(() -> FermenterRecipe.getFluidValuesSorted((Fluid)IEContent.fluidEthanol, true), "mB"));
        builder2.readFromFile(new ResourceLocation("immersiveengineering", "fermenter"));
        ieMan.addEntry(heavyMachinesCat, builder2.create());
        builder2 = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder2.addSpecialElement("list", 0, IEManual.addDynamicTable(() -> SqueezerRecipe.getFluidValuesSorted((Fluid)IEContent.fluidPlantoil, true), "mB"));
        builder2.readFromFile(new ResourceLocation("immersiveengineering", "squeezer"));
        ieMan.addEntry(heavyMachinesCat, builder2.create());
        ieMan.addEntry(heavyMachinesCat, new ResourceLocation("immersiveengineering", "refinery"));
        ieMan.addEntry(heavyMachinesCat, new ResourceLocation("immersiveengineering", "mixer"));
        ieMan.addEntry(heavyMachinesCat, new ResourceLocation("immersiveengineering", "bottling_machine"));
        ieMan.addEntry(heavyMachinesCat, new ResourceLocation("immersiveengineering", "automated_workbench"));
        ieMan.addEntry(heavyMachinesCat, new ResourceLocation("immersiveengineering", "arc_furnace"));
        ieMan.addEntry(heavyMachinesCat, new ResourceLocation("immersiveengineering", "excavator"));
        builder2 = new ManualEntry.ManualEntryBuilder(ieMan);
        builder2.setContent(() -> "Shader list", () -> "", () -> {
            StringBuilder content = new StringBuilder();
            for (ShaderRegistry.ShaderRegistryEntry shader : ShaderRegistry.shaderRegistry.values()) {
                String key = shader.name.func_110623_a();
                content.append("<&").append(key).append(">").append("<np>");
            }
            return content.toString();
        });
        for (ShaderRegistry.ShaderRegistryEntry shader : ShaderRegistry.shaderRegistry.values()) {
            String key = shader.name.func_110623_a();
            builder2.addSpecialElement(key, 0, new ShaderManualElement(ieMan, shader));
        }
        builder2.setLocation(new ResourceLocation("immersiveengineering", "shader_list"));
        ManualEntry e = builder2.create();
        ieMan.addEntry(generalCat, e);
        ieMan.hideEntry(e.getLocation());
        IEManual.addChangelogToManual();
    }

    private static Supplier<ManualElementTable> addDynamicTable(Supplier<SortedMap<String, Integer>> getContents, String valueType) {
        return () -> {
            ITextComponent[][] table = IEManual.formatToTable_ItemIntMap((Map)getContents.get(), valueType);
            return new ManualElementTable((ManualInstance)ManualHelper.getManual(), table, false);
        };
    }

    private static String getMineralVeinTexts(TextSplitter splitter) {
        StringBuilder text = new StringBuilder();
        ArrayList<MineralMix> mineralsToAdd = new ArrayList<MineralMix>(MineralMix.mineralList.values());
        Function<MineralMix, String> toName = mineral -> {
            String translationKey = mineral.getTranslationKey();
            String localizedName = I18n.func_135052_a((String)translationKey, (Object[])new Object[0]);
            if (localizedName.equals(translationKey)) {
                localizedName = mineral.getPlainName();
            }
            return localizedName;
        };
        mineralsToAdd.sort((i1, i2) -> ((String)toName.apply((MineralMix)i1)).compareToIgnoreCase((String)toName.apply((MineralMix)i2)));
        for (MineralMix mineral2 : mineralsToAdd) {
            String dimensionString;
            if (mineral2.dimensions != null && mineral2.dimensions.size() > 0) {
                StringBuilder validDims = new StringBuilder();
                for (DimensionType dim : mineral2.dimensions) {
                    validDims.append(validDims.length() > 0 ? ", " : "").append("<dim;").append(DimensionType.func_212678_a((DimensionType)dim)).append(">");
                }
                dimensionString = I18n.func_135052_a((String)"ie.manual.entry.mineralsDimValid", (Object[])new Object[]{toName.apply(mineral2), validDims.toString()});
            } else {
                dimensionString = I18n.func_135052_a((String)"ie.manual.entry.mineralsDimAny", (Object[])new Object[]{toName.apply(mineral2)});
            }
            List<StackWithChance> formattedOutputs = Arrays.asList(mineral2.outputs);
            formattedOutputs.sort(Comparator.comparingDouble(i -> -i.getChance()));
            StringBuilder outputString = new StringBuilder();
            NonNullList sortedOres = NonNullList.func_191196_a();
            for (StackWithChance sorted : formattedOutputs) {
                outputString.append("\n").append(new DecimalFormat("00.00").format(sorted.getChance() * 100.0f).replaceAll("\\G0", "\u00a0")).append("% ").append(sorted.getStack().func_200301_q().func_150254_d());
                sortedOres.add((Object)sorted.getStack());
            }
            splitter.addSpecialPage(mineral2.func_199560_c().toString(), 0, new ManualElementItem((ManualInstance)ManualHelper.getManual(), (NonNullList<ItemStack>)sortedOres));
            String desc = I18n.func_135052_a((String)"ie.manual.entry.minerals_desc", (Object[])new Object[]{dimensionString, outputString.toString()});
            if (text.length() > 0) {
                text.append("<np>");
            }
            text.append("<&").append(mineral2.func_199560_c()).append(">").append(desc);
        }
        return text.toString();
    }

    private static void addChangelogToManual() {
        TreeMap allChanges = new TreeMap(Comparator.reverseOrder());
        ComparableVersion currIEVer = new ComparableVersion("${version}");
        try {
            InputStream in = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation("immersiveengineering", "changelog.json")).func_199027_b();
            Object object = null;
            try {
                JsonElement jsonElement = new JsonParser().parse((Reader)new InputStreamReader(in));
                JsonObject upToCurrent = jsonElement.getAsJsonObject();
                for (Map.Entry entry : upToCurrent.entrySet()) {
                    ComparableVersion version = new ComparableVersion((String)entry.getKey());
                    ManualEntry manualEntry = IEManual.addVersionToManual(currIEVer, version, ((JsonElement)entry.getValue()).getAsString(), false);
                    if (manualEntry == null) continue;
                    allChanges.put(version, manualEntry);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)ModLoadingContext.get().getActiveContainer().getModInfo());
        if (result.status != VersionChecker.Status.PENDING && result.status != VersionChecker.Status.FAILED) {
            for (Map.Entry entry : result.changes.entrySet()) {
                allChanges.put(entry.getKey(), IEManual.addVersionToManual(currIEVer, (ComparableVersion)entry.getKey(), (String)entry.getValue(), true));
            }
        }
        IEManualInstance ieMan = ManualHelper.getManual();
        Tree.InnerNode<ResourceLocation, ManualEntry> innerNode = ieMan.getRoot().getOrCreateSubnode(new ResourceLocation("immersiveengineering", ManualHelper.CAT_UPDATE), -2);
        for (ManualEntry entry : allChanges.values()) {
            ManualHelper.getManual().addEntry(innerNode, entry);
        }
    }

    private static ManualEntry addVersionToManual(ComparableVersion currVer, ComparableVersion version, String changes, boolean ahead) {
        String title = version.toString();
        if (ahead) {
            title = title + I18n.func_135052_a((String)"ie.manual.newerVersion", (Object[])new Object[0]);
        } else if (currVer.equals((Object)version)) {
            title = title + I18n.func_135052_a((String)"ie.manual.currentVersion", (Object[])new Object[0]);
        }
        String text = changes.replace("\t", "  ");
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder.setContent(title, "", text);
        builder.setLocation(new ResourceLocation("immersiveengineering", "changelog_" + version.toString()));
        return builder.create();
    }

    static <T> ITextComponent[][] formatToTable_ItemIntMap(Map<T, Integer> map, String valueType) {
        ArrayList<Map.Entry<T, Integer>> sortedMapArray = new ArrayList<Map.Entry<T, Integer>>(map.entrySet());
        sortedMapArray.sort(Comparator.comparing(Map.Entry::getValue));
        ArrayList<ITextComponent[]> list = new ArrayList<ITextComponent[]>();
        try {
            for (Map.Entry entry : sortedMapArray) {
                ITextComponent item = null;
                if (entry.getKey() instanceof ResourceLocation) {
                    ItemStack is;
                    ResourceLocation key = (ResourceLocation)entry.getKey();
                    if (TagUtils.isNonemptyItemTag(key) && !(is = IEApi.getPreferredTagStack(key)).func_190926_b()) {
                        item = is.func_200301_q();
                    }
                } else if (entry.getKey() instanceof ITextComponent) {
                    item = (ITextComponent)entry.getKey();
                }
                if (item == null) {
                    item = new StringTextComponent(entry.getKey().toString());
                }
                int bt = (Integer)entry.getValue();
                StringTextComponent am = new StringTextComponent(bt + " " + valueType);
                list.add(new ITextComponent[]{item, am});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (ITextComponent[][])list.toArray((T[])new ITextComponent[0][]);
    }
}

