/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.ClientTileScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonBoolean;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorRedstoneTileEntity;
import blusunrize.immersiveengineering.common.network.MessageTileSync;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class RedstoneConnectorScreen
extends ClientTileScreen<ConnectorRedstoneTileEntity> {
    private GuiButtonState<IEEnums.IOSideConfig> buttonInOut;
    private GuiButtonBoolean[] colorButtons;

    public RedstoneConnectorScreen(ConnectorRedstoneTileEntity tileEntity, ITextComponent title) {
        super(tileEntity, title);
        this.xSize = 100;
        this.ySize = 120;
    }

    @Override
    public void init() {
        super.init();
        ClientUtils.mc().field_195559_v.func_197967_a(true);
        this.buttons.clear();
        this.buttonInOut = new GuiButtonState<IEEnums.IOSideConfig>(this.guiLeft + 41, this.guiTop + 20, 18, 18, "", new IEEnums.IOSideConfig[]{IEEnums.IOSideConfig.INPUT, IEEnums.IOSideConfig.OUTPUT}, ((ConnectorRedstoneTileEntity)this.tileEntity).ioMode.ordinal() - 1, "immersiveengineering:textures/gui/redstone_configuration.png", 176, 0, 1, btn -> this.sendConfig("ioMode", ((IEEnums.IOSideConfig)((Object)((Object)btn.getNextState()))).ordinal()));
        this.addButton((Widget)this.buttonInOut);
        this.colorButtons = new GuiButtonBoolean[16];
        for (int i = 0; i < this.colorButtons.length; ++i) {
            DyeColor color = DyeColor.func_196056_a((int)i);
            this.colorButtons[i] = RedstoneConnectorScreen.buildColorButton(this.colorButtons, this.guiLeft + 22 + i % 4 * 14, this.guiTop + 44 + i / 4 * 14, ((ConnectorRedstoneTileEntity)this.tileEntity).redstoneChannel.ordinal() == i, color, btn -> this.sendConfig("redstoneChannel", color.func_196059_a()));
            this.addButton((Widget)this.colorButtons[i]);
        }
    }

    public void sendConfig(String key, int value) {
        CompoundNBT message = new CompoundNBT();
        message.func_74768_a(key, value);
        ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageTileSync((IEBaseTileEntity)this.tileEntity, message));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY, float partialTick) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (this.buttonInOut.isHovered()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("gui.immersiveengineering.config.redstone_iomode", new Object[0]));
            tooltip.add(this.buttonInOut.getState().getTextComponent().func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
        for (int i = 0; i < this.colorButtons.length; ++i) {
            if (!this.colorButtons[i].isHovered()) continue;
            tooltip.add((ITextComponent)new TranslationTextComponent("gui.immersiveengineering.config.redstone_color", new Object[0]));
            tooltip.add(new TranslationTextComponent("color.minecraft." + DyeColor.func_196056_a((int)i).func_176762_d(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mouseX, mouseY, this.font, this.width, this.height);
        }
    }

    public static GuiButtonBoolean buildColorButton(GuiButtonBoolean[] buttons, int posX, int posY, boolean active, final DyeColor color, Consumer<GuiButtonBoolean> onClick) {
        return new GuiButtonBoolean(posX, posY, 12, 12, "", active, "immersiveengineering:textures/gui/redstone_configuration.png", 194, 0, 1, btn -> {
            if (((Boolean)btn.getNextState()).booleanValue()) {
                onClick.accept((GuiButtonBoolean)btn);
            }
            for (int j = 0; j < buttons.length; ++j) {
                if (j == color.ordinal()) continue;
                buttons[j].setStateByInt(0);
            }
        }){

            protected boolean isValidClickButton(int button) {
                return button == 0 && (Boolean)this.getState() == false;
            }

            @Override
            public void render(int mouseX, int mouseY, float partialTicks) {
                super.render(mouseX, mouseY, partialTicks);
                if (this.visible) {
                    int col = color.field_193351_w;
                    if (!((Boolean)this.getState()).booleanValue()) {
                        col = ClientUtils.getDarkenedTextColour(col);
                    }
                    col = 0xFF000000 | col;
                    this.fillGradient(this.x + 3, this.y + 3, this.x + 9, this.y + 9, col, col);
                }
            }
        };
    }
}

