/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.client.models.connection.RenderCacheKey;
import blusunrize.immersiveengineering.client.models.obj.MaterialColorGetter;
import blusunrize.immersiveengineering.client.models.obj.MaterialSpriteGetter;
import blusunrize.immersiveengineering.client.models.obj.OBJHelper;
import blusunrize.immersiveengineering.client.models.obj.QuadListAdder;
import blusunrize.immersiveengineering.client.models.obj.TextureCoordinateRemapper;
import blusunrize.immersiveengineering.client.utils.CombinedModelData;
import blusunrize.immersiveengineering.client.utils.SinglePropertyModelData;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.obj.MaterialLibrary;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;

public class IESmartObjModel
implements IBakedModel {
    public static Cache<ComparableItemStack, IBakedModel> cachedBakedItemModels = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(60L, TimeUnit.SECONDS).build();
    public static Cache<RenderCacheKey, List<BakedQuad>> modelCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(60L, TimeUnit.SECONDS).build();
    ImmutableList<BakedQuad> bakedQuads;
    ItemStack tempStack = ItemStack.field_190927_a;
    BlockState tempState;
    public LivingEntity tempEntity;
    public static LivingEntity tempEntityStatic;
    public ItemCameraTransforms.TransformType lastCameraTransform;
    public boolean isDynamic;
    public final OBJModel baseModel;
    private final IBakedModel baseBaked;
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final IModelTransform sprite;
    private final IEProperties.IEObjState state;
    ItemOverrideList overrideList = new ItemOverrideList(){

        public IBakedModel func_209581_a(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
            tempEntityStatic = entity;
            ComparableItemStack comp = ComparableItemStack.create(stack, false, true);
            if (comp == null) {
                return originalModel;
            }
            IBakedModel model = (IBakedModel)cachedBakedItemModels.getIfPresent((Object)comp);
            if (model == null) {
                model = originalModel;
                comp.copy();
                cachedBakedItemModels.put((Object)comp, (Object)model);
            }
            if (model instanceof IESmartObjModel) {
                ((IESmartObjModel)model).tempStack = stack;
                ((IESmartObjModel)model).tempEntity = entity;
            }
            return model;
        }
    };
    private Cache<Pair<String, String>, List<ShadedQuads>> groupCache = CacheBuilder.newBuilder().maximumSize(100L).build();

    public IESmartObjModel(OBJModel baseModel, IBakedModel baseBaked, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform sprite, IEProperties.IEObjState state, boolean dynamic) {
        this.baseModel = baseModel;
        this.baseBaked = baseBaked;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.sprite = sprite;
        this.state = state;
        this.isDynamic = dynamic;
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        this.lastCameraTransform = cameraTransformType;
        TransformationMatrix matrix = (TransformationMatrix)PerspectiveMapWrapper.getTransforms((IModelTransform)this.owner.getCombinedTransform()).getOrDefault((Object)cameraTransformType, (Object)TransformationMatrix.func_227983_a_());
        matrix.push(mat);
        if (!this.tempStack.func_190926_b() && this.tempStack.func_77973_b() instanceof IOBJModelCallback) {
            ((IOBJModelCallback)this.tempStack.func_77973_b()).handlePerspective(this.tempStack, cameraTransformType, mat, this.tempEntity);
        }
        return this;
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_230044_c_() {
        return true;
    }

    public boolean func_188618_c() {
        return this.isDynamic;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.baseBaked.func_177554_e();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    @Nonnull
    public List<BakedQuad> getQuads(BlockState blockState, Direction side, @Nonnull Random rand, @Nonnull IModelData modelData) {
        if (side != null) {
            return ImmutableList.of();
        }
        IEProperties.IEObjState objState = null;
        Object tex = ImmutableMap.of();
        if (modelData.hasProperty(IEProperties.Model.IE_OBJ_STATE)) {
            objState = (IEProperties.IEObjState)modelData.getData(IEProperties.Model.IE_OBJ_STATE);
        }
        if (modelData.hasProperty(IEProperties.Model.TEXTURE_REMAP)) {
            tex = (Map)modelData.getData(IEProperties.Model.TEXTURE_REMAP);
        }
        return this.getQuads(blockState, side, rand.nextLong(), objState, (Map<String, String>)tex, true, modelData);
    }

    @Nonnull
    public IModelData getModelData(@Nonnull ILightReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        ArrayList<IModelData> customData = new ArrayList<IModelData>();
        if (state.func_177230_c() instanceof IEBlockInterfaces.IAdvancedHasObjProperty) {
            customData.add(new SinglePropertyModelData<IEProperties.IEObjState>(((IEBlockInterfaces.IAdvancedHasObjProperty)state.func_177230_c()).getIEObjState(state), IEProperties.Model.IE_OBJ_STATE));
        }
        if (state.func_177230_c() instanceof IEBlockInterfaces.IModelDataBlock) {
            customData.add(((IEBlockInterfaces.IModelDataBlock)state.func_177230_c()).getModelData(world, pos, state, tileData));
        } else {
            LazyOptional shaderCap;
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IOBJModelCallback) {
                customData.add(new SinglePropertyModelData<IOBJModelCallback>((IOBJModelCallback)te, IOBJModelCallback.PROPERTY));
            }
            if (te instanceof IEBlockInterfaces.IAdvancedHasObjProperty) {
                customData.add(new SinglePropertyModelData<IEProperties.IEObjState>(((IEBlockInterfaces.IAdvancedHasObjProperty)te).getIEObjState(state), IEProperties.Model.IE_OBJ_STATE));
            }
            if (te != null && (shaderCap = te.getCapability(CapabilityShader.SHADER_CAPABILITY)).isPresent()) {
                customData.add(new SinglePropertyModelData<CapabilityShader.ShaderWrapper>((CapabilityShader.ShaderWrapper)shaderCap.orElseThrow(RuntimeException::new), CapabilityShader.MODEL_PROPERTY));
            }
        }
        customData.add(tileData);
        return new CombinedModelData(customData.toArray(new IModelData[0]));
    }

    public List<BakedQuad> getQuads(BlockState blockState, Direction side, long rand, IEProperties.IEObjState visibility, Map<String, String> tex, boolean addAnimationAndTex, IModelData modelData) {
        if (blockState == null) {
            this.bakedQuads = ImmutableList.copyOf(this.buildQuads(modelData));
            return this.bakedQuads;
        }
        this.tempState = blockState;
        String cacheKey = "";
        if (blockState != null && modelData.hasProperty(IOBJModelCallback.PROPERTY)) {
            cacheKey = ((IOBJModelCallback)modelData.getData(IOBJModelCallback.PROPERTY)).getCacheKey(blockState);
        }
        RenderCacheKey adapter = addAnimationAndTex ? new RenderCacheKey(blockState, MinecraftForgeClient.getRenderLayer(), visibility, tex, cacheKey) : new RenderCacheKey(blockState, MinecraftForgeClient.getRenderLayer(), cacheKey);
        try {
            modelCache.invalidateAll();
            List quads = (List)modelCache.get((Object)adapter, () -> {
                IESmartObjModel model = visibility != null ? new IESmartObjModel(this.baseModel, this.baseBaked, this.owner, this.bakery, this.spriteGetter, this.sprite, visibility, this.isDynamic) : new IESmartObjModel(this.baseModel, this.baseBaked, this.owner, this.bakery, this.spriteGetter, this.sprite, this.state, this.isDynamic);
                model.tempState = blockState;
                return model.buildQuads(modelData);
            });
            return Collections.synchronizedList(Lists.newArrayList((Iterable)quads));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private ImmutableList<BakedQuad> buildQuads(IModelData data) {
        CapabilityShader.ShaderWrapper wrapper;
        List<Object> quads = Lists.newArrayList();
        ItemStack shader = ItemStack.field_190927_a;
        ShaderCase sCase = null;
        IOBJModelCallback callback = null;
        BlockState callbackObject = null;
        LazyOptional shaderOpt = this.tempStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
        if (shaderOpt.isPresent()) {
            wrapper = (CapabilityShader.ShaderWrapper)shaderOpt.orElseThrow(NullPointerException::new);
            shader = wrapper.getShaderItem();
            if (!shader.func_190926_b() && shader.func_77973_b() instanceof IShaderItem) {
                sCase = ((IShaderItem)shader.func_77973_b()).getShaderCase(shader, this.tempStack, wrapper.getShaderType());
            }
        } else if (data.hasProperty(CapabilityShader.MODEL_PROPERTY) && (wrapper = (CapabilityShader.ShaderWrapper)data.getData(CapabilityShader.MODEL_PROPERTY)) != null && !(shader = wrapper.getShaderItem()).func_190926_b() && shader.func_77973_b() instanceof IShaderItem) {
            sCase = ((IShaderItem)shader.func_77973_b()).getShaderCase(shader, null, wrapper.getShaderType());
        }
        if (!this.tempStack.func_190926_b() && this.tempStack.func_77973_b() instanceof IOBJModelCallback) {
            callback = (IOBJModelCallback)this.tempStack.func_77973_b();
            callbackObject = this.tempStack;
        } else if (data.hasProperty(IOBJModelCallback.PROPERTY)) {
            callback = (IOBJModelCallback)data.getData(IOBJModelCallback.PROPERTY);
            callbackObject = this.tempState;
        }
        for (String groupName : OBJHelper.getGroups(this.baseModel).keySet()) {
            List<ShadedQuads> temp = this.addQuadsForGroup(callback, callbackObject, groupName, sCase, true);
            quads.addAll(temp.stream().map(s -> s.quadsInLayer).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if (callback != null) {
            quads = callback.modifyQuads(callbackObject, (List<BakedQuad>)quads);
        }
        return ImmutableList.copyOf((Collection)quads);
    }

    public <T> List<ShadedQuads> addQuadsForGroup(IOBJModelCallback<T> callback, T callbackObject, String groupName, ShaderCase sCase, boolean allowCaching) {
        String objCacheKey;
        String string = objCacheKey = callback != null ? callback.getCacheKey(callbackObject) : "<none>";
        if (sCase != null) {
            objCacheKey = objCacheKey + ";" + sCase.getShaderType().toString();
        }
        Pair cacheKey = Pair.of((Object)groupName, (Object)objCacheKey);
        if (allowCaching) {
            // empty if block
        }
        int numPasses = sCase != null ? sCase.getLayers().length : 1;
        OBJModel.ModelGroup g = OBJHelper.getGroups(this.baseModel).get(groupName);
        ArrayList<ShadedQuads> ret = new ArrayList<ShadedQuads>();
        TransformationMatrix transform = this.state.transform;
        TransformationMatrix optionalTransform = this.sprite.func_225615_b_();
        if (callback != null) {
            optionalTransform = callback.applyTransformations(callbackObject, groupName, optionalTransform);
        }
        MaterialSpriteGetter spriteGetter = new MaterialSpriteGetter(this.spriteGetter, groupName, callback, callbackObject, sCase);
        MaterialColorGetter colorGetter = new MaterialColorGetter(groupName, callback, callbackObject, sCase);
        TextureCoordinateRemapper coordinateRemapper = new TextureCoordinateRemapper(this.baseModel, sCase);
        if (this.state.visibility.isVisible(groupName) && (callback == null || callback.shouldRenderGroup(callbackObject, groupName))) {
            for (int pass = 0; pass < numPasses; ++pass) {
                if (sCase != null && !sCase.shouldRenderGroupForPass(groupName, pass)) continue;
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                spriteGetter.setRenderPass(pass);
                colorGetter.setRenderPass(pass);
                coordinateRemapper.setRenderPass(pass);
                QuadListAdder modelBuilder = new QuadListAdder(quads::add, transform);
                this.addModelObjectQuads((OBJModel.ModelObject)g, this.owner, modelBuilder, spriteGetter, colorGetter, coordinateRemapper, optionalTransform);
                TransformationMatrix finalTransform = optionalTransform;
                g.getParts().stream().filter(part -> this.owner.getPartVisibility(part) && part instanceof OBJModel.ModelObject).forEach(part -> this.addModelObjectQuads((OBJModel.ModelObject)part, this.owner, modelBuilder, spriteGetter, colorGetter, coordinateRemapper, finalTransform));
                ShaderLayer layer = sCase != null ? sCase.getLayers()[pass] : new ShaderLayer(new ResourceLocation("missing/no"), -1){

                    @Override
                    public RenderType getRenderType(RenderType baseType) {
                        return baseType;
                    }
                };
                ret.add(new ShadedQuads(layer, quads));
            }
        }
        if (allowCaching) {
            this.groupCache.put((Object)cacheKey, ret);
        }
        return ret;
    }

    private void addModelObjectQuads(OBJModel.ModelObject modelObject, IModelConfiguration owner, IModelBuilder<?> modelBuilder, MaterialSpriteGetter<?> spriteGetter, MaterialColorGetter<?> colorGetter, TextureCoordinateRemapper coordinateRemapper, TransformationMatrix transform) {
        List<OBJHelper.MeshWrapper> meshes = OBJHelper.getMeshes(modelObject);
        for (OBJHelper.MeshWrapper mesh : meshes) {
            MaterialLibrary.Material mat = mesh.getMaterial();
            if (mat == null) continue;
            TextureAtlasSprite texture = spriteGetter.apply(mat.name, ModelLoaderRegistry.resolveTexture((String)mat.diffuseColorMap, (IModelConfiguration)owner));
            int tintIndex = mat.diffuseTintIndex;
            Vector4f colorTint = colorGetter.apply(mat.name, mat.diffuseColor);
            for (int[][] face : mesh.getFaces()) {
                boolean drawFace = coordinateRemapper.remapCoord(face);
                if (drawFace) {
                    Pair<BakedQuad, Direction> quad = OBJHelper.makeQuad(this.baseModel, face, tintIndex, colorTint, mat.ambientColor, texture, transform);
                    if (quad.getRight() == null) {
                        modelBuilder.addGeneralQuad((BakedQuad)quad.getLeft());
                    } else {
                        modelBuilder.addFaceQuad((Direction)quad.getRight(), (BakedQuad)quad.getLeft());
                    }
                }
                coordinateRemapper.resetCoords();
            }
        }
    }

    public static class ShadedQuads {
        public final ShaderLayer layer;
        public final List<BakedQuad> quadsInLayer;

        public ShadedQuads(ShaderLayer layer, List<BakedQuad> quadsInLayer) {
            this.layer = layer;
            this.quadsInLayer = quadsInLayer;
        }
    }
}

