/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.MetalPressTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class MetalPressRenderer
extends TileEntityRenderer<MetalPressTileEntity> {
    private final DynamicModel<Void> piston = DynamicModel.createSimple(new ResourceLocation("immersiveengineering", "block/metal_multiblock/metal_press_piston.obj"), "metal_press_piston", DynamicModel.ModelType.OBJ);

    public MetalPressRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(MetalPressTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        PoweredMultiblockTileEntity.MultiblockProcess process;
        int i;
        if (!te.formed || te.isDummy() || !te.getWorldNonnull().func_175667_e(te.func_174877_v())) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockPos blockPos = te.func_174877_v();
        BlockState state = te.func_145831_w().func_180495_p(blockPos);
        if (state.func_177230_c() != IEBlocks.Multiblocks.metalPress) {
            return;
        }
        IBakedModel model = this.piston.get(null);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        float piston = 0.0f;
        float[] shift = new float[te.processQueue.size()];
        for (i = 0; i < shift.length; ++i) {
            process = (PoweredMultiblockTileEntity.MultiblockProcess)te.processQueue.get(i);
            if (process == null) continue;
            float transportTime = 0.4375f;
            float pressTime = 0.03125f;
            float fProcess = ((float)process.processTick + (te.shouldRenderAsActive() ? partialTicks : 0.0f)) / (float)process.maxTicks;
            shift[i] = fProcess < transportTime ? fProcess / transportTime * 0.5f : (fProcess < 1.0f - transportTime ? 0.5f : 0.5f + (fProcess - (1.0f - transportTime)) / transportTime * 0.5f);
            if (te.mold.func_190926_b() || !(fProcess >= transportTime) || !(fProcess < 1.0f - transportTime)) continue;
            piston = fProcess < transportTime + pressTime ? (fProcess - transportTime) / pressTime : (fProcess < 1.0f - transportTime - pressTime ? 1.0f : 1.0f - (fProcess - (1.0f - transportTime - pressTime)) / pressTime);
        }
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), te.getFacing() == Direction.SOUTH ? 180.0f : (te.getFacing() == Direction.WEST ? 90.0f : (te.getFacing() == Direction.EAST ? -90.0f : 0.0f)), true));
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)(-piston * 0.6875f), 0.0);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        blockRenderer.func_175019_b().renderModel((ILightReader)te.getWorldNonnull(), model, state, blockPos, matrixStack, bufferIn.getBuffer(RenderType.func_228639_c_()), true, te.func_145831_w().field_73012_v, 0L, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.func_227865_b_();
        if (!te.mold.func_190926_b()) {
            matrixStack.func_227861_a_(0.0, 0.34, 0.0);
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -90.0f, true));
            float scale = 0.75f;
            matrixStack.func_227862_a_(scale, scale, 1.0f);
            ClientUtils.mc().func_175599_af().func_229110_a_(te.mold, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn);
        }
        matrixStack.func_227865_b_();
        matrixStack.func_227861_a_(0.0, -0.35, 1.25);
        for (i = 0; i < shift.length; ++i) {
            List<ItemStack> displays;
            process = (PoweredMultiblockTileEntity.MultiblockProcess)te.processQueue.get(i);
            if (!(process instanceof PoweredMultiblockTileEntity.MultiblockProcessInWorld)) continue;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, -2.5 * (double)shift[i]);
            if ((double)piston > 0.92) {
                matrixStack.func_227861_a_(0.0, 0.92 - (double)piston, 0.0);
            }
            if ((displays = ((PoweredMultiblockTileEntity.MultiblockProcessInWorld)process).getDisplayItem()).isEmpty()) continue;
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -90.0f, true));
            float scale = 0.625f;
            matrixStack.func_227862_a_(scale, scale, 1.0f);
            ClientUtils.mc().func_175599_af().func_229110_a_(displays.get(0), ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }
}

