/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.MixerTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;

public class MixerRenderer
extends TileEntityRenderer<MixerTileEntity> {
    private final DynamicModel<Direction> dynamic = DynamicModel.createSided(new ResourceLocation("immersiveengineering", "block/metal_multiblock/mixer_agitator.obj"), "mixer", DynamicModel.ModelType.OBJ);

    public MixerRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(MixerTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!te.formed || te.isDummy() || !te.getWorldNonnull().func_175667_e(te.func_174877_v())) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockPos blockPos = te.func_174877_v();
        BlockState state = te.func_145831_w().func_180495_p(blockPos);
        if (state.func_177230_c() != IEBlocks.Multiblocks.mixer) {
            return;
        }
        IBakedModel model = this.dynamic.get(te.getFacing());
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        if (te.getIsMirrored()) {
            matrixStack.func_227862_a_(te.getFacing().func_82601_c() == 0 ? -1.0f : 1.0f, 1.0f, te.getFacing().func_82599_e() == 0 ? -1.0f : 1.0f);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(te.getFacing() == Direction.SOUTH || te.getFacing() == Direction.WEST ? -0.5 : 0.5, 0.0, te.getFacing() == Direction.SOUTH || te.getFacing() == Direction.EAST ? 0.5 : -0.5);
        float agitator = te.animation_agitator - (!te.shouldRenderAsActive() ? 0.0f : (1.0f - partialTicks) * 9.0f);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), agitator, true));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        blockRenderer.func_175019_b().renderModel((ILightReader)te.getWorldNonnull(), model, state, blockPos, matrixStack, bufferIn.getBuffer(RenderType.func_228639_c_()), true, te.func_145831_w().field_73012_v, 0L, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.func_227865_b_();
        matrixStack.func_227861_a_(te.getFacing() == Direction.SOUTH || te.getFacing() == Direction.WEST ? -0.5 : 0.5, -0.625, te.getFacing() == Direction.SOUTH || te.getFacing() == Direction.EAST ? 0.5 : -0.5);
        matrixStack.func_227862_a_(0.0625f, 1.0f, 0.0625f);
        matrixStack.func_227863_a_(new Quaternion(90.0f, 0.0f, 0.0f, true));
        for (int i = te.tank.getFluidTypes() - 1; i >= 0; --i) {
            FluidStack fs = te.tank.fluids.get(i);
            if (fs == null || fs.getFluid() == null) continue;
            float yy = (float)fs.getAmount() / (float)te.tank.getCapacity() * 1.125f;
            matrixStack.func_227861_a_(0.0, 0.0, (double)(-yy));
            float w = i < te.tank.getFluidTypes() - 1 || (double)yy >= 0.125 ? 26.0f : 16.0f + yy / 0.0125f;
            ClientUtils.drawRepeatedFluidSprite(bufferIn.getBuffer(RenderType.func_228645_f_()), matrixStack, fs, -w / 2.0f, -w / 2.0f, w, w);
        }
        matrixStack.func_227865_b_();
    }
}

