/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;

public class TransformingVertexBuilder
implements IVertexBuilder {
    private final IVertexBuilder base;
    private final MatrixStack transform;
    ObjectWithGlobal<Vec2f> uv = new ObjectWithGlobal();
    ObjectWithGlobal<Vec3d> pos = new ObjectWithGlobal();
    ObjectWithGlobal<Vec2i> overlay = new ObjectWithGlobal();
    ObjectWithGlobal<Vec2i> lightmap = new ObjectWithGlobal();
    ObjectWithGlobal<Vector3f> normal = new ObjectWithGlobal();
    ObjectWithGlobal<Vector4f> color = new ObjectWithGlobal();

    public TransformingVertexBuilder(IVertexBuilder base, MatrixStack transform) {
        this.base = base;
        this.transform = transform;
    }

    public TransformingVertexBuilder(IVertexBuilder base) {
        this(base, new MatrixStack());
    }

    @Nonnull
    public IVertexBuilder func_225582_a_(double x, double y, double z) {
        this.pos.putData(new Vec3d(x, y, z));
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225586_a_(int red, int green, int blue, int alpha) {
        this.color.putData(new Vector4f((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f));
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225583_a_(float u, float v) {
        this.uv.putData(new Vec2f(u, v));
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225585_a_(int u, int v) {
        this.overlay.putData(new Vec2i(u, v));
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225587_b_(int u, int v) {
        this.lightmap.putData(new Vec2i(u, v));
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225584_a_(float x, float y, float z) {
        this.normal.putData(new Vector3f(x, y, z));
        return this;
    }

    public void func_181675_d() {
        this.pos.ifPresent(pos -> this.base.func_227888_a_(this.transform.func_227866_c_().func_227870_a_(), (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c));
        this.color.ifPresent(c -> this.base.func_227885_a_(c.func_195910_a(), c.func_195913_b(), c.func_195914_c(), c.func_195915_d()));
        this.uv.ifPresent(uv -> this.base.func_225583_a_(uv.field_189982_i, uv.field_189983_j));
        this.overlay.ifPresent(overlay -> this.base.func_225585_a_(overlay.x, overlay.y));
        this.lightmap.ifPresent(lightmap -> this.base.func_225587_b_(lightmap.x, lightmap.y));
        this.normal.ifPresent(normal -> this.base.func_227887_a_(this.transform.func_227866_c_().func_227872_b_(), normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()));
        this.base.func_181675_d();
    }

    public void setLight(int light) {
        this.lightmap.setGlobal(new Vec2i(light & 0xFF, light >> 16));
    }

    public void setColor(float r, float g, float b, float a) {
        this.color.setGlobal(new Vector4f(r, g, b, a));
    }

    public void setNormal(float x, float y, float z) {
        Vector3f vec = new Vector3f(x, y, z);
        vec.func_229194_d_();
        this.normal.setGlobal(vec);
    }

    public void setOverlay(int packedOverlayIn) {
        this.overlay.setGlobal(new Vec2i(packedOverlayIn & 0xFFFF, packedOverlayIn >> 16));
    }

    private static class ObjectWithGlobal<T> {
        @Nullable
        T obj;
        boolean isGlobal;

        private ObjectWithGlobal() {
        }

        public void putData(T newVal) {
            Preconditions.checkState((this.obj == null ? 1 : 0) != 0);
            this.obj = newVal;
        }

        public void setGlobal(@Nullable T obj) {
            this.obj = obj;
            this.isGlobal = obj != null;
        }

        public T read() {
            Object ret = Preconditions.checkNotNull(this.obj);
            if (!this.isGlobal) {
                this.obj = null;
            }
            return (T)ret;
        }

        public boolean hasValue() {
            return this.obj != null;
        }

        public void ifPresent(Consumer<T> out) {
            if (this.hasValue()) {
                out.accept(this.read());
            }
        }
    }

    private static class Vec2i {
        final int x;
        final int y;

        private Vec2i(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

