/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.CapabilitySkyhookData;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.NetHandlerCapability;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.IEMultiblockBlock;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.CrusherTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.RazorWireTileEntity;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEExplosion;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

public class EventHandler {
    public static final Map<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>> interdictionTiles = new HashMap<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>>();
    public static HashSet<IEExplosion> currentExplosions = new HashSet();
    public static final Queue<Pair<DimensionType, BlockPos>> requestedBlockUpdates = new LinkedList<Pair<DimensionType, BlockPos>>();
    public static final Set<TileEntity> REMOVE_FROM_TICKING = new HashSet<TileEntity>();
    public static List<ResourceLocation> lootInjections = Arrays.asList(new ResourceLocation("immersiveengineering", "chests/stronghold_library"), new ResourceLocation("immersiveengineering", "chests/village_blacksmith"));
    public static HashMap<UUID, CrusherTileEntity> crusherMap = new HashMap();
    public static HashSet<Class<? extends MobEntity>> listOfBoringBosses = new HashSet();

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        ImmersiveEngineering.proxy.onWorldLoad();
    }

    @SubscribeEvent
    public void onCapabilitiesAttachEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof AbstractMinecartEntity) {
            event.addCapability(new ResourceLocation("immersiveengineering:shader"), (ICapabilityProvider)new CapabilityShader.ShaderWrapper_Direct(new ResourceLocation("immersiveengineering", "minecart")));
        }
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("immersiveengineering", "skyhook_data"), (ICapabilityProvider)new CapabilitySkyhookData.SimpleSkyhookProvider());
        }
    }

    @SubscribeEvent
    public void onCapabilitiesAttachWorld(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("immersiveengineering", "wire_network"), (ICapabilityProvider)new NetHandlerCapability.Provider((World)event.getObject()));
    }

    @SubscribeEvent
    public void onMinecartInteraction(PlayerInteractEvent.EntityInteractSpecific event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        if (!(event.getTarget() instanceof AbstractMinecartEntity)) {
            return;
        }
        AbstractMinecartEntity cart = (AbstractMinecartEntity)event.getTarget();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IShaderItem) {
            cart.getCapability(CapabilityShader.SHADER_CAPABILITY).ifPresent(wrapper -> {
                wrapper.setShaderItem(Utils.copyStackWithAmount(stack, 1));
                if (!player.field_70170_p.field_72995_K) {
                    ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageMinecartShaderSync((Entity)cart, wrapper));
                }
            });
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    @SubscribeEvent
    public void onEntityJoiningWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof AbstractMinecartEntity && event.getEntity().getCapability(CapabilityShader.SHADER_CAPABILITY).isPresent()) {
            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageMinecartShaderSync(event.getEntity(), null));
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.world.field_72995_K) {
            DimensionType dim = event.world.func_201675_m().func_186058_p();
            GlobalWireNetwork.getNetwork(event.world).func_73660_a();
            if (!REMOVE_FROM_TICKING.isEmpty()) {
                event.world.field_175730_i.removeAll(REMOVE_FROM_TICKING);
                REMOVE_FROM_TICKING.removeIf(te -> te.func_145831_w().func_201675_m().func_186058_p() == dim);
            }
        }
        if (event.phase == TickEvent.Phase.START) {
            if (!currentExplosions.isEmpty()) {
                Iterator<IEExplosion> itExplosion = currentExplosions.iterator();
                while (itExplosion.hasNext()) {
                    IEExplosion ex = itExplosion.next();
                    ex.doExplosionTick();
                    if (!ex.isExplosionFinished) continue;
                    itExplosion.remove();
                }
            }
            while (!requestedBlockUpdates.isEmpty()) {
                Pair<DimensionType, BlockPos> curr = requestedBlockUpdates.poll();
                ServerWorld w = DimensionManager.getWorld((MinecraftServer)ServerLifecycleHooks.getCurrentServer(), (DimensionType)((DimensionType)curr.getLeft()), (boolean)false, (boolean)false);
                if (w == null) continue;
                BlockState state = w.func_180495_p((BlockPos)curr.getRight());
                w.func_184138_a((BlockPos)curr.getRight(), state, state, 3);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDropsLowest(LivingDropsEvent event) {
        CrusherTileEntity crusher;
        if (!event.isCanceled() && Lib.DMG_Crusher.equals(event.getSource().func_76355_l()) && (crusher = crusherMap.get(event.getEntityLiving().func_110124_au())) != null) {
            for (ItemEntity item : event.getDrops()) {
                if (item == null || item.func_92059_d().func_190926_b()) continue;
                crusher.doProcessOutput(item.func_92059_d());
            }
            crusherMap.remove(event.getEntityLiving().func_110124_au());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled() && !event.getEntityLiving().func_184222_aU()) {
            Rarity r = Rarity.EPIC;
            for (Class<? extends MobEntity> boring : listOfBoringBosses) {
                if (!boring.isAssignableFrom(event.getEntityLiving().getClass())) continue;
                return;
            }
            ItemStack bag = new ItemStack((IItemProvider)IEItems.Misc.shaderBag.get(r));
            event.getDrops().add(new ItemEntity(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), bag));
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        PlayerEntity player;
        ItemStack activeStack;
        if (event.getEntityLiving() instanceof PlayerEntity && !(activeStack = (player = (PlayerEntity)event.getEntityLiving()).func_184607_cu()).func_190926_b() && activeStack.func_77973_b() instanceof IEShieldItem && event.getAmount() >= 3.0f && Utils.canBlockDamageSource((LivingEntity)player, event.getSource())) {
            float amount = event.getAmount();
            ((IEShieldItem)activeStack.func_77973_b()).hitShield(activeStack, player, event.getSource(), amount, event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent event) {
        float mod;
        int amp;
        if (event.getSource().func_76347_k() && event.getEntityLiving().func_70660_b(IEPotions.flammable) != null) {
            amp = event.getEntityLiving().func_70660_b(IEPotions.flammable).func_76458_c();
            mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.setAmount(event.getAmount() * mod);
        }
        if (("flux".equals(event.getSource().func_76355_l()) || IEDamageSources.razorShock.equals(event.getSource()) || event.getSource() instanceof IEDamageSources.ElectricDamageSource) && event.getEntityLiving().func_70660_b(IEPotions.conductive) != null) {
            amp = event.getEntityLiving().func_70660_b(IEPotions.conductive).func_76458_c();
            mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.setAmount(event.getAmount() * mod);
        }
        if (!event.isCanceled() && !event.getEntityLiving().func_184222_aU() && event.getAmount() >= event.getEntityLiving().func_110143_aJ() && event.getSource().func_76346_g() instanceof PlayerEntity && ((PlayerEntity)event.getSource().func_76346_g()).func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof DrillItem) {
            Utils.unlockIEAdvancement((PlayerEntity)event.getSource().func_76346_g(), "main/secret_drillbreak");
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Vec3d motion = event.getEntity().func_213322_ci();
        if (event.getEntityLiving().func_70660_b(IEPotions.sticky) != null) {
            motion = motion.func_178786_a(0.0, (double)((float)(event.getEntityLiving().func_70660_b(IEPotions.sticky).func_76458_c() + 1) * 0.3f), 0.0);
        } else if (event.getEntityLiving().func_70660_b(IEPotions.concreteFeet) != null) {
            motion = Vec3d.field_186680_a;
        }
        event.getEntity().func_213317_d(motion);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        ItemStack powerpack;
        if (event.getEntityLiving() instanceof PlayerEntity && !event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST).func_190926_b() && ItemNBTHelper.hasKey(event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST), "IE:Powerpack") && !(powerpack = ItemNBTHelper.getItemStack(event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST), "IE:Powerpack")).func_190926_b()) {
            powerpack.func_77973_b().onArmorTick(powerpack, event.getEntityLiving().func_130014_f_(), (PlayerEntity)event.getEntityLiving());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (event.getEntityLiving().func_200600_R().func_220339_d() == EntityClassification.MONSTER) {
            Map<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
            synchronized (map) {
                Set<IEBlockInterfaces.ISpawnInterdiction> dimSet = interdictionTiles.get(event.getEntity().field_70170_p.func_201675_m().func_186058_p());
                if (dimSet != null) {
                    Iterator<IEBlockInterfaces.ISpawnInterdiction> it = dimSet.iterator();
                    while (it.hasNext()) {
                        IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                        if (interdictor instanceof TileEntity) {
                            if (((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w() == null) {
                                it.remove();
                                continue;
                            }
                            if (!(((TileEntity)interdictor).func_145835_a(event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_()) <= interdictor.getInterdictionRangeSquared())) continue;
                            event.setCanceled(true);
                            continue;
                        }
                        if (!(interdictor instanceof Entity)) continue;
                        if (!((Entity)interdictor).func_70089_S() || ((Entity)interdictor).field_70170_p == null) {
                            it.remove();
                            continue;
                        }
                        if (!(((Entity)interdictor).func_70068_e(event.getEntity()) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setCanceled(true);
                    }
                }
            }
        }
        if (event.getEntityLiving().func_70660_b(IEPotions.stunned) != null) {
            event.setCanceled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onEntitySpawnCheck(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DENY || event.isSpawner()) {
            return;
        }
        if (event.getEntityLiving().func_200600_R().func_220339_d() == EntityClassification.MONSTER) {
            Map<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
            synchronized (map) {
                DimensionType dimension = event.getEntity().field_70170_p.func_201675_m().func_186058_p();
                if (interdictionTiles.containsKey(dimension)) {
                    Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.get(dimension).iterator();
                    while (it.hasNext()) {
                        IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                        if (interdictor instanceof TileEntity) {
                            if (((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w() == null) {
                                it.remove();
                                continue;
                            }
                            if (!(((TileEntity)interdictor).func_145835_a(event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_()) <= interdictor.getInterdictionRangeSquared())) continue;
                            event.setResult(Event.Result.DENY);
                            continue;
                        }
                        if (!(interdictor instanceof Entity)) continue;
                        if (!((Entity)interdictor).func_70089_S() || ((Entity)interdictor).field_70170_p == null) {
                            it.remove();
                            continue;
                        }
                        if (!(((Entity)interdictor).func_70068_e(event.getEntity()) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setResult(Event.Result.DENY);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void digSpeedEvent(PlayerEvent.BreakSpeed event) {
        TileEntity te;
        ItemStack current = event.getPlayer().func_184586_b(Hand.MAIN_HAND);
        if (!current.func_190926_b() && current.func_77973_b() == IEItems.Tools.drill && event.getPlayer().func_70090_H()) {
            if (((DrillItem)IEItems.Tools.drill).getUpgrades(current).func_74767_n("waterproof")) {
                event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
            } else {
                event.setCanceled(true);
            }
        }
        if (event.getState().func_177230_c() == IEBlocks.MetalDevices.razorWire && current.func_77973_b() != IEItems.Tools.wirecutter) {
            event.setCanceled(true);
            RazorWireTileEntity.applyDamage(event.getEntityLiving());
        }
        if ((te = event.getPlayer().func_130014_f_().func_175625_s(event.getPos())) instanceof IEBlockInterfaces.IEntityProof && !((IEBlockInterfaces.IEntityProof)te).canEntityDestroy((Entity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAnvilChange(AnvilUpdateEvent event) {
        if (!event.getLeft().func_190926_b() && event.getLeft().func_77973_b() instanceof IDrillHead && ((IDrillHead)event.getLeft().func_77973_b()).getHeadDamage(event.getLeft()) > 0 && !event.getRight().func_190926_b() && event.getLeft().func_77973_b().func_82789_a(event.getLeft(), event.getRight())) {
            int cost;
            event.setOutput(event.getLeft().func_77946_l());
            int repair = Math.min(((IDrillHead)event.getOutput().func_77973_b()).getHeadDamage(event.getOutput()), ((IDrillHead)event.getOutput().func_77973_b()).getMaximumHeadDamage(event.getOutput()) / 4);
            for (cost = 0; repair > 0 && cost < event.getRight().func_190916_E(); ++cost) {
                ((IDrillHead)event.getOutput().func_77973_b()).damageHead(event.getOutput(), -repair);
                event.setCost(Math.max(1, repair / 200));
                repair = Math.min(((IDrillHead)event.getOutput().func_77973_b()).getHeadDamage(event.getOutput()), ((IDrillHead)event.getOutput().func_77973_b()).getMaximumHeadDamage(event.getOutput()) / 4);
            }
            event.setMaterialCost(cost);
            if (event.getName() == null || event.getName().isEmpty()) {
                if (event.getLeft().func_82837_s()) {
                    event.setCost(event.getCost() + 5);
                    event.getOutput().func_135074_t();
                }
            } else if (!event.getName().equals(event.getLeft().func_200301_q())) {
                event.setCost(event.getCost() + 5);
                if (event.getLeft().func_82837_s()) {
                    event.setCost(event.getCost() + 2);
                }
                event.getOutput().func_200302_a((ITextComponent)new StringTextComponent(event.getName()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void breakLast(BlockEvent.BreakEvent event) {
        TileEntity te;
        if (event.getState().func_177230_c() instanceof IEMultiblockBlock && (te = event.getWorld().func_175625_s(event.getPos())) instanceof MultiblockPartTileEntity) {
            ((MultiblockPartTileEntity)te).onlyLocalDissassembly = event.getWorld().func_72912_H().func_82573_f();
        }
    }

    @SubscribeEvent
    public void onFurnaceBurnTime(FurnaceFuelBurnTimeEvent event) {
        if (Utils.isFluidRelatedItemStack(event.getItemStack())) {
            FluidUtil.getFluidContained((ItemStack)event.getItemStack()).ifPresent(fs -> {
                if (!fs.isEmpty() && fs.getFluid() == IEContent.fluidCreosote) {
                    event.setBurnTime((int)(0.8 * (double)fs.getAmount()));
                }
            });
        }
    }

    static {
        listOfBoringBosses.add(WitherEntity.class);
    }
}

