/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerWallBlock;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class ShaderBannerTileEntity
extends IEBaseTileEntity
implements IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.ITileDrop {
    public boolean wall = false;
    public CapabilityShader.ShaderWrapper_Direct shader = new CapabilityShader.ShaderWrapper_Direct(new ResourceLocation("immersiveengineering", "banner"));
    public static TileEntityType<ShaderBannerTileEntity> TYPE;
    private static VoxelShape SHAPE;
    private static Map<Direction, VoxelShape> WALL_SHAPES;
    private LazyOptional<CapabilityShader.ShaderWrapper> shaderCap;

    public ShaderBannerTileEntity() {
        super(TYPE);
        this.reInitCapability();
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.wall = nbt.func_74767_n("wall");
        if (nbt.func_150297_b("shader", 10)) {
            this.shader = new CapabilityShader.ShaderWrapper_Direct(new ResourceLocation("immersiveengineering", "banner"));
            this.shader.deserializeNBT(nbt.func_74775_l("shader"));
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74757_a("wall", this.wall);
        nbt.func_218657_a("shader", (INBT)this.shader.serializeNBT());
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(ISelectionContext ctx) {
        if (this.wall) {
            return WALL_SHAPES.get(this.getState().func_177229_b(ShaderBannerWallBlock.FACING));
        }
        return SHAPE;
    }

    @Override
    public List<ItemStack> getTileDrops(LootContext context) {
        return ImmutableList.of((Object)new ItemStack((IItemProvider)Items.field_196191_eg, 1));
    }

    @Override
    public void readOnPlacement(@Nullable LivingEntity placer, ItemStack stack) {
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    private void reInitCapability() {
        if (this.shaderCap != null) {
            this.unregisterCap(this.shaderCap);
        }
        this.shaderCap = this.registerConstantCap(this.shader);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityShader.SHADER_CAPABILITY) {
            return this.shaderCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    static {
        SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        WALL_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)12.5, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.5, (double)2.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)12.5, (double)16.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)12.5, (double)16.0)));
    }
}

