/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.AssemblerHandler;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.CapabilityReference;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class AssemblerTileEntity
extends PoweredMultiblockTileEntity<AssemblerTileEntity, MultiblockRecipe>
implements IEBlockInterfaces.IInteractionObjectIE,
ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IBlockBounds {
    public static TileEntityType<AssemblerTileEntity> TYPE;
    public boolean[] computerOn = new boolean[3];
    public boolean isComputerControlled = false;
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(8000), new FluidTank(8000), new FluidTank(8000)};
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)21, (Object)ItemStack.field_190927_a);
    public CrafterPatternInventory[] patterns = new CrafterPatternInventory[]{new CrafterPatternInventory(this), new CrafterPatternInventory(this), new CrafterPatternInventory(this)};
    public boolean recursiveIngredients = false;
    private CapabilityReference<IItemHandler> output = CapabilityReference.forTileEntity(this, () -> new DirectionalBlockPos(this.field_174879_c.func_177967_a(this.getFacing(), 2), this.getFacing().func_176734_d()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private LazyOptional<IItemHandler> insertionHandler = this.registerConstantCap(new IEInventoryHandler(18, (IIEInventory)this, 0, true, false));
    private LazyOptional<IItemHandler> extractionHandler = this.registerConstantCap(new IEInventoryHandler(3, (IIEInventory)this, 18, false, true));
    private static final BlockPos inputPos;
    private static final BlockPos outputPos;
    private static final Set<BlockPos> itemConnections;

    public AssemblerTileEntity() {
        super(IEMultiblocks.ASSEMBLER, 32000, true, TYPE);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        byte cOn;
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.tanks[2].readFromNBT(nbt.func_74775_l("tank2"));
        this.recursiveIngredients = nbt.func_74767_n("recursiveIngredients");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 21);
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                ListNBT patternList = nbt.func_150295_c("pattern" + iPattern, 10);
                this.patterns[iPattern] = new CrafterPatternInventory(this);
                this.patterns[iPattern].readFromNBT(patternList);
            }
        }
        boolean bl = this.isComputerControlled = ((cOn = nbt.func_74771_c("computerControlled")) & 1) != 0;
        if (this.isComputerControlled) {
            for (int i = 0; i < 3; ++i) {
                this.computerOn[i] = (cOn & 2 << i) != 0;
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_218657_a("tank0", (INBT)this.tanks[0].writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("tank1", (INBT)this.tanks[1].writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("tank2", (INBT)this.tanks[2].writeToNBT(new CompoundNBT()));
        nbt.func_74757_a("recursiveIngredients", this.recursiveIngredients);
        if (!descPacket) {
            nbt.func_218657_a("inventory", (INBT)Utils.writeInventory(this.inventory));
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                ListNBT patternList = new ListNBT();
                this.patterns[iPattern].writeToNBT(patternList);
                nbt.func_218657_a("pattern" + iPattern, (INBT)patternList);
            }
        }
        if (this.isComputerControlled) {
            byte cOn = 1;
            for (int i = 0; i < 3; ++i) {
                if (!this.computerOn[i]) continue;
                cOn = (byte)(cOn | 2 << i);
            }
            nbt.func_74774_a("computerControlled", cOn);
        }
    }

    @Override
    public void receiveMessageFromClient(CompoundNBT message) {
        block5: {
            block3: {
                int id;
                block4: {
                    Preconditions.checkState((!this.field_145850_b.field_72995_K ? 1 : 0) != 0);
                    if (!message.func_150297_b("buttonID", 3)) break block3;
                    id = message.func_74762_e("buttonID");
                    if (id < 0 || id >= this.patterns.length) break block4;
                    CrafterPatternInventory pattern = this.patterns[id];
                    for (int i = 0; i < pattern.inv.size(); ++i) {
                        pattern.inv.set(i, (Object)ItemStack.field_190927_a);
                    }
                    break block5;
                }
                if (id != 3) break block5;
                this.recursiveIngredients = !this.recursiveIngredients;
                break block5;
            }
            if (message.func_150297_b("patternSync", 3)) {
                int r = message.func_74762_e("recipe");
                ListNBT list = message.func_150295_c("patternSync", 10);
                CrafterPatternInventory pattern = this.patterns[r];
                for (int i = 0; i < list.size(); ++i) {
                    CompoundNBT itemTag = list.func_150305_b(i);
                    pattern.inv.set(itemTag.func_74762_e("slot"), (Object)ItemStack.func_199557_a((CompoundNBT)itemTag));
                }
            }
        }
    }

    @Override
    public void func_73660_a() {
        ItemStack output;
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled() || this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 16L != (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0xF)) {
            return;
        }
        boolean update = false;
        NonNullList[] outputBuffer = new NonNullList[this.patterns.length];
        for (int p = 0; p < this.patterns.length; ++p) {
            CrafterPatternInventory pattern = this.patterns[p];
            if (this.isComputerControlled && !this.computerOn[p] || ((ItemStack)pattern.inv.get(9)).func_190926_b() || !this.canOutput((ItemStack)pattern.inv.get(9), p)) continue;
            output = ((ItemStack)pattern.inv.get(9)).func_77946_l();
            ArrayList<ItemStack> availableStacks = new ArrayList<ItemStack>();
            for (NonNullList bufferedStacks : outputBuffer) {
                if (bufferedStacks == null) continue;
                for (ItemStack stack : bufferedStacks) {
                    if (stack.func_190926_b()) continue;
                    availableStacks.add(stack);
                }
            }
            for (ItemStack stack : this.inventory) {
                if (stack.func_190926_b()) continue;
                availableStacks.add(stack);
            }
            int consumed = (Integer)IEConfig.MACHINES.assembler_consumption.get();
            AssemblerHandler.IRecipeAdapter<?> adapter = AssemblerHandler.findAdapter(pattern.recipe);
            AssemblerHandler.RecipeQuery[] queries = adapter.getQueriedInputs(pattern.recipe, pattern.inv);
            if (queries == null || this.energyStorage.extractEnergy(consumed, true) != consumed || !this.consumeIngredients(queries, availableStacks, false, null)) continue;
            this.energyStorage.extractEnergy(consumed, false);
            NonNullList outputList = NonNullList.func_191196_a();
            outputList.add((Object)output);
            NonNullList gridItems = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
            this.consumeIngredients(queries, availableStacks, true, (NonNullList<ItemStack>)gridItems);
            NonNullList remainingItems = pattern.recipe.func_179532_b((IInventory)Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, (NonNullList<ItemStack>)gridItems));
            for (ItemStack rem : remainingItems) {
                if (rem.func_190926_b()) continue;
                outputList.add((Object)rem);
            }
            outputBuffer[p] = outputList;
            update = true;
        }
        for (int buffer = 0; buffer < outputBuffer.length; ++buffer) {
            if (outputBuffer[buffer] == null || outputBuffer[buffer].size() <= 0) continue;
            for (int iOutput = 0; iOutput < outputBuffer[buffer].size(); ++iOutput) {
                output = (ItemStack)outputBuffer[buffer].get(iOutput);
                if (output.func_190926_b() || output.func_190916_E() <= 0 || !this.isRecipeIngredient(output, buffer) && ((output = Utils.insertStackIntoInventory(this.output, output, false)).func_190926_b() || output.func_190916_E() <= 0)) continue;
                int free = -1;
                if (iOutput == 0) {
                    if (((ItemStack)this.inventory.get(18 + buffer)).func_190926_b() && free < 0) {
                        free = 18 + buffer;
                    } else if (!((ItemStack)this.inventory.get(18 + buffer)).func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)((ItemStack)this.inventory.get(18 + buffer))) && ((ItemStack)this.inventory.get(18 + buffer)).func_190916_E() + output.func_190916_E() <= ((ItemStack)this.inventory.get(18 + buffer)).func_77976_d()) {
                        ((ItemStack)this.inventory.get(18 + buffer)).func_190917_f(output.func_190916_E());
                        free = -1;
                        continue;
                    }
                } else {
                    for (int i = 0; i < this.inventory.size(); ++i) {
                        if (((ItemStack)this.inventory.get(i)).func_190926_b() && free < 0) {
                            free = i;
                            continue;
                        }
                        if (((ItemStack)this.inventory.get(i)).func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)((ItemStack)this.inventory.get(i))) || ((ItemStack)this.inventory.get(i)).func_190916_E() + output.func_190916_E() > ((ItemStack)this.inventory.get(i)).func_77976_d()) continue;
                        ((ItemStack)this.inventory.get(i)).func_190917_f(output.func_190916_E());
                        free = -1;
                        break;
                    }
                }
                if (free < 0) continue;
                this.inventory.set(free, (Object)output.func_77946_l());
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.isRecipeIngredient((ItemStack)this.inventory.get(18 + i), i)) continue;
            this.inventory.set(18 + i, (Object)Utils.insertStackIntoInventory(this.output, (ItemStack)this.inventory.get(18 + i), false));
        }
        if (update) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
    }

    public boolean consumeIngredients(AssemblerHandler.RecipeQuery[] queries, ArrayList<ItemStack> itemStacks, boolean doConsume, @Nullable NonNullList<ItemStack> gridItems) {
        if (!doConsume) {
            ArrayList<ItemStack> dupeList = new ArrayList<ItemStack>(itemStacks.size());
            for (ItemStack itemStack : itemStacks) {
                dupeList.add(itemStack.func_77946_l());
            }
            itemStacks = dupeList;
        }
        for (int i = 0; i < queries.length; ++i) {
            AssemblerHandler.RecipeQuery recipeQuery = queries[i];
            if (recipeQuery == null || recipeQuery.query == null) continue;
            FluidStack fluidStack = recipeQuery.query instanceof FluidStack ? (FluidStack)recipeQuery.query : null;
            int querySize = recipeQuery.querySize;
            if (fluidStack != null) {
                boolean hasFluid = false;
                for (FluidTank tank : this.tanks) {
                    if (!tank.getFluid().containsFluid(fluidStack)) continue;
                    hasFluid = true;
                    if (!doConsume) break;
                    tank.drain(fluidStack.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                    break;
                }
                if (hasFluid) continue;
                querySize = 1;
            }
            Iterator<Object> it = itemStacks.iterator();
            while (it.hasNext()) {
                ItemStack next = (ItemStack)it.next();
                if (next.func_190926_b() || !ItemUtils.stackMatchesObject(next, recipeQuery.query, true)) continue;
                int taken = Math.min(querySize, next.func_190916_E());
                ItemStack forGrid = next.func_77979_a(taken);
                if (gridItems != null) {
                    gridItems.set(i, (Object)forGrid);
                }
                if (next.func_190916_E() <= 0) {
                    it.remove();
                }
                if ((querySize -= taken) > 0) continue;
                break;
            }
            if (querySize <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean canOutput(ItemStack output, int iPattern) {
        if (((ItemStack)this.inventory.get(18 + iPattern)).func_190926_b()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)((ItemStack)this.inventory.get(18 + iPattern))) && ((ItemStack)this.inventory.get(18 + iPattern)).func_190916_E() + output.func_190916_E() <= ((ItemStack)this.inventory.get(18 + iPattern)).func_77976_d();
    }

    public boolean isRecipeIngredient(ItemStack stack, int slot) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot - 1 < this.patterns.length || this.recursiveIngredients) {
            int p;
            int n = p = this.recursiveIngredients ? 0 : slot;
            while (p < this.patterns.length) {
                CrafterPatternInventory pattern = this.patterns[p];
                for (int i = 0; i < 9; ++i) {
                    if (((ItemStack)pattern.inv.get(i)).func_190926_b() || !ItemStack.func_179545_c((ItemStack)((ItemStack)pattern.inv.get(i)), (ItemStack)stack)) continue;
                    return true;
                }
                ++p;
            }
        }
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        ImmutableSet fullBlocks = ImmutableSet.of((Object)new BlockPos(1, 1, 2), (Object)new BlockPos(1, 1, 1), (Object)new BlockPos(1, 1, 0), (Object)new BlockPos(1, 2, 1));
        if (this.posInMultiblock.func_177956_o() == 0 || fullBlocks.contains(this.posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (this.posInMultiblock.func_177952_p() == 2 && this.getFacing() == Direction.SOUTH || this.posInMultiblock.func_177952_p() == 0 && this.getFacing() == Direction.NORTH) {
            zMin = 0.25f;
        } else if (this.posInMultiblock.func_177952_p() == 2 && this.getFacing() == Direction.NORTH || this.posInMultiblock.func_177952_p() == 0 && this.getFacing() == Direction.SOUTH) {
            zMax = 0.75f;
        } else if (this.posInMultiblock.func_177952_p() == 2 && this.getFacing() == Direction.EAST || this.posInMultiblock.func_177952_p() == 0 && this.getFacing() == Direction.WEST) {
            xMin = 0.25f;
        } else if (this.posInMultiblock.func_177952_p() == 2 && this.getFacing() == Direction.WEST || this.posInMultiblock.func_177952_p() == 0 && this.getFacing() == Direction.EAST) {
            xMax = 0.75f;
        }
        if (this.posInMultiblock.func_177958_n() == 0 && this.getFacing() == Direction.EAST || this.posInMultiblock.func_177958_n() == 2 && this.getFacing() == Direction.WEST) {
            zMin = 0.1875f;
        } else if (this.posInMultiblock.func_177958_n() == 0 && this.getFacing() == Direction.WEST || this.posInMultiblock.func_177958_n() == 2 && this.getFacing() == Direction.EAST) {
            zMax = 0.8125f;
        } else if (this.posInMultiblock.func_177958_n() == 0 && this.getFacing() == Direction.NORTH || this.posInMultiblock.func_177958_n() == 2 && this.getFacing() == Direction.SOUTH) {
            xMin = 0.1875f;
        } else if (this.posInMultiblock.func_177958_n() == 0 && this.getFacing() == Direction.SOUTH || this.posInMultiblock.func_177958_n() == 2 && this.getFacing() == Direction.NORTH) {
            xMax = 0.8125f;
        }
        return VoxelShapes.func_197873_a((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
    }

    @Override
    public Set<BlockPos> getEnergyPos() {
        return ImmutableSet.of((Object)new BlockPos(1, 2, 1));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(0, 0, 1), (Object)new BlockPos(2, 0, 1));
    }

    @Override
    public void replaceStructureBlock(BlockPos pos, BlockState state, ItemStack stack, int h, int l, int w) {
        TileEntity tile;
        super.replaceStructureBlock(pos, state, stack, h, l, w);
        if (h == 1 && w == 1 && l != 1 && (tile = this.getWorldNonnull().func_175625_s(pos)) instanceof ConveyorBeltTileEntity) {
            ((ConveyorBeltTileEntity)tile).setFacing(this.getFacing());
        }
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
        return false;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 0;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 0;
    }

    @Override
    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (itemConnections.contains(this.posInMultiblock) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            AssemblerTileEntity master = (AssemblerTileEntity)this.master();
            if (master == null) {
                return LazyOptional.empty();
            }
            if (inputPos.equals((Object)this.posInMultiblock) && facing == this.getFacing().func_176734_d()) {
                return master.insertionHandler.cast();
            }
            if (outputPos.equals((Object)this.posInMultiblock) && facing == this.getFacing()) {
                return master.extractionHandler.cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected MultiblockRecipe getRecipeForId(ResourceLocation id) {
        return null;
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return this.formed;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)((Object)this.master());
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        AssemblerTileEntity master = (AssemblerTileEntity)this.master();
        if (master != null && (side == null || side == this.getFacing().func_176734_d())) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        return true;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return true;
    }

    @Override
    public Direction[] sigOutputDirections() {
        return new Direction[]{this.getFacing()};
    }

    @Override
    public void func_226984_a_(World world, BlockPos blockPos) {
        super.func_226984_a_(world, blockPos);
        if (this.func_145831_w() != null) {
            for (int i = 0; i < this.patterns.length; ++i) {
                this.patterns[i].recalculateOutput();
            }
        }
    }

    static {
        inputPos = new BlockPos(1, 1, 2);
        outputPos = new BlockPos(1, 1, 0);
        itemConnections = ImmutableSet.of((Object)inputPos, (Object)outputPos);
    }

    public static class CrafterPatternInventory
    implements IInventory {
        public NonNullList<ItemStack> inv = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
        public IRecipe recipe;
        final AssemblerTileEntity tile;

        public CrafterPatternInventory(AssemblerTileEntity tile) {
            this.tile = tile;
        }

        public int func_70302_i_() {
            return 10;
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.inv) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int slot) {
            return (ItemStack)this.inv.get(slot);
        }

        public ItemStack func_70298_a(int slot, int amount) {
            ItemStack stack = this.func_70301_a(slot);
            if (slot < 9 && !stack.func_190926_b()) {
                if (stack.func_190916_E() <= amount) {
                    this.func_70299_a(slot, ItemStack.field_190927_a);
                } else if ((stack = stack.func_77979_a(amount)).func_190916_E() == 0) {
                    this.func_70299_a(slot, ItemStack.field_190927_a);
                }
            }
            return stack;
        }

        public ItemStack func_70304_b(int slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (!stack.func_190926_b()) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
            return stack;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            if (slot < 9) {
                this.inv.set(slot, (Object)stack);
                if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                    stack.func_190920_e(this.func_70297_j_());
                }
            }
            this.recalculateOutput();
        }

        public void func_174888_l() {
            for (int i = 0; i < this.inv.size(); ++i) {
                this.inv.set(i, (Object)ItemStack.field_190927_a);
            }
        }

        public void recalculateOutput() {
            if (this.tile.func_145831_w() != null) {
                CraftingInventory invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, this.inv);
                this.recipe = Utils.findCraftingRecipe(invC, this.tile.getWorldNonnull()).orElse(null);
                this.inv.set(9, (Object)(this.recipe != null ? this.recipe.func_77572_b((IInventory)invC) : ItemStack.field_190927_a));
            }
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_70300_a(PlayerEntity player) {
            return true;
        }

        public void func_174889_b(PlayerEntity player) {
        }

        public void func_174886_c(PlayerEntity player) {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return true;
        }

        public void func_70296_d() {
            this.tile.func_70296_d();
        }

        public void writeToNBT(ListNBT list) {
            for (int i = 0; i < this.inv.size(); ++i) {
                if (((ItemStack)this.inv.get(i)).func_190926_b()) continue;
                CompoundNBT itemTag = new CompoundNBT();
                itemTag.func_74774_a("Slot", (byte)i);
                ((ItemStack)this.inv.get(i)).func_77955_b(itemTag);
                list.add((Object)itemTag);
            }
        }

        public void readFromNBT(ListNBT list) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT itemTag = list.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot >= this.func_70302_i_()) continue;
                this.inv.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemTag));
            }
            this.recalculateOutput();
        }
    }
}

