/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MiscConnectorBlock;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class BreakerSwitchTileEntity
extends ImmersiveConnectableTileEntity
implements IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IAdvancedDirectionalTile,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IRedstoneOutput,
IOBJModelCallback<BlockState>,
IEBlockInterfaces.IStateBasedDirectional {
    public static TileEntityType<BreakerSwitchTileEntity> TYPE;
    public static final int LEFT_INDEX = 0;
    public static final int RIGHT_INDEX = 1;
    public int rotation = 0;
    public int wires = 0;
    public boolean inverted = false;

    public BreakerSwitchTileEntity() {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)TYPE);
    }

    public BreakerSwitchTileEntity(TileEntityType<? extends BreakerSwitchTileEntity> type) {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)type);
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        Matrix4 mat = new Matrix4().setIdentity().translate(0.5, 0.5, 0.0).rotate(-1.5707963267948966 * (double)this.rotation, 0.0, 0.0, 1.0).translate(-0.5, -0.5, 0.0).multiply(Matrix4.inverseFacing(this.getFacing()));
        Vec3d transformedHit = mat.apply(new Vec3d((double)info.hitX, (double)info.hitY, (double)info.hitZ));
        IELogger.logger.info("Transformed hit: {}, original: {}", (Object)transformedHit, (Object)new Vec3d((double)info.hitX, (double)info.hitY, (double)info.hitZ));
        return new ConnectionPoint(this.field_174879_c, transformedHit.field_72450_a > 0.5 ? 1 : 0);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        if ("HV".equals(cableType.getCategory()) && !this.canTakeHV()) {
            return false;
        }
        for (ConnectionPoint cp : this.getConnectionPoints()) {
            for (Connection c : this.globalNet.getLocalNet(cp).getConnections(cp)) {
                if (c.isInternal() || !cp.equals(target) && cableType.getCategory().equals(c.type.getCategory())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean canTakeHV() {
        return false;
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        ++this.wires;
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        WireType type;
        WireType wireType = type = connection != null ? connection.type : null;
        this.wires = type == null ? 0 : --this.wires;
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("rotation", this.rotation);
        nbt.func_74768_a("wires", this.wires);
        nbt.func_74757_a("inverted", this.inverted);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.rotation = nbt.func_74762_e("rotation");
        this.wires = nbt.func_74762_e("wires");
        this.inverted = nbt.func_74767_n("inverted");
    }

    @Override
    public Vec3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        Matrix4 mat = new Matrix4(this.getFacing());
        mat.translate(0.5, 0.5, 0.0).rotate(1.5707963267948966 * (double)this.rotation, 0.0, 0.0, 1.0).translate(-0.5, -0.5, 0.0);
        boolean isLeft = here.getIndex() == 0;
        return mat.apply(new Vec3d(isLeft ? 0.25 : 0.75, 0.5, 0.125));
    }

    @Override
    public boolean hammerUseSide(Direction side, PlayerEntity player, Vec3d hitVec) {
        this.rotation = (this.rotation + 3) % 4;
        for (ConnectionPoint cp : this.getConnectionPoints()) {
            for (Connection c : this.getLocalNet(cp.getIndex()).getConnections(cp)) {
                if (c.isInternal()) continue;
                this.globalNet.updateCatenaryData(c);
            }
        }
        this.func_70296_d();
        this.markContainingBlockForUpdate(this.func_195044_w());
        return true;
    }

    @Override
    public ActionResultType screwdriverUseSide(Direction side, PlayerEntity player, Vec3d hitVec) {
        boolean oldPassing = this.allowEnergyToPass();
        boolean bl = this.inverted = !this.inverted;
        if (!this.field_145850_b.field_72995_K) {
            ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TranslationTextComponent("chat.immersiveengineering.info.rsSignal." + (this.inverted ? "invertedOn" : "invertedOff"), new Object[0])});
            this.notifyNeighbours();
            if (oldPassing != this.allowEnergyToPass()) {
                this.updateConductivity();
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (!Utils.isHammer(heldItem)) {
            boolean active = !this.getIsActive();
            this.setActive(active);
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), IESounds.direSwitch, SoundCategory.BLOCKS, 2.5f, 1.0f);
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), active ? 1 : 0, 0);
            this.notifyNeighbours();
            this.updateConductivity();
            return true;
        }
        return false;
    }

    protected void updateConductivity() {
        if (this.allowEnergyToPass()) {
            this.globalNet.addConnection(new Connection(this.field_174879_c, 0, 1));
        } else {
            this.globalNet.removeConnection(new Connection(this.field_174879_c, 0, 1));
        }
    }

    public void notifyNeighbours() {
        this.func_70296_d();
        this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
        for (Direction f : Direction.field_199792_n) {
            this.field_145850_b.func_195593_d(this.func_174877_v().func_177972_a(f), this.func_195044_w().func_177230_c());
        }
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (super.func_145842_c(id, arg)) {
            return true;
        }
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return MiscConnectorBlock.DEFAULT_FACING_PROP;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        Vec3d start = new Vec3d(0.25, 0.1875, 0.0);
        Vec3d end = new Vec3d(0.75, 0.8125, 0.5);
        Matrix4 mat = new Matrix4(this.getFacing());
        mat.translate(0.5, 0.5, 0.0).rotate(1.5707963267948966 * (double)this.rotation, 0.0, 0.0, 1.0).translate(-0.5, -0.5, 0.0);
        start = mat.apply(start);
        end = mat.apply(end);
        return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(start, end));
    }

    @Override
    public int getWeakRSOutput(BlockState state, Direction side) {
        return this.getIsActive() ^ this.inverted ? 15 : 0;
    }

    @Override
    public int getStrongRSOutput(BlockState state, Direction side) {
        return side.func_176734_d() == this.getFacing() && this.getIsActive() ^ this.inverted ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(BlockState state, Direction side) {
        return true;
    }

    @Override
    public TransformationMatrix applyTransformations(BlockState object, String group, TransformationMatrix transform) {
        return transform.compose(new TransformationMatrix(null, new Quaternion(0.0f, (float)(90 * this.rotation), 0.0f, true), null, null));
    }

    @Override
    public String getCacheKey(BlockState object) {
        return this.rotation + "," + this.getFacing().func_176745_a();
    }

    @Override
    public void onDirectionalPlacement(Direction side, float hitX, float hitY, float hitZ, LivingEntity placer) {
        Direction f = Direction.SOUTH;
        int rotationSign = -1;
        if (side.func_176740_k() == Direction.Axis.Y) {
            float xFromMid = hitX - 0.5f;
            float zFromMid = hitZ - 0.5f;
            float max = Math.max(Math.abs(xFromMid), Math.abs(zFromMid));
            if (max == Math.abs(xFromMid)) {
                f = xFromMid < 0.0f ? Direction.WEST : Direction.EAST;
            } else {
                Direction direction = f = zFromMid < 0.0f ? Direction.NORTH : Direction.SOUTH;
            }
            if (side == Direction.DOWN) {
                f = f.func_176734_d();
                rotationSign = 1;
            }
        }
        this.rotation = Direction.NORTH.func_176736_b() + rotationSign * f.func_176736_b();
        this.rotation = (this.rotation + 4) % 4;
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.field_174879_c, 0), (Object)new ConnectionPoint(this.field_174879_c, 1));
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        if (this.allowEnergyToPass()) {
            return ImmutableList.of((Object)new Connection(this.field_174879_c, 0, 1));
        }
        return ImmutableList.of();
    }

    protected boolean allowEnergyToPass() {
        return this.getIsActive();
    }
}

