/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.ClocheFertilizer;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.network.MessageTileSync;
import blusunrize.immersiveengineering.common.util.CapabilityReference;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ClocheTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHasDummyBlocks,
IIEInventory,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IInteractionObjectIE,
IOBJModelCallback<BlockState> {
    public static TileEntityType<ClocheTileEntity> TYPE;
    public static final int SLOT_SOIL = 0;
    public static final int SLOT_SEED = 1;
    public static final int SLOT_FERTILIZER = 2;
    public int dummy = 0;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
    public final FluidTank tank = new FluidTank(4000){

        protected void onContentsChanged() {
            ClocheTileEntity.this.sendSyncPacket(2);
        }

        public boolean isFluidValid(FluidStack fluid) {
            return FluidTags.field_206959_a.func_199685_a_((Object)fluid.getFluid());
        }
    };
    public FluxStorage energyStorage;
    public int fertilizerAmount;
    public float fertilizerMod;
    private float growth;
    public float renderGrowth;
    public boolean renderActive;
    private CapabilityReference<IItemHandler> output;
    private LazyOptional<IItemHandler> inputHandler;
    private LazyOptional<IItemHandler> outputHandler;
    private LazyOptional<IFluidHandler> tankCap;
    EnergyHelper.IEForgeEnergyWrapper energyWrapper;
    AxisAlignedBB renderBB;

    public ClocheTileEntity() {
        super(TYPE);
        this.energyStorage = new FluxStorage(16000, Math.max(256, (Integer)IEConfig.MACHINES.cloche_consumption.get()));
        this.fertilizerAmount = 0;
        this.fertilizerMod = 1.0f;
        this.growth = 0.0f;
        this.renderGrowth = 0.0f;
        this.renderActive = false;
        this.output = CapabilityReference.forTileEntity(this, () -> new DirectionalBlockPos(this.field_174879_c.func_177984_a().func_177972_a(this.getFacing().func_176734_d()), this.getFacing()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        this.inputHandler = this.registerConstantCap(new IEInventoryHandler(1, (IIEInventory)this, 2, true, false));
        this.outputHandler = this.registerConstantCap(new IEInventoryHandler(4, (IIEInventory)this, 3, false, true));
        this.tankCap = this.registerConstantCap(this.tank);
        this.energyWrapper = new EnergyHelper.IEForgeEnergyWrapper(this, null);
    }

    public void func_73660_a() {
        block27: {
            ItemStack seed;
            block26: {
                ClocheRecipe recipe;
                ApiUtils.checkForNeedlessTicking(this);
                if (this.dummy != 0 || this.isRSPowered()) {
                    return;
                }
                seed = (ItemStack)this.inventory.get(1);
                if (!this.field_145850_b.field_72995_K) break block26;
                if (this.energyStorage.getEnergyStored() <= (Integer)IEConfig.MACHINES.cloche_consumption.get() || this.fertilizerAmount <= 0 || !this.renderActive || (recipe = this.getRecipe()) == null || this.fertilizerAmount <= 0) break block27;
                if ((double)this.renderGrowth < (double)recipe.time + (Double)IEConfig.MACHINES.cloche_growth_mod.get() * (double)this.fertilizerMod) {
                    this.renderGrowth = (float)((double)this.renderGrowth + (Double)IEConfig.MACHINES.cloche_growth_mod.get() * (double)this.fertilizerMod);
                    --this.fertilizerAmount;
                } else {
                    this.renderGrowth = 0.0f;
                }
                if (Utils.RAND.nextInt(8) != 0) break block27;
                double partX = (double)this.func_174877_v().func_177958_n() + 0.5;
                double partY = (double)this.func_174877_v().func_177956_o() + 2.6875;
                double partZ = (double)this.func_174877_v().func_177952_p() + 0.5;
                ImmersiveEngineering.proxy.spawnRedstoneFX(this.getWorldNonnull(), partX, partY, partZ, 0.25, 0.25, 0.25, 1.0f, 0.55f, 0.1f, 0.1f);
                break block27;
            }
            if (!seed.func_190926_b()) {
                ClocheRecipe recipe = this.getRecipe();
                int consumption = (Integer)IEConfig.MACHINES.cloche_consumption.get();
                if (recipe != null && this.fertilizerAmount > 0 && this.energyStorage.extractEnergy(consumption, true) == consumption) {
                    boolean consume = false;
                    if (this.growth >= (float)recipe.time) {
                        ItemStack existing;
                        int j;
                        List<ItemStack> outputs = recipe.outputs;
                        int canFit = 0;
                        boolean[] emptySlotsUsed = new boolean[4];
                        block0: for (ItemStack output : outputs) {
                            if (output.func_190926_b()) continue;
                            for (j = 3; j < 7; ++j) {
                                existing = (ItemStack)this.inventory.get(j);
                                if ((!existing.func_190926_b() || emptySlotsUsed[j - 3]) && (!ItemHandlerHelper.canItemStacksStack((ItemStack)existing, (ItemStack)output) || existing.func_190916_E() + output.func_190916_E() > existing.func_77976_d())) continue;
                                ++canFit;
                                if (!existing.func_190926_b()) continue block0;
                                emptySlotsUsed[j - 3] = true;
                                continue block0;
                            }
                        }
                        if (canFit >= outputs.size()) {
                            block2: for (ItemStack output : outputs) {
                                for (j = 3; j < 7; ++j) {
                                    existing = (ItemStack)this.inventory.get(j);
                                    if (existing.func_190926_b()) {
                                        this.inventory.set(j, (Object)output.func_77946_l());
                                        continue block2;
                                    }
                                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)existing, (ItemStack)output) || existing.func_190916_E() + output.func_190916_E() > existing.func_77976_d()) continue;
                                    existing.func_190917_f(output.func_190916_E());
                                    continue block2;
                                }
                            }
                            this.growth = 0.0f;
                            consume = true;
                        }
                    } else {
                        this.growth = (float)((double)this.growth + (Double)IEConfig.MACHINES.cloche_growth_mod.get() * (double)this.fertilizerMod);
                        consume = true;
                        if (this.field_145850_b.func_82737_E() % 32L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x1F)) {
                            this.sendSyncPacket(0);
                        }
                    }
                    if (consume) {
                        this.energyStorage.extractEnergy(consumption, false);
                        --this.fertilizerAmount;
                        if (!this.renderActive) {
                            this.renderActive = true;
                            this.sendSyncPacket(0);
                        }
                    } else if (this.renderActive) {
                        this.renderActive = false;
                        this.sendSyncPacket(0);
                    }
                } else {
                    this.growth = 0.0f;
                }
                int fluidConsumption = (Integer)IEConfig.MACHINES.cloche_fluid.get();
                if (this.fertilizerAmount <= 0 && this.tank.getFluidAmount() >= fluidConsumption) {
                    float itemMod;
                    this.fertilizerMod = 1.0f;
                    this.tank.drain(fluidConsumption, IFluidHandler.FluidAction.EXECUTE);
                    ItemStack fertilizer = (ItemStack)this.inventory.get(2);
                    if (!fertilizer.func_190926_b() && (itemMod = ClocheFertilizer.getFertilizerGrowthModifier(fertilizer)) > 0.0f) {
                        this.fertilizerMod *= itemMod;
                        fertilizer.func_190918_g(1);
                        if (fertilizer.func_190916_E() <= 0) {
                            this.inventory.set(2, (Object)ItemStack.field_190927_a);
                        }
                    }
                    this.fertilizerAmount = (Integer)IEConfig.MACHINES.cloche_fertilizer.get();
                    this.sendSyncPacket(1);
                }
            } else {
                this.growth = 0.0f;
            }
            if (this.field_145850_b.func_82737_E() % 8L == 0L && this.output.isPresent()) {
                for (int j = 3; j < 7; ++j) {
                    ItemStack outStack = (ItemStack)this.inventory.get(j);
                    if (outStack.func_190926_b()) continue;
                    int outCount = Math.min(outStack.func_190916_E(), 16);
                    ItemStack stack = Utils.copyStackWithAmount(outStack, outCount);
                    if (!(stack = Utils.insertStackIntoInventory(this.output, stack, false)).func_190926_b()) {
                        outCount -= stack.func_190916_E();
                    }
                    outStack.func_190918_g(outCount);
                    if (outStack.func_190916_E() > 0) continue;
                    this.inventory.set(j, (Object)ItemStack.field_190927_a);
                }
            }
        }
    }

    @Nullable
    public ClocheRecipe getRecipe() {
        ItemStack soil = (ItemStack)this.inventory.get(0);
        ItemStack seed = (ItemStack)this.inventory.get(1);
        return ClocheRecipe.findRecipe(seed, soil);
    }

    protected void sendSyncPacket(int type) {
        CompoundNBT nbt = new CompoundNBT();
        if (type == 0) {
            nbt.func_74776_a("growth", this.growth);
            nbt.func_74768_a("energy", this.energyStorage.getEnergyStored());
            nbt.func_74757_a("renderActive", this.renderActive);
        } else if (type == 1) {
            nbt.func_74768_a("fertilizerAmount", this.fertilizerAmount);
            nbt.func_74776_a("fertilizerMod", this.fertilizerMod);
        } else if (type == 2) {
            nbt.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        }
        ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)new MessageTileSync(this, nbt));
    }

    @Override
    public void receiveMessageFromServer(CompoundNBT message) {
        if (message.func_150297_b("growth", 5)) {
            this.renderGrowth = message.func_74760_g("growth");
        }
        if (message.func_150297_b("renderActive", 1)) {
            this.renderActive = message.func_74767_n("renderActive");
        }
        if (message.func_150297_b("energy", 3)) {
            this.energyStorage.setEnergy(message.func_74762_e("energy"));
        }
        if (message.func_150297_b("fertilizerAmount", 3)) {
            this.fertilizerAmount = message.func_74762_e("fertilizerAmount");
        }
        if (message.func_150297_b("fertilizerMod", 5)) {
            this.fertilizerMod = message.func_74760_g("fertilizerMod");
        }
        if (message.func_150297_b("tank", 10)) {
            this.tank.readFromNBT(message.func_74775_l("tank"));
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.dummy = nbt.func_74762_e("dummy");
        this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 7);
        this.energyStorage.readFromNBT(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.fertilizerAmount = nbt.func_74762_e("fertilizerAmount");
        this.fertilizerMod = nbt.func_74760_g("fertilizerMod");
        this.growth = nbt.func_74760_g("growth");
        this.renderBB = null;
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74768_a("dummy", this.dummy);
        nbt.func_218657_a("inventory", (INBT)Utils.writeInventory(this.inventory));
        this.energyStorage.writeToNBT(nbt);
        CompoundNBT tankTag = this.tank.writeToNBT(new CompoundNBT());
        nbt.func_218657_a("tank", (INBT)tankTag);
        nbt.func_74768_a("fertilizerAmount", this.fertilizerAmount);
        nbt.func_74776_a("fertilizerMod", this.fertilizerMod);
        nbt.func_74776_a("growth", this.growth);
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return true;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return true;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return VoxelShapes.func_197868_b();
    }

    @Override
    public boolean isDummy() {
        return this.dummy != 0;
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        if (!this.isDummy()) {
            return this;
        }
        if (this.tempMasterTE != null) {
            return this.tempMasterTE;
        }
        BlockPos masterPos = this.func_174877_v().func_177979_c(this.dummy);
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockItemUseContext ctx, BlockState state) {
        state = (BlockState)state.func_206870_a((IProperty)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        for (int i = 1; i <= 2; ++i) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177981_b(i), state);
            ((ClocheTileEntity)this.field_145850_b.func_175625_s((BlockPos)this.field_174879_c.func_177981_b((int)i))).dummy = i;
            ((ClocheTileEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(i))).setFacing(this.getFacing());
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        this.tempMasterTE = this.master();
        for (int i = 0; i <= 2; ++i) {
            BlockPos p = this.func_174877_v().func_177979_c(this.dummy).func_177981_b(i);
            if (!(this.field_145850_b.func_175625_s(p) instanceof ClocheTileEntity)) continue;
            this.field_145850_b.func_217377_a(p, false);
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        if (slot == 2) {
            return ClocheFertilizer.isValidFertilizer(stack);
        }
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot < 2 ? 1 : 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        if (slot == 0) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            ClocheTileEntity te;
            if (this.dummy == 0 && (facing == null || facing.func_176740_k() != this.getFacing().func_176746_e().func_176740_k())) {
                return this.inputHandler.cast();
            }
            if (this.dummy == 1 && (facing == null || facing == this.getFacing().func_176734_d()) && (te = this.getGuiMaster()) != null) {
                return te.outputHandler.cast();
            }
        } else if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.dummy == 0 && (facing == null || facing.func_176740_k() != this.getFacing().func_176746_e().func_176740_k())) {
            return this.tankCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return true;
    }

    @Override
    public ClocheTileEntity getGuiMaster() {
        if (this.dummy == 0) {
            return this;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177979_c(this.dummy));
        if (te instanceof ClocheTileEntity) {
            return (ClocheTileEntity)te;
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getTextureReplacement(BlockState object, String group, String material) {
        ResourceLocation rl;
        if (!((ItemStack)this.inventory.get(0)).func_190926_b() && "farmland".equals(material) && (rl = this.getSoilTexture()) != null) {
            return ClientUtils.getSprite(rl);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderGroup(BlockState object, String group) {
        return "glass".equals(group) == (MinecraftForgeClient.getRenderLayer() == RenderType.func_228645_f_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TransformationMatrix applyTransformations(BlockState object, String group, TransformationMatrix transform) {
        return transform;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getCacheKey(BlockState object) {
        ResourceLocation rl;
        if (!((ItemStack)this.inventory.get(0)).func_190926_b() && (rl = this.getSoilTexture()) != null) {
            return rl.toString();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private ResourceLocation getSoilTexture() {
        ItemStack soil = (ItemStack)this.inventory.get(0);
        ResourceLocation rl = ClocheRecipe.getSoilTexture(soil);
        if (rl == null) {
            try {
                BlockState state = Utils.getStateFromItemStack(soil);
                if (state != null) {
                    rl = ClientUtils.getSideTexture(state, Direction.UP);
                }
            }
            catch (Exception e) {
                rl = ClientUtils.getSideTexture(soil, Direction.UP);
            }
        }
        if (rl == null && !soil.func_190926_b() && Utils.isFluidRelatedItemStack(soil)) {
            rl = (ResourceLocation)FluidUtil.getFluidContained((ItemStack)soil).map(fs -> fs.getFluid().getAttributes().getStillTexture(fs)).orElse((Object)rl);
        }
        return rl;
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.dummy != 0 && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177979_c(this.dummy))) instanceof ClocheTileEntity) {
            return ((ClocheTileEntity)te).energyStorage;
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(@Nullable Direction facing) {
        return facing == null || this.dummy == 0 && facing.func_176740_k() == this.getFacing().func_176746_e().func_176740_k() || this.dummy == 2 && facing == Direction.UP ? IEEnums.IOSideConfig.INPUT : IEEnums.IOSideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (facing == null || this.dummy == 0 && facing.func_176740_k() == this.getFacing().func_176746_e().func_176740_k() || this.dummy == 2 && facing == Direction.UP) {
            return this.energyWrapper;
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBB == null) {
            this.renderBB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0).func_186670_a(this.field_174879_c);
        }
        return this.renderBB;
    }
}

