/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.generic.MiscConnectorBlock;
import blusunrize.immersiveengineering.common.util.CapabilityReference;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2FloatAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class EnergyConnectorTileEntity
extends ImmersiveConnectableTileEntity
implements IEBlockInterfaces.IStateBasedDirectional,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IBlockBounds,
EnergyTransferHandler.EnergyConnector,
ITickableTileEntity {
    public static final BiMap<Pair<String, Boolean>, TileEntityType<EnergyConnectorTileEntity>> DATA_TYPE_MAP = HashBiMap.create();
    private final String voltage;
    private final boolean relay;
    public int currentTickToMachine = 0;
    public int currentTickToNet = 0;
    private FluxStorage storageToNet = new FluxStorage(this.getMaxInput(), this.getMaxInput(), this.getMaxInput());
    private FluxStorage storageToMachine = new FluxStorage(this.getMaxInput(), this.getMaxInput(), this.getMaxInput());
    private CapabilityReference<IEnergyStorage> output = CapabilityReference.forNeighbor((TileEntity)this, CapabilityEnergy.ENERGY, (NonNullSupplier<Direction>)((NonNullSupplier)this::getFacing));
    EnergyHelper.IEForgeEnergyWrapper energyWrapper;
    private static final Object2FloatMap<Pair<String, Boolean>> LENGTH = new Object2FloatAVLTreeMap();

    public static void registerConnectorTEs(RegistryEvent.Register<TileEntityType<?>> event) {
        for (String type : new String[]{"LV", "MV", "HV"}) {
            for (int b = 0; b < 2; ++b) {
                boolean relay = b != 0;
                ImmutablePair key = new ImmutablePair((Object)type, (Object)relay);
                TileEntityType teType = new TileEntityType(() -> new EnergyConnectorTileEntity(type, relay), (Set)ImmutableSet.of((Object)IEBlocks.Connectors.ENERGY_CONNECTORS.get((Object)key)), null);
                teType.setRegistryName("immersiveengineering", type.toLowerCase() + "_" + (relay ? "relay" : "conn"));
                event.getRegistry().register((IForgeRegistryEntry)teType);
                DATA_TYPE_MAP.put((Object)key, (Object)teType);
            }
        }
    }

    public EnergyConnectorTileEntity(TileEntityType<? extends EnergyConnectorTileEntity> type) {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)type);
        Pair data = (Pair)DATA_TYPE_MAP.inverse().get(type);
        this.voltage = (String)data.getKey();
        this.relay = (Boolean)data.getValue();
    }

    public EnergyConnectorTileEntity(String voltage, boolean relay) {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)((TileEntityType)DATA_TYPE_MAP.get((Object)new ImmutablePair((Object)voltage, (Object)relay))));
        this.voltage = voltage;
        this.relay = relay;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int maxOut = Math.min(this.storageToMachine.getEnergyStored(), this.getMaxOutput() - this.currentTickToMachine);
            if (maxOut > 0 && this.output.isPresent()) {
                IEnergyStorage target = this.output.get();
                int inserted = target.receiveEnergy(maxOut, false);
                this.storageToMachine.extractEnergy(inserted, false);
            }
            this.currentTickToMachine = 0;
            this.currentTickToNet = 0;
        }
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return MiscConnectorBlock.DEFAULT_FACING_PROP;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        LocalWireNetwork local;
        if (!this.relay && (local = this.globalNet.getNullableLocalNet(new ConnectionPoint(this.field_174879_c, 0))) != null && !local.getConnections(this.field_174879_c).isEmpty()) {
            return false;
        }
        return this.voltage.equals(cableType.getCategory());
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        CompoundNBT toNet = new CompoundNBT();
        this.storageToNet.writeToNBT(toNet);
        nbt.func_218657_a("toNet", (INBT)toNet);
        CompoundNBT toMachine = new CompoundNBT();
        this.storageToMachine.writeToNBT(toMachine);
        nbt.func_218657_a("toMachine", (INBT)toMachine);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        CompoundNBT toMachine = nbt.func_74775_l("toMachine");
        this.storageToMachine.readFromNBT(toMachine);
        CompoundNBT toNet = nbt.func_74775_l("toNet");
        this.storageToNet.readFromNBT(toNet);
    }

    @Override
    public Vec3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        Direction side = this.getFacing().func_176734_d();
        double lengthFromHalf = (double)LENGTH.getFloat((Object)new ImmutablePair((Object)this.voltage, (Object)this.relay)) - con.type.getRenderDiameter() / 2.0 - 0.5;
        return new Vec3d(0.5 + lengthFromHalf * (double)side.func_82601_c(), 0.5 + lengthFromHalf * (double)side.func_96559_d(), 0.5 + lengthFromHalf * (double)side.func_82599_e());
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (facing != this.getFacing() || this.relay) {
            return null;
        }
        if (this.energyWrapper == null || this.energyWrapper.side != this.getFacing()) {
            this.energyWrapper = new EnergyHelper.IEForgeEnergyWrapper(this, this.getFacing());
        }
        return this.energyWrapper;
    }

    @Override
    public FluxStorage getFluxStorage() {
        return this.storageToNet;
    }

    @Override
    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        return !this.relay && facing == this.getFacing() ? IEEnums.IOSideConfig.INPUT : IEEnums.IOSideConfig.NONE;
    }

    @Override
    public boolean canConnectEnergy(Direction from) {
        if (this.relay) {
            return false;
        }
        return from == this.getFacing();
    }

    @Override
    public int receiveEnergy(Direction from, int energy, boolean simulate) {
        if (this.field_145850_b.field_72995_K || this.relay) {
            return 0;
        }
        energy = Math.min(this.getMaxInput() - this.currentTickToNet, energy);
        if (energy <= 0) {
            return 0;
        }
        int accepted = Math.min(Math.min(this.getMaxOutput(), this.getMaxInput()), energy);
        accepted = Math.min(this.getMaxOutput() - this.storageToNet.getEnergyStored(), accepted);
        if (accepted <= 0) {
            return 0;
        }
        if (!simulate) {
            this.storageToNet.modifyEnergyStored(accepted);
            this.currentTickToNet += accepted;
            this.func_70296_d();
        }
        return accepted;
    }

    @Override
    public int getEnergyStored(Direction from) {
        if (this.relay) {
            return 0;
        }
        return this.storageToNet.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(Direction from) {
        if (this.relay) {
            return 0;
        }
        return this.getMaxInput();
    }

    @Override
    public int extractEnergy(Direction from, int energy, boolean simulate) {
        return 0;
    }

    private int getVoltageIndex() {
        if ("LV".equals(this.voltage)) {
            return 0;
        }
        if ("MV".equals(this.voltage)) {
            return 1;
        }
        return 2;
    }

    public int getMaxInput() {
        return IEConfig.CACHED.connectorInputRates[this.getVoltageIndex()];
    }

    public int getMaxOutput() {
        return IEConfig.CACHED.connectorInputRates[this.getVoltageIndex()];
    }

    public static VoxelShape getConnectorBounds(Direction facing, float wMin, float length) {
        float wMax = 1.0f - wMin;
        switch (facing.func_176734_d()) {
            case UP: {
                return VoxelShapes.func_197873_a((double)wMin, (double)0.0, (double)wMin, (double)wMax, (double)length, (double)wMax);
            }
            case DOWN: {
                return VoxelShapes.func_197873_a((double)wMin, (double)(1.0f - length), (double)wMin, (double)wMax, (double)1.0, (double)wMax);
            }
            case SOUTH: {
                return VoxelShapes.func_197873_a((double)wMin, (double)wMin, (double)0.0, (double)wMax, (double)wMax, (double)length);
            }
            case NORTH: {
                return VoxelShapes.func_197873_a((double)wMin, (double)wMin, (double)(1.0f - length), (double)wMax, (double)wMax, (double)1.0);
            }
            case EAST: {
                return VoxelShapes.func_197873_a((double)0.0, (double)wMin, (double)wMin, (double)length, (double)wMax, (double)wMax);
            }
            case WEST: {
                return VoxelShapes.func_197873_a((double)(1.0f - length), (double)wMin, (double)wMin, (double)1.0, (double)wMax, (double)wMax);
            }
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        float length = LENGTH.getFloat((Object)new ImmutablePair((Object)this.voltage, (Object)this.relay));
        float wMin = 0.3125f;
        return EnergyConnectorTileEntity.getConnectorBounds(this.getFacing(), wMin, length);
    }

    @Override
    public boolean isSource(ConnectionPoint cp) {
        return !this.relay;
    }

    @Override
    public boolean isSink(ConnectionPoint cp) {
        return !this.relay;
    }

    @Override
    public int getAvailableEnergy() {
        return this.storageToNet.getEnergyStored();
    }

    @Override
    public int getRequestedEnergy() {
        return this.storageToMachine.getMaxEnergyStored() - this.storageToMachine.getEnergyStored();
    }

    @Override
    public void insertEnergy(int amount) {
        this.storageToMachine.receiveEnergy(amount, false);
    }

    @Override
    public void extractEnergy(int amount) {
        this.storageToNet.extractEnergy(amount, false);
    }

    @Override
    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)EnergyTransferHandler.ID);
    }

    static {
        LENGTH.put((Object)new ImmutablePair((Object)"HV", (Object)false), 0.75f);
        LENGTH.put((Object)new ImmutablePair((Object)"HV", (Object)true), 0.875f);
        LENGTH.put((Object)new ImmutablePair((Object)"MV", (Object)false), 0.5625f);
        LENGTH.defaultReturnValue(0.5f);
    }
}

