/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.FakeLightBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;

public class FloodlightTileEntity
extends ImmersiveConnectableTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IAdvancedDirectionalTile,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.ISpawnInterdiction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IActiveState,
IOBJModelCallback<BlockState>,
EnergyTransferHandler.EnergyConnector,
IEBlockInterfaces.IStateBasedDirectional {
    public static TileEntityType<FloodlightTileEntity> TYPE;
    public int energyStorage = 0;
    private int energyDraw;
    private int maximumStorage;
    public boolean redstoneControlInverted;
    public Direction facing;
    public float rotY;
    public float rotX;
    public List<BlockPos> fakeLights;
    public List<BlockPos> lightsToBePlaced;
    public List<BlockPos> lightsToBeRemoved;
    final int timeBetweenSwitches = 20;
    int switchCooldown;
    private boolean shouldUpdate;
    public boolean computerOn;
    public int controllingComputers;
    public int turnCooldown;

    public FloodlightTileEntity() {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)TYPE);
        this.energyDraw = (Integer)IEConfig.MACHINES.floodlight_energyDraw.get();
        this.maximumStorage = (Integer)IEConfig.MACHINES.floodlight_maximumStorage.get();
        this.redstoneControlInverted = false;
        this.facing = Direction.NORTH;
        this.rotY = 0.0f;
        this.rotX = 0.0f;
        this.fakeLights = new ArrayList<BlockPos>();
        this.lightsToBePlaced = new ArrayList<BlockPos>();
        this.lightsToBeRemoved = new ArrayList<BlockPos>();
        this.timeBetweenSwitches = 20;
        this.switchCooldown = 0;
        this.shouldUpdate = true;
        this.computerOn = true;
        this.controllingComputers = 0;
        this.turnCooldown = 0;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.turnCooldown > 0) {
            --this.turnCooldown;
        }
        boolean activeBeforeTick = this.getIsActive();
        if (this.shouldUpdate) {
            this.lightsToBePlaced.clear();
            this.updateFakeLights(true, activeBeforeTick);
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            this.shouldUpdate = false;
        }
        boolean enabled = this.controllingComputers > 0 && this.computerOn || this.isRSPowered() ^ this.redstoneControlInverted;
        if (this.energyStorage >= (!activeBeforeTick ? this.energyDraw * 10 : this.energyDraw) && enabled && this.switchCooldown <= 0) {
            this.energyStorage -= this.energyDraw;
            if (!activeBeforeTick) {
                this.setActive(true);
            }
        } else if (activeBeforeTick) {
            this.setActive(false);
            this.switchCooldown = 20;
        }
        --this.switchCooldown;
        boolean activeAfterTick = this.getIsActive();
        if (activeAfterTick != activeBeforeTick || this.field_145850_b.func_82737_E() % 512L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x1FF)) {
            this.markContainingBlockForUpdate(null);
            this.updateFakeLights(true, activeAfterTick);
            this.checkLight();
        }
        if (!activeAfterTick && !this.lightsToBePlaced.isEmpty()) {
            this.lightsToBePlaced.clear();
        }
        if (!(this.lightsToBePlaced.isEmpty() && this.lightsToBeRemoved.isEmpty() || this.field_145850_b.func_82737_E() % 8L != (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 7))) {
            BlockPos cc;
            Iterator<BlockPos> it = this.lightsToBePlaced.iterator();
            int timeout = 0;
            while (it.hasNext() && timeout++ < Math.max(16, 32 - this.lightsToBeRemoved.size())) {
                cc = it.next();
                this.field_145850_b.func_180501_a(cc, IEBlocks.Misc.fakeLight.func_176223_P(), 2);
                TileEntity te = this.field_145850_b.func_175625_s(cc);
                if (te instanceof FakeLightBlock.FakeLightTileEntity) {
                    ((FakeLightBlock.FakeLightTileEntity)te).floodlightCoords = this.func_174877_v();
                }
                this.fakeLights.add(cc);
                it.remove();
            }
            it = this.lightsToBeRemoved.iterator();
            while (it.hasNext() && timeout++ < 32) {
                cc = it.next();
                if (Utils.getExistingTileEntity(this.field_145850_b, cc) instanceof FakeLightBlock.FakeLightTileEntity) {
                    this.field_145850_b.func_217377_a(cc, false);
                }
                it.remove();
            }
        }
    }

    public void updateFakeLights(boolean deleteOld, boolean genNew) {
        Iterator<BlockPos> it = this.fakeLights.iterator();
        ArrayList<BlockPos> tempRemove = new ArrayList<BlockPos>();
        while (it.hasNext()) {
            BlockPos cc = it.next();
            TileEntity te = this.field_145850_b.func_175625_s(cc);
            if (te instanceof FakeLightBlock.FakeLightTileEntity) {
                if (!deleteOld) continue;
                tempRemove.add(cc);
                continue;
            }
            it.remove();
        }
        if (genNew) {
            float angle = this.facing == Direction.NORTH ? 180 : (this.facing == Direction.EAST ? 90 : (this.facing == Direction.WEST ? -90 : 0));
            float yRotation = this.rotY;
            double angleX = Math.toRadians(this.rotX);
            Vec3d[] rays = new Vec3d[]{new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0)};
            Matrix4 mat = new Matrix4();
            if (this.getFacing() == Direction.DOWN) {
                mat.scale(1.0, -1.0, 1.0);
            } else if (this.getFacing() != Direction.UP) {
                float f = this.facing == Direction.DOWN ? 180.0f : (this.facing == Direction.NORTH ? -90.0f : (angle = this.facing == Direction.SOUTH ? 90.0f : angle));
                if (this.getFacing().func_176740_k() == Direction.Axis.X) {
                    mat.rotate(1.5707963267948966, -1.0, 0.0, 0.0);
                    mat.rotate(1.5707963267948966, 0.0, 0.0, -this.getFacing().func_176743_c().func_179524_a());
                } else {
                    mat.rotate(1.5707963267948966, -1.0, 0.0, 0.0);
                    if (this.getFacing() == Direction.SOUTH) {
                        mat.rotate(Math.PI, 0.0, 0.0, 1.0);
                        if (this.facing.func_176740_k() == Direction.Axis.X) {
                            angle = -angle;
                        }
                    }
                }
            }
            double angleY = Math.toRadians(angle + yRotation);
            mat.rotate(angleY, 0.0, 1.0, 0.0);
            mat.rotate(-angleX, 1.0, 0.0, 0.0);
            rays[0] = mat.apply(rays[0]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            rays[1] = mat.apply(rays[1]);
            mat.rotate(-0.19634954084936207, 0.0, 1.0, 0.0);
            rays[5] = mat.apply(rays[5]);
            mat.rotate(-0.39269908169872414, 0.0, 1.0, 0.0);
            rays[6] = mat.apply(rays[6]);
            mat.rotate(-0.19634954084936207, 0.0, 1.0, 0.0);
            rays[2] = mat.apply(rays[2]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            mat.rotate(0.39269908169872414, 1.0, 0.0, 0.0);
            rays[3] = mat.apply(rays[3]);
            mat.rotate(-0.19634954084936207, 1.0, 0.0, 0.0);
            rays[7] = mat.apply(rays[7]);
            mat.rotate(-0.39269908169872414, 1.0, 0.0, 0.0);
            rays[8] = mat.apply(rays[8]);
            mat.rotate(-0.19634954084936207, 1.0, 0.0, 0.0);
            rays[4] = mat.apply(rays[4]);
            mat.rotate(0.39269908169872414, 1.0, 0.0, 0.0);
            mat.rotate(0.19634954084936207, 1.0, 0.0, 0.0);
            mat.rotate(0.19634954084936207, 0.0, 1.0, 0.0);
            rays[9] = mat.apply(rays[9]);
            mat.rotate(-0.39269908169872414, 0.0, 1.0, 0.0);
            rays[10] = mat.apply(rays[10]);
            mat.rotate(-0.39269908169872414, 1.0, 0.0, 0.0);
            rays[11] = mat.apply(rays[11]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            rays[12] = mat.apply(rays[12]);
            for (int ray = 0; ray < rays.length; ++ray) {
                int offset = ray == 0 ? 0 : (ray < 4 ? 3 : 1);
                this.placeLightAlongVector(rays[ray], offset, tempRemove);
            }
        }
        this.lightsToBeRemoved.addAll(tempRemove);
    }

    public void placeLightAlongVector(Vec3d vec, int offset, ArrayList<BlockPos> checklist) {
        Vec3d light = new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.75, 0.5);
        int range = 32;
        HashSet<BlockPos> ignore = new HashSet<BlockPos>();
        ignore.add(this.func_174877_v());
        BlockPos hit = Utils.rayTraceForFirst(Utils.addVectors(vec, light), light.func_72441_c(vec.field_72450_a * (double)range, vec.field_72448_b * (double)range, vec.field_72449_c * (double)range), this.field_145850_b, ignore);
        double maxDistance = hit != null ? new Vec3d((Vec3i)hit).func_72441_c(0.5, 0.75, 0.5).func_72436_e(light) : (double)(range * range);
        for (int i = 1 + offset; i <= range; ++i) {
            BlockPos target = this.func_174877_v().func_177963_a((double)Math.round(vec.field_72450_a * (double)i), (double)Math.round(vec.field_72448_b * (double)i), (double)Math.round(vec.field_72449_c * (double)i));
            double dist = vec.field_72450_a * (double)i * vec.field_72450_a * (double)i + vec.field_72448_b * (double)i * vec.field_72448_b * (double)i + vec.field_72449_c * (double)i * vec.field_72449_c * (double)i;
            if (dist > maxDistance) break;
            if (target.func_177956_o() > 255 || target.func_177956_o() < 0 || target.equals((Object)this.func_174877_v()) || !this.field_145850_b.func_175623_d(target)) continue;
            if (!checklist.remove(target)) {
                this.lightsToBePlaced.add(target);
            }
            i += 2;
        }
    }

    @Override
    public double getInterdictionRangeSquared() {
        return this.getIsActive() ? 1024.0 : 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_145843_s() {
        Map<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>> map = EventHandler.interdictionTiles;
        synchronized (map) {
            EventHandler.interdictionTiles.remove(this);
        }
        super.func_145843_s();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChunkUnloaded() {
        Map<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>> map = EventHandler.interdictionTiles;
        synchronized (map) {
            EventHandler.interdictionTiles.remove(this);
        }
        super.onChunkUnloaded();
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage = nbt.func_74762_e("energy");
        this.redstoneControlInverted = nbt.func_74767_n("redstoneControlInverted");
        this.facing = Direction.func_82600_a((int)nbt.func_74762_e("facing"));
        this.rotY = nbt.func_74760_g("rotY");
        this.rotX = nbt.func_74760_g("rotX");
        int lightAmount = nbt.func_74762_e("lightAmount");
        this.fakeLights.clear();
        for (int i = 0; i < lightAmount; ++i) {
            int[] icc = nbt.func_74759_k("fakeLight_" + i);
            this.fakeLights.add(new BlockPos(icc[0], icc[1], icc[2]));
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.markContainingBlockForUpdate(null);
        }
        if (descPacket) {
            this.controllingComputers = nbt.func_74767_n("computerControlled") ? 1 : 0;
            this.computerOn = nbt.func_74767_n("computerOn");
        }
        if (this.field_145850_b != null && this.getIsActive()) {
            this.checkLight();
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("energyStorage", this.energyStorage);
        nbt.func_74757_a("redstoneControlInverted", this.redstoneControlInverted);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74776_a("rotY", this.rotY);
        nbt.func_74776_a("rotX", this.rotX);
        nbt.func_74768_a("lightAmount", this.fakeLights.size());
        for (int i = 0; i < this.fakeLights.size(); ++i) {
            BlockPos cc = this.fakeLights.get(i);
            nbt.func_74783_a("fakeLight_" + i, new int[]{cc.func_177958_n(), cc.func_177956_o(), cc.func_177952_p()});
        }
        if (descPacket) {
            nbt.func_74757_a("computerControlled", this.controllingComputers > 0);
            nbt.func_74757_a("computerOn", this.computerOn);
        }
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 1) {
            this.markContainingBlockForUpdate(null);
            this.checkLight();
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "LV".equals(cableType.getCategory());
    }

    @Override
    public Vec3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        double z;
        double y;
        double x;
        BlockPos other = con == null ? this.field_174879_c : con.getOtherEnd(here).getPosition();
        int xDif = other.func_177958_n() - this.field_174879_c.func_177958_n();
        int yDif = other.func_177956_o() - this.field_174879_c.func_177956_o();
        int zDif = other.func_177952_p() - this.field_174879_c.func_177952_p();
        switch (this.getFacing()) {
            case DOWN: 
            case UP: {
                x = Math.abs(xDif) >= Math.abs(zDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                double d = y = this.getFacing() == Direction.DOWN ? 0.9375 : 0.0625;
                z = Math.abs(zDif) > Math.abs(xDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                break;
            }
            case NORTH: 
            case SOUTH: {
                double d = Math.abs(xDif) >= Math.abs(yDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : (x = 0.5);
                y = Math.abs(yDif) > Math.abs(xDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                z = this.getFacing() == Direction.NORTH ? 0.9375 : 0.0625;
                break;
            }
            default: {
                double d = x = this.getFacing() == Direction.WEST ? 0.9375 : 0.0625;
                double d2 = Math.abs(yDif) >= Math.abs(zDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : (y = 0.5);
                z = Math.abs(zDif) > Math.abs(yDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
            }
        }
        return new Vec3d(x, y, z);
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return VoxelShapes.func_197873_a((double)(this.getFacing().func_176740_k() == Direction.Axis.X ? 0.0 : 0.0625), (double)(this.getFacing().func_176740_k() == Direction.Axis.Y ? 0.0 : 0.0625), (double)(this.getFacing().func_176740_k() == Direction.Axis.Z ? 0.0 : 0.0625), (double)(this.getFacing().func_176740_k() == Direction.Axis.X ? 1.0 : 0.9375), (double)(this.getFacing().func_176740_k() == Direction.Axis.Y ? 1.0 : 0.9375), (double)(this.getFacing().func_176740_k() == Direction.Axis.Z ? 1.0 : 0.9375));
    }

    @Override
    public boolean hammerUseSide(Direction side, PlayerEntity player, Vec3d hitVec) {
        if (!this.field_145850_b.field_72995_K) {
            double hitX = hitVec.field_72450_a;
            double hitY = hitVec.field_72448_b;
            double hitZ = hitVec.field_72449_c;
            if (side.func_176740_k() == this.getFacing().func_176740_k()) {
                this.turnY(player.func_225608_bj_(), false);
            } else {
                this.turnX(player.func_225608_bj_(), false);
            }
        }
        return true;
    }

    @Override
    public ActionResultType screwdriverUseSide(Direction side, PlayerEntity player, Vec3d hitVec) {
        if (!this.field_145850_b.field_72995_K) {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TranslationTextComponent("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"), new Object[0])});
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public void onDirectionalPlacement(Direction side, float hitX, float hitY, float hitZ, LivingEntity placer) {
        Direction f = Direction.func_176733_a((double)placer.field_70177_z);
        if (f == side.func_176734_d()) {
            f = placer.field_70125_A > 0.0f ? Direction.DOWN : Direction.UP;
        }
        this.facing = f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderGroup(BlockState object, String group) {
        if ("glass".equals(group)) {
            return MinecraftForgeClient.getRenderLayer() == RenderType.func_228645_f_();
        }
        return MinecraftForgeClient.getRenderLayer() == RenderType.func_228639_c_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TransformationMatrix applyTransformations(BlockState object, String group, TransformationMatrix transform) {
        Vector3f transl = new Vector3f(0.5f, 0.5f, 0.5f);
        double yaw = 0.0;
        double pitch = 0.0;
        double roll = 0.0;
        if (this.getFacing().func_176740_k() == Direction.Axis.Y) {
            double d = this.facing == Direction.SOUTH ? 180.0 : (this.facing == Direction.WEST ? 90.0 : (yaw = this.facing == Direction.EAST ? -90.0 : 0.0));
            if (this.getFacing() == Direction.DOWN) {
                roll = 180.0;
            }
        } else {
            if (this.getFacing() == Direction.NORTH) {
                pitch = 90.0;
                yaw = 180.0;
            }
            if (this.getFacing() == Direction.SOUTH) {
                pitch = 90.0;
            }
            if (this.getFacing() == Direction.WEST) {
                pitch = 90.0;
                yaw = -90.0;
            }
            if (this.getFacing() == Direction.EAST) {
                pitch = 90.0;
                yaw = 90.0;
            }
            if (this.facing == Direction.DOWN) {
                roll += 180.0;
            } else if (this.getFacing().func_176740_k() == Direction.Axis.X && this.facing.func_176740_k() == Direction.Axis.Z) {
                roll += (double)(90 * this.facing.func_176743_c().func_179524_a() * this.getFacing().func_176743_c().func_179524_a());
            } else if (this.getFacing().func_176740_k() == Direction.Axis.Z && this.facing.func_176740_k() == Direction.Axis.X) {
                roll += (double)(-90 * this.facing.func_176743_c().func_179524_a() * this.getFacing().func_176743_c().func_179524_a());
            }
        }
        transl.func_229189_a_(new Vector3f((float)this.getFacing().func_82601_c() * 0.125f, (float)this.getFacing().func_96559_d() * 0.125f, (float)this.getFacing().func_82599_e() * 0.125f));
        if ("axis".equals(group) || "light".equals(group) || "off".equals(group) || "glass".equals(group)) {
            if (this.getFacing().func_176740_k() == Direction.Axis.Y) {
                yaw += (double)this.rotY;
            } else {
                roll += (double)this.rotY;
            }
            if ("light".equals(group) || "off".equals(group) || "glass".equals(group)) {
                pitch += (double)this.rotX;
            }
        }
        return new TransformationMatrix(transl, ClientUtils.degreeToQuaterion(pitch, yaw, roll), null, null).blockCornerToCenter();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getCacheKey(BlockState object) {
        return this.getFacing() + ":" + this.facing + ":" + this.rotX + ":" + this.rotY;
    }

    public boolean canComputerTurn() {
        return this.turnCooldown <= 0 || !this.getIsActive();
    }

    public void turnX(boolean dir, boolean throwException) {
        if (!this.canComputerTurn()) {
            if (throwException) {
                throw new IllegalArgumentException("The floodlight can't turn again yet.");
            }
            return;
        }
        this.rotX = Math.min(191.25f, Math.max(-11.25f, this.rotX + (dir ? -11.25f : 11.25f)));
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 255, 0);
        this.turnCooldown = 20;
        this.shouldUpdate = true;
    }

    public void turnY(boolean dir, boolean throwException) {
        if (!this.canComputerTurn()) {
            if (throwException) {
                throw new IllegalArgumentException("The floodlight can't turn again yet.");
            }
            return;
        }
        this.rotY = (float)((double)this.rotY + (dir ? -11.25 : 11.25));
        this.rotY %= 360.0f;
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 255, 0);
        this.turnCooldown = 20;
        this.shouldUpdate = true;
    }

    @Override
    public boolean isSource(ConnectionPoint cp) {
        return false;
    }

    @Override
    public boolean isSink(ConnectionPoint cp) {
        return true;
    }

    @Override
    public int getRequestedEnergy() {
        if (this.energyStorage < this.maximumStorage) {
            return this.maximumStorage - this.energyStorage;
        }
        return 0;
    }

    @Override
    public void insertEnergy(int amount) {
        this.energyStorage += amount;
    }
}

