/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.util.CapabilityReference;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.shapes.CachedVoxelShapes;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FluidPipeTileEntity
extends IEBaseTileEntity
implements IFluidPipe,
IEBlockInterfaces.IAdvancedHasObjProperty,
IOBJModelCallback<BlockState>,
IEBlockInterfaces.IColouredTile,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IPlacementInteraction,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.ICollisionBounds,
IEBlockInterfaces.IAdditionalDrops {
    public static TileEntityType<FluidPipeTileEntity> TYPE;
    static ConcurrentHashMap<BlockPos, Set<DirectionalFluidOutput>> indirectConnections;
    public static ArrayList<Predicate<Block>> validPipeCovers;
    public static ArrayList<Predicate<Block>> climbablePipeCovers;
    public Object2BooleanMap<Direction> sideConfig = new Object2BooleanOpenHashMap();
    public Block cover;
    private byte connections;
    @Nullable
    private DyeColor color;
    private EnumMap<Direction, LazyOptional<IFluidHandler>> sidedHandlers;
    private EnumMap<Direction, CapabilityReference<IFluidHandler>> neighbors;
    private static final CachedVoxelShapes<BoundingBoxKey> SHAPES;
    public static HashMap<String, IEProperties.IEObjState> cachedOBJStates;

    public FluidPipeTileEntity() {
        super(TYPE);
        for (Direction d : Direction.field_199792_n) {
            this.sideConfig.put((Object)d, true);
        }
        this.cover = Blocks.field_150350_a;
        this.connections = 0;
        this.color = null;
        this.sidedHandlers = new EnumMap(Direction.class);
        this.neighbors = new EnumMap(Direction.class);
        for (Direction f : Direction.field_199792_n) {
            this.sidedHandlers.put(f, this.registerConstantCap(new PipeFluidHandler(this, f)));
            this.neighbors.put(f, CapabilityReference.forNeighbor((TileEntity)this, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f));
        }
    }

    public static void initCovers() {
        validPipeCovers.add(arg_0 -> IETags.scaffoldingAlu.func_199685_a_(arg_0));
        validPipeCovers.add(arg_0 -> IETags.scaffoldingSteel.func_199685_a_(arg_0));
        validPipeCovers.add(input -> input == IEBlocks.WoodenDecoration.treatedScaffolding);
        climbablePipeCovers.add(arg_0 -> IETags.scaffoldingAlu.func_199685_a_(arg_0));
        climbablePipeCovers.add(arg_0 -> IETags.scaffoldingSteel.func_199685_a_(arg_0));
        climbablePipeCovers.add(input -> input == IEBlocks.WoodenDecoration.treatedScaffolding);
    }

    public static Set<DirectionalFluidOutput> getConnectedFluidHandlers(BlockPos node, World world) {
        if (indirectConnections.containsKey(node)) {
            return indirectConnections.get(node);
        }
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        Set<DirectionalFluidOutput> fluidHandlers = Collections.newSetFromMap(new ConcurrentHashMap());
        openList.add(node);
        while (!openList.isEmpty() && closedList.size() < 1024) {
            BlockPos next = (BlockPos)openList.get(0);
            TileEntity pipeTile = Utils.getExistingTileEntity(world, next);
            if (!closedList.contains(next) && pipeTile instanceof IFluidPipe) {
                if (pipeTile instanceof FluidPipeTileEntity) {
                    closedList.add(next);
                }
                for (int i = 0; i < 6; ++i) {
                    BlockPos nextPos;
                    TileEntity adjacentTile;
                    Direction fd = Direction.func_82600_a((int)i);
                    if (!((IFluidPipe)pipeTile).hasOutputConnection(fd) || (adjacentTile = Utils.getExistingTileEntity(world, nextPos = next.func_177972_a(fd))) == null) continue;
                    if (adjacentTile instanceof FluidPipeTileEntity) {
                        openList.add(nextPos);
                        continue;
                    }
                    LazyOptional handlerOptional = adjacentTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, fd.func_176734_d());
                    handlerOptional.ifPresent(handler -> {
                        if (handler.getTanks() > 0) {
                            fluidHandlers.add(new DirectionalFluidOutput((IFluidHandler)handler, adjacentTile, fd));
                        }
                    });
                }
            }
            openList.remove(0);
        }
        if (!world.field_72995_K && !indirectConnections.containsKey(node)) {
            indirectConnections.put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
            indirectConnections.get(node).addAll(fluidHandlers);
        }
        return fluidHandlers;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            ApiUtils.addFutureServerTask(this.field_145850_b, () -> {
                boolean changed = false;
                for (Direction f : Direction.field_199792_n) {
                    changed |= this.updateConnectionByte(f);
                }
                if (changed) {
                    this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
                    this.markContainingBlockForUpdate(null);
                }
            }, true);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            indirectConnections.clear();
        }
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (!(entity instanceof LivingEntity) || ((LivingEntity)entity).func_70617_f_() || this.cover == Blocks.field_150350_a) {
            return;
        }
        boolean climb = false;
        for (Predicate<Block> f : climbablePipeCovers) {
            if (f == null || !f.test(this.cover)) continue;
            climb = true;
            break;
        }
        if (climb) {
            IEBaseBlock.IELadderBlock.applyLadderLogic(entity);
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        int[] config = nbt.func_74759_k("sideConfig");
        for (int i = 0; i < 6; ++i) {
            if (i < config.length) {
                this.sideConfig.put((Object)Direction.func_82600_a((int)i), config[i] != 0);
                continue;
            }
            this.sideConfig.put((Object)Direction.func_82600_a((int)i), false);
        }
        this.cover = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("cover")));
        DyeColor oldColor = this.color;
        this.color = nbt.func_150297_b("color", 3) ? DyeColor.func_196056_a((int)nbt.func_74762_e("color")) : null;
        byte oldConns = this.connections;
        this.connections = nbt.func_74771_c("connections");
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && (this.connections != oldConns || this.color != oldColor)) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        int[] config = new int[6];
        for (int i = 0; i < 6; ++i) {
            if (!this.sideConfig.getBoolean((Object)Direction.func_82600_a((int)i))) continue;
            config[i] = 1;
        }
        nbt.func_74783_a("sideConfig", config);
        if (this.hasCover()) {
            nbt.func_74778_a("cover", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.cover).toString());
        }
        nbt.func_74774_a("connections", this.connections);
        if (this.color != null) {
            nbt.func_74768_a("color", this.color.func_196059_a());
        }
    }

    boolean canOutputPressurized(TileEntity output, boolean consumePower) {
        if (output instanceof IFluidPipe) {
            return ((IFluidPipe)output).canOutputPressurized(consumePower);
        }
        return false;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && this.sideConfig.getBoolean((Object)facing)) {
            return this.sidedHandlers.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    protected boolean hasCover() {
        return this.cover != Blocks.field_150350_a;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> modifyQuads(BlockState object, List<BakedQuad> quads) {
        if (this.hasCover()) {
            BlockState state = this.cover.func_176223_P();
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
            RenderType curL = MinecraftForgeClient.getRenderLayer();
            if (model != null) {
                for (RenderType layer : new RenderType[]{RenderType.func_228639_c_(), RenderType.func_228645_f_(), RenderType.func_228643_e_(), RenderType.func_228641_d_()}) {
                    ForgeHooksClient.setRenderLayer((RenderType)layer);
                    for (Direction direction : Direction.values()) {
                        quads.addAll(model.getQuads(state, direction, this.field_145850_b.field_73012_v, (IModelData)EmptyModelData.INSTANCE));
                    }
                    quads.addAll(model.getQuads(state, null, this.field_145850_b.field_73012_v, (IModelData)EmptyModelData.INSTANCE));
                }
            }
            ForgeHooksClient.setRenderLayer((RenderType)curL);
        }
        return quads;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getCacheKey(BlockState object) {
        return this.getRenderCacheKey();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TransformationMatrix applyTransformations(BlockState object, String group, TransformationMatrix transform) {
        return transform;
    }

    @Override
    public Collection<ItemStack> getExtraDrops(PlayerEntity player, BlockState state) {
        if (this.hasCover()) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)this.cover)});
        }
        return null;
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        super.onNeighborBlockChange(otherPos);
        Direction dir = Direction.func_176737_a((float)(otherPos.func_177958_n() - this.field_174879_c.func_177958_n()), (float)(otherPos.func_177956_o() - this.field_174879_c.func_177956_o()), (float)(otherPos.func_177952_p() - this.field_174879_c.func_177952_p()));
        if (this.updateConnectionByte(dir)) {
            this.field_145850_b.func_175695_a(this.field_174879_c, this.func_195044_w().func_177230_c(), dir);
            this.markContainingBlockForUpdate(null);
        }
        if (!this.getWorldNonnull().field_72995_K) {
            indirectConnections.clear();
        }
    }

    public boolean updateConnectionByte(Direction dir) {
        IFluidHandler handler;
        byte oldConn = this.connections;
        int i = dir.func_176745_a();
        int mask = 1 << i;
        this.connections = (byte)(this.connections & ~mask);
        if (this.sideConfig.getBoolean((Object)dir) && this.neighbors.get(dir).isPresent() && (handler = this.neighbors.get(dir).get()).getTanks() > 0) {
            this.connections = (byte)(this.connections | mask);
        }
        return oldConn != this.connections;
    }

    public byte getAvailableConnectionByte() {
        byte connections = 0;
        int mask = 1;
        for (Direction dir : Direction.field_199792_n) {
            IFluidHandler handler;
            if (this.neighbors.get(dir).isPresent() && (handler = this.neighbors.get(dir).get()).getTanks() > 0) {
                connections = (byte)(connections | mask);
            }
            mask <<= 1;
        }
        return connections;
    }

    public int getConnectionStyle(Direction connection) {
        byte tileConnections;
        if (!this.sideConfig.getBoolean((Object)connection)) {
            return 0;
        }
        if ((this.connections & 1 << connection.ordinal()) == 0) {
            return 0;
        }
        if (this.connections != 3 && this.connections != 12 && this.connections != 48) {
            return 1;
        }
        TileEntity con = Utils.getExistingTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(connection));
        if (con instanceof FluidPipeTileEntity && this.connections == (tileConnections = ((FluidPipeTileEntity)con).connections)) {
            return 0;
        }
        return 1;
    }

    public void toggleSide(Direction side) {
        this.sideConfig.put((Object)side, !this.sideConfig.getBoolean((Object)side));
        this.func_70296_d();
        TileEntity connected = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
        if (connected instanceof FluidPipeTileEntity) {
            ((FluidPipeTileEntity)connected).sideConfig.put((Object)side.func_176734_d(), this.sideConfig.getBoolean((Object)side));
            connected.func_70296_d();
            this.field_145850_b.func_175641_c(this.func_174877_v().func_177972_a(side), this.func_195044_w().func_177230_c(), 0, 0);
        }
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 0, 0);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape getCollisionShape(ISelectionContext ctx) {
        return SHAPES.get(new BoundingBoxKey(true, this));
    }

    @Override
    public VoxelShape getSelectionShape(@Nullable ISelectionContext ctx) {
        return SHAPES.get(new BoundingBoxKey(false, this));
    }

    private static List<AxisAlignedBB> getBoxes(BoundingBoxKey key) {
        double[] dArray;
        ArrayList list = Lists.newArrayList();
        if (key.collisions && key.hasCover) {
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186662_g(-0.03125));
            return list;
        }
        byte availableConnections = key.availableConnections;
        byte activeConnections = key.connections;
        if (key.hasCover) {
            double[] dArray2 = new double[6];
            dArray2[0] = 0.002;
            dArray2[1] = 0.998;
            dArray2[2] = 0.002;
            dArray2[3] = 0.998;
            dArray2[4] = 0.002;
            dArray = dArray2;
            dArray2[5] = 0.998;
        } else {
            double[] dArray3 = new double[6];
            dArray3[0] = 0.25;
            dArray3[1] = 0.75;
            dArray3[2] = 0.25;
            dArray3[3] = 0.75;
            dArray3[4] = 0.25;
            dArray = dArray3;
            dArray3[5] = 0.75;
        }
        double[] baseAABB = dArray;
        for (Direction d : Direction.field_199792_n) {
            int i = d.ordinal();
            if ((availableConnections & 1) == 1) {
                if ((activeConnections & 1) == 1) {
                    list.add(new AxisAlignedBB(i == 4 ? 0.0 : (i == 5 ? 0.75 : 0.25), i == 0 ? 0.0 : (i == 1 ? 0.75 : 0.25), i == 2 ? 0.0 : (i == 3 ? 0.75 : 0.25), i == 4 ? 0.25 : (i == 5 ? 1.0 : 0.75), i == 0 ? 0.25 : (i == 1 ? 1.0 : 0.75), i == 2 ? 0.25 : (i == 3 ? 1.0 : 0.75)));
                }
                if ((activeConnections & 1) == 0 && !key.collisions || (Integer)key.connectionStyles.get(d) == 1) {
                    list.add(new AxisAlignedBB(i == 4 ? 0.0 : (i == 5 ? 0.875 : 0.125), i == 0 ? 0.0 : (i == 1 ? 0.875 : 0.125), i == 2 ? 0.0 : (i == 3 ? 0.875 : 0.125), i == 4 ? 0.125 : (i == 5 ? 1.0 : 0.875), i == 0 ? 0.125 : (i == 1 ? 1.0 : 0.875), i == 2 ? 0.125 : (i == 3 ? 1.0 : 0.875)));
                }
            }
            availableConnections = (byte)(availableConnections >> 1);
            activeConnections = (byte)(activeConnections >> 1);
        }
        list.add(new AxisAlignedBB(baseAABB[4], baseAABB[0], baseAABB[2], baseAABB[5], baseAABB[1], baseAABB[3]));
        return list;
    }

    String getRenderCacheKey() {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            if ((this.connections & 1 << i) != 0) {
                key.append(this.getConnectionStyle(Direction.func_82600_a((int)i)) == 1 ? "2" : "1");
                continue;
            }
            key.append("0");
        }
        if (this.hasCover()) {
            key.append("scaf:").append(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.cover).toString());
        }
        key.append(this.color);
        return key.toString();
    }

    private static short getConnectionsFromKey(String key) {
        short ret = 0;
        block5: for (int i = 0; i < 6; ++i) {
            char c = key.charAt(i);
            switch (c) {
                case '0': {
                    continue block5;
                }
                case '2': {
                    ret = (short)(ret | (1 << i | 1 << i + 8));
                    continue block5;
                }
                case '1': {
                    ret = (short)(ret | 1 << i);
                }
            }
        }
        return ret;
    }

    private static int getConnectionStyle(int dir, short conns) {
        return 1 & conns >> dir + 8;
    }

    @Override
    public IEProperties.IEObjState getIEObjState(BlockState state) {
        String key = this.getRenderCacheKey();
        return FluidPipeTileEntity.getStateFromKey(key);
    }

    public static IEProperties.IEObjState getStateFromKey(String key) {
        if (!cachedOBJStates.containsKey(key)) {
            ArrayList<String> parts = new ArrayList<String>();
            Matrix4 rotationMatrix = new Matrix4();
            rotationMatrix.translate(0.5, 0.5, 0.5);
            short connections = FluidPipeTileEntity.getConnectionsFromKey(key);
            if (key.contains("scaf:")) {
                parts.add("cover");
            }
            int totalConnections = Integer.bitCount(connections & 0xFF);
            boolean straightY = (connections & 3) == 3;
            boolean straightZ = (connections & 0xC) == 12;
            boolean straightX = (connections & 0x30) == 48;
            switch (totalConnections) {
                case 0: {
                    parts.add("center");
                    break;
                }
                case 1: {
                    parts.add("stopper");
                    if ((connections & 2) != 0) {
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                    } else if ((connections & 4) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                    } else if ((connections & 8) != 0) {
                        rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                    } else if ((connections & 0x10) != 0) {
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                    } else if ((connections & 0x20) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    }
                    parts.add("con_yMin");
                    break;
                }
                case 2: {
                    if (straightY) {
                        parts.add("pipe_y");
                        if (FluidPipeTileEntity.getConnectionStyle(0, connections) == 1) {
                            parts.add("con_yMin");
                        }
                        if (FluidPipeTileEntity.getConnectionStyle(1, connections) != 1) break;
                        parts.add("con_yMax");
                        break;
                    }
                    if (straightZ) {
                        parts.add("pipe_z");
                        if (FluidPipeTileEntity.getConnectionStyle(2, connections) == 1) {
                            parts.add("con_zMin");
                        }
                        if (FluidPipeTileEntity.getConnectionStyle(3, connections) != 1) break;
                        parts.add("con_zMax");
                        break;
                    }
                    if (straightX) {
                        parts.add("pipe_x");
                        if (FluidPipeTileEntity.getConnectionStyle(4, connections) == 1) {
                            parts.add("con_xMin");
                        }
                        if (FluidPipeTileEntity.getConnectionStyle(5, connections) != 1) break;
                        parts.add("con_xMax");
                        break;
                    }
                    parts.add("curve");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    byte connectTo = (byte)(connections & 0x3C);
                    if ((connections & 3) != 0) {
                        if (connectTo == 16) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                        } else if (connectTo == 32) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                        } else if (connectTo == 8) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                    if (connectTo == 40) {
                        rotationMatrix.rotate(Math.PI, 1.0, 0.0, 0.0);
                        break;
                    }
                    if (connectTo == 24) {
                        rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                        break;
                    }
                    if (connectTo != 36) break;
                    rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    if (straightX || straightZ || straightY) {
                        parts.add("tcross");
                        parts.add("con_yMin");
                        parts.add("con_zMin");
                        parts.add("con_zMax");
                        if (straightX) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                            if ((connections & 4) != 0) {
                                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 8) != 0) {
                                rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 2) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (straightY) {
                            rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                            if ((connections & 0x10) != 0) {
                                rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 0x20) != 0) {
                                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 8) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x20) != 0) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    parts.add("tcurve");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    parts.add("con_xMax");
                    if ((connections & 8) != 0) {
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        } else {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                        }
                    } else if ((connections & 0x10) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    }
                    if ((connections & 2) == 0) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                case 4: {
                    boolean cross;
                    boolean bl = cross = straightX && straightZ || straightX && straightY || straightZ && straightY;
                    if (cross) {
                        parts.add("cross");
                        parts.add("con_yMin");
                        parts.add("con_yMax");
                        parts.add("con_zMin");
                        parts.add("con_zMax");
                        if (!straightY) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (!straightX) break;
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                        break;
                    }
                    parts.add("tcross2");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMax");
                    if (straightZ) {
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (straightY) {
                        rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                        if ((connections & 8) != 0) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            if ((connections & 0x10) == 0) break;
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x10) == 0) break;
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    if ((connections & 8) != 0) {
                        rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    }
                    if ((connections & 2) == 0) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                case 5: {
                    parts.add("tcross3");
                    parts.add("con_yMin");
                    parts.add("con_yMax");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMax");
                    if (straightZ) {
                        if (straightY) {
                            if ((connections & 0x10) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                            break;
                        }
                        if (!straightX) break;
                        rotationMatrix.rotate((connections & 2) != 0 ? 1.5707963267948966 : -1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (!straightX) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    if ((connections & 8) == 0) break;
                    rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    break;
                }
                case 6: {
                    parts.add("con_yMin");
                    parts.add("con_yMax");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMin");
                    parts.add("con_xMax");
                }
            }
            rotationMatrix.translate(-0.5, -0.5, -0.5);
            cachedOBJStates.put(key, new IEProperties.IEObjState(IEProperties.VisibilityList.show(parts), new TransformationMatrix(rotationMatrix.toMatrix4f())));
        }
        return cachedOBJStates.get(key);
    }

    @Override
    public int getRenderColour(int tintIndex) {
        return 0xFFFFFF;
    }

    public void dropCover(PlayerEntity player) {
        ItemEntity entityitem;
        if (!this.field_145850_b.field_72995_K && this.hasCover() && this.field_145850_b.func_82736_K().func_223586_b(GameRules.field_223603_f) && (entityitem = player.func_71019_a(new ItemStack((IItemProvider)this.cover), false)) != null) {
            entityitem.func_174868_q();
        }
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (heldItem.func_190926_b() && player.func_225608_bj_() && this.hasCover()) {
            this.dropCover(player);
            this.cover = Blocks.field_150350_a;
            this.markContainingBlockForUpdate(null);
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 255, 0);
            return true;
        }
        if (!heldItem.func_190926_b() && !player.func_225608_bj_()) {
            DyeColor heldDye;
            Block heldBlock = Block.func_149634_a((Item)heldItem.func_77973_b());
            if (heldBlock != Blocks.field_150350_a) {
                for (Predicate<Block> func : validPipeCovers) {
                    if (!func.test(heldBlock) || this.cover == heldBlock) continue;
                    this.dropCover(player);
                    this.cover = heldBlock;
                    heldItem.func_190918_g(1);
                    this.markContainingBlockForUpdate(null);
                    this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 255, 0);
                    return true;
                }
            }
            if ((heldDye = Utils.getDye(heldItem)) != null) {
                this.color = heldDye;
                this.markContainingBlockForUpdate(null);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hammerUseSide(Direction side, PlayerEntity player, Vec3d hitVec) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        hitVec = hitVec.func_178788_d(new Vec3d((Vec3i)this.field_174879_c));
        Direction fd = side;
        List<AxisAlignedBB> boxes = FluidPipeTileEntity.getBoxes(new BoundingBoxKey(true, this));
        block0: for (AxisAlignedBB box : boxes) {
            if (!box.func_186662_g(0.002).func_72318_a(hitVec)) continue;
            for (Direction d : Direction.field_199792_n) {
                Vec3d testVec = new Vec3d(0.5 + 0.5 * (double)d.func_82601_c(), 0.5 + 0.5 * (double)d.func_96559_d(), 0.5 + 0.5 * (double)d.func_82599_e());
                if (!box.func_186662_g(0.002).func_72318_a(testVec)) continue;
                fd = d;
                break block0;
            }
        }
        if (fd != null) {
            this.toggleSide(fd);
            this.markContainingBlockForUpdate(null);
            indirectConnections.clear();
            return true;
        }
        return false;
    }

    @Override
    public void onTilePlaced(World world, BlockPos pos, BlockState state, Direction side, float hitX, float hitY, float hitZ, LivingEntity placer, ItemStack stack) {
        for (Direction dir : Direction.values()) {
            TileEntity te = world.func_175625_s(pos.func_177972_a(dir));
            if (!(te instanceof FluidPipeTileEntity) || ((FluidPipeTileEntity)te).color == this.color) continue;
            this.toggleSide(dir);
        }
    }

    @Override
    public boolean canOutputPressurized(boolean consumePower) {
        return false;
    }

    @Override
    public boolean hasOutputConnection(Direction side) {
        return side != null && this.sideConfig.getBoolean((Object)side);
    }

    @Override
    public Vector4f getRenderColor(BlockState object, String group, Vector4f original) {
        if (this.color != null) {
            float[] rgb = this.color.func_193349_f();
            return new Vector4f(rgb[0], rgb[1], rgb[2], 1.0f);
        }
        return original;
    }

    static {
        indirectConnections = new ConcurrentHashMap();
        validPipeCovers = new ArrayList();
        climbablePipeCovers = new ArrayList();
        SHAPES = new CachedVoxelShapes<BoundingBoxKey>(FluidPipeTileEntity::getBoxes);
        cachedOBJStates = new HashMap();
    }

    private static class BoundingBoxKey {
        private final boolean collisions;
        private final byte connections;
        private final byte availableConnections;
        private final boolean hasCover;
        private final Map<Direction, Integer> connectionStyles = new EnumMap<Direction, Integer>(Direction.class);

        private BoundingBoxKey(boolean collisions, FluidPipeTileEntity te) {
            this.collisions = collisions;
            this.connections = te.connections;
            this.availableConnections = te.getAvailableConnectionByte();
            this.hasCover = te.hasCover();
            for (Direction d : Direction.field_199792_n) {
                this.connectionStyles.put(d, te.getConnectionStyle(d));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundingBoxKey that = (BoundingBoxKey)o;
            return this.collisions == that.collisions && this.connections == that.connections && this.availableConnections == that.availableConnections && this.hasCover == that.hasCover && this.connectionStyles.equals(that.connectionStyles);
        }

        public int hashCode() {
            return Objects.hash(this.collisions, this.connections, this.availableConnections, this.hasCover, this.connectionStyles);
        }
    }

    public static class DirectionalFluidOutput {
        IFluidHandler output;
        Direction direction;
        TileEntity containingTile;

        public DirectionalFluidOutput(IFluidHandler output, TileEntity containingTile, Direction direction) {
            this.output = output;
            this.direction = direction;
            this.containingTile = containingTile;
        }
    }

    static class PipeFluidHandler
    implements IFluidHandler {
        FluidPipeTileEntity pipe;
        Direction facing;

        public PipeFluidHandler(FluidPipeTileEntity pipe, Direction facing) {
            this.pipe = pipe;
            this.facing = facing;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            if (resource == null) {
                return 0;
            }
            int canAccept = resource.getAmount();
            if (canAccept <= 0) {
                return 0;
            }
            ArrayList<DirectionalFluidOutput> outputList = new ArrayList<DirectionalFluidOutput>(FluidPipeTileEntity.getConnectedFluidHandlers(this.pipe.func_174877_v(), this.pipe.field_145850_b));
            if (outputList.size() < 1) {
                return 0;
            }
            BlockPos ccFrom = new BlockPos((Vec3i)this.pipe.func_174877_v().func_177972_a(this.facing));
            int sum = 0;
            HashMap<DirectionalFluidOutput, Integer> sorting = new HashMap<DirectionalFluidOutput, Integer>();
            for (DirectionalFluidOutput output : outputList) {
                int limit;
                int tileSpecificAcceptedFluid;
                int temp;
                BlockPos cc = output.containingTile.func_174877_v();
                if (cc.equals((Object)ccFrom) || !this.pipe.field_145850_b.func_175667_e(cc) || this.pipe.equals(output.containingTile) || (temp = output.output.fill(Utils.copyFluidStackWithAmount(resource, tileSpecificAcceptedFluid = Math.min(limit = this.getTranferrableAmount(resource, output), canAccept), true), IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
                sorting.put(output, temp);
                sum += temp;
            }
            if (sum > 0) {
                int f = 0;
                for (DirectionalFluidOutput output : sorting.keySet()) {
                    int r;
                    int amount = (Integer)sorting.get(output);
                    if (sum > resource.getAmount()) {
                        int limit = this.getTranferrableAmount(resource, output);
                        int tileSpecificAcceptedFluid = Math.min(limit, canAccept);
                        float prio = (float)amount / (float)sum;
                        amount = (int)Math.ceil(MathHelper.func_76131_a((float)amount, (float)1.0f, (float)Math.min((float)resource.getAmount() * prio, (float)tileSpecificAcceptedFluid)));
                        amount = Math.min(amount, canAccept);
                    }
                    if ((r = output.output.fill(Utils.copyFluidStackWithAmount(resource, amount, true), doFill)) > 50) {
                        this.pipe.canOutputPressurized(output.containingTile, true);
                    }
                    f += r;
                    if ((canAccept -= r) > 0) continue;
                    break;
                }
                return f;
            }
            return 0;
        }

        private int getTranferrableAmount(FluidStack resource, DirectionalFluidOutput output) {
            return resource.hasTag() && resource.getOrCreateTag().func_74764_b("pressurized") || this.pipe.canOutputPressurized(output.containingTile, false) ? 1000 : 50;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return this.drain(resource.getAmount(), doDrain);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            if (maxDrain <= 0) {
                return FluidStack.EMPTY;
            }
            ArrayList<DirectionalFluidOutput> outputList = new ArrayList<DirectionalFluidOutput>(FluidPipeTileEntity.getConnectedFluidHandlers(this.pipe.func_174877_v(), this.pipe.field_145850_b));
            if (outputList.size() < 1) {
                return FluidStack.EMPTY;
            }
            BlockPos ccFrom = new BlockPos((Vec3i)this.pipe.func_174877_v().func_177972_a(this.facing));
            outputList.removeIf(output -> ccFrom.equals((Object)output.containingTile.func_174877_v()));
            int chosen = outputList.size() == 1 ? 0 : Utils.RAND.nextInt(outputList.size());
            DirectionalFluidOutput output2 = outputList.get(chosen);
            FluidStack available = output2.output.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
            int limit = this.getTranferrableAmount(available, output2);
            int actualTake = Math.min(limit, maxDrain);
            return output2.output.drain(actualTake, doDrain);
        }
    }
}

