/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.FeedthroughTileEntity;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FeedthroughMultiblock
implements MultiblockHandler.IMultiblock {
    private static final ITextComponent ARBITRARY_SOLID = new TranslationTextComponent("block.immersiveengineering.arb_solid", new Object[0]);
    public static FeedthroughMultiblock instance = new FeedthroughMultiblock();
    static List<Template.BlockInfo> structure = new ArrayList<Template.BlockInfo>();
    private ItemStack renderStack;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRenderFormedStructure() {
        return true;
    }

    private Block getDemoConnector() {
        return IEBlocks.Connectors.getEnergyConnector("LV", false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderFormedStructure(MatrixStack transform, IRenderTypeBuffer buffer) {
        if (this.renderStack == null || this.renderStack.func_190926_b()) {
            this.renderStack = new ItemStack((IItemProvider)IEBlocks.Connectors.feedthrough);
        }
        transform.func_227861_a_(1.5, 0.5, 0.5);
        transform.func_227863_a_(new Quaternion(0.0f, 45.0f, 0.0f, true));
        transform.func_227863_a_(new Quaternion(-30.0f, 0.0f, 0.0f, true));
        transform.func_227862_a_(1.75f, 1.75f, 1.75f);
        ClientUtils.mc().func_175599_af().func_229110_a_(this.renderStack, ItemCameraTransforms.TransformType.GUI, 0xF000F0, OverlayTexture.field_229196_a_, transform, buffer);
    }

    @Override
    public Vec3i getSize() {
        return new Vec3i(3, 1, 1);
    }

    @Override
    public void disassemble(World world, BlockPos startPos, boolean mirrored, Direction clickDirectionAtCreation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockPos getTriggerOffset() {
        return new BlockPos(-1, 0, 0);
    }

    @Override
    public float getManualScale() {
        return 12.0f;
    }

    @Override
    public ResourceLocation getUniqueName() {
        return new ResourceLocation("immersiveengineering", "feedthrough");
    }

    @Override
    public boolean isBlockTrigger(BlockState state) {
        return WireApi.getWireType(state) != null;
    }

    @Nullable
    WireType checkValidConnector(World w, BlockPos pos, GlobalWireNetwork globalNet, Direction expectedDirection) {
        LocalWireNetwork localNet = globalNet.getNullableLocalNet(pos);
        if (localNet == null) {
            return null;
        }
        ImmutableSet connsHere = localNet.getConnections(pos);
        IImmersiveConnectable connHere = localNet.getConnector(pos);
        if (connsHere == null) {
            connsHere = ImmutableSet.of();
        }
        if (connsHere.size() > 1 || connHere.getConnectionPoints().size() != 1) {
            return null;
        }
        BlockState state = w.func_180495_p(pos);
        if (!state.func_196959_b((IProperty)IEProperties.FACING_ALL) || state.func_177229_b((IProperty)IEProperties.FACING_ALL) != expectedDirection) {
            return null;
        }
        return WireApi.getWireType(state);
    }

    @Override
    public boolean createStructure(World world, BlockPos pos, Direction side, PlayerEntity player) {
        ConnectionPoint cpOther;
        WireType wire;
        GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(world);
        BlockState stateHere = world.func_180495_p(pos);
        if (stateHere.func_206869_a().contains(IEProperties.FACING_ALL)) {
            side = (Direction)stateHere.func_177229_b((IProperty)IEProperties.FACING_ALL);
        }
        if ((wire = this.checkValidConnector(world, pos, globalNet, side)) == null) {
            return false;
        }
        BlockPos middlePos = pos.func_177972_a(side);
        BlockState middle = world.func_180495_p(middlePos);
        if (!middle.func_196954_c((IBlockReader)world, pos).equals(VoxelShapes.func_197868_b()) || middle.func_177230_c().hasTileEntity(middle) || middle.func_185901_i() != BlockRenderType.MODEL) {
            return false;
        }
        BlockPos otherPos = pos.func_177967_a(side, 2);
        WireType otherWire = this.checkValidConnector(world, otherPos, globalNet, side.func_176734_d());
        if (otherWire != wire) {
            return false;
        }
        LocalWireNetwork localHere = globalNet.getLocalNet(pos);
        ConnectionPoint cpHere = localHere.getConnector(pos).getConnectionPoints().iterator().next();
        Collection<Connection> connsHere = localHere.getConnections(cpHere);
        LocalWireNetwork localOther = globalNet.getLocalNet(otherPos);
        Collection<Connection> connsOther = localOther.getConnections(cpOther = localOther.getConnector(otherPos).getConnectionPoints().iterator().next());
        if (connsOther.stream().anyMatch(c -> c.isEnd(cpHere))) {
            return false;
        }
        for (Connection c3 : connsOther) {
            ConnectionPoint otherEnd = c3.getOtherEnd(cpOther);
            if (!connsHere.stream().anyMatch(c2 -> c2.isEnd(otherEnd))) continue;
            return false;
        }
        if (!world.field_72995_K) {
            BlockState state = (BlockState)IEBlocks.Connectors.feedthrough.func_176223_P().func_206870_a((IProperty)IEProperties.FACING_ALL, (Comparable)side);
            BlockPos masterPos = pos.func_177972_a(side);
            FeedthroughTileEntity master = this.setBlock(world, masterPos, state, wire, middle, 0);
            if (master != null) {
                this.moveConnectionsToMaster(connsOther, cpOther, world, master.getPositivePoint());
                this.moveConnectionsToMaster(connsHere, cpHere, world, master.getNegativePoint());
            }
            this.setBlock(world, pos, state, wire, middle, -1);
            this.setBlock(world, pos.func_177967_a(side, 2), state, wire, middle, 1);
        }
        return true;
    }

    @Override
    public List<Template.BlockInfo> getStructure() {
        if (structure.isEmpty()) {
            structure.add(new Template.BlockInfo(BlockPos.field_177992_a, (BlockState)this.getDemoConnector().func_176223_P().func_206870_a((IProperty)IEProperties.FACING_ALL, (Comparable)Direction.EAST), null));
            structure.add(new Template.BlockInfo(new BlockPos(1, 0, 0), Blocks.field_150342_X.func_176223_P(), null));
            structure.add(new Template.BlockInfo(new BlockPos(2, 0, 0), (BlockState)this.getDemoConnector().func_176223_P().func_206870_a((IProperty)IEProperties.FACING_ALL, (Comparable)Direction.WEST), null));
        }
        return structure;
    }

    private void moveConnectionsToMaster(Collection<Connection> conns, ConnectionPoint oldCommon, World world, ConnectionPoint newCommon) {
        for (Connection c : ImmutableSet.copyOf(conns)) {
            WireUtils.moveConnectionEnd(c, oldCommon, newCommon, world);
        }
    }

    @Nullable
    private FeedthroughTileEntity setBlock(World world, BlockPos here, BlockState newState, WireType wire, BlockState middle, int offset) {
        world.func_175656_a(here, newState);
        TileEntity te = world.func_175625_s(here);
        if (te instanceof FeedthroughTileEntity) {
            FeedthroughTileEntity feedthrough = (FeedthroughTileEntity)te;
            feedthrough.reference = wire;
            feedthrough.stateForMiddle = middle;
            feedthrough.offset = offset;
            world.func_175641_c(here, feedthrough.func_195044_w().func_177230_c(), 253, 0);
            return feedthrough;
        }
        return null;
    }

    @Override
    public ItemStack[] getTotalMaterials() {
        return new ItemStack[]{new ItemStack((IItemProvider)this.getDemoConnector(), 2), new ItemStack((IItemProvider)Blocks.field_150342_X, 1).func_200302_a(ARBITRARY_SOLID)};
    }

    @Override
    public boolean overwriteBlockRender(BlockState state, int iterator) {
        return false;
    }
}

