/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.CapabilityReference;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SorterTileEntity
extends IEBaseTileEntity
implements IEBlockInterfaces.IInteractionObjectIE {
    public static TileEntityType<SorterTileEntity> TYPE;
    public SorterInventory filter;
    public int[] sideFilter = new int[]{0, 0, 0, 0, 0, 0};
    public static final int filterSlotsPerSide = 8;
    private static Set<BlockPos> routed;
    private EnumMap<Direction, CapabilityReference<IItemHandler>> neighborCaps = new EnumMap(Direction.class);
    private EnumMap<Direction, LazyOptional<IItemHandler>> insertionHandlers = new EnumMap(Direction.class);

    public SorterTileEntity() {
        super(TYPE);
        for (Direction f : Direction.field_199792_n) {
            LazyOptional<SorterInventoryHandler> forSide = this.registerConstantCap(new SorterInventoryHandler(this, f));
            this.insertionHandlers.put(f, forSide);
        }
        this.filter = new SorterInventory(this);
        for (Direction f : Direction.field_199792_n) {
            this.neighborCaps.put(f, CapabilityReference.forNeighbor((TileEntity)this, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f));
        }
    }

    public ItemStack routeItem(Direction inputSide, ItemStack stack, boolean simulate) {
        if (!this.field_145850_b.field_72995_K && this.canRoute()) {
            boolean first = this.startRouting();
            Direction[][] validOutputs = this.getValidOutputs(inputSide, stack);
            stack = this.doInsert(stack, validOutputs[0], simulate);
            stack = this.doInsert(stack, validOutputs[1], simulate);
            if (first) {
                routed = null;
            }
        }
        return stack;
    }

    private boolean canRoute() {
        return routed == null || !routed.contains(this.field_174879_c);
    }

    private boolean startRouting() {
        boolean first;
        boolean bl = first = routed == null;
        if (first) {
            routed = new HashSet<BlockPos>();
        }
        routed.add(this.field_174879_c);
        return first;
    }

    private ItemStack doInsert(ItemStack stack, Direction[] sides, boolean simulate) {
        for (int lengthFiltered = sides.length; lengthFiltered > 0 && !stack.func_190926_b(); --lengthFiltered) {
            int rand = Utils.RAND.nextInt(lengthFiltered);
            stack = this.outputItemToInv(stack, sides[rand], simulate);
            sides[rand] = sides[lengthFiltered - 1];
        }
        return stack;
    }

    public boolean doOredict(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 1) != 0;
        }
        return false;
    }

    public boolean doNBT(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 2) != 0;
        }
        return false;
    }

    public boolean doFuzzy(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 4) != 0;
        }
        return false;
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return true;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return this;
    }

    @Override
    public void receiveMessageFromClient(CompoundNBT message) {
        if (message.func_150297_b("sideConfig", 11)) {
            this.sideFilter = message.func_74759_k("sideConfig");
        }
    }

    public Direction[][] getValidOutputs(Direction inputSide, ItemStack stack) {
        if (stack.func_190926_b()) {
            return new Direction[][]{new Direction[0], new Direction[0], new Direction[0], new Direction[0]};
        }
        ArrayList<Direction> validFiltered = new ArrayList<Direction>(6);
        ArrayList<Direction> validUnfiltered = new ArrayList<Direction>(6);
        for (Direction side : Direction.values()) {
            if (side == inputSide) continue;
            EnumFilterResult result = this.checkStackAgainstFilter(stack, side);
            if (result == EnumFilterResult.VALID_FILTERED) {
                validFiltered.add(side);
                continue;
            }
            if (result != EnumFilterResult.VALID_UNFILTERED) continue;
            validUnfiltered.add(side);
        }
        return new Direction[][]{validFiltered.toArray(new Direction[0]), validUnfiltered.toArray(new Direction[0])};
    }

    public ItemStack pullItem(Direction outputSide, int amount, boolean simulate) {
        if (!this.field_145850_b.field_72995_K && this.canRoute()) {
            boolean first = this.startRouting();
            for (Direction side : Direction.values()) {
                CapabilityReference<IItemHandler> capRef;
                IItemHandler itemHandler;
                if (side == outputSide || (itemHandler = (capRef = this.neighborCaps.get(side)).getNullable()) == null) continue;
                Predicate<ItemStack> concatFilter = null;
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack extractItem = itemHandler.extractItem(i, amount, true);
                    if (extractItem.func_190926_b()) continue;
                    if (concatFilter == null) {
                        concatFilter = this.concatFilters(outputSide, side);
                    }
                    if (!concatFilter.test(extractItem)) continue;
                    if (first) {
                        routed = null;
                    }
                    if (!simulate) {
                        itemHandler.extractItem(i, amount, false);
                    }
                    return extractItem;
                }
            }
            if (first) {
                routed = null;
            }
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareStackToFilterstack(ItemStack stack, ItemStack filterStack, boolean fuzzy, boolean oredict, boolean nbt) {
        boolean b = ItemStack.func_179545_c((ItemStack)filterStack, (ItemStack)stack);
        if (!b && fuzzy) {
            b = ItemStack.func_185132_d((ItemStack)filterStack, (ItemStack)stack);
        }
        if (!b && oredict) {
            for (ResourceLocation name : ItemTags.func_199903_a().func_199913_a((Object)stack.func_77973_b())) {
                if (!Utils.isInTag(filterStack, name)) continue;
                b = true;
                break;
            }
        }
        if (nbt) {
            b &= Utils.compareItemNBT(filterStack, stack);
        }
        return b;
    }

    private EnumFilterResult checkStackAgainstFilter(ItemStack stack, Direction side) {
        boolean unmapped = true;
        for (ItemStack filterStack : this.filter.filters[side.ordinal()]) {
            if (filterStack.func_190926_b()) continue;
            unmapped = false;
            if (!this.compareStackToFilterstack(stack, filterStack, this.doFuzzy(side.ordinal()), this.doOredict(side.ordinal()), this.doNBT(side.ordinal()))) continue;
            return EnumFilterResult.VALID_FILTERED;
        }
        if (unmapped) {
            return EnumFilterResult.VALID_UNFILTERED;
        }
        return EnumFilterResult.INVALID;
    }

    private Predicate<ItemStack> concatFilters(final Direction side0, Direction side1) {
        final ArrayList<ItemStack> concat = new ArrayList<ItemStack>();
        for (ItemStack filterStack : this.filter.filters[side0.ordinal()]) {
            if (filterStack.func_190926_b()) continue;
            concat.add(filterStack);
        }
        Predicate<ItemStack> matchFilter = concat.isEmpty() ? stack -> true : new Predicate<ItemStack>(){
            final Set<ItemStack> filter;
            {
                this.filter = new HashSet<ItemStack>(concat);
            }

            @Override
            public boolean test(ItemStack stack) {
                for (ItemStack filterStack : this.filter) {
                    if (!SorterTileEntity.this.compareStackToFilterstack(stack, filterStack, SorterTileEntity.this.doFuzzy(side0.ordinal()), SorterTileEntity.this.doOredict(side0.ordinal()), SorterTileEntity.this.doNBT(side0.ordinal()))) continue;
                    return true;
                }
                return false;
            }
        };
        for (ItemStack filterStack : this.filter.filters[side1.ordinal()]) {
            if (filterStack.func_190926_b() || !matchFilter.test(filterStack)) continue;
            concat.add(filterStack);
        }
        boolean concatFuzzy = this.doFuzzy(side0.ordinal()) | this.doFuzzy(side1.ordinal());
        boolean concatOredict = this.doOredict(side0.ordinal()) | this.doOredict(side1.ordinal());
        boolean concatNBT = this.doNBT(side0.ordinal()) | this.doNBT(side1.ordinal());
        return concat.isEmpty() ? stack -> true : stack -> {
            for (ItemStack filterStack : concat) {
                if (!this.compareStackToFilterstack((ItemStack)stack, filterStack, concatFuzzy, concatOredict, concatNBT)) continue;
                return true;
            }
            return false;
        };
    }

    public ItemStack outputItemToInv(ItemStack stack, Direction side, boolean simulate) {
        return Utils.insertStackIntoInventory(this.neighborCaps.get(side), stack, simulate);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.sideFilter = nbt.func_74759_k("sideFilter");
        if (!descPacket) {
            ListNBT filterList = nbt.func_150295_c("filter", 10);
            this.filter = new SorterInventory(this);
            this.filter.readFromNBT(filterList);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74783_a("sideFilter", this.sideFilter);
        if (!descPacket) {
            ListNBT filterList = new ListNBT();
            this.filter.writeToNBT(filterList);
            nbt.func_218657_a("filter", (INBT)filterList);
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
            return this.insertionHandlers.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        return id == 0;
    }

    static {
        routed = null;
    }

    private static enum EnumFilterResult {
        INVALID,
        VALID_FILTERED,
        VALID_UNFILTERED;

    }

    public static class SorterInventory
    implements IInventory {
        public ItemStack[][] filters = new ItemStack[6][8];
        final SorterTileEntity tile;

        public SorterInventory(SorterTileEntity tile) {
            this.tile = tile;
            this.func_174888_l();
        }

        public int func_70302_i_() {
            return 48;
        }

        public boolean func_191420_l() {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 8; ++j) {
                    if (this.filters[i][j].func_190926_b()) continue;
                    return false;
                }
            }
            return true;
        }

        public ItemStack func_70301_a(int slot) {
            return this.filters[slot / 8][slot % 8];
        }

        public ItemStack func_70298_a(int slot, int amount) {
            ItemStack stack = this.func_70301_a(slot);
            if (!stack.func_190926_b()) {
                if (stack.func_190916_E() <= amount) {
                    this.func_70299_a(slot, null);
                } else if ((stack = stack.func_77979_a(amount)).func_190916_E() == 0) {
                    this.func_70299_a(slot, null);
                }
            }
            return stack;
        }

        public ItemStack func_70304_b(int slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (!stack.func_190926_b()) {
                this.func_70299_a(slot, null);
            }
            return stack;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.filters[slot / 8][slot % 8] = stack;
            if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
        }

        public void func_174888_l() {
            for (Object[] objectArray : this.filters) {
                Arrays.fill(objectArray, ItemStack.field_190927_a);
            }
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_70300_a(PlayerEntity player) {
            return true;
        }

        public void func_174889_b(PlayerEntity player) {
        }

        public void func_174886_c(PlayerEntity player) {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return true;
        }

        public void func_70296_d() {
            this.tile.func_70296_d();
        }

        public void writeToNBT(ListNBT list) {
            for (int i = 0; i < this.filters.length; ++i) {
                for (int j = 0; j < this.filters[i].length; ++j) {
                    if (this.filters[i][j].func_190926_b()) continue;
                    CompoundNBT itemTag = new CompoundNBT();
                    itemTag.func_74774_a("Slot", (byte)(i * 8 + j));
                    this.filters[i][j].func_77955_b(itemTag);
                    list.add((Object)itemTag);
                }
            }
        }

        public void readFromNBT(ListNBT list) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT itemTag = list.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot >= this.func_70302_i_()) continue;
                this.filters[slot / 8][slot % 8] = ItemStack.func_199557_a((CompoundNBT)itemTag);
            }
        }
    }

    public static class SorterInventoryHandler
    implements IItemHandlerModifiable {
        SorterTileEntity sorter;
        Direction side;

        public SorterInventoryHandler(SorterTileEntity sorter, Direction side) {
            this.sorter = sorter;
            this.side = side;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.sorter.routeItem(this.side, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.sorter.pullItem(this.side, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }
}

