/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.crafting.IngredientSerializerFluidStack;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class IngredientFluidStack
extends Ingredient {
    private final FluidStack fluid;
    ItemStack[] cachedStacks;

    public IngredientFluidStack(FluidStack fluid) {
        super(Stream.empty());
        this.fluid = fluid;
    }

    public IngredientFluidStack(Fluid fluid, int amount) {
        this(new FluidStack(fluid, amount));
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.cachedStacks == null) {
            this.cachedStacks = new ItemStack[]{FluidUtil.getFilledBucket((FluidStack)this.fluid)};
        }
        return this.cachedStacks;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return (Boolean)FluidUtil.getFluidContained((ItemStack)stack).map(fs -> fs.containsFluid(this.fluid)).orElse((Object)false);
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return IngredientSerializerFluidStack.INSTANCE;
    }

    @Nonnull
    public JsonElement func_200304_c() {
        JsonObject ret = new JsonObject();
        ret.addProperty("amount", (Number)this.fluid.getAmount());
        ret.addProperty("fluid", this.fluid.getFluid().getRegistryName().toString());
        ret.addProperty("type", IngredientSerializerFluidStack.NAME.toString());
        return ret;
    }

    public boolean isSimple() {
        return false;
    }
}

