/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class ArcFurnaceRecipeSerializer
extends IERecipeSerializer<ArcFurnaceRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IEBlocks.Multiblocks.arcFurnace);
    }

    @Override
    public ArcFurnaceRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        JsonArray results = json.getAsJsonArray("results");
        NonNullList outputs = NonNullList.func_191197_a((int)results.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < results.size(); ++i) {
            outputs.set(i, (Object)this.readOutput(results.get(i)));
        }
        IngredientWithSize input = IngredientWithSize.deserialize(json.get("input"));
        JsonArray additives = json.getAsJsonArray("additives");
        IngredientWithSize[] ingredients = new IngredientWithSize[additives.size()];
        for (int i = 0; i < additives.size(); ++i) {
            ingredients[i] = IngredientWithSize.deserialize(additives.get(i));
        }
        ItemStack slag = ItemStack.field_190927_a;
        if (json.has("slag")) {
            slag = this.readOutput(json.get("slag"));
        }
        int time = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
        int energy = JSONUtils.func_151203_m((JsonObject)json, (String)"energy");
        return new ArcFurnaceRecipe(recipeId, (NonNullList<ItemStack>)outputs, input, slag, time, energy, ingredients);
    }

    @Nullable
    public ArcFurnaceRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        int outputCount = buffer.readInt();
        NonNullList outputs = NonNullList.func_191197_a((int)outputCount, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < outputCount; ++i) {
            outputs.set(i, (Object)buffer.func_150791_c());
        }
        IngredientWithSize input = IngredientWithSize.read(buffer);
        int additiveCount = buffer.readInt();
        IngredientWithSize[] additives = new IngredientWithSize[additiveCount];
        for (int i = 0; i < additiveCount; ++i) {
            additives[i] = IngredientWithSize.read(buffer);
        }
        ItemStack slag = buffer.func_150791_c();
        int time = buffer.readInt();
        int energy = buffer.readInt();
        return new ArcFurnaceRecipe(recipeId, (NonNullList<ItemStack>)outputs, input, slag, time, energy, additives);
    }

    public void write(PacketBuffer buffer, ArcFurnaceRecipe recipe) {
        buffer.writeInt(recipe.output.size());
        for (ItemStack stack : recipe.output) {
            buffer.func_150788_a(stack);
        }
        recipe.input.write(buffer);
        buffer.writeInt(recipe.additives.length);
        for (IngredientWithSize ingr : recipe.additives) {
            ingr.write(buffer);
        }
        buffer.func_150788_a(recipe.slag);
        buffer.writeInt(recipe.getTotalProcessTime());
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

