/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.client.render.IEOBJItemRenderer;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class IEShieldItem
extends UpgradeableToolItem
implements EnergyHelper.IIEEnergyItem,
IOBJModelCallback<ItemStack> {
    public IEShieldItem() {
        super("shield", new Item.Properties().func_200915_b(1024).setISTER(() -> () -> IEOBJItemRenderer.INSTANCE), "SHIELD");
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)ArmorItem.field_96605_cw);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                final LazyOptional<EnergyHelper.ItemEnergyStorage> energyStorage;
                final LazyOptional<CapabilityShader.ShaderWrapper_Item> shaders;
                {
                    super(stack2);
                    this.energyStorage = CapabilityUtils.constantOptional(new EnergyHelper.ItemEnergyStorage(stack));
                    this.shaders = CapabilityUtils.constantOptional(new CapabilityShader.ShaderWrapper_Item(new ResourceLocation("immersiveengineering", "shield"), stack));
                }

                @Override
                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    if (capability == CapabilityEnergy.ENERGY) {
                        return this.energyStorage.cast();
                    }
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return this.shaders.cast();
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        LazyOptional wrapperOld = oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
        LazyOptional sameShader = wrapperOld.map(wOld -> {
            LazyOptional wrapperNew = newStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
            return (Boolean)wrapperNew.map(w -> ItemStack.func_77989_b((ItemStack)wOld.getShaderItem(), (ItemStack)w.getShaderItem())).orElse((Object)true);
        });
        if (!((Boolean)sameShader.orElse((Object)true)).booleanValue()) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (this.getMaxEnergyStored(stack) > 0) {
            String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.energyStored", new Object[]{stored}));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
        boolean blocking;
        super.func_77663_a(stack, world, ent, slot, inHand);
        if (world.field_72995_K) {
            return;
        }
        if (ent instanceof LivingEntity) {
            inHand |= ((LivingEntity)ent).func_184586_b(Hand.OFF_HAND) == stack;
        }
        boolean bl = blocking = ent instanceof LivingEntity && ((LivingEntity)ent).func_184585_cz();
        if (!inHand || !blocking) {
            int cooldown;
            if (this.getUpgrades(stack).func_150297_b("flash_cooldown", 3) && this.extractEnergy(stack, 10, true) == 10) {
                this.extractEnergy(stack, 20, false);
                cooldown = this.getUpgrades(stack).func_74762_e("flash_cooldown");
                if (--cooldown <= 0) {
                    this.getUpgrades(stack).func_82580_o("flash_cooldown");
                } else {
                    this.getUpgrades(stack).func_74768_a("flash_cooldown", cooldown);
                }
            }
            if (this.getUpgrades(stack).func_150297_b("shock_cooldown", 3) && this.extractEnergy(stack, 10, true) == 10) {
                this.extractEnergy(stack, 20, false);
                cooldown = this.getUpgrades(stack).func_74762_e("shock_cooldown");
                if (--cooldown <= 0) {
                    this.getUpgrades(stack).func_82580_o("shock_cooldown");
                } else {
                    this.getUpgrades(stack).func_74768_a("shock_cooldown", cooldown);
                }
            }
        }
    }

    public boolean isShield(ItemStack stack, @Nullable LivingEntity entity) {
        return true;
    }

    public void hitShield(ItemStack stack, PlayerEntity player, DamageSource source, float amount, LivingAttackEvent event) {
        if (this.getUpgrades(stack).func_74767_n("flash") && this.getUpgrades(stack).func_74762_e("flash_cooldown") <= 0) {
            Vec3d look = player.func_70040_Z();
            List<LivingEntity> targets = Utils.getTargetsInCone(player.func_130014_f_(), player.func_174791_d().func_178788_d(look), player.func_70040_Z().func_186678_a(9.0), 1.57079f, 0.5f);
            for (LivingEntity t : targets) {
                if (player.equals((Object)t)) continue;
                t.func_195064_c(new EffectInstance(IEPotions.flashed, 100, 1));
                if (!(t instanceof MobEntity)) continue;
                ((MobEntity)t).func_70624_b(null);
            }
            this.getUpgrades(stack).func_74768_a("flash_cooldown", 40);
        }
        if (this.getUpgrades(stack).func_74767_n("shock") && this.getUpgrades(stack).func_74762_e("shock_cooldown") <= 0) {
            boolean b = false;
            if (event.getSource().func_76352_a() && event.getSource().func_76364_f() != null) {
                Entity projectile = event.getSource().func_76364_f();
                projectile.func_70106_y();
                event.setCanceled(true);
                b = true;
            }
            if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof LivingEntity && event.getSource().func_76346_g().func_70068_e((Entity)player) < 4.0) {
                IEDamageSources.ElectricDamageSource dmgsrc = IEDamageSources.causeTeslaDamage(1.0f, true);
                dmgsrc.apply(event.getSource().func_76346_g());
                b = true;
            }
            if (b) {
                this.getUpgrades(stack).func_74768_a("shock_cooldown", 40);
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), IESounds.spark, SoundCategory.BLOCKS, 2.5f, 0.5f + Utils.RAND.nextFloat());
            }
        }
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return Utils.isInTag(material, new ResourceLocation("immersiveengineering", "ingot_steel"));
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.getUpgrades(container).func_74767_n("flash") || this.getUpgrades(container).func_74767_n("shock") ? 3200 : 0;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    @Override
    public boolean shouldRenderGroup(ItemStack object, String group) {
        if ("flash".equals(group)) {
            return this.getUpgrades(object).func_74767_n("flash");
        }
        if ("shock".equals(group)) {
            return this.getUpgrades(object).func_74767_n("shock");
        }
        return true;
    }

    @Override
    public void handlePerspective(ItemStack Object2, ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat, LivingEntity entity) {
        if (entity != null && entity.func_184587_cr()) {
            if (entity.func_184600_cs() == Hand.MAIN_HAND == (entity.func_184591_cq() == HandSide.RIGHT)) {
                if (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                    mat.func_227863_a_(new Quaternion(-0.15f, 0.0f, 0.0f, false));
                    mat.func_227861_a_(-0.25, 0.5, -0.4375);
                } else if (cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                    mat.func_227863_a_(new Quaternion(0.52359f, 0.0f, 0.0f, false));
                    mat.func_227863_a_(new Quaternion(0.0f, 0.78539f, 0.0f, false));
                    mat.func_227861_a_(0.40625, -0.125, -0.125);
                }
            } else if (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
                mat.func_227863_a_(new Quaternion(0.15f, 0.0f, 0.0f, false));
                mat.func_227861_a_(0.25, 0.375, 0.4375);
            } else if (cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
                mat.func_227863_a_(new Quaternion(-0.52359f, 1.0f, 0.0f, false));
                mat.func_227861_a_(0.1875, 0.3125, 0.75);
            }
        }
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, Supplier<World> getWorld, Supplier<PlayerEntity> getPlayer) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(RuntimeException::new);
        return new Slot[]{new IESlot.Upgrades(container, inv, 0, 80, 32, "SHIELD", stack, true, getWorld, getPlayer), new IESlot.Upgrades(container, inv, 1, 100, 32, "SHIELD", stack, true, getWorld, getPlayer)};
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 2;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

