/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.event.ForgeEventFactory;

public class IEExplosion
extends Explosion {
    public float dropChance = 1.0f;
    private int blockDestroyInt = 0;
    public int blocksPerTick = 8;
    public boolean isExplosionFinished = false;
    private final World world;
    private final float size;
    private final Explosion.Mode damagesTerrain;

    public IEExplosion(World world, Entity igniter, double x, double y, double z, float size, boolean isFlaming, Explosion.Mode damageTerrain) {
        super(world, igniter, x, y, z, size, isFlaming, damageTerrain);
        this.dropChance = 1.0f / size;
        this.world = world;
        this.damagesTerrain = damageTerrain;
        this.size = size;
    }

    public IEExplosion setDropChance(float chance) {
        this.dropChance = chance;
        return this;
    }

    public void doExplosionTick() {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        int max = Math.min(this.blockDestroyInt + this.blocksPerTick, this.func_180343_e().size());
        while (this.blockDestroyInt < max) {
            BlockPos pos = (BlockPos)this.func_180343_e().get(this.blockDestroyInt);
            BlockState state = this.world.func_180495_p(pos);
            Block block = state.func_177230_c();
            double d0 = (float)pos.func_177958_n() + Utils.RAND.nextFloat();
            double d1 = (float)pos.func_177956_o() + Utils.RAND.nextFloat();
            double d2 = (float)pos.func_177952_p() + Utils.RAND.nextFloat();
            double d3 = d0 - this.getPosition().field_72450_a;
            double d4 = d1 - this.getPosition().field_72448_b;
            double d5 = d2 - this.getPosition().field_72449_c;
            double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
            d3 /= d6;
            d4 /= d6;
            d5 /= d6;
            double d7 = 0.5 / (d6 / (double)this.size + 0.1);
            this.world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, (d0 + this.getPosition().field_72450_a * 1.0) / 2.0, (d1 + this.getPosition().field_72448_b * 1.0) / 2.0, (d2 + this.getPosition().field_72449_c * 1.0) / 2.0, d3 *= (d7 *= (double)(Utils.RAND.nextFloat() * Utils.RAND.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
            this.world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, d3, d4, d5);
            if (!state.isAir((IBlockReader)this.world, pos) && this.world instanceof ServerWorld && state.canDropFromExplosion((IBlockReader)this.world, pos, (Explosion)this)) {
                TileEntity tile = state.hasTileEntity() ? this.world.func_175625_s(pos) : null;
                LootContext.Builder lootCtx = new LootContext.Builder((ServerWorld)this.world).func_216023_a(this.world.field_73012_v).func_216015_a(LootParameters.field_216286_f, (Object)pos).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tile);
                if (this.damagesTerrain == Explosion.Mode.DESTROY) {
                    lootCtx.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(this.size));
                }
                state.func_215693_a(lootCtx).forEach(p_229977_2_ -> IEExplosion.func_229976_a_((ObjectArrayList)objectarraylist, (ItemStack)p_229977_2_, (BlockPos)pos));
                state.onBlockExploded(this.world, pos, (Explosion)this);
            }
            ++this.blockDestroyInt;
        }
        for (Pair pair : objectarraylist) {
            Block.func_180635_a((World)this.world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
        if (this.blockDestroyInt >= this.func_180343_e().size()) {
            this.isExplosionFinished = true;
        }
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.getPosition().field_72450_a;
                    double d6 = this.getPosition().field_72448_b;
                    double d8 = this.getPosition().field_72449_c;
                    float f1 = 0.3f;
                    for (float f = this.size * (0.7f + Utils.RAND.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        BlockState iblockstate = this.world.func_180495_p(blockpos);
                        IFluidState ifluidstate = this.world.func_204610_c(blockpos);
                        if (!iblockstate.isAir((IBlockReader)this.world, blockpos) || !ifluidstate.func_206888_e()) {
                            float f2 = Math.max(iblockstate.getExplosionResistance((IWorldReader)this.world, blockpos, (Entity)this.func_94613_c(), (Explosion)this), ifluidstate.getExplosionResistance((IWorldReader)this.world, blockpos, (Entity)this.func_94613_c(), (Explosion)this));
                            if (this.func_94613_c() != null) {
                                f2 = this.func_94613_c().func_180428_a((Explosion)this, (IBlockReader)this.world, blockpos, iblockstate, ifluidstate, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.func_94613_c() == null || this.func_94613_c().func_174816_a((Explosion)this, (IBlockReader)this.world, blockpos, iblockstate, f))) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.func_180343_e().addAll(set);
        this.func_180343_e().sort(Comparator.comparingDouble(pos -> pos.func_218140_a(this.getPosition().field_72450_a, this.getPosition().field_72448_b, this.getPosition().field_72449_c, true)));
        float f3 = this.size * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.getPosition().field_72450_a - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.getPosition().field_72450_a + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.getPosition().field_72448_b - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.getPosition().field_72448_b + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.getPosition().field_72449_c - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.getPosition().field_72449_c + (double)f3 + 1.0));
        List list = this.world.func_72839_b((Entity)this.func_94613_c(), new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)f3);
        Vec3d vec3 = new Vec3d(this.getPosition().field_72450_a, this.getPosition().field_72448_b, this.getPosition().field_72449_c);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.func_180427_aV() || !((d12 = entity.func_213303_ch().func_186679_c(this.getPosition().field_72450_a, this.getPosition().field_72448_b, this.getPosition().field_72449_c) / (double)f3) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.func_226277_ct_() - this.getPosition().field_72450_a) * d5 + (d7 = entity.func_226278_cu_() + (double)entity.func_70047_e() - this.getPosition().field_72448_b) * d7 + (d9 = entity.func_226281_cx_() - this.getPosition().field_72449_c) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = IEExplosion.func_222259_a((Vec3d)vec3, (Entity)entity);
            double d10 = (1.0 - d12) * d14;
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)((int)((d10 * d10 + d10) / 2.0 * 8.0 * (double)f3 + 1.0)));
            double d11 = entity instanceof LivingEntity ? ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)d10) : d10;
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof PlayerEntity) || ((PlayerEntity)entity).field_71075_bZ.field_75102_a) continue;
            this.func_77277_b().put((PlayerEntity)entity, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        Vec3d pos = this.getPosition();
        this.world.func_184134_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187539_bB, SoundCategory.NEUTRAL, 4.0f, (1.0f + (Utils.RAND.nextFloat() - Utils.RAND.nextFloat()) * 0.2f) * 0.7f, true);
        if (this.size >= 2.0f && this.damagesTerrain != Explosion.Mode.NONE) {
            this.world.func_195594_a((IParticleData)ParticleTypes.field_197626_s, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 1.0, 0.0, 0.0);
        } else {
            this.world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 1.0, 0.0, 0.0);
        }
        EventHandler.currentExplosions.add(this);
    }
}

