/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.wires;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.localhandlers.ICollisionHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class WireCollisions {
    public static void handleEntityCollision(BlockPos p, Entity e) {
        if (!(e.field_70170_p.field_72995_K || !IEConfig.CACHED.wireDamage || !(e instanceof LivingEntity) || e.func_180431_b(IEDamageSources.wireShock) || e instanceof PlayerEntity && ((PlayerEntity)e).field_71075_bZ.field_75102_a)) {
            GlobalWireNetwork global = GlobalWireNetwork.getNetwork(e.field_70170_p);
            WireCollisionData wireData = global.getCollisionData();
            Collection<WireCollisionData.CollisionInfo> atBlock = wireData.getCollisionInfo(p);
            for (WireCollisionData.CollisionInfo info : atBlock) {
                LocalWireNetwork local = info.getLocalNet();
                for (LocalNetworkHandler h : local.getAllHandlers()) {
                    if (!(h instanceof ICollisionHandler)) continue;
                    ((ICollisionHandler)((Object)h)).onCollided((LivingEntity)e, p, info);
                }
            }
        }
    }

    public static void notifyBlockUpdate(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState oldState, @Nonnull BlockState newState, int flags) {
        GlobalWireNetwork globalNet;
        Collection<WireCollisionData.CollisionInfo> data;
        if (IEConfig.CACHED.blocksBreakWires && !worldIn.field_72995_K && (flags & 1) != 0 && !newState.func_196952_d((IBlockReader)worldIn, pos).func_197766_b() && !(data = (globalNet = GlobalWireNetwork.getNetwork(worldIn)).getCollisionData().getCollisionInfo(pos)).isEmpty()) {
            HashMap<Connection, BlockPos> toBreak = new HashMap<Connection, BlockPos>();
            for (WireCollisionData.CollisionInfo collisionInfo : data) {
                Vec3d vecB;
                Vec3d vecA;
                if (!collisionInfo.isInBlock || Utils.isVecInBlock(vecA = collisionInfo.conn.getPoint(0.0, collisionInfo.conn.getEndA()), pos, collisionInfo.conn.getEndA().getPosition(), 0.001) || Utils.isVecInBlock(vecB = collisionInfo.conn.getPoint(0.0, collisionInfo.conn.getEndB()), pos, collisionInfo.conn.getEndB().getPosition(), 0.001)) continue;
                BlockPos dropPos = pos;
                if (!WireUtils.preventsConnection(worldIn, pos, newState, collisionInfo.intersectA, collisionInfo.intersectB)) continue;
                for (Direction f : Direction.field_199792_n) {
                    if (!worldIn.func_175623_d(pos.func_177972_a(f))) continue;
                    dropPos = dropPos.func_177972_a(f);
                    break;
                }
                toBreak.put(collisionInfo.conn, dropPos);
            }
            for (Map.Entry entry : toBreak.entrySet()) {
                globalNet.removeAndDropConnection((Connection)entry.getKey(), (BlockPos)entry.getValue());
            }
        }
    }
}

