/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.ManualScreen;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ManualElementTable
extends SpecialManualElements {
    private ITextComponent[][] table;
    private int[] bars;
    private boolean horizontalBars;
    private OptionalInt height = OptionalInt.empty();
    private int[] textOff;

    @Deprecated
    public ManualElementTable(ManualInstance manual, String[][] table, boolean horizontalBars) {
        this(manual, (ITextComponent[][])Arrays.stream(table).map(a -> (ITextComponent[])Arrays.stream(a).map(StringTextComponent::new).toArray(ITextComponent[]::new)).toArray(x$0 -> new ITextComponent[x$0][]), horizontalBars);
    }

    public ManualElementTable(ManualInstance manual, ITextComponent[][] table, boolean horizontalBars) {
        super(manual);
        Preconditions.checkNotNull((Object)table);
        this.table = table;
        this.horizontalBars = horizontalBars;
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> pageButtons) {
        super.onOpened(gui, x, y, pageButtons);
        try {
            this.recalculateLayout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(ManualScreen gui, int x, int y, int mx, int my) {
        if (this.table != null) {
            int col = this.manual.getHighlightColour() | 0xFF000000;
            AbstractGui.fill((int)x, (int)(y - 2), (int)(x + 120), (int)(y - 1), (int)col);
            int yOff = 0;
            for (ITextComponent[] line : this.table) {
                if (line == null) continue;
                int height = 0;
                for (int j = 0; j < line.length; ++j) {
                    if (line[j] == null) continue;
                    int xx = this.textOff.length > 0 && j > 0 ? this.textOff[j - 1] : x;
                    int w = Math.max(10, 120 - (j > 0 ? this.textOff[j - 1] - x : 0));
                    String lineText = line[j].func_150254_d();
                    this.manual.fontRenderer().func_78279_b(lineText, xx, y + yOff, w, this.manual.getTextColour());
                    int lines = this.manual.fontRenderer().func_78271_c(lineText, w).size();
                    if (lines <= height) continue;
                    height = lines;
                }
                if (this.horizontalBars) {
                    float scale = 0.5f;
                    RenderSystem.scalef((float)1.0f, (float)scale, (float)1.0f);
                    this.manual.fontRenderer().getClass();
                    int barHeight = (int)((float)(y + yOff + height * 9) / scale);
                    AbstractGui.fill((int)x, (int)barHeight, (int)(x + 120), (int)(barHeight + 1), (int)(this.manual.getTextColour() | 0xFF000000));
                    RenderSystem.scalef((float)1.0f, (float)(1.0f / scale), (float)1.0f);
                }
                this.manual.fontRenderer().getClass();
                yOff += height * (9 + 1);
            }
            if (this.bars != null) {
                for (int i = 0; i < this.bars.length; ++i) {
                    AbstractGui.fill((int)(this.textOff[i] - 4), (int)(y - 4), (int)(this.textOff[i] - 3), (int)(y + yOff), (int)col);
                }
            }
        }
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    private void recalculateLayout() {
        this.bars = new int[1];
        for (ITextComponent[] tableLine : this.table) {
            if (tableLine.length - 1 > this.bars.length) {
                this.bars = Arrays.copyOf(this.bars, tableLine.length - 1);
            }
            for (int j = 0; j < tableLine.length - 1; ++j) {
                int fl = this.manual.fontRenderer().func_78256_a(tableLine[j].func_150254_d());
                if (fl <= this.bars[j]) continue;
                this.bars[j] = fl;
            }
        }
        this.textOff = new int[this.bars.length];
        int xx = 0;
        for (int i = 0; i < this.bars.length; ++i) {
            this.textOff[i] = xx += this.bars[i] + 8;
        }
        int yOff = 0;
        for (ITextComponent[] tableLine : this.table) {
            if (tableLine == null) continue;
            for (int j = 0; j < tableLine.length; ++j) {
                if (tableLine[j] == null) continue;
                int w = Math.max(10, 120 - (j > 0 ? this.textOff[j - 1] : 0));
                int l = this.manual.fontRenderer().func_78271_c(tableLine[j].func_150254_d(), w).size();
                if (j == 0) continue;
                this.manual.fontRenderer().getClass();
                yOff += l * (9 + 1);
            }
        }
        this.height = OptionalInt.of(yOff);
    }

    @Override
    public int getPixelsTaken() {
        if (!this.height.isPresent()) {
            this.recalculateLayout();
        }
        return this.height.getAsInt();
    }

    @Override
    public boolean isAbove() {
        return false;
    }
}

