/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.SplitResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class TextSplitter {
    public static final String START = "start";
    public static final Pattern LINEBREAK = Pattern.compile("[\\n\\r]+");
    private final Function<String, Integer> width;
    private final int lineWidth;
    private final IntSupplier pixelsPerLine;
    private final Map<String, Map<Integer, SpecialManualElement>> specialByAnchor = new HashMap<String, Map<Integer, SpecialManualElement>>();
    private final Function<String, String> tokenTransform;
    private final int pixelsPerPage;

    public TextSplitter(Function<String, Integer> w, int lineWidthPixel, int pageHeightPixel, IntSupplier pixelsPerLine, Function<String, String> tokenTransform) {
        this.width = w;
        this.lineWidth = lineWidthPixel;
        this.pixelsPerPage = pageHeightPixel;
        this.pixelsPerLine = pixelsPerLine;
        this.tokenTransform = tokenTransform;
        this.clearSpecialByAnchor();
    }

    public TextSplitter(ManualInstance m) {
        this(m, s -> s);
    }

    public TextSplitter(ManualInstance m, Function<String, String> tokenTransform) {
        this(s -> m.fontRenderer().func_78256_a(s), m.pageWidth, m.pageHeight, () -> {
            m.fontRenderer().getClass();
            return 9;
        }, tokenTransform);
    }

    public void clearSpecialByAnchor() {
        this.specialByAnchor.clear();
        this.specialByAnchor.put(START, new HashMap());
    }

    public void addSpecialPage(String ref, int offset, SpecialManualElement element) {
        if (offset < 0 || ref == null || ref.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (!this.specialByAnchor.containsKey(ref)) {
            this.specialByAnchor.put(ref, new HashMap());
        }
        this.specialByAnchor.get(ref).put(offset, element);
    }

    public SplitResult split(String in) {
        int n;
        for (Map<Integer, SpecialManualElement> forAnchor : this.specialByAnchor.values()) {
            for (SpecialManualElement e : forAnchor.values()) {
                e.recalculateCraftingRecipes();
            }
        }
        ArrayList<List<String>> entry = new ArrayList<List<String>>();
        Object2IntOpenHashMap pageByAnchor = new Object2IntOpenHashMap();
        pageByAnchor.put((Object)START, 0);
        String[] wordsAndSpaces = TextSplitter.splitWhitespace(in);
        NextPageData pageOverflow = new NextPageData();
        while (pageOverflow != null && pageOverflow.topLine != null) {
            Page nextPage = this.parsePage(pageOverflow, wordsAndSpaces, arg_0 -> this.lambda$split$3(entry, (Object2IntMap)pageByAnchor, arg_0), arg_0 -> this.lambda$split$4((Object2IntMap)pageByAnchor, entry, arg_0));
            nextPage.anchor.ifPresent(arg_0 -> TextSplitter.lambda$split$5((Object2IntMap)pageByAnchor, entry, arg_0));
            entry.add(nextPage.lines);
            pageOverflow = nextPage.nextPage;
        }
        for (List list : entry) {
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, ((String)list.get(i)).replace('\u00a0', ' '));
            }
        }
        Int2ObjectOpenHashMap specialByPage = new Int2ObjectOpenHashMap();
        boolean bl = false;
        for (Object2IntMap.Entry forAnchor : pageByAnchor.object2IntEntrySet()) {
            for (Map.Entry<Integer, SpecialManualElement> element : this.getElements((String)forAnchor.getKey()).entrySet()) {
                int page = forAnchor.getIntValue() + element.getKey();
                Preconditions.checkState((!specialByPage.containsKey(page) ? 1 : 0) != 0);
                specialByPage.put(page, (Object)element.getValue());
                if (page <= n) continue;
                n = page;
            }
        }
        while (entry.size() <= n) {
            entry.add(new ArrayList());
        }
        return new SplitResult(entry, (Object2IntMap<String>)pageByAnchor, (Int2ObjectMap<SpecialManualElement>)specialByPage);
    }

    private boolean noCollidingElements(String newAnchor, int anchorPage, Object2IntMap<String> pageByAnchor) {
        IntArraySet newSpecials = new IntArraySet();
        ObjectIterator objectIterator = this.getElements(newAnchor).keySet().iterator();
        while (objectIterator.hasNext()) {
            int offset = objectIterator.next();
            newSpecials.add(offset + anchorPage);
        }
        for (Object2IntMap.Entry e : pageByAnchor.object2IntEntrySet()) {
            for (int offset : this.getElements((String)e.getKey()).keySet()) {
                if (!newSpecials.contains(e.getIntValue() + offset)) continue;
                return false;
            }
        }
        return true;
    }

    private Optional<SpecialManualElement> findElement(Object2IntMap<String> pageByAnchor, int newAnchorPage, Optional<String> newAnchor) {
        Map<Integer, SpecialManualElement> forNewAnchor;
        if (newAnchor.isPresent() && (forNewAnchor = this.getElements(newAnchor.get())).containsKey(0)) {
            return Optional.of(forNewAnchor.get(0));
        }
        for (Object2IntMap.Entry e : pageByAnchor.object2IntEntrySet()) {
            int offset;
            Map<Integer, SpecialManualElement> forAnchor = this.getElements((String)e.getKey());
            if (!forAnchor.containsKey(offset = newAnchorPage - e.getIntValue())) continue;
            return Optional.of(forAnchor.get(offset));
        }
        return Optional.empty();
    }

    private Map<Integer, SpecialManualElement> getElements(String anchor) {
        if (!this.specialByAnchor.containsKey(anchor)) {
            IELogger.warn("Tried to access invalid key \"" + anchor + "\"");
            return ImmutableMap.of();
        }
        return this.specialByAnchor.get(anchor);
    }

    private Page parsePage(NextPageData overflow, String[] wordsAndSpaces, Predicate<String> canPlaceAnchor, Function<Optional<String>, Integer> getLines) {
        ArrayList<String> page = new ArrayList<String>();
        NextLineData lineOverflow = overflow.topLine;
        Optional anchorOnPage = Optional.empty();
        while (page.size() < getLines.apply(anchorOnPage) && lineOverflow != null) {
            Optional finalAnchorOnPage = anchorOnPage;
            Function<String, AnchorViability> getAnchorViability = anchor -> {
                if (finalAnchorOnPage.isPresent()) {
                    return AnchorViability.NOT_VALID;
                }
                if (!canPlaceAnchor.test((String)anchor)) {
                    return AnchorViability.NOT_VALID;
                }
                if (page.size() + 1 > (Integer)getLines.apply(Optional.of(anchor))) {
                    return AnchorViability.VALID_IF_ALONE;
                }
                return AnchorViability.VALID;
            };
            Line next = this.parseLine(lineOverflow, getAnchorViability, wordsAndSpaces);
            if (next.anchorBeforeLine.isPresent()) {
                String newAnchor = (String)next.anchorBeforeLine.get();
                AnchorViability viability = getAnchorViability.apply(newAnchor);
                Preconditions.checkState((viability != AnchorViability.NOT_VALID ? 1 : 0) != 0);
                if (viability == AnchorViability.VALID_IF_ALONE && !page.isEmpty()) break;
                anchorOnPage = next.anchorBeforeLine;
            }
            if (!page.isEmpty() || !next.line.isEmpty()) {
                page.add(next.line);
            }
            if ((lineOverflow = next.overflow) == null || !lineOverflow.putOnNewPage) continue;
            break;
        }
        while (!page.isEmpty() && ((String)page.get(page.size() - 1)).trim().isEmpty()) {
            page.remove(page.size() - 1);
        }
        return new Page(page, anchorOnPage, lineOverflow);
    }

    private Line parseLine(NextLineData lastOverflow, Function<String, AnchorViability> canPlaceAnchor, String[] wordsAndSpaces) {
        String token;
        int textWidth;
        int currWidth;
        int pos;
        StringBuilder lineBuilder = new StringBuilder(lastOverflow.formattingOverflow + lastOverflow.textOverflow);
        Optional<String> anchorBeforeLine = Optional.empty();
        for (pos = lastOverflow.firstToken; pos < wordsAndSpaces.length && this.getWidth(lineBuilder.toString()) < this.lineWidth && ((currWidth = this.getWidth(lineBuilder.toString())) + (textWidth = this.getWidth(token = this.tokenTransform.apply(wordsAndSpaces[pos]))) <= this.lineWidth || currWidth == 0); ++pos) {
            if (token.equals("<np>")) {
                return new Line(lineBuilder.toString(), pos + 1, true, anchorBeforeLine, "");
            }
            if (LINEBREAK.matcher(token).matches()) {
                return new Line(lineBuilder.toString(), pos + 1, false, anchorBeforeLine, "");
            }
            if (token.startsWith("<&") && token.endsWith(">")) {
                String anchor = this.toAnchor(token);
                AnchorViability allowed = canPlaceAnchor.apply(anchor);
                if (allowed == AnchorViability.VALID_IF_ALONE && lineBuilder.toString().isEmpty()) {
                    return new Line("", pos + 1, true, Optional.of(anchor), "");
                }
                if (allowed != AnchorViability.VALID) {
                    return new Line(lineBuilder.toString(), pos, true, Optional.empty(), "");
                }
                anchorBeforeLine = Optional.of(anchor);
                continue;
            }
            if (Character.isWhitespace(token.charAt(0)) && currWidth == 0) continue;
            lineBuilder.append(token);
        }
        String line = lineBuilder.toString().trim();
        if (this.getWidth(line) > this.lineWidth) {
            String upToWidth = "";
            for (int i = 0; i < line.length() && this.getWidth(upToWidth) < this.lineWidth; ++i) {
                upToWidth = upToWidth + line.charAt(i);
            }
            String overflow = line.substring(upToWidth.length());
            return new Line(upToWidth, pos, false, anchorBeforeLine, overflow);
        }
        if (pos < wordsAndSpaces.length) {
            return new Line(line, pos, false, anchorBeforeLine, "");
        }
        return new Line(line, null, anchorBeforeLine);
    }

    private String toAnchor(String token) {
        return token.substring(2, token.length() - 1);
    }

    private int getWidth(String text) {
        if (LINEBREAK.matcher(text).matches()) {
            return 0;
        }
        switch (text) {
            case "<br>": 
            case "<np>": {
                return 0;
            }
        }
        if (text.startsWith("<link;")) {
            text = text.substring(text.indexOf(59) + 1);
            text = text.substring(text.indexOf(59) + 1, text.lastIndexOf(59));
        }
        return this.width.apply(text);
    }

    private int getLinesOnPage(Optional<SpecialManualElement> elementOnPage) {
        int pixels = this.pixelsPerPage;
        if (elementOnPage.isPresent()) {
            pixels = this.pixelsPerPage - elementOnPage.get().getPixelsTaken();
        }
        return MathHelper.func_76128_c((double)((double)pixels / (double)this.pixelsPerLine.getAsInt()));
    }

    public static String[] splitWhitespace(String in) {
        ArrayList<String> parts = new ArrayList<String>();
        int i = 0;
        while (i < in.length()) {
            StringBuilder here = new StringBuilder();
            char first = in.charAt(i);
            here.append(first);
            ++i;
            while (i < in.length()) {
                char hereC = in.charAt(i);
                byte action = TextSplitter.shouldSplit(first, hereC);
                if ((action & 1) != 0) {
                    here.append(in.charAt(i));
                    ++i;
                }
                if ((action & 2) == 0 && (action & 1) != 0) continue;
                break;
            }
            parts.add(here.toString());
        }
        return parts.toArray(new String[0]);
    }

    private static byte shouldSplit(char start, char here) {
        int ret = 1;
        if (Character.isWhitespace(start) ^ Character.isWhitespace(here)) {
            ret = 2;
        } else if (Character.isWhitespace(here)) {
            if (start == '\n' && here == '\r' || start == '\r' && here == '\n') {
                ret = 3;
            } else if (here == '\r' || here == '\n' || start == '\r' || start == '\n') {
                ret = 2;
            }
        }
        if (here == '<') {
            ret = 2;
        }
        if (start == '<') {
            ret = 1;
            if (here == '>') {
                ret = (byte)(ret | 2);
            }
        }
        return (byte)ret;
    }

    private static /* synthetic */ void lambda$split$5(Object2IntMap pageByAnchor, List entry, String anchor) {
        pageByAnchor.put((Object)anchor, entry.size());
    }

    private /* synthetic */ Integer lambda$split$4(Object2IntMap pageByAnchor, List entry, Optional str) {
        Optional<SpecialManualElement> element = this.findElement((Object2IntMap<String>)pageByAnchor, entry.size(), str);
        return this.getLinesOnPage(element);
    }

    private /* synthetic */ boolean lambda$split$3(List entry, Object2IntMap pageByAnchor, String anchor) {
        return this.noCollidingElements(anchor, entry.size(), (Object2IntMap<String>)pageByAnchor);
    }

    private static enum AnchorViability {
        NOT_VALID,
        VALID,
        VALID_IF_ALONE;

    }

    private static class NextPageData {
        private final NextLineData topLine;

        private NextPageData(NextLineData topLine) {
            this.topLine = topLine;
        }

        public NextPageData() {
            this(new NextLineData(0, false, "", ""));
        }
    }

    private static class Page {
        private final List<String> lines;
        private final Optional<String> anchor;
        private final NextPageData nextPage;

        private Page(List<String> lines, Optional<String> anchor, NextPageData nextPage) {
            this.lines = lines;
            this.anchor = anchor;
            this.nextPage = nextPage;
        }

        public Page(List<String> page, Optional<String> anchor, NextLineData overflow) {
            this(page, anchor, overflow == null ? null : new NextPageData(overflow));
        }
    }

    private static class NextLineData {
        private final int firstToken;
        private final boolean putOnNewPage;
        private final String formattingOverflow;
        private final String textOverflow;

        private NextLineData(int firstToken, boolean putOnNewPage, String formattingOverflow, String textOverflow) {
            this.firstToken = firstToken;
            this.putOnNewPage = putOnNewPage;
            this.formattingOverflow = formattingOverflow;
            this.textOverflow = textOverflow;
        }
    }

    private static class Line {
        private final String line;
        private final NextLineData overflow;
        private final Optional<String> anchorBeforeLine;

        private Line(String line, NextLineData overflow, @Nullable Optional<String> anchorBeforeLine) {
            this.line = line;
            this.overflow = overflow;
            this.anchorBeforeLine = anchorBeforeLine;
        }

        public Line(String line, int firstToken, boolean endPageAfterLine, Optional<String> anchorBeforeLine, String textOverflow) {
            this(line, new NextLineData(firstToken, endPageAfterLine, TextFormatting.func_211164_a((String)line), textOverflow), anchorBeforeLine);
        }
    }
}

