/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial;

import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.module.ModuleTransport;
import com.buuz135.industrial.proxy.CommonProxy;
import com.buuz135.industrial.proxy.client.ClientProxy;
import com.buuz135.industrial.proxy.client.render.ContributorsCatEarsRender;
import com.buuz135.industrial.proxy.network.ConveyorButtonInteractMessage;
import com.buuz135.industrial.proxy.network.ConveyorSplittingSyncEntityMessage;
import com.buuz135.industrial.proxy.network.SpecialParticleMessage;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.recipe.FluidExtractorRecipe;
import com.buuz135.industrial.recipe.LaserDrillFluidRecipe;
import com.buuz135.industrial.recipe.LaserDrillOreRecipe;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import com.buuz135.industrial.recipe.provider.IndustrialRecipeProvider;
import com.buuz135.industrial.recipe.provider.IndustrialSerializableProvider;
import com.buuz135.industrial.recipe.provider.IndustrialTagsProvider;
import com.buuz135.industrial.registry.IFRegistries;
import com.buuz135.industrial.utils.IFFakePlayer;
import com.buuz135.industrial.utils.data.IndustrialBlockstateProvider;
import com.buuz135.industrial.utils.data.IndustrialModelProvider;
import com.hrznstudio.titanium.TitaniumClient;
import com.hrznstudio.titanium.datagenerator.loot.TitaniumLootTableProvider;
import com.hrznstudio.titanium.datagenerator.model.BlockItemModelGeneratorProvider;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.Module;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardGiver;
import com.hrznstudio.titanium.reward.RewardManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="industrialforegoing")
public class IndustrialForegoing
extends ModuleController {
    private static CommonProxy proxy;
    private static HashMap<DimensionType, IFFakePlayer> worldFakePlayer;
    public static NetworkHandler NETWORK;
    public static Logger LOGGER;

    public IndustrialForegoing() {
        proxy = new CommonProxy();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> EventManager.mod(FMLClientSetupEvent.class).process(fmlClientSetupEvent -> new ClientProxy().run()).subscribe());
        EventManager.mod(FMLCommonSetupEvent.class).process(fmlCommonSetupEvent -> proxy.run()).subscribe();
        EventManager.forge(FMLServerStartingEvent.class).process(fmlServerStartingEvent -> worldFakePlayer.clear()).subscribe();
        EventManager.modGeneric(RegistryEvent.Register.class, IRecipeSerializer.class).process(register -> ((RegistryEvent.Register)register).getRegistry().registerAll(new IForgeRegistryEntry[]{FluidExtractorRecipe.SERIALIZER, DissolutionChamberRecipe.SERIALIZER, LaserDrillOreRecipe.SERIALIZER, LaserDrillFluidRecipe.SERIALIZER})).subscribe();
        IFRegistries.poke();
        RewardGiver giver = RewardManager.get().getGiver(UUID.fromString("d28b7061-fb92-4064-90fb-7e02b95a72a6"), "Buuz135");
        try {
            giver.addReward(new Reward(new ResourceLocation("industrialforegoing", "cat_ears"), new URL("https://raw.githubusercontent.com/Buuz135/Industrial-Foregoing/master/contributors.json"), () -> dist -> {
                if (dist == Dist.CLIENT) {
                    this.registerReward();
                }
            }, new String[]{"normal"}));
        }
        catch (MalformedURLException e) {
            LOGGER.catching((Throwable)e);
        }
        LaserDrillRarity.init();
    }

    public static FakePlayer getFakePlayer(World world) {
        if (worldFakePlayer.containsKey(world.func_230315_m_())) {
            return worldFakePlayer.get(world.func_230315_m_());
        }
        if (world instanceof ServerWorld) {
            IFFakePlayer fakePlayer = new IFFakePlayer((ServerWorld)world);
            worldFakePlayer.put(world.func_230315_m_(), fakePlayer);
            return fakePlayer;
        }
        return null;
    }

    public static FakePlayer getFakePlayer(World world, BlockPos pos) {
        FakePlayer player = IndustrialForegoing.getFakePlayer(world);
        if (player != null) {
            player.func_70080_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 90.0f, 90.0f);
        }
        return player;
    }

    public void onPreInit() {
        super.onPreInit();
    }

    public void addDataProvider(GatherDataEvent event) {
        super.addDataProvider(event);
        NonNullLazy blocksToProcess = NonNullLazy.of(() -> ForgeRegistries.BLOCKS.getValues().stream().filter(basicBlock -> Optional.ofNullable(basicBlock.getRegistryName()).map(ResourceLocation::func_110624_b).filter("industrialforegoing"::equalsIgnoreCase).isPresent()).collect(Collectors.toList()));
        event.getGenerator().func_200390_a((IDataProvider)new IndustrialTagsProvider.Blocks(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new IndustrialTagsProvider.Items(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new IndustrialRecipeProvider(event.getGenerator(), (NonNullLazy<List<Block>>)blocksToProcess));
        event.getGenerator().func_200390_a((IDataProvider)new IndustrialSerializableProvider(event.getGenerator(), "industrialforegoing"));
        event.getGenerator().func_200390_a((IDataProvider)new TitaniumLootTableProvider(event.getGenerator(), blocksToProcess));
        event.getGenerator().func_200390_a((IDataProvider)new BlockItemModelGeneratorProvider(event.getGenerator(), "industrialforegoing", blocksToProcess));
        event.getGenerator().func_200390_a((IDataProvider)new IndustrialBlockstateProvider(event.getGenerator(), event.getExistingFileHelper(), (NonNullLazy<List<Block>>)blocksToProcess));
        event.getGenerator().func_200390_a((IDataProvider)new IndustrialModelProvider(event.getGenerator(), event.getExistingFileHelper()));
    }

    protected void initModules() {
        Module.Builder core = Module.builder((String)"core").description("Module for all the Industrial Foregoing basic features");
        new ModuleCore().generateFeatures().forEach(arg_0 -> ((Module.Builder)core).feature(arg_0));
        this.addModule(core);
        Module.Builder tool = Module.builder((String)"tools").description("A collection of Industrial Foregoing tools");
        new ModuleTool().generateFeatures().forEach(arg_0 -> ((Module.Builder)tool).feature(arg_0));
        this.addModule(tool);
        Module.Builder transport = Module.builder((String)"transport").description("All the Industrial Foregoing tools that allow of transport of things");
        new ModuleTransport().generateFeatures().forEach(arg_0 -> ((Module.Builder)transport).feature(arg_0));
        this.addModule(transport);
        Module.Builder generator = Module.builder((String)"generator").description("All machines that generate power");
        new ModuleGenerator().generateFeatures().forEach(arg_0 -> ((Module.Builder)generator).feature(arg_0));
        this.addModule(generator);
        Module.Builder agriculture = Module.builder((String)"agriculture").description("All of your farming options");
        new ModuleAgricultureHusbandry().generateFeatures().forEach(arg_0 -> ((Module.Builder)agriculture).feature(arg_0));
        this.addModule(agriculture);
        Module.Builder resources = Module.builder((String)"resource_production");
        new ModuleResourceProduction().generateFeatures().forEach(arg_0 -> ((Module.Builder)resources).feature(arg_0));
        this.addModule(resources);
        Module.Builder misc = Module.builder((String)"misc").description("Random things that don't fit");
        new ModuleMisc().generateFeatures().forEach(arg_0 -> ((Module.Builder)misc).feature(arg_0));
        this.addModule(misc);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerReward() {
        Minecraft instance = Minecraft.func_71410_x();
        EntityRendererManager manager = instance.func_175598_ae();
        ((PlayerRenderer)manager.getSkinMap().get("default")).func_177094_a((LayerRenderer)new ContributorsCatEarsRender((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)TitaniumClient.getPlayerRenderer((Minecraft)Minecraft.func_71410_x())));
        ((PlayerRenderer)manager.getSkinMap().get("slim")).func_177094_a((LayerRenderer)new ContributorsCatEarsRender((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)TitaniumClient.getPlayerRenderer((Minecraft)Minecraft.func_71410_x())));
    }

    static {
        worldFakePlayer = new HashMap();
        NETWORK = new NetworkHandler("industrialforegoing");
        LOGGER = LogManager.getLogger((String)"industrialforegoing");
        NETWORK.registerMessage(ConveyorButtonInteractMessage.class);
        NETWORK.registerMessage(ConveyorSplittingSyncEntityMessage.class);
        NETWORK.registerMessage(SpecialParticleMessage.class);
    }
}

