/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.AnimalBabySeparatorConfig;
import com.buuz135.industrial.gui.component.ItemGuiAddon;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;

public class AnimalBabySeparatorTile
extends IndustrialAreaWorkingTile<AnimalBabySeparatorTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private boolean movingAdults = false;

    public AnimalBabySeparatorTile() {
        super(ModuleAgricultureHusbandry.ANIMAL_BABY_SEPARATOR, RangeManager.RangeType.BEHIND, true, AnimalBabySeparatorConfig.powerPerOperation);
        this.addButton(new ButtonComponent(42, 20, 18, 18){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new StateButtonAddon(this, new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.ITEM_BACKGROUND, new String[]{"Moving babies"}), new StateButtonInfo(1, AssetTypes.ITEM_BACKGROUND, new String[]{"Moving adults"})}){

                    public int getState() {
                        return AnimalBabySeparatorTile.this.movingAdults ? 1 : 0;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.movingAdults = !this.movingAdults;
            this.markForUpdate();
        }));
        this.addGuiAddonFactory(() -> new ItemGuiAddon(42, 20){

            @Override
            public ItemStack getItemStack() {
                return new ItemStack((IItemProvider)(AnimalBabySeparatorTile.this.movingAdults ? Items.field_151015_O : Items.field_151014_N));
            }
        }.withoutTooltip());
        this.maxProgress = AnimalBabySeparatorConfig.maxProgress;
        this.powerPerOperation = AnimalBabySeparatorConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.field_145850_b != null && this.hasEnergy(this.powerPerOperation)) {
            List mobs = this.field_145850_b.func_217357_a(AnimalEntity.class, this.getWorkingArea().func_197752_a());
            mobs.removeIf(animalEntity -> !animalEntity.func_70631_g_() == !this.movingAdults);
            if (mobs.size() == 0) {
                return new IndustrialWorkingTile.WorkAction(1.0f, 0);
            }
            BlockPos pos = this.func_174877_v().func_177972_a(this.getFacingDirection());
            ((AnimalEntity)mobs.get(0)).func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            return new IndustrialWorkingTile.WorkAction(0.25f, this.powerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction(1.0f, 0);
    }

    protected EnergyStorageComponent<AnimalBabySeparatorTile> createEnergyStorage() {
        return new EnergyStorageComponent(AnimalBabySeparatorConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public AnimalBabySeparatorTile getSelf() {
        return this;
    }
}

