/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.AnimalRancherConfig;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BucketItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class AnimalRancherTile
extends IndustrialAreaWorkingTile<AnimalRancherTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private SidedFluidTankComponent<AnimalRancherTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("fluid_output", AnimalRancherConfig.maxTankSize, 47, 20, 0).setColor(DyeColor.WHITE).setComponentHarness((IComponentHarness)this);
    @Save
    private SidedInventoryComponent<AnimalRancherTile> output;

    public AnimalRancherTile() {
        super(ModuleAgricultureHusbandry.ANIMAL_RANCHER, RangeManager.RangeType.BEHIND, true, AnimalRancherConfig.powerPerOperation);
        this.addTank(this.tank);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 74, 22, 15, 1).setColor(DyeColor.ORANGE).setRange(5, 3).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.maxProgress = AnimalRancherConfig.maxProgress;
        this.powerPerOperation = AnimalRancherConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        List mobs;
        if (this.hasEnergy(this.powerPerOperation) && (mobs = this.field_145850_b.func_217357_a(CreatureEntity.class, this.getWorkingArea().func_197752_a())).size() > 0) {
            for (CreatureEntity mob : mobs) {
                FakePlayer player = IndustrialForegoing.getFakePlayer(this.field_145850_b, mob.func_233580_cy_());
                if (mob instanceof AnimalEntity && this.tank.getFluidAmount() + 1000 <= this.tank.getCapacity()) {
                    player.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151133_ar));
                    if (((AnimalEntity)mob).func_230254_b_((PlayerEntity)player, Hand.MAIN_HAND).func_226246_a_()) {
                        ItemStack stack2 = player.func_184586_b(Hand.MAIN_HAND);
                        if (stack2.func_77973_b() instanceof BucketItem) {
                            this.tank.fillForced(new FluidStack(((BucketItem)stack2.func_77973_b()).getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                            return new IndustrialWorkingTile.WorkAction(0.35f, this.powerPerOperation);
                        }
                        player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                    }
                }
                ItemStack shears = new ItemStack((IItemProvider)Items.field_151097_aZ);
                if (mob instanceof IForgeShearable && ((IForgeShearable)mob).isShearable(shears, this.field_145850_b, mob.func_233580_cy_())) {
                    List items = ((IForgeShearable)mob).onSheared((PlayerEntity)player, shears, this.field_145850_b, mob.func_233580_cy_(), 0);
                    items.forEach(stack -> ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false));
                    if (items.size() > 0) {
                        return new IndustrialWorkingTile.WorkAction(0.35f, this.powerPerOperation);
                    }
                }
                if (!(mob instanceof SquidEntity) || ItemStackUtils.isInventoryFull(this.output) || !this.field_145850_b.field_73012_v.nextBoolean() || !this.field_145850_b.field_73012_v.nextBoolean() || !this.field_145850_b.field_73012_v.nextBoolean() || !this.field_145850_b.field_73012_v.nextBoolean()) continue;
                ItemHandlerHelper.insertItem(this.output, (ItemStack)new ItemStack((IItemProvider)Items.field_222086_lz), (boolean)false);
                return new IndustrialWorkingTile.WorkAction(0.35f, this.powerPerOperation);
            }
        }
        return new IndustrialWorkingTile.WorkAction(1.0f, 0);
    }

    protected EnergyStorageComponent<AnimalRancherTile> createEnergyStorage() {
        return new EnergyStorageComponent(AnimalRancherConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public AnimalRancherTile getSelf() {
        return this;
    }
}

