/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.MobCrusherConfig;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.LangUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.ItemHandlerHelper;

public class MobCrusherTile
extends IndustrialAreaWorkingTile<MobCrusherTile> {
    private final Method GET_EXPERIENCE_POINTS = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"func_70693_a", (Class[])new Class[]{PlayerEntity.class});
    private final Method DROP_SPECIAL_ITEMS = ObfuscationReflectionHelper.findMethod(MobEntity.class, (String)"func_213333_a", (Class[])new Class[]{DamageSource.class, Integer.TYPE, Boolean.TYPE});
    @Save
    private SidedInventoryComponent<MobCrusherTile> output;
    @Save
    private SidedFluidTankComponent<MobCrusherTile> tank;
    @Save
    private boolean dropXP;
    private ButtonComponent buttonComponent;

    public MobCrusherTile() {
        super(ModuleAgricultureHusbandry.MOB_CRUSHER, RangeManager.RangeType.BEHIND, true, MobCrusherConfig.powerPerOperation);
        if (!this.GET_EXPERIENCE_POINTS.isAccessible()) {
            this.GET_EXPERIENCE_POINTS.setAccessible(true);
        }
        if (!this.DROP_SPECIAL_ITEMS.isAccessible()) {
            this.DROP_SPECIAL_ITEMS.setAccessible(true);
        }
        this.dropXP = true;
        this.tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", MobCrusherConfig.tankSize, 43, 20, 0).setColor(DyeColor.LIME).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.ESSENCE.getSourceFluid()));
        this.addTank(this.tank);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 64, 22, 18, 1).setColor(DyeColor.ORANGE).setRange(6, 3).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.buttonComponent = new ButtonComponent(118, 84, 14, 14){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new StateButtonAddon(this, new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{TextFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.mob_crusher.produce", (Object[])new Object[0]), "tooltip.industrialforegoing.mob_crusher.produce_extra"}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{TextFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.mob_crusher.consume", (Object[])new Object[0]), "tooltip.industrialforegoing.mob_crusher.consume_extra"})}){

                    public int getState() {
                        return MobCrusherTile.this.dropXP ? 0 : 1;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.dropXP = !this.dropXP;
            this.markForUpdate();
        });
        this.addButton(this.buttonComponent);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        List mobs;
        if (this.hasEnergy(MobCrusherConfig.powerPerOperation) && (mobs = this.field_145850_b.func_217357_a(MobEntity.class, this.getWorkingArea().func_197752_a()).stream().filter(mobEntity -> !(mobEntity instanceof AnimalEntity && mobEntity.func_70631_g_() || mobEntity.func_190530_aW() || mobEntity instanceof WitherEntity && ((WitherEntity)mobEntity).func_82212_n() > 0)).filter(LivingEntity::func_70089_S).collect(Collectors.toList())).size() > 0) {
            MobEntity entity = (MobEntity)mobs.get(0);
            FakePlayer player = IndustrialForegoing.getFakePlayer(this.field_145850_b);
            int experience = 0;
            try {
                experience = (Integer)this.GET_EXPERIENCE_POINTS.invoke((Object)entity, player);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            int looting = 0;
            if (!this.dropXP) {
                looting = this.field_145850_b.field_73012_v.nextInt(4);
                ItemStack sword = new ItemStack((IItemProvider)Items.field_151048_u);
                EnchantmentHelper.func_82782_a(Collections.singletonMap(Enchantments.field_185304_p, looting), (ItemStack)sword);
                player.func_184611_a(Hand.MAIN_HAND, sword);
            }
            DamageSource source = DamageSource.func_76365_a((PlayerEntity)player);
            LootTable table = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(entity.func_213346_cF());
            LootContext.Builder context = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216023_a(this.field_145850_b.field_73012_v).func_216015_a(LootParameters.field_216281_a, (Object)entity).func_216015_a(LootParameters.field_216283_c, (Object)source).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p())).func_216015_a(LootParameters.field_216284_d, (Object)player).func_216015_a(LootParameters.field_216282_b, (Object)player).func_216021_b(LootParameters.field_216285_e, (Object)player);
            table.func_216113_a(context.func_216022_a(LootParameterSets.field_216263_d)).forEach(stack -> ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false));
            ArrayList extra = new ArrayList();
            ForgeHooks.onLivingDrops((LivingEntity)entity, (DamageSource)source, extra, (int)looting, (boolean)true);
            extra.forEach(itemEntity -> {
                ItemHandlerHelper.insertItem(this.output, (ItemStack)itemEntity.func_92059_d(), (boolean)false);
                itemEntity.remove(false);
            });
            try {
                if (entity.captureDrops() == null) {
                    entity.captureDrops(new ArrayList());
                }
                this.DROP_SPECIAL_ITEMS.invoke((Object)entity, source, looting, true);
                if (entity.captureDrops() != null) {
                    entity.captureDrops().forEach(itemEntity -> {
                        ItemHandlerHelper.insertItem(this.output, (ItemStack)itemEntity.func_92059_d(), (boolean)false);
                        itemEntity.remove(false);
                    });
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (this.dropXP) {
                this.tank.fillForced(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid(), experience * 20), IFluidHandler.FluidAction.EXECUTE);
            }
            entity.func_70606_j(0.0f);
            entity.remove(false);
            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            return new IndustrialWorkingTile.WorkAction(0.1f, MobCrusherConfig.powerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction(1.0f, 0);
    }

    public MobCrusherTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<MobCrusherTile> createEnergyStorage() {
        return new EnergyStorageComponent(MobCrusherConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return MobCrusherConfig.maxProgress;
    }
}

