/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.mycelial;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.DyeColor;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class DisenchantmentGeneratorType
implements IMycelialGeneratorType {
    @Override
    public String getName() {
        return "disenchantment";
    }

    @Override
    public IMycelialGeneratorType.Input[] getInputs() {
        return new IMycelialGeneratorType.Input[]{IMycelialGeneratorType.Input.SLOT};
    }

    @Override
    public List<BiPredicate<ItemStack, Integer>> getSlotInputPredicates() {
        return Arrays.asList((stack, integer) -> stack.func_77948_v() || stack.func_77973_b() instanceof EnchantedBookItem);
    }

    @Override
    public List<Predicate<FluidStack>> getTankInputPredicates() {
        return new ArrayList<Predicate<FluidStack>>();
    }

    @Override
    public boolean canStart(INBTSerializable<CompoundNBT>[] inputs) {
        return inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).func_190916_E() > 0 && this.getSlotInputPredicates().get(0).test(((SidedInventoryComponent)inputs[0]).getStackInSlot(0), 0);
    }

    @Override
    public Pair<Integer, Integer> getTimeAndPowerGeneration(INBTSerializable<CompoundNBT>[] inputs) {
        if (inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).func_190916_E() > 0) {
            ItemStack itemstack = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).func_77946_l();
            if (itemstack.func_77973_b().equals(Items.field_151134_bR)) {
                ((SidedInventoryComponent)inputs[0]).setStackInSlot(0, new ItemStack((IItemProvider)Items.field_151122_aG));
            } else {
                ((SidedInventoryComponent)inputs[0]).setStackInSlot(0, new ItemStack((IItemProvider)itemstack.func_77973_b()));
            }
            return this.calculate(itemstack);
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public DyeColor[] getInputColors() {
        return new DyeColor[]{DyeColor.LIME};
    }

    @Override
    public Item getDisplay() {
        return Items.field_151134_bR;
    }

    @Override
    public int getSlotSize() {
        return 1;
    }

    @Override
    public List<MycelialGeneratorRecipe> getRecipes() {
        ArrayList<MycelialGeneratorRecipe> recipes = new ArrayList<MycelialGeneratorRecipe>();
        for (Enchantment value : ForgeRegistries.ENCHANTMENTS.getValues()) {
            for (int i = value.func_77319_d(); i <= value.func_77325_b(); ++i) {
                HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
                map.put(value, i);
                ItemStack book = new ItemStack((IItemProvider)Items.field_151134_bR);
                EnchantmentHelper.func_82782_a(map, (ItemStack)book);
                Pair<Integer, Integer> power = this.calculate(book);
                recipes.add(new MycelialGeneratorRecipe(Collections.singletonList(Collections.singletonList(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{book}))), new ArrayList<List<FluidStack>>(), (Integer)power.getLeft(), (Integer)power.getRight()));
            }
        }
        return recipes;
    }

    private Pair<Integer, Integer> calculate(ItemStack stack) {
        Map ench = EnchantmentHelper.func_82781_a((ItemStack)stack);
        int rarity = 0;
        double level = 0.0;
        for (Map.Entry enchEntry : ench.entrySet()) {
            rarity += 14 - ((Enchantment)enchEntry.getKey()).func_77324_c().func_185270_a();
            level += (double)((Integer)enchEntry.getValue()).intValue() / (double)((Enchantment)enchEntry.getKey()).func_77325_b();
        }
        return Pair.of((Object)(rarity * 80), (Object)((int)(160.0 * level)));
    }

    @Override
    public ShapedRecipeBuilder addIngredients(ShapedRecipeBuilder recipeBuilder) {
        recipeBuilder = recipeBuilder.func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151122_aG).func_200462_a(Character.valueOf('C'), (IItemProvider)Blocks.field_222427_lP).func_200469_a(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_ADVANCED);
        return recipeBuilder;
    }
}

