/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.mycelial;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FireworkGeneratorType
implements IMycelialGeneratorType {
    @Override
    public String getName() {
        return "rocket";
    }

    @Override
    public IMycelialGeneratorType.Input[] getInputs() {
        return new IMycelialGeneratorType.Input[]{IMycelialGeneratorType.Input.SLOT};
    }

    @Override
    public List<BiPredicate<ItemStack, Integer>> getSlotInputPredicates() {
        return Arrays.asList((stack, slot) -> stack.func_77973_b() instanceof FireworkRocketItem && stack.func_77942_o());
    }

    @Override
    public List<Predicate<FluidStack>> getTankInputPredicates() {
        return new ArrayList<Predicate<FluidStack>>();
    }

    @Override
    public boolean canStart(INBTSerializable<CompoundNBT>[] inputs) {
        return inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).func_190916_E() > 0;
    }

    @Override
    public Pair<Integer, Integer> getTimeAndPowerGeneration(INBTSerializable<CompoundNBT>[] inputs) {
        if (inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).func_190916_E() > 0) {
            ItemStack stack = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0);
            stack.func_190918_g(1);
            return this.calculate(stack);
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public DyeColor[] getInputColors() {
        return new DyeColor[]{DyeColor.RED};
    }

    @Override
    public Item getDisplay() {
        return Items.field_196152_dE;
    }

    @Override
    public int getSlotSize() {
        return 64;
    }

    @Override
    public List<MycelialGeneratorRecipe> getRecipes() {
        return new ArrayList<MycelialGeneratorRecipe>();
    }

    private Pair<Integer, Integer> calculate(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("Fireworks");
        int flight = nbt.func_74762_e("Flight");
        double power = 1.0;
        ListNBT listnbt = nbt.func_150295_c("Explosions", 10);
        if (!listnbt.isEmpty()) {
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compound = listnbt.func_150305_b(i);
                FireworkRocketItem.Shape shape = FireworkRocketItem.Shape.func_196070_a((int)compound.func_74771_c("Type"));
                power *= this.getShapeModifier(shape);
                int[] colors = compound.func_74759_k("Colors");
                power *= 1.0 + (double)colors.length / 100.0;
                int[] fadeColors = compound.func_74759_k("FadeColors");
                power *= 1.0 + (double)fadeColors.length / 90.0;
                if (compound.func_74767_n("Trail")) {
                    power *= 1.6;
                }
                if (!compound.func_74767_n("Flicker")) continue;
                power *= 1.4;
            }
        }
        return Pair.of((Object)((int)(80.0 * power)), (Object)(60 * flight));
    }

    private double getShapeModifier(FireworkRocketItem.Shape shape) {
        switch (shape) {
            case STAR: {
                return 1.2;
            }
            case BURST: {
                return 1.05;
            }
            case CREEPER: {
                return 1.5;
            }
            case LARGE_BALL: {
                return 1.1;
            }
        }
        return 1.01;
    }

    @Override
    public ShapedRecipeBuilder addIngredients(ShapedRecipeBuilder recipeBuilder) {
        recipeBuilder = recipeBuilder.func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151016_H).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_151121_aF).func_200469_a(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_ADVANCED);
        return recipeBuilder;
    }

    @Override
    public void onTick(World world, BlockPos pos) {
        AxisAlignedBB area = new AxisAlignedBB((double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() - 3), (double)(pos.func_177952_p() - 3), (double)(pos.func_177958_n() + 3), (double)(pos.func_177956_o() + 3), (double)(pos.func_177952_p() + 3));
        for (LivingEntity livingEntity : world.func_217357_a(LivingEntity.class, area)) {
            livingEntity.func_195064_c(new EffectInstance(Effects.field_188424_y, 10, 2));
        }
    }
}

