/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.tile;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.block.generator.mycelial.MycelialDataManager;
import com.buuz135.industrial.block.tile.IndustrialGeneratorTile;
import com.buuz135.industrial.gui.component.GeneratorBackgroundScreenAddon;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.tuple.Pair;

public class MycelialGeneratorTile
extends IndustrialGeneratorTile<MycelialGeneratorTile> {
    @Save
    private int powerGeneration;
    private IMycelialGeneratorType type;
    private INBTSerializable<CompoundNBT>[] inputs;
    private ProgressBarComponent<MycelialGeneratorTile> bar;
    @Save
    private String owner;

    public MycelialGeneratorTile(BasicTileBlock<MycelialGeneratorTile> basicTileBlock, IMycelialGeneratorType type) {
        super(basicTileBlock);
        this.type = type;
        this.powerGeneration = 10;
        this.inputs = new INBTSerializable[this.type.getInputs().length];
        this.addGuiAddonFactory(() -> new GeneratorBackgroundScreenAddon(128, 39, type));
        for (int i = 0; i < this.type.getInputs().length; ++i) {
            SidedInventoryComponent slot;
            if (this.type.getInputs()[i] == IMycelialGeneratorType.Input.SLOT) {
                slot = (SidedInventoryComponent)new SidedInventoryComponent(this.type.getName() + ".input_" + i, 44 + i * 21, 22, 1, i).setColor(this.type.getInputColors()[i]).setInputFilter(this.type.getSlotInputPredicates().get(i)).setSlotLimit(type.getSlotSize());
                this.addInventory((InventoryComponent)slot);
                this.inputs[i] = slot;
                continue;
            }
            if (this.type.getInputs()[i] != IMycelialGeneratorType.Input.TANK) continue;
            slot = (SidedFluidTankComponent)new SidedFluidTankComponent(this.type.getName() + ".input_" + i, 8000, 44 + i * 21, 20, i).setColor(this.type.getInputColors()[i]).setTankAction(FluidTankComponent.Action.FILL).setValidator(this.type.getTankInputPredicates().get(i));
            this.addTank((FluidTankComponent)slot);
            this.inputs[i] = slot;
        }
    }

    public int consumeFuel() {
        Pair<Integer, Integer> inputs = this.type.getTimeAndPowerGeneration(this.inputs);
        this.powerGeneration = (Integer)inputs.getRight();
        return (Integer)inputs.getKey();
    }

    public boolean canStart() {
        return this.type.canStart(this.inputs);
    }

    public int getEnergyProducedEveryTick() {
        return this.powerGeneration;
    }

    public ProgressBarComponent<MycelialGeneratorTile> getProgressBar() {
        this.bar = new ProgressBarComponent<MycelialGeneratorTile>(30, 20, 0, 100){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon(30, 20, MycelialGeneratorTile.this.bar){

                    public List<ITextComponent> getTooltipLines() {
                        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.titanium.progressbar.progress").getString() + TextFormatting.WHITE + new DecimalFormat().format(MycelialGeneratorTile.this.bar.getProgress()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(MycelialGeneratorTile.this.bar.getMaxProgress())));
                        int progress = MycelialGeneratorTile.this.bar.getMaxProgress() - MycelialGeneratorTile.this.bar.getProgress();
                        if (!MycelialGeneratorTile.this.bar.getIncreaseType()) {
                            progress = MycelialGeneratorTile.this.bar.getMaxProgress() - progress;
                        }
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "ETA: " + TextFormatting.WHITE + new DecimalFormat().format(Math.ceil((double)(progress * MycelialGeneratorTile.this.bar.getTickingTime()) / 20.0 / (double)MycelialGeneratorTile.this.bar.getProgressIncrease())) + TextFormatting.DARK_AQUA + "s"));
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.industrialforegoing.generating").getString() + TextFormatting.WHITE + MycelialGeneratorTile.this.powerGeneration + TextFormatting.DARK_AQUA + " FE" + TextFormatting.GOLD + "/" + TextFormatting.WHITE + TextFormatting.DARK_AQUA + "t"));
                        return tooltip;
                    }
                });
            }
        }.setComponentHarness((IComponentHarness)this).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.CYAN);
        return this.bar;
    }

    public void func_73660_a() {
        if (this.isServer() && this.bar.getCanIncrease().test(this) && (this.bar.getProgress() != 0 || this.canStart()) && this.field_145850_b.func_82737_E() % 5L == 0L) {
            MycelialDataManager.setGeneratorInfo(this.owner, this.field_145850_b, this.field_174879_c, this.type);
            this.type.onTick(this.field_145850_b, this.field_174879_c);
        }
        super.func_73660_a();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        for (int i = 0; i < this.inputs.length; ++i) {
            compound.func_218657_a("input_" + i, this.inputs[i].serializeNBT());
        }
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i].deserializeNBT((INBT)compound.func_74775_l("input_" + i));
        }
        super.func_230337_a_(state, compound);
    }

    public int getEnergyCapacity() {
        return 100000;
    }

    public int getExtractingEnergy() {
        return 100000;
    }

    @Nonnull
    public MycelialGeneratorTile getSelf() {
        return this;
    }

    public boolean isSmart() {
        return true;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }
}

