/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.tile;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.block.generator.mycelial.MycelialDataManager;
import com.buuz135.industrial.block.tile.IndustrialGeneratorTile;
import com.buuz135.industrial.module.ModuleGenerator;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.DyeColor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class MycelialReactorTile
extends IndustrialGeneratorTile<MycelialReactorTile> {
    @Save
    private String owner;
    private ProgressBarComponent<MycelialReactorTile> bar;

    public MycelialReactorTile() {
        super(ModuleGenerator.MYCELIAL_REACTOR);
    }

    @Nonnull
    public MycelialReactorTile getSelf() {
        return this;
    }

    public int consumeFuel() {
        MycelialDataManager.getReactorAvailable(this.owner, this.field_145850_b, true);
        return 5;
    }

    public boolean canStart() {
        int amount = MycelialDataManager.getReactorAvailable(this.owner, this.field_145850_b, false).size();
        if (amount == IMycelialGeneratorType.TYPES.size()) {
            MycelialDataManager.getReactorAvailable(this.owner, this.field_145850_b, true);
            return true;
        }
        this.markForUpdate();
        return false;
    }

    public int getEnergyProducedEveryTick() {
        return 25000000;
    }

    public ProgressBarComponent<MycelialReactorTile> getProgressBar() {
        this.bar = new ProgressBarComponent<MycelialReactorTile>(30, 20, 0, 100){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon(30, 20, MycelialReactorTile.this.bar){

                    public List<ITextComponent> getTooltipLines() {
                        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.titanium.progressbar.progress").getString() + TextFormatting.WHITE + new DecimalFormat().format(MycelialReactorTile.this.bar.getProgress()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(MycelialReactorTile.this.bar.getMaxProgress())));
                        int progress = MycelialReactorTile.this.bar.getMaxProgress() - MycelialReactorTile.this.bar.getProgress();
                        if (!MycelialReactorTile.this.bar.getIncreaseType()) {
                            progress = MycelialReactorTile.this.bar.getMaxProgress() - progress;
                        }
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "ETA: " + TextFormatting.WHITE + new DecimalFormat().format(Math.ceil((double)(progress * MycelialReactorTile.this.bar.getTickingTime()) / 20.0 / (double)MycelialReactorTile.this.bar.getProgressIncrease())) + TextFormatting.DARK_AQUA + "s"));
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.industrialforegoing.generating").getString() + TextFormatting.WHITE + new DecimalFormat().format(MycelialReactorTile.this.getEnergyProducedEveryTick()) + TextFormatting.DARK_AQUA + " FE" + TextFormatting.GOLD + "/" + TextFormatting.WHITE + TextFormatting.DARK_AQUA + "t"));
                        return tooltip;
                    }
                });
            }
        }.setComponentHarness((IComponentHarness)this).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.CYAN);
        return this.bar;
    }

    public int getEnergyCapacity() {
        return 100000000;
    }

    public int getExtractingEnergy() {
        return this.getEnergyCapacity();
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ProgressBarComponent<MycelialReactorTile> getBar() {
        return this.bar;
    }
}

