/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.resourceproduction.FluidCollectorConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidCollectorTile
extends IndustrialAreaWorkingTile<FluidCollectorTile> {
    private int getMaxProgress;
    private int getPowerPerOperation;
    @Save
    private SidedFluidTankComponent<FluidCollectorTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("output", FluidCollectorConfig.maxOutputTankSize, 43, 20, 0).setColor(DyeColor.ORANGE).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this);

    public FluidCollectorTile() {
        super(ModuleResourceProduction.FLUID_COLLECTOR, RangeManager.RangeType.BEHIND, false, FluidCollectorConfig.powerPerOperation);
        this.addTank(this.tank);
        this.getMaxProgress = FluidCollectorConfig.maxProgress;
        this.getPowerPerOperation = FluidCollectorConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.getPowerPerOperation) && this.isLoaded(this.getPointedBlockPos()) && !this.field_145850_b.func_175623_d(this.getPointedBlockPos()) && BlockUtils.canBlockBeBroken(this.field_145850_b, this.getPointedBlockPos()) && this.field_145850_b.func_204610_c(this.getPointedBlockPos()).func_206889_d()) {
            Fluid fluid = this.field_145850_b.func_204610_c(this.getPointedBlockPos()).func_206886_c();
            if (this.tank.isEmpty() || this.tank.getFluid().getFluid().func_207187_a(fluid) && this.tank.getFluidAmount() + 1000 <= this.tank.getCapacity()) {
                if (this.field_145850_b.func_180495_p(this.getPointedBlockPos()).func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                    this.field_145850_b.func_175656_a(this.getPointedBlockPos(), (BlockState)this.field_145850_b.func_180495_p(this.getPointedBlockPos()).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
                } else {
                    this.field_145850_b.func_175656_a(this.getPointedBlockPos(), Blocks.field_150350_a.func_176223_P());
                }
                this.tank.fillForced(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                this.increasePointer();
                return new IndustrialWorkingTile.WorkAction(1.0f, this.getPowerPerOperation);
            }
        }
        this.increasePointer();
        return new IndustrialWorkingTile.WorkAction(1.0f, 0);
    }

    protected EnergyStorageComponent<FluidCollectorTile> createEnergyStorage() {
        return new EnergyStorageComponent(FluidCollectorConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }

    @Nonnull
    public FluidCollectorTile getSelf() {
        return this;
    }
}

