/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.MaterialStoneWorkFactoryConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.CraftingUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.BasicButtonAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.AssetUtil;
import com.hrznstudio.titanium.util.LangUtil;
import com.hrznstudio.titanium.util.RecipeUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class MaterialStoneWorkFactoryTile
extends IndustrialProcessingTile<MaterialStoneWorkFactoryTile> {
    private int maxProgress;
    private int powerPerOperation;
    private static GeneratorRecipe[] GENERATOR_RECIPES = new GeneratorRecipe[]{new GeneratorRecipe(new ItemStack((IItemProvider)Blocks.field_150347_e), 1000, 1000, 0, 0), new GeneratorRecipe(new ItemStack((IItemProvider)Blocks.field_150424_aL), 250, 400, 250, 200), new GeneratorRecipe(new ItemStack((IItemProvider)Blocks.field_150343_Z), 1000, 1000, 0, 1000), new GeneratorRecipe(new ItemStack((IItemProvider)Blocks.field_196650_c), 200, 200, 200, 200), new GeneratorRecipe(new ItemStack((IItemProvider)Blocks.field_196654_e), 200, 250, 200, 250), new GeneratorRecipe(new ItemStack((IItemProvider)Blocks.field_196656_g), 300, 300, 300, 300)};
    private static StoneWorkAction[] ACTION_RECIPES = new StoneWorkAction[]{new StoneWorkAction(new ItemStack((IItemProvider)Blocks.field_150460_al), (world1, itemStack) -> {
        FurnaceRecipe recipe = RecipeUtil.getSmelingRecipeFor((World)world1, (ItemStack)itemStack);
        if (recipe != null) {
            return recipe.func_77571_b();
        }
        return ItemStack.field_190927_a;
    }, 1, "smelt"), new StoneWorkAction(new ItemStack((IItemProvider)Items.field_151046_w), (world1, stack) -> CraftingUtils.getCrushOutput(stack), 1, "crush"), new StoneWorkAction(new ItemStack((IItemProvider)Blocks.field_196662_n), (world1, stack) -> CraftingUtils.findOutput(2, stack, world1), 4, "small_craft"), new StoneWorkAction(new ItemStack((IItemProvider)Blocks.field_150462_ai), (world1, stack) -> CraftingUtils.findOutput(3, stack, world1), 9, "big_craft"), new StoneWorkAction(new ItemStack((IItemProvider)Blocks.field_180401_cv), (world1, stack) -> ItemStack.field_190927_a, 0, "none")};
    @Save
    private SidedFluidTankComponent<MaterialStoneWorkFactoryTile> water = (SidedFluidTankComponent)new SidedFluidTankComponent("water", MaterialStoneWorkFactoryConfig.maxWaterTankSize, 30, 23, 0).setColor(DyeColor.BLUE).setTankType(FluidTankComponent.Type.SMALL).setTankAction(FluidTankComponent.Action.FILL).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204546_a));
    @Save
    private SidedFluidTankComponent<MaterialStoneWorkFactoryTile> lava;
    @Save
    private SidedInventoryComponent<MaterialStoneWorkFactoryTile> inventoryGenerator;
    @Save
    private int generatorRecipeId;
    @Save
    private SidedInventoryComponent<MaterialStoneWorkFactoryTile> inventoryFirst;
    @Save
    private int firstRecipeId;
    @Save
    private SidedInventoryComponent<MaterialStoneWorkFactoryTile> inventorySecond;
    @Save
    private int secondRecipeId;
    @Save
    private SidedInventoryComponent<MaterialStoneWorkFactoryTile> inventoryThird;
    @Save
    private int thirdRecipeId;

    public MaterialStoneWorkFactoryTile() {
        super(ModuleResourceProduction.MATERIAL_STONEWORK_FACTORY, 52, 40);
        this.addTank(this.water);
        this.lava = (SidedFluidTankComponent)new SidedFluidTankComponent("lava", MaterialStoneWorkFactoryConfig.maxLavaTankSize, 30, 55, 1).setColor(DyeColor.ORANGE).setTankType(FluidTankComponent.Type.SMALL).setTankAction(FluidTankComponent.Action.FILL).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204547_b));
        this.addTank(this.lava);
        this.generatorRecipeId = 0;
        this.addButton(new ButtonComponent(54, 64, 18, 18){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        AssetUtil.drawAsset((MatrixStack)stack, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                        Minecraft.func_71410_x().func_175599_af().func_175042_a(GENERATOR_RECIPES[MaterialStoneWorkFactoryTile.this.generatorRecipeId].output, guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                        RenderHelper.func_74518_a();
                        RenderSystem.enableAlphaTest();
                    }

                    public List<ITextComponent> getTooltipLines() {
                        GeneratorRecipe recipe = GENERATOR_RECIPES[MaterialStoneWorkFactoryTile.this.generatorRecipeId];
                        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
                        lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.generating", (Object[])new Object[0]) + TextFormatting.WHITE + recipe.output.func_200301_q().getString()));
                        lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.needs", (Object[])new Object[0])));
                        lines.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + " - " + TextFormatting.WHITE + recipe.needsWater + TextFormatting.DARK_AQUA + LangUtil.getString((String)"tooltip.industrialforegoing.mb_of", (Object[])new Object[]{LangUtil.getString((String)"block.minecraft.water", (Object[])new Object[0])})));
                        lines.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + " - " + TextFormatting.WHITE + recipe.needsLava + TextFormatting.DARK_AQUA + LangUtil.getString((String)"tooltip.industrialforegoing.mb_of", (Object[])new Object[]{LangUtil.getString((String)"block.minecraft.lava", (Object[])new Object[0])})));
                        lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.consumes", (Object[])new Object[0])));
                        lines.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + " - " + TextFormatting.WHITE + recipe.consumeWater + TextFormatting.DARK_AQUA + LangUtil.getString((String)"tooltip.industrialforegoing.mb_of", (Object[])new Object[]{LangUtil.getString((String)"block.minecraft.water", (Object[])new Object[0])})));
                        lines.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + " - " + TextFormatting.WHITE + recipe.consumeLava + TextFormatting.DARK_AQUA + LangUtil.getString((String)"tooltip.industrialforegoing.mb_of", (Object[])new Object[]{LangUtil.getString((String)"block.minecraft.lava", (Object[])new Object[0])})));
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.generatorRecipeId = (this.generatorRecipeId + 1) % GENERATOR_RECIPES.length;
            this.markForUpdate();
        }));
        this.inventoryGenerator = (SidedInventoryComponent)new SidedInventoryComponent("inventoryGenerator", 80, 23, 2, 2).setColor(DyeColor.LIME).setSlotPosition(integer -> integer == 0 ? Pair.of((Object)0, (Object)0) : Pair.of((Object)0, (Object)18)).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inventoryGenerator);
        this.inventoryFirst = (SidedInventoryComponent)new SidedInventoryComponent("inventoryFirst", 103, 23, 2, 3).setColor(DyeColor.CYAN).setSlotPosition(integer -> integer == 0 ? Pair.of((Object)0, (Object)0) : Pair.of((Object)0, (Object)18)).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inventoryFirst);
        this.inventorySecond = (SidedInventoryComponent)new SidedInventoryComponent("inventorySecond", 126, 23, 2, 4).setColor(DyeColor.YELLOW).setSlotPosition(integer -> integer == 0 ? Pair.of((Object)0, (Object)0) : Pair.of((Object)0, (Object)18)).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inventorySecond);
        this.inventoryThird = (SidedInventoryComponent)new SidedInventoryComponent("inventoryThird", 149, 23, 2, 5).setColor(DyeColor.RED).setSlotPosition(integer -> integer == 0 ? Pair.of((Object)0, (Object)0) : Pair.of((Object)0, (Object)18)).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inventoryThird);
        this.firstRecipeId = 0;
        this.secondRecipeId = 0;
        this.thirdRecipeId = 0;
        this.addButton(new ButtonComponent(90, 64, 18, 18){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        AssetUtil.drawAsset((MatrixStack)stack, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                        Minecraft.func_71410_x().func_175599_af().func_175042_a(ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.firstRecipeId].icon, guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                        RenderHelper.func_74518_a();
                        RenderSystem.enableAlphaTest();
                    }

                    public List<ITextComponent> getTooltipLines() {
                        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
                        lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.action", (Object[])new Object[0]) + TextFormatting.WHITE + LangUtil.getString((String)("tooltip.industrialforegoing.stonework." + ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.firstRecipeId].getAction()), (Object[])new Object[0])));
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.firstRecipeId = (this.firstRecipeId + 1) % ACTION_RECIPES.length;
            this.markForUpdate();
        }));
        this.addButton(new ButtonComponent(113, 64, 18, 18){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        AssetUtil.drawAsset((MatrixStack)stack, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                        Minecraft.func_71410_x().func_175599_af().func_175042_a(ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.secondRecipeId].icon, guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                        RenderHelper.func_74518_a();
                        RenderSystem.enableAlphaTest();
                    }

                    public List<ITextComponent> getTooltipLines() {
                        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
                        lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.action", (Object[])new Object[0]) + TextFormatting.WHITE + LangUtil.getString((String)("tooltip.industrialforegoing.stonework." + ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.secondRecipeId].getAction()), (Object[])new Object[0])));
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.secondRecipeId = (this.secondRecipeId + 1) % ACTION_RECIPES.length;
            this.markForUpdate();
        }));
        this.addButton(new ButtonComponent(136, 64, 18, 18){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        AssetUtil.drawAsset((MatrixStack)stack, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                        Minecraft.func_71410_x().func_175599_af().func_175042_a(ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.thirdRecipeId].icon, guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                        RenderHelper.func_74518_a();
                        RenderSystem.enableAlphaTest();
                    }

                    public List<ITextComponent> getTooltipLines() {
                        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
                        lines.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.action", (Object[])new Object[0]) + TextFormatting.WHITE + LangUtil.getString((String)("tooltip.industrialforegoing.stonework." + ACTION_RECIPES[MaterialStoneWorkFactoryTile.this.thirdRecipeId].getAction()), (Object[])new Object[0])));
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.thirdRecipeId = (this.thirdRecipeId + 1) % ACTION_RECIPES.length;
            this.markForUpdate();
        }));
        this.maxProgress = MaterialStoneWorkFactoryConfig.maxProgress;
        this.powerPerOperation = MaterialStoneWorkFactoryConfig.powerPerTick;
    }

    protected EnergyStorageComponent<MaterialStoneWorkFactoryTile> createEnergyStorage() {
        return new EnergyStorageComponent(MaterialStoneWorkFactoryConfig.maxStoredPower, 10, 20);
    }

    @Override
    public boolean canIncrease() {
        return GENERATOR_RECIPES[this.generatorRecipeId].canIncrease.test(this.water, this.lava);
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            GeneratorRecipe recipe;
            ItemStack output;
            if (!this.process(this.inventorySecond, this.inventoryThird, ACTION_RECIPES[this.thirdRecipeId]) && !this.process(this.inventoryFirst, this.inventorySecond, ACTION_RECIPES[this.secondRecipeId]) && !this.process(this.inventoryGenerator, this.inventoryFirst, ACTION_RECIPES[this.firstRecipeId]) && ItemHandlerHelper.insertItem(this.inventoryGenerator, (ItemStack)(output = (recipe = GENERATOR_RECIPES[this.generatorRecipeId]).output.func_77946_l()), (boolean)false).func_190926_b()) {
                recipe.consume.accept(this.water, this.lava);
            }
        };
    }

    @Override
    protected int getTickPower() {
        return this.powerPerOperation;
    }

    private boolean process(SidedInventoryComponent input, SidedInventoryComponent output, StoneWorkAction action) {
        for (int slot = 0; slot < input.getSlots(); ++slot) {
            ItemStack outputStack;
            ItemStack inputStack = input.getStackInSlot(slot);
            if (inputStack.func_190926_b() || (outputStack = ((ItemStack)action.work.apply(this.field_145850_b, inputStack.func_77946_l())).func_77946_l()).func_190926_b() || !ItemHandlerHelper.insertItem((IItemHandler)output, (ItemStack)outputStack, (boolean)true).func_190926_b()) continue;
            ItemHandlerHelper.insertItem((IItemHandler)output, (ItemStack)outputStack, (boolean)false);
            inputStack.func_190918_g(action.getShrinkAmount());
            return true;
        }
        return false;
    }

    @Nonnull
    public MaterialStoneWorkFactoryTile getSelf() {
        return this;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    private static class StoneWorkAction {
        private final ItemStack icon;
        private final BiFunction<World, ItemStack, ItemStack> work;
        private final int shrinkAmount;
        private final String action;

        private StoneWorkAction(ItemStack icon, BiFunction<World, ItemStack, ItemStack> work, int shrinkAmount, String action) {
            this.icon = icon;
            this.work = work;
            this.shrinkAmount = shrinkAmount;
            this.action = action;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public BiFunction<World, ItemStack, ItemStack> getWork() {
            return this.work;
        }

        public int getShrinkAmount() {
            return this.shrinkAmount;
        }

        public String getAction() {
            return this.action;
        }
    }

    private static class GeneratorRecipe {
        private ItemStack output;
        private BiPredicate<FluidTank, FluidTank> canIncrease;
        private BiConsumer<FluidTankComponent, FluidTankComponent> consume;
        private int needsWater;
        private int needsLava;
        private int consumeWater;
        private int consumeLava;

        public GeneratorRecipe(ItemStack output, int needsWater, int needsLava, int consumeWater, int consumeLava) {
            this.output = output;
            this.needsWater = needsWater;
            this.needsLava = needsLava;
            this.consumeWater = consumeWater;
            this.consumeLava = consumeLava;
            this.canIncrease = (fluidTank, fluidTank2) -> fluidTank.getFluidAmount() >= needsWater && fluidTank2.getFluidAmount() >= needsLava;
            this.consume = (fluidTank, fluidTank2) -> {
                fluidTank.drainForced(consumeWater, IFluidHandler.FluidAction.EXECUTE);
                fluidTank2.drainForced(consumeLava, IFluidHandler.FluidAction.EXECUTE);
            };
        }
    }
}

