/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.ResourcefulFurnaceConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.util.InventoryUtil;
import com.hrznstudio.titanium.util.ItemHandlerUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemHandlerHelper;

public class PotionBrewerTile
extends IndustrialProcessingTile<PotionBrewerTile> {
    @Save
    private SidedFluidTankComponent<PotionBrewerTile> water = (SidedFluidTankComponent)new SidedFluidTankComponent("water", 1000, 75, 40, 0).setColor(DyeColor.CYAN).setTankAction(FluidTankComponent.Action.FILL).setTankType(FluidTankComponent.Type.SMALL).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204546_a));
    @Save
    private ProgressBarComponent<PotionBrewerTile> blaze;
    @Save
    private SidedInventoryComponent<PotionBrewerTile> blazeInput;
    @Save
    private SidedInventoryComponent<PotionBrewerTile> bottleInput;
    @Save
    private SidedInventoryComponent<PotionBrewerTile> brewingItems;
    @Save
    private SidedInventoryComponent<PotionBrewerTile> output;
    @Save
    private int state = 0;

    public PotionBrewerTile() {
        super(ModuleResourceProduction.POTION_BREWER, 100, 38);
        this.addTank(this.water);
        this.blaze = new ProgressBarComponent<PotionBrewerTile>(30, 20, 100){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<PotionBrewerTile>(30, 20, (ProgressBarComponent)this){

                    public List<ITextComponent> getTooltipLines() {
                        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Blaze Fuel: " + TextFormatting.WHITE + new DecimalFormat().format(PotionBrewerTile.this.blaze.getProgress()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(PotionBrewerTile.this.blaze.getMaxProgress())));
                        return tooltip;
                    }
                });
            }
        }.setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.ORANGE).setCanReset(potionBrewerTile -> false).setCanIncrease(iComponentHarness -> false);
        this.addProgressBar(this.blaze);
        this.blazeInput = (SidedInventoryComponent)new SidedInventoryComponent("blazeInput", 45, 61, 1, 2).setColor(DyeColor.ORANGE).setInputFilter((stack, integer) -> stack.func_77973_b().equals(Items.field_151065_br)).setOutputFilter((stack, integer) -> false).setSlotToItemStackRender(0, new ItemStack((IItemProvider)Items.field_151065_br));
        this.addInventory((InventoryComponent)this.blazeInput);
        this.bottleInput = (SidedInventoryComponent)new SidedInventoryComponent("bottleInput", 123, 42, 1, 1).setColor(DyeColor.YELLOW).setInputFilter((stack, integer) -> stack.func_77973_b().equals(Items.field_151069_bo)).setOutputFilter((stack, integer) -> false).setSlotToItemStackRender(0, new ItemStack((IItemProvider)Items.field_151069_bo));
        this.addInventory((InventoryComponent)this.bottleInput);
        this.brewingItems = (SidedInventoryComponent)new SidedInventoryComponent("brewingInput", 55, 19, 6, 3).setColor(DyeColor.BLUE).setInputFilter((stack, integer) -> true).setOutputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.brewingItems);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 82, 64, 3, 4).setColor(DyeColor.MAGENTA).setInputFilter((stack, integer) -> false).setOutputFilter((stack, integer) -> true);
        this.addInventory((InventoryComponent)this.output);
    }

    @Override
    public boolean canIncrease() {
        if (this.blaze.getProgress() + 20 <= this.blaze.getMaxProgress() && !this.blazeInput.getStackInSlot(0).func_190926_b()) {
            this.blazeInput.getStackInSlot(0).func_190918_g(1);
            this.blaze.setProgress(this.blaze.getProgress() + 20);
        }
        if (ItemHandlerUtil.isEmpty(this.output)) {
            this.state = 0;
        }
        if (this.state == 0) {
            return this.water.getFluidAmount() == 1000 && !this.bottleInput.getStackInSlot(0).func_190926_b();
        }
        return this.canBrew(this.state - 1) && this.blaze.getProgress() > 0;
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            if (this.state == 0) {
                int bottleAmount = Math.min(3, this.bottleInput.getStackInSlot(0).func_190916_E());
                for (int i = 0; i < bottleAmount; ++i) {
                    ItemHandlerHelper.insertItem(this.output, (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b), (boolean)false);
                    this.bottleInput.getStackInSlot(0).func_190918_g(1);
                }
                ++this.state;
            } else {
                this.brewPotions(this.state - 1);
                this.blaze.setProgress(this.blaze.getProgress() - 1);
                ++this.state;
                if (this.state > 7) {
                    this.state = 1;
                }
            }
        };
    }

    @Override
    public ProgressBarComponent.BarDirection getBarDirection() {
        return ProgressBarComponent.BarDirection.ARROW_DOWN;
    }

    @Override
    protected int getTickPower() {
        return 80;
    }

    public PotionBrewerTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<PotionBrewerTile> createEnergyStorage() {
        return new EnergyStorageComponent(ResourcefulFurnaceConfig.maxStoredPower, 10, 20);
    }

    private boolean canBrew(int slot) {
        int i;
        ItemStack ingredient = this.brewingItems.getStackInSlot(slot);
        NonNullList input = NonNullList.func_191196_a();
        input.addAll((Collection)InventoryUtil.getStacks(this.output));
        int[] indices = new int[input.size()];
        for (i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        if (!ingredient.func_190926_b()) {
            return BrewingRecipeRegistry.canBrew((NonNullList)input, (ItemStack)ingredient, (int[])indices);
        }
        if (ingredient.func_190926_b()) {
            return false;
        }
        if (!PotionBrewing.func_185205_a((ItemStack)ingredient)) {
            return false;
        }
        for (i = 0; i < 3; ++i) {
            ItemStack itemstack1 = this.output.getStackInSlot(i);
            if (itemstack1.func_190926_b() || !PotionBrewing.func_185208_a((ItemStack)itemstack1, (ItemStack)ingredient)) continue;
            return true;
        }
        return false;
    }

    private void brewPotions(int slot) {
        NonNullList input = NonNullList.func_191196_a();
        input.addAll((Collection)InventoryUtil.getStacks(this.output));
        int[] indices = new int[input.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        ItemStack ingredient = this.brewingItems.getStackInSlot(slot);
        input.add((Object)ingredient);
        if (ForgeEventFactory.onPotionAttemptBrew((NonNullList)input)) {
            return;
        }
        BrewingRecipeRegistry.brewPotions((NonNullList)input, (ItemStack)ingredient, (int[])indices);
        ingredient.func_190918_g(1);
        ForgeEventFactory.onPotionBrewed((NonNullList)input);
        for (int i : indices) {
            this.output.setStackInSlot(i, (ItemStack)input.get(i));
        }
    }
}

