/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transport.conveyor;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.IConveyorContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.block.transport.ConveyorBlock;
import com.buuz135.industrial.gui.component.FilterGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.TextGuiComponent;
import com.buuz135.industrial.gui.component.TextureGuiComponent;
import com.buuz135.industrial.gui.component.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransport;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.google.common.collect.ImmutableSet;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class ConveyorBouncingUpgrade
extends ConveyorUpgrade {
    public static VoxelShape BB = VoxelShapes.func_197873_a((double)0.1875, (double)0.0625, (double)0.1875, (double)0.8125, (double)0.075, (double)0.8125);
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 3, 3);
    private boolean whitelist = false;
    private double velocityVertical = 1.0;
    private double velocityHorizontal = 1.0;

    public ConveyorBouncingUpgrade(IConveyorContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
    }

    @Override
    public void handleEntity(Entity entity) {
        super.handleEntity(entity);
        if (this.whitelist != this.filter.matches(entity)) {
            return;
        }
        Direction direction = (Direction)this.getContainer().getConveyorWorld().func_180495_p(this.getContainer().getConveyorPosition()).func_177229_b((Property)ConveyorBlock.FACING);
        Vector3d vec3d = new Vector3d(this.velocityHorizontal * (double)direction.func_176730_m().func_177958_n(), this.velocityVertical, this.velocityHorizontal * (double)direction.func_176730_m().func_177952_p());
        double x = vec3d.field_72450_a;
        double y = vec3d.field_72448_b;
        double z = vec3d.field_72449_c;
        if (vec3d.field_72448_b != 0.0) {
            entity.field_70143_R = 3.0f;
            y = vec3d.field_72448_b;
        }
        z = vec3d.field_72449_c;
        entity.func_213293_j(x, y, z);
        this.getWorld().func_184133_a(null, this.getPos(), SoundEvents.field_192796_et, SoundCategory.AMBIENT, 0.5f, 1.0f);
    }

    @Override
    public VoxelShape getBoundingBox() {
        return BB;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT() == null ? new CompoundNBT() : super.serializeNBT();
        compound.func_218657_a("Filter", (INBT)this.filter.serializeNBT());
        compound.func_74757_a("Whitelist", this.whitelist);
        compound.func_74780_a("VelocityVertical", this.velocityVertical);
        compound.func_74780_a("VelocityHorizontal", this.velocityHorizontal);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("Filter")) {
            this.filter.deserializeNBT(nbt.func_74775_l("Filter"));
        }
        this.whitelist = nbt.func_74767_n("Whitelist");
        this.velocityHorizontal = nbt.func_74769_h("VelocityHorizontal");
        this.velocityVertical = nbt.func_74769_h("VelocityVertical");
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundNBT compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, ItemStack.func_199557_a((CompoundNBT)compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 10) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
        if (buttonId == 11 && this.velocityHorizontal < 1.0) {
            this.velocityHorizontal += 0.05;
            this.getContainer().requestSync();
        }
        if (buttonId == 12 && this.velocityHorizontal > 0.0) {
            this.velocityHorizontal -= 0.05;
            this.getContainer().requestSync();
        }
        if (buttonId == 13 && this.velocityVertical < 1.0) {
            this.velocityVertical += 0.05;
            this.getContainer().requestSync();
        }
        if (buttonId == 14 && this.velocityVertical > 0.0) {
            this.velocityVertical -= 0.05;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorBouncingUpgrade.this.filter;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(10, 80, 19, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorBouncingUpgrade.this.whitelist ? 0 : 1;
            }
        });
        componentList.add(new TextureGuiComponent(80, 40, 16, 16, res, 2, 234, "bouncing_horizontal"));
        componentList.add(new TextureGuiComponent(80, 56, 16, 16, res, 21, 234, "bouncing_vertical"));
        componentList.add(new TextGuiComponent(104, 44){

            @Override
            public String getText() {
                return TextFormatting.DARK_GRAY + NumberFormat.getNumberInstance(Locale.ROOT).format(ConveyorBouncingUpgrade.this.velocityHorizontal > 0.0 ? ConveyorBouncingUpgrade.this.velocityHorizontal : 0.0);
            }
        });
        componentList.add(new TextGuiComponent(104, 61){

            @Override
            public String getText() {
                return TextFormatting.DARK_GRAY + NumberFormat.getNumberInstance(Locale.ROOT).format(ConveyorBouncingUpgrade.this.velocityVertical > 0.0 ? ConveyorBouncingUpgrade.this.velocityVertical : 0.0);
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(11, 130, 40, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 104, new String[]{"increase"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(12, 146, 40, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 16, 104, new String[]{"decrease"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(13, 130, 56, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 104, new String[]{"increase"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(14, 146, 56, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 16, 104, new String[]{"decrease"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            this.setRegistryName("bouncing");
        }

        @Override
        public ConveyorUpgrade create(IConveyorContainer container, Direction face) {
            return new ConveyorBouncingUpgrade(container, this, face);
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return ImmutableSet.of((Object)new ResourceLocation("industrialforegoing", "blocks/conveyor_bouncing_upgrade_north"), (Object)new ResourceLocation("industrialforegoing", "blocks/conveyor_bouncing_upgrade_east"), (Object)new ResourceLocation("industrialforegoing", "blocks/conveyor_bouncing_upgrade_west"), (Object)new ResourceLocation("industrialforegoing", "blocks/conveyor_bouncing_upgrade_south"));
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_bouncing_" + conveyorFacing.func_176610_l().toLowerCase());
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_bouncing_upgrade");
        }

        @Override
        @Nonnull
        public Set<Direction> getValidFacings() {
            return DOWN;
        }

        @Override
        public Direction getSideForPlacement(World world, BlockPos pos, PlayerEntity player) {
            return Direction.DOWN;
        }

        public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((IItemProvider)this.getUpgradeItem()).func_200472_a("IPI").func_200472_a("IDI").func_200472_a("ICI").func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('P'), (IItemProvider)Blocks.field_180399_cE).func_200462_a(Character.valueOf('D'), (IItemProvider)Blocks.field_150331_J).func_200462_a(Character.valueOf('C'), (IItemProvider)ModuleTransport.CONVEYOR).func_200464_a(consumer);
        }
    }
}

