/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transport.conveyor;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.IConveyorContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.gui.component.FilterGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransport;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class ConveyorDetectorUpgrade
extends ConveyorUpgrade {
    public static VoxelShape BB = VoxelShapes.func_197873_a((double)0.1875, (double)0.0625, (double)0.1875, (double)0.8125, (double)0.075, (double)0.8125);
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 5, 3);
    private boolean hasEntity = false;
    private boolean whitelist = false;
    private boolean inverted = false;

    public ConveyorDetectorUpgrade(IConveyorContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
    }

    @Override
    public void update() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        boolean previous = this.hasEntity;
        this.hasEntity = false;
        List entities = this.getWorld().func_217357_a(Entity.class, this.getBoundingBox().func_197752_a().func_186670_a(this.getPos()).func_186662_g(0.01));
        boolean bl = this.hasEntity = !entities.isEmpty() && this.whitelist == this.someoneMatchesFilter(entities);
        if (this.inverted) {
            boolean bl2 = this.hasEntity = !this.hasEntity;
        }
        if (previous != this.hasEntity) {
            this.getWorld().func_195593_d(this.getPos(), this.getWorld().func_180495_p(this.getPos()).func_177230_c());
        }
    }

    private boolean someoneMatchesFilter(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!this.filter.matches(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT() == null ? new CompoundNBT() : super.serializeNBT();
        compound.func_218657_a("Filter", (INBT)this.filter.serializeNBT());
        compound.func_74757_a("Whitelist", this.whitelist);
        compound.func_74757_a("Inverted", this.inverted);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("Filter")) {
            this.filter.deserializeNBT(nbt.func_74775_l("Filter"));
        }
        this.whitelist = nbt.func_74767_n("Whitelist");
        this.inverted = nbt.func_74767_n("Inverted");
    }

    @Override
    public int getRedstoneOutput() {
        return this.hasEntity ? 15 : 0;
    }

    @Override
    public VoxelShape getBoundingBox() {
        return BB;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundNBT compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, ItemStack.func_199557_a((CompoundNBT)compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
        if (buttonId == 17) {
            this.inverted = !this.inverted;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorDetectorUpgrade.this.filter;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorDetectorUpgrade.this.whitelist ? 0 : 1;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(17, 133, 55, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 96, 214, new String[]{"redstone_normal"}), new StateButtonInfo(1, res, 77, 214, new String[]{"redstone_inverted"})}){

            @Override
            public int getState() {
                return ConveyorDetectorUpgrade.this.inverted ? 1 : 0;
            }
        });
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            this.setRegistryName("detection");
        }

        @Override
        public ConveyorUpgrade create(IConveyorContainer container, Direction face) {
            return new ConveyorDetectorUpgrade(container, this, face);
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Collections.singleton(new ResourceLocation("industrialforegoing", "blocks/conveyor_detection_upgrade"));
        }

        @Override
        @Nonnull
        public Set<Direction> getValidFacings() {
            return DOWN;
        }

        @Override
        public Direction getSideForPlacement(World world, BlockPos pos, PlayerEntity player) {
            return Direction.DOWN;
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_detection");
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_detection_upgrade");
        }

        public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((IItemProvider)this.getUpgradeItem()).func_200472_a("IPI").func_200472_a("IDI").func_200472_a("ICI").func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('P'), (IItemProvider)Blocks.field_150456_au).func_200462_a(Character.valueOf('D'), (IItemProvider)Blocks.field_196762_fd).func_200462_a(Character.valueOf('C'), (IItemProvider)ModuleTransport.CONVEYOR).func_200464_a(consumer);
        }
    }
}

