/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transport.tile;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.IConveyorContainer;
import com.buuz135.industrial.block.transport.ConveyorBlock;
import com.buuz135.industrial.gui.conveyor.ContainerConveyor;
import com.buuz135.industrial.module.ModuleTransport;
import com.buuz135.industrial.proxy.client.model.ConveyorModelData;
import com.buuz135.industrial.utils.MovementUtils;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;

public class ConveyorTile
extends ActiveTile<ConveyorTile>
implements IConveyorContainer,
ITickableTileEntity {
    private Direction facing;
    private ConveyorBlock.EnumType type;
    private int color;
    private Map<Direction, ConveyorUpgrade> upgradeMap = new HashMap<Direction, ConveyorUpgrade>();
    private List<Integer> filter;
    private boolean sticky;
    private FluidTank tank;
    private boolean needsFluidSync;

    public ConveyorTile() {
        super((BasicTileBlock)ModuleTransport.CONVEYOR);
        this.facing = Direction.NORTH;
        this.type = ConveyorBlock.EnumType.FLAT;
        this.color = DyeColor.WHITE.func_196055_e().field_76291_p;
        this.filter = new ArrayList<Integer>();
        this.sticky = false;
        this.tank = new FluidTank(250);
    }

    @Override
    public World getConveyorWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getConveyorPosition() {
        return this.func_174877_v();
    }

    @Override
    public void requestSync() {
        this.markForUpdate();
    }

    @Override
    public void requestFluidSync() {
        this.needsFluidSync = true;
    }

    @Override
    public boolean hasUpgrade(Direction facing) {
        return this.upgradeMap.containsKey(facing);
    }

    public int getPower() {
        int highestPower = 0;
        for (ConveyorUpgrade upgrade : this.upgradeMap.values()) {
            int power;
            if (upgrade == null || (power = upgrade.getRedstoneOutput()) <= highestPower) continue;
            highestPower = power;
        }
        return highestPower;
    }

    @Override
    public void addUpgrade(Direction facing, ConveyorUpgradeFactory upgrade) {
        if (!this.hasUpgrade(facing)) {
            this.upgradeMap.put(facing, upgrade.create(this, facing));
            this.requestSync();
            if (this.field_145850_b.field_72995_K) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
            }
        }
    }

    @Override
    public void removeUpgrade(Direction facing, boolean drop) {
        if (this.hasUpgrade(facing)) {
            if (!this.field_145850_b.field_72995_K && drop) {
                ConveyorUpgrade upgrade = this.upgradeMap.get(facing);
                for (ItemStack stack : upgrade.getDrops()) {
                    ItemEntity item = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                    item.func_92058_a(stack);
                    this.field_145850_b.func_217376_c((Entity)item);
                }
            }
            this.upgradeMap.get(facing).onUpgradeRemoved();
            this.upgradeMap.remove(facing);
            this.requestSync();
            if (this.field_145850_b.field_72995_K) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
            }
        }
    }

    @Override
    public List<Integer> getEntityFilter() {
        return this.filter;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public void setFacing(Direction facing) {
        this.facing = facing;
        this.markForUpdate();
    }

    public ConveyorBlock.EnumType getConveyorType() {
        return this.type;
    }

    public void setType(ConveyorBlock.EnumType type) {
        this.type = type;
        this.markForUpdate();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.markForUpdate();
    }

    public void setColor(DyeColor color) {
        this.color = color.func_196055_e().field_76291_p;
        this.markForUpdate();
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
        this.markForUpdate();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_74778_a("Facing", this.facing.func_176610_l());
        compound.func_74778_a("Type", this.type.getName());
        compound.func_74768_a("Color", this.color);
        compound.func_74757_a("Sticky", this.sticky);
        CompoundNBT upgrades = new CompoundNBT();
        for (Direction facing : Direction.values()) {
            if (!this.hasUpgrade(facing)) continue;
            CompoundNBT upgradeTag = new CompoundNBT();
            ConveyorUpgrade upgrade = this.upgradeMap.get(facing);
            upgradeTag.func_74778_a("factory", upgrade.getFactory().getRegistryName().toString());
            CompoundNBT customNBT = upgrade.serializeNBT();
            if (customNBT != null) {
                upgradeTag.func_218657_a("customNBT", (INBT)customNBT);
            }
            upgrades.func_218657_a(facing.func_176610_l(), (INBT)upgradeTag);
        }
        compound.func_218657_a("Upgrades", (INBT)upgrades);
        compound.func_218657_a("Tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.facing = Direction.func_176739_a((String)compound.func_74779_i("Facing"));
        this.type = ConveyorBlock.EnumType.getFromName(compound.func_74779_i("Type"));
        this.color = compound.func_74762_e("Color");
        this.sticky = compound.func_74767_n("Sticky");
        if (compound.func_74764_b("Upgrades")) {
            CompoundNBT upgradesTag = compound.func_74775_l("Upgrades");
            for (Direction facing : Direction.values()) {
                if (!upgradesTag.func_74764_b(facing.func_176610_l())) continue;
                CompoundNBT upgradeTag = upgradesTag.func_74775_l(facing.func_176610_l());
                ConveyorUpgradeFactory factory = null;
                for (ConveyorUpgradeFactory conveyorUpgradeFactory : ConveyorUpgradeFactory.FACTORIES) {
                    if (!conveyorUpgradeFactory.getRegistryName().equals((Object)new ResourceLocation(upgradeTag.func_74779_i("factory")))) continue;
                    factory = conveyorUpgradeFactory;
                    break;
                }
                if (factory == null) continue;
                ConveyorUpgrade upgrade = this.upgradeMap.getOrDefault(facing, factory.create(this, facing));
                if (upgradeTag.func_150297_b("customNBT", 10)) {
                    upgrade.deserializeNBT(upgradeTag.func_74775_l("customNBT"));
                }
                this.upgradeMap.put(facing, upgrade);
            }
        }
        if (compound.func_74764_b("Tank")) {
            this.tank = this.tank.readFromNBT(compound.func_74775_l("Tank"));
        }
    }

    public void markForUpdate() {
        super.markForUpdate();
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)((BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)ConveyorBlock.FACING, (Comparable)this.facing)).func_206870_a(ConveyorBlock.TYPE, (Comparable)((Object)this.type)));
        this.field_145850_b.func_175625_s(this.field_174879_c).func_230337_a_(this.field_145850_b.func_180495_p(this.field_174879_c), this.func_189515_b(new CompoundNBT()));
    }

    public List<AxisAlignedBB> getCollisionBoxes() {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        Direction facing = this.facing;
        if (this.type.isDown()) {
            facing = facing.func_176734_d();
        }
        for (double height = 1.0; height > 0.0; height -= 0.1) {
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                boxes.add(new AxisAlignedBB(0.0, 0.0, facing == Direction.NORTH ? 0.0 : 1.0 - height, 1.0, 1.0 - height, facing == Direction.NORTH ? height : 1.0));
            }
            if (facing != Direction.WEST && facing != Direction.EAST) continue;
            boxes.add(new AxisAlignedBB(facing == Direction.WEST ? 0.0 : 1.0 - height, 0.0, 0.0, facing == Direction.WEST ? height : 1.0, 1.0 - height, 1.0));
        }
        return boxes;
    }

    public void handleEntityMovement(Entity entity) {
        for (ConveyorUpgrade upgrade : this.upgradeMap.values()) {
            if (upgrade == null) continue;
            upgrade.handleEntity(entity);
        }
        if (entity.func_70089_S()) {
            if (!this.getEntityFilter().contains(entity.func_145782_y())) {
                MovementUtils.handleConveyorMovement(entity, this.facing, this.field_174879_c, this.type);
            }
            if (entity instanceof ItemEntity && this.sticky) {
                ((ItemEntity)entity).func_174867_a(5);
            }
        }
    }

    public Map<Direction, ConveyorUpgrade> getUpgradeMap() {
        return this.upgradeMap;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void func_73660_a() {
        BlockState state;
        if (this.type.isVertical() && !this.upgradeMap.isEmpty()) {
            new ArrayList<Direction>(this.upgradeMap.keySet()).forEach(facing1 -> this.removeUpgrade((Direction)facing1, true));
        }
        this.upgradeMap.values().forEach(ConveyorUpgrade::update);
        if (!this.field_145850_b.field_72995_K && this.tank.getFluidAmount() > 0 && this.field_145850_b.func_82737_E() % 3L == 0L && this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(this.facing)).func_177230_c() instanceof ConveyorBlock && this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.facing)) instanceof ConveyorTile && !((ConveyorBlock.EnumType)((Object)(state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(this.facing))).func_177229_b(ConveyorBlock.TYPE))).isVertical()) {
            int amount = Math.max(this.tank.getFluidAmount() - 1, 1);
            ConveyorTile conveyorTile = (ConveyorTile)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.facing));
            FluidStack drained = this.tank.drain(conveyorTile.getTank().fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            if (!drained.isEmpty() && drained.getAmount() > 0) {
                this.requestFluidSync();
                conveyorTile.requestFluidSync();
            }
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 6L == 0L && this.needsFluidSync) {
            this.markForUpdate();
            this.needsFluidSync = false;
        }
    }

    @Nonnull
    public ConveyorTile getSelf() {
        return this;
    }

    @Nullable
    public Container createMenu(int menu, PlayerInventory inventoryPlayer, PlayerEntity entityPlayer) {
        return new ContainerConveyor(menu, this, ModuleTransport.CONVEYOR.getFacingUpgradeHit(this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b, this.field_174879_c, entityPlayer), inventoryPlayer);
    }

    public void openGui(PlayerEntity player, Direction facing) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, packetBuffer -> {
                packetBuffer.func_179255_a(this.field_174879_c);
                packetBuffer.func_179249_a((Enum)facing);
            });
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ConveyorModelData.UPGRADE_PROPERTY, (Object)new ConveyorModelData(new HashMap<Direction, ConveyorUpgrade>(this.upgradeMap))).build();
    }
}

