/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.entity;

import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleTool;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class InfinityTridentEntity
extends AbstractArrowEntity {
    private static final DataParameter<Integer> LOYALTY_LEVEL = EntityDataManager.func_187226_a(InfinityTridentEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CHANNELING = EntityDataManager.func_187226_a(InfinityTridentEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TIER = EntityDataManager.func_187226_a(InfinityTridentEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static int DAMAGE = 8;
    private ItemStack thrownStack = new ItemStack((IItemProvider)ModuleTool.INFINITY_TRIDENT);
    private boolean dealtDamage;
    public int returningTicks;

    public InfinityTridentEntity(EntityType<? extends InfinityTridentEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public InfinityTridentEntity(World worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        super(ModuleTool.TRIDENT_ENTITY_TYPE, thrower, worldIn);
        this.thrownStack = thrownStackIn.func_77946_l();
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)ModuleTool.INFINITY_TRIDENT.getCurrentLoyalty(this.thrownStack));
        this.field_70180_af.func_187227_b(CHANNELING, (Object)ModuleTool.INFINITY_TRIDENT.getCurrentChanneling(this.thrownStack));
        this.field_70180_af.func_187227_b(TIER, (Object)ItemInfinity.getSelectedTier(this.thrownStack).getRadius());
    }

    @OnlyIn(value=Dist.CLIENT)
    public InfinityTridentEntity(World worldIn, double x, double y, double z) {
        super(ModuleTool.TRIDENT_ENTITY_TYPE, x, y, z, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LOYALTY_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(CHANNELING, (Object)false);
        this.field_70180_af.func_187214_a(TIER, (Object)1);
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.func_234616_v_();
        if ((this.dealtDamage || this.func_203047_q()) && entity != null) {
            int loyaltyLevel = (Integer)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
            if (!this.shouldReturnToThrower()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (loyaltyLevel > 0) {
                this.func_203045_n(true);
                Vector3d vector3d = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226280_cw_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vector3d.field_72448_b * 0.015 * (double)loyaltyLevel, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double d0 = 0.05 * (double)loyaltyLevel;
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vector3d.func_72432_b().func_186678_a(d0)));
                if (this.returningTicks == 0) {
                    this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.func_70071_h_();
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        BlockPos blockpos;
        Entity entity1;
        Entity target = p_213868_1_.func_216348_a();
        float damageHit = (float)((double)DAMAGE + Math.pow(2.0, ((Integer)this.field_70180_af.func_187225_a(TIER)).intValue())) * 0.5f;
        if (target instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)target;
            damageHit += EnchantmentHelper.func_152377_a((ItemStack)this.thrownStack, (CreatureAttribute)livingentity.func_70668_bt());
        }
        DamageSource damagesource = DamageSource.func_203096_a((Entity)this, (Entity)((entity1 = this.func_234616_v_()) == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.field_203268_ij;
        if (target.func_70097_a(damagesource, damageHit)) {
            if (target.func_200600_R() == EntityType.field_200803_q) {
                return;
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)target;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.func_184548_a(livingentity1);
            }
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        AxisAlignedBB area = new AxisAlignedBB(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_()).func_186662_g((double)((Integer)this.field_70180_af.func_187225_a(TIER)).intValue());
        List mobs = this.func_130014_f_().func_217357_a(MobEntity.class, area);
        if (entity1 instanceof PlayerEntity) {
            mobs.forEach(mobEntity -> {
                float damage = (float)((double)DAMAGE + Math.pow(2.0, ((Integer)this.field_70180_af.func_187225_a(TIER)).intValue())) * 0.5f;
                if (target instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)target;
                    damage += EnchantmentHelper.func_152377_a((ItemStack)this.thrownStack, (CreatureAttribute)livingentity.func_70668_bt());
                }
                mobEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)entity1)), damage);
            });
            this.func_130014_f_().func_217357_a(ItemEntity.class, area.func_186662_g(1.0)).forEach(itemEntity -> {
                itemEntity.func_174868_q();
                itemEntity.func_70634_a((double)entity1.func_233580_cy_().func_177958_n(), (double)(entity1.func_233580_cy_().func_177956_o() + 1), (double)entity1.func_233580_cy_().func_177952_p());
            });
            this.func_130014_f_().func_217357_a(ExperienceOrbEntity.class, area.func_186662_g(1.0)).forEach(entityXPOrb -> entityXPOrb.func_70634_a((double)entity1.func_233580_cy_().func_177958_n(), (double)entity1.func_233580_cy_().func_177956_o(), (double)entity1.func_233580_cy_().func_177952_p()));
        }
        if (this.field_70170_p instanceof ServerWorld && ((Boolean)this.field_70180_af.func_187225_a(CHANNELING)).booleanValue() && this.field_70170_p.func_226660_f_(blockpos = target.func_233580_cy_())) {
            LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_70170_p);
            lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)blockpos));
            lightningboltentity.func_204809_d(entity1 instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity1 : null);
            this.field_70170_p.func_217376_c((Entity)lightningboltentity);
            soundevent = SoundEvents.field_203275_iq;
            f1 = 5.0f;
            mobs.forEach(mobEntity -> {
                if (this.field_70170_p.func_226660_f_(mobEntity.func_233580_cy_())) {
                    LightningBoltEntity lightningboltentity1 = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_70170_p);
                    lightningboltentity1.func_233576_c_(Vector3d.func_237492_c_((Vector3i)mobEntity.func_233580_cy_()));
                    lightningboltentity1.func_204809_d(entity1 instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity1 : null);
                    this.field_70170_p.func_217376_c((Entity)lightningboltentity1);
                }
            });
        }
        this.func_184185_a(soundevent, f1, 1.0f);
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }

    protected ItemStack func_184550_j() {
        return this.thrownStack.func_77946_l();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEnchanted() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public boolean func_70112_a(double dist) {
        return dist <= 64.0;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_225516_i_() {
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Trident", 10)) {
            this.thrownStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Trident"));
        }
        this.dealtDamage = compound.func_74767_n("DealtDamage");
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)ModuleTool.INFINITY_TRIDENT.getCurrentLoyalty(this.thrownStack));
        this.field_70180_af.func_187227_b(CHANNELING, (Object)ModuleTool.INFINITY_TRIDENT.getCurrentChanneling(this.thrownStack));
        this.field_70180_af.func_187227_b(TIER, (Object)ItemInfinity.getSelectedTier(this.thrownStack).getRadius());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("Trident", (INBT)this.thrownStack.func_77955_b(new CompoundNBT()));
        compound.func_74757_a("DealtDamage", this.dealtDamage);
    }
}

