/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ArrowButtonScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemInfinityHammer
extends ItemInfinity {
    public static HashMap<Class<?>, Function<Entity, ItemStack>> HEADS = new HashMap();
    public static int POWER_CONSUMPTION = 10000;
    public static int FUEL_CONSUMPTION = 3;
    public static int DAMAGE = 10;
    public static float ATTACK_SPEED = -2.0f;
    public static String BEHEADING_NBT = "Beheading";

    public ItemInfinityHammer(ItemGroup group) {
        super("infinity_hammer", group, new Item.Properties().func_200917_a(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, true);
    }

    public static ItemStack createHead(String name) {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_196184_dx);
        stack.func_196082_o().func_74778_a("SkullOwner", name);
        return stack;
    }

    @Override
    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        super.addNbt(stack, power, fuel, special);
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a(BEHEADING_NBT, 0);
        stack.func_77982_d(nbt);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnchantmentType.WEAPON;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    @Override
    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    @Override
    public float func_150893_a(ItemStack stack, BlockState state) {
        if (state.func_203425_a(Blocks.field_196553_aF)) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && !state.func_235714_a_((ITag)BlockTags.field_206952_E) && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        InfinityTier infinityTier = ItemInfinityHammer.getSelectedTier(stack);
        if (infinityTier.getRadius() > 1 && attacker instanceof PlayerEntity) {
            AxisAlignedBB area = new AxisAlignedBB(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_()).func_186662_g((double)infinityTier.getRadius());
            List mobs = attacker.func_130014_f_().func_217357_a(MobEntity.class, new AxisAlignedBB(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_()).func_186662_g((double)infinityTier.getRadius()));
            mobs.forEach(mobEntity -> {
                if (this.enoughFuel(stack)) {
                    mobEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), (float)((double)DAMAGE + Math.pow(2.0, infinityTier.getRadius())) * 0.8f);
                    this.consumeFuel(stack);
                    if (mobEntity.func_110143_aJ() <= 0.0f && attacker.func_130014_f_().field_73012_v.nextDouble() <= (double)this.getCurrentBeheading(stack) * 0.15) {
                        ItemStack head = HEADS.getOrDefault(mobEntity.getClass(), entity -> ItemStack.field_190927_a).apply((Entity)mobEntity);
                        Block.func_180635_a((World)attacker.field_70170_p, (BlockPos)attacker.func_233580_cy_(), (ItemStack)head);
                    }
                }
            });
            attacker.func_130014_f_().func_217357_a(ItemEntity.class, area.func_186662_g(1.0)).forEach(itemEntity -> {
                itemEntity.func_174868_q();
                itemEntity.func_70634_a((double)attacker.func_233580_cy_().func_177958_n(), (double)(attacker.func_233580_cy_().func_177956_o() + 1), (double)attacker.func_233580_cy_().func_177952_p());
            });
            attacker.func_130014_f_().func_217357_a(ExperienceOrbEntity.class, area.func_186662_g(1.0)).forEach(entityXPOrb -> entityXPOrb.func_70634_a((double)attacker.func_233580_cy_().func_177958_n(), (double)attacker.func_233580_cy_().func_177956_o(), (double)attacker.func_233580_cy_().func_177952_p()));
        }
        if (target.func_110143_aJ() <= 0.0f && target instanceof PlayerEntity) {
            Block.func_180635_a((World)attacker.field_70170_p, (BlockPos)attacker.func_233580_cy_(), (ItemStack)ItemInfinityHammer.createHead(target.func_145748_c_().getString()));
        }
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        InfinityTier infinityTier = ItemInfinityHammer.getSelectedTier(stack);
        PlayerEntity player = context.func_195999_j();
        if (infinityTier.getRadius() > 1) {
            Vector3d[] all;
            Vector3d looking = player.func_70040_Z();
            for (Vector3d vector3d : all = new Vector3d[]{looking, looking.func_178785_b(0.22f), looking.func_178785_b(-0.22f)}) {
                float f = (float)MathHelper.func_181159_b((double)vector3d.field_72449_c, (double)vector3d.field_72450_a);
                int i = 0;
                while ((double)i < (double)infinityTier.getRadius() * 1.5 + 1.0) {
                    double d2 = 1.25 * (double)(i + 1);
                    int j = 1;
                    this.spawnFangs((LivingEntity)player, player.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, player.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, player.func_226278_cu_() - 1.0, player.func_226278_cu_() + 1.0, f, j);
                    this.consumeFuel(stack);
                    ++i;
                }
            }
            player.func_184811_cZ().func_185145_a((Item)this, 12);
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    private void spawnFangs(LivingEntity caster, double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos(x, maxY, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = caster.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)caster.field_70170_p, blockpos1, Direction.UP)) continue;
            if (!caster.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = caster.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)caster.field_70170_p, blockpos)).func_197766_b()) {
                d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)minY) - 1);
        if (flag) {
            caster.field_70170_p.func_217376_c((Entity)new EvokerFangsEntity(caster.field_70170_p, x, (double)blockpos.func_177956_o() + d0, z, rotation, delay, caster));
        }
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            entityLiving.func_213361_c(EquipmentSlotType.MAINHAND);
        }
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return blockIn.func_203425_a(Blocks.field_196553_aF);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        ListMultimap multimap = MultimapBuilder.hashKeys().arrayListValues().build();
        if (slot == EquipmentSlotType.MAINHAND) {
            InfinityTier infinityTier = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityHammer.getPowerFromStack(stack)).getLeft());
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)DAMAGE + Math.pow(2.0, infinityTier.getRadius()), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)ATTACK_SPEED, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public int getCurrentBeheading(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(BEHEADING_NBT);
    }

    public int getMaxBeheading(ItemStack stack) {
        InfinityTier infinityTier = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityHammer.getPowerFromStack(stack)).getLeft());
        return Math.min(Math.max(0, infinityTier.getRadius() - 2), 3);
    }

    public void setBeheading(ItemStack stack, int level) {
        stack.func_196082_o().func_74768_a(BEHEADING_NBT, level);
    }

    @Override
    public void addTooltipDetails(BasicItem.Key key, ItemStack stack, List<ITextComponent> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        String level = "0";
        switch (this.getCurrentBeheading(stack)) {
            case 1: {
                level = "I";
                break;
            }
            case 2: {
                level = "II";
                break;
            }
            case 3: {
                level = "III";
            }
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("text.industrialforegoing.display.beheading").func_240702_b_(" " + level).func_240699_a_(TextFormatting.GRAY));
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        List<IFactory<? extends IScreenAddon>> factory = super.getScreenAddons(stack);
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 52, 14, 14, FacingUtil.Sideness.RIGHT).setId(4))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 52, 14, 14, FacingUtil.Sideness.LEFT).setId(5))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon("", 72, 56, false){

            public String getText() {
                return TextFormatting.DARK_GRAY + new TranslationTextComponent("text.industrialforegoing.display.beheading").func_240702_b_(": ").func_240702_b_(ItemInfinityHammer.this.getCurrentBeheading((ItemStack)stack.get()) + "/" + ItemInfinityHammer.this.getMaxBeheading((ItemStack)stack.get())).getString();
            }
        }));
        return factory;
    }

    @Override
    public void handleButtonMessage(int id, PlayerEntity playerEntity, CompoundNBT compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        ItemStack stack = playerEntity.func_184586_b(Hand.MAIN_HAND);
        int currentBeheading = this.getCurrentBeheading(stack);
        int maxBeheading = this.getMaxBeheading(stack);
        if (id == 5 && currentBeheading > 0) {
            this.setBeheading(stack, Math.max(currentBeheading - 1, 0));
        }
        if (id == 4 && currentBeheading < maxBeheading) {
            this.setBeheading(stack, Math.min(3, currentBeheading + 1));
        }
    }

    @Override
    public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
        new DissolutionChamberRecipe(this.getRegistryName(), new Ingredient.IItemList[]{new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_221732_cb)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_151048_u)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_221732_cb)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_151056_x)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)ModuleCore.RANGE_ADDONS[11])), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD)}, new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid(), 2000), 400, new ItemStack((IItemProvider)this), FluidStack.EMPTY);
    }

    static {
        HEADS.put(WitherSkeletonEntity.class, entity -> new ItemStack((IItemProvider)Blocks.field_196705_eO));
        HEADS.put(SkeletonEntity.class, entity -> new ItemStack((IItemProvider)Blocks.field_196703_eM));
        HEADS.put(ZombieEntity.class, entity -> new ItemStack((IItemProvider)Blocks.field_196708_eQ));
        HEADS.put(CreeperEntity.class, entity -> new ItemStack((IItemProvider)Blocks.field_196714_eU));
        HEADS.put(EnderDragonEntity.class, entity -> new ItemStack((IItemProvider)Blocks.field_196716_eW));
    }
}

