/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IndustrialTags;
import com.buuz135.industrial.utils.apihandlers.plant.TreeCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInfinitySaw
extends ItemInfinity {
    public static LoadingCache<Pair<World, BlockPos>, TreeCache> SAW_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Pair<World, BlockPos>, TreeCache>(){

        public TreeCache load(Pair<World, BlockPos> key) throws Exception {
            TreeCache cache = new TreeCache((World)key.getLeft(), (BlockPos)key.getRight());
            cache.scanForTreeBlockSection();
            return cache;
        }
    });
    public static int POWER_CONSUMPTION = 10000;
    public static int FUEL_CONSUMPTION = 3;

    public ItemInfinitySaw(ItemGroup group) {
        super("infinity_saw", group, new Item.Properties().func_200917_a(1).addToolType(ToolType.AXE, 3), POWER_CONSUMPTION, FUEL_CONSUMPTION, false);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnchantmentType.DIGGER;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return Items.field_151056_x.func_150897_b(blockIn);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity && BlockUtils.isLog(worldIn, pos)) {
            try {
                TreeCache cache = (TreeCache)SAW_CACHE.get((Object)Pair.of((Object)worldIn, (Object)pos));
                if (cache != null) {
                    ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                    InfinityTier currentTier = ItemInfinitySaw.getSelectedTier(stack);
                    int operations = this.getBlocksAmount(currentTier.getRadius());
                    for (int i = 0; i < operations; ++i) {
                        if (cache.getWoodCache().isEmpty() && cache.getLeavesCache().isEmpty()) {
                            SAW_CACHE.invalidate((Object)Pair.of((Object)worldIn, (Object)pos));
                            break;
                        }
                        if (!this.enoughFuel(stack)) break;
                        if (!cache.getLeavesCache().isEmpty()) {
                            itemStacks.addAll(cache.chop(cache.getLeavesCache(), false));
                        } else {
                            itemStacks.addAll(cache.chop(cache.getWoodCache(), false));
                        }
                        this.consumeFuel(stack);
                    }
                    itemStacks.forEach(itemStack -> ItemHandlerHelper.giveItemToPlayer((PlayerEntity)((PlayerEntity)entityLiving), (ItemStack)itemStack));
                    return false;
                }
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private int getBlocksAmount(int radius) {
        return (radius * 2 + 1) * (radius * 2 + 1);
    }

    @Override
    public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
        new DissolutionChamberRecipe(this.getRegistryName(), new Ingredient.IItemList[]{new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_221732_cb)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_151046_w)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_151056_x)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_151056_x)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)ModuleCore.RANGE_ADDONS[11])), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD)}, new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid(), 2000), 400, new ItemStack((IItemProvider)this), FluidStack.EMPTY);
    }
}

