/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.jei;

import com.buuz135.industrial.block.generator.MycelialGeneratorBlock;
import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.block.generator.tile.BioReactorTile;
import com.buuz135.industrial.gui.conveyor.GuiConveyor;
import com.buuz135.industrial.jei.category.BioReactorRecipeCategory;
import com.buuz135.industrial.jei.category.DissolutionChamberCategory;
import com.buuz135.industrial.jei.category.FluidExtractorCategory;
import com.buuz135.industrial.jei.category.LaserDrillFluidCategory;
import com.buuz135.industrial.jei.category.LaserDrillOreCategory;
import com.buuz135.industrial.jei.generator.MycelialGeneratorCategory;
import com.buuz135.industrial.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.jei.machineproduce.MachineProduceCategory;
import com.buuz135.industrial.jei.ore.OreFermenterCategory;
import com.buuz135.industrial.jei.ore.OreSieveCategory;
import com.buuz135.industrial.jei.ore.OreWasherCategory;
import com.buuz135.industrial.jei.petrifiedgen.PetrifiedBurnTimeCategory;
import com.buuz135.industrial.jei.sludge.SludgeRefinerRecipeCategory;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.recipe.FluidExtractorRecipe;
import com.buuz135.industrial.recipe.LaserDrillFluidRecipe;
import com.buuz135.industrial.recipe.LaserDrillOreRecipe;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

@JeiPlugin
public class JEICustomPlugin
implements IModPlugin {
    private static IRecipesGui recipesGui;
    private SludgeRefinerRecipeCategory sludgeRefinerRecipeCategory;
    private BioReactorRecipeCategory bioReactorRecipeCategory;
    private BioReactorRecipeCategory proteinReactorRecipeCategory;
    private LaserDrillOreCategory laserRecipeOreCategory;
    private LaserDrillFluidCategory laserDrillFluidCategory;
    private MachineProduceCategory machineProduceCategory;
    private PetrifiedBurnTimeCategory petrifiedBurnTimeCategory;
    private FluidExtractorCategory fluidExtractorCategory;
    private OreWasherCategory oreWasherCategory;
    private OreFermenterCategory oreFermenterCategory;
    private OreSieveCategory oreSieveCategory;
    private DissolutionChamberCategory dissolutionChamberJEICategory;
    private List<MycelialGeneratorCategory> mycelialGeneratorCategories;

    public static void showUses(ItemStack stack) {
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{ModuleTool.INFINITY_DRILL, ModuleTool.INFINITY_SAW, ModuleTool.INFINITY_HAMMER, ModuleTool.INFINITY_TRIDENT, ModuleCore.EFFICIENCY_ADDON_1, ModuleCore.EFFICIENCY_ADDON_2, ModuleCore.SPEED_ADDON_1, ModuleCore.SPEED_ADDON_2});
        registration.useNbtForSubtypes((Item[])ModuleCore.RANGE_ADDONS);
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(GuiConveyor.class, (IGhostIngredientHandler)new IGhostIngredientHandler<GuiConveyor>(){

            public <I> List<IGhostIngredientHandler.Target<I>> getTargets(GuiConveyor guiConveyor, I i, boolean b) {
                if (i instanceof ItemStack) {
                    return guiConveyor.getGhostSlots().stream().map(ghostSlot -> new IGhostIngredientHandler.Target<I>((IFilter.GhostSlot)ghostSlot){
                        final /* synthetic */ IFilter.GhostSlot val$ghostSlot;
                        {
                            this.val$ghostSlot = ghostSlot;
                        }

                        public Rectangle2d getArea() {
                            return this.val$ghostSlot.getArea();
                        }

                        public void accept(I stack) {
                            this.val$ghostSlot.accept((ItemStack)stack);
                        }
                    }).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }

            public void onComplete() {
            }
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.bioReactorRecipeCategory = new BioReactorRecipeCategory(registry.getJeiHelpers().getGuiHelper(), "Bioreactor accepted items");
        registry.addRecipeCategories(new IRecipeCategory[]{this.bioReactorRecipeCategory});
        this.fluidExtractorCategory = new FluidExtractorCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.fluidExtractorCategory});
        this.dissolutionChamberJEICategory = new DissolutionChamberCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.dissolutionChamberJEICategory});
        this.laserRecipeOreCategory = new LaserDrillOreCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.laserRecipeOreCategory});
        this.laserDrillFluidCategory = new LaserDrillFluidCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.laserDrillFluidCategory});
        this.mycelialGeneratorCategories = new ArrayList<MycelialGeneratorCategory>();
        for (IMycelialGeneratorType type : IMycelialGeneratorType.TYPES) {
            MycelialGeneratorCategory category = new MycelialGeneratorCategory(type, registry.getJeiHelpers().getGuiHelper());
            this.mycelialGeneratorCategories.add(category);
            registry.addRecipeCategories(new IRecipeCategory[]{category});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeUtil.getRecipes((World)Minecraft.func_71410_x().field_71441_e, (IRecipeType)FluidExtractorRecipe.SERIALIZER.getRecipeType()), this.fluidExtractorCategory.getUid());
        registration.addRecipes(RecipeUtil.getRecipes((World)Minecraft.func_71410_x().field_71441_e, (IRecipeType)DissolutionChamberRecipe.SERIALIZER.getRecipeType()), this.dissolutionChamberJEICategory.getUid());
        registration.addRecipes(this.generateBioreactorRecipes(), this.bioReactorRecipeCategory.getUid());
        registration.addRecipes((Collection)RecipeUtil.getRecipes((World)Minecraft.func_71410_x().field_71441_e, (IRecipeType)LaserDrillOreRecipe.SERIALIZER.getRecipeType()).stream().filter(laserDrillOreRecipe -> !laserDrillOreRecipe.output.func_203189_d()).collect(Collectors.toList()), this.laserRecipeOreCategory.getUid());
        registration.addRecipes(RecipeUtil.getRecipes((World)Minecraft.func_71410_x().field_71441_e, (IRecipeType)LaserDrillFluidRecipe.SERIALIZER.getRecipeType()), this.laserDrillFluidCategory.getUid());
        for (int i = 0; i < IMycelialGeneratorType.TYPES.size(); ++i) {
            registration.addRecipes((Collection)IMycelialGeneratorType.TYPES.get(i).getRecipes().stream().sorted(Comparator.comparingInt(value -> ((MycelialGeneratorRecipe)value).getTicks() * ((MycelialGeneratorRecipe)value).getPowerTick()).reversed()).collect(Collectors.toList()), this.mycelialGeneratorCategories.get(i).getUid());
        }
    }

    private List<BioReactorRecipeCategory.ReactorRecipeWrapper> generateBioreactorRecipes() {
        ArrayList<BioReactorRecipeCategory.ReactorRecipeWrapper> recipes = new ArrayList<BioReactorRecipeCategory.ReactorRecipeWrapper>();
        for (ITag<Item> itemTag : BioReactorTile.VALID) {
            for (Item item : itemTag.func_230236_b_()) {
                recipes.add(new BioReactorRecipeCategory.ReactorRecipeWrapper(new ItemStack((IItemProvider)item), new FluidStack((Fluid)ModuleCore.BIOFUEL.getSourceFluid(), 80)));
            }
        }
        return recipes;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleCore.FLUID_EXTRACTOR), new ResourceLocation[]{FluidExtractorCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleCore.DISSOLUTION_CHAMBER), new ResourceLocation[]{DissolutionChamberCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleGenerator.BIOREACTOR), new ResourceLocation[]{BioReactorRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.ORE_LASER_BASE), new ResourceLocation[]{LaserDrillOreCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.LASER_DRILL), new ResourceLocation[]{LaserDrillOreCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.FLUID_LASER_BASE), new ResourceLocation[]{LaserDrillFluidCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.LASER_DRILL), new ResourceLocation[]{LaserDrillFluidCategory.ID});
        for (MycelialGeneratorBlock mycelialGenerator : ModuleGenerator.MYCELIAL_GENERATORS) {
            for (MycelialGeneratorCategory mycelialGeneratorCategory : this.mycelialGeneratorCategories) {
                if (!mycelialGenerator.getType().equals(mycelialGeneratorCategory.getType())) continue;
                registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)mycelialGenerator), new ResourceLocation[]{mycelialGeneratorCategory.getUid()});
            }
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("industrialforegoing", "default");
    }
}

