/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.model;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.block.transport.ConveyorBlock;
import com.buuz135.industrial.module.ModuleTransport;
import com.buuz135.industrial.proxy.client.model.ConveyorModelData;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

public class ConveyorBlockModel
implements IDynamicBakedModel {
    public static Cache<Pair<Pair<String, Pair<Direction, Direction>>, Direction>, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build();
    private VertexFormat format;
    private IBakedModel previousConveyor;
    private Map<Direction, List<BakedQuad>> prevQuads = new HashMap<Direction, List<BakedQuad>>();

    public ConveyorBlockModel(IBakedModel previousConveyor) {
        this.previousConveyor = previousConveyor;
        this.format = DefaultVertexFormats.field_176600_a;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (state == null) {
            if (!this.prevQuads.containsKey(side)) {
                this.prevQuads.put(side, this.previousConveyor.func_200117_a(state, side, rand));
            }
            return this.prevQuads.get(side);
        }
        if (!this.prevQuads.containsKey(side)) {
            this.prevQuads.put(side, this.previousConveyor.func_200117_a(state, side, rand));
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>((Collection)this.prevQuads.get(side));
        if (extraData.hasProperty(ConveyorModelData.UPGRADE_PROPERTY)) {
            for (ConveyorUpgrade upgrade : ((ConveyorModelData)extraData.getData(ConveyorModelData.UPGRADE_PROPERTY)).getUpgrades().values()) {
                if (upgrade == null) continue;
                List upgradeQuads = (List)CACHE.getIfPresent((Object)Pair.of((Object)Pair.of((Object)upgrade.getFactory().getRegistryName().toString(), (Object)Pair.of((Object)upgrade.getSide(), (Object)state.func_177229_b((Property)ConveyorBlock.FACING))), (Object)side));
                if (upgradeQuads == null) {
                    try {
                        IBakedModel model = ModuleTransport.CONVEYOR_UPGRADES_CACHE.get(upgrade.getFactory().getModel(upgrade.getSide(), (Direction)state.func_177229_b((Property)ConveyorBlock.FACING)));
                        upgradeQuads = model.getQuads(state, side, rand, extraData);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    CACHE.put((Object)Pair.of((Object)Pair.of((Object)upgrade.getFactory().getRegistryName().toString(), (Object)Pair.of((Object)upgrade.getSide(), (Object)state.func_177229_b((Property)ConveyorBlock.FACING))), (Object)side), (Object)upgradeQuads);
                }
                if (upgradeQuads.isEmpty()) continue;
                quads.addAll(upgradeQuads);
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.previousConveyor.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.previousConveyor.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.previousConveyor.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.previousConveyor.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.previousConveyor.func_177554_e();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.previousConveyor.func_188617_f();
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        return this.previousConveyor.handlePerspective(cameraTransformType, mat);
    }

    public ItemCameraTransforms func_177552_f() {
        return this.previousConveyor.func_177552_f();
    }
}

