/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleVex
extends Particle {
    private final Entity entity;
    private List<Direction> directions;
    private List<Vector3d> lines;
    private boolean isDying = false;

    public ParticleVex(Entity entity) {
        super((ClientWorld)entity.field_70170_p, entity.func_226277_ct_() + entity.field_70170_p.field_73012_v.nextDouble() - 0.5, entity.func_226278_cu_() + 1.0 + entity.field_70170_p.field_73012_v.nextDouble() - 0.5, entity.func_226281_cx_() + entity.field_70170_p.field_73012_v.nextDouble() - 0.5);
        this.entity = entity;
        this.directions = new ArrayList<Direction>();
        Direction prev = Direction.NORTH;
        this.directions.add(0, prev);
        for (int i = 1; i < 50; ++i) {
            prev = this.directions.get(i - 1);
            this.directions.add(i, this.field_187122_b.field_73012_v.nextDouble() < 0.05 ? this.getRandomFacing(this.field_187122_b.field_73012_v, prev) : prev);
        }
        this.calculateLines();
        this.field_70547_e = 500;
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.entity.func_233580_cy_().func_218140_a(this.field_187126_f, this.field_187127_g, this.field_187128_h, true) > 2.0) {
            this.isDying = true;
        }
        if (!this.isDying && !this.field_187133_m) {
            this.directions.add(0, this.field_187122_b.field_73012_v.nextDouble() < 0.05 ? this.getRandomFacing(this.field_187122_b.field_73012_v, this.directions.get(0)) : this.directions.get(0));
            this.directions.remove(50);
            Vector3d directionVector = new Vector3d((double)this.directions.get(0).func_176730_m().func_177958_n(), (double)this.directions.get(0).func_176730_m().func_177956_o(), (double)this.directions.get(0).func_176730_m().func_177952_p()).func_186678_a(0.01);
            this.func_187109_b(this.field_187126_f - directionVector.field_72450_a, this.field_187127_g - directionVector.field_72448_b, this.field_187128_h - directionVector.field_72449_c);
            this.calculateLines();
        } else {
            this.directions.remove(this.directions.size() - 1);
            this.calculateLines();
            if (this.directions.isEmpty()) {
                this.func_187112_i();
            }
        }
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo activeRenderInfo, float v) {
        if (this.entity instanceof ClientPlayerEntity && Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(this.entity.func_110124_au()) && Minecraft.func_71410_x().field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON && this.entity.func_233580_cy_().func_177982_a(0, 1, 0).func_218140_a(this.field_187126_f, this.field_187127_g, this.field_187128_h, false) < 3.0) {
            return;
        }
        Vector3d vector3d = activeRenderInfo.func_216785_c();
        double x = this.entity.field_70142_S + (vector3d.field_72450_a - this.entity.field_70142_S);
        double y = this.entity.field_70137_T + (vector3d.field_72448_b - this.entity.field_70137_T);
        double z = this.entity.field_70136_U + (vector3d.field_72449_c - this.entity.field_70136_U);
        for (Vector3d line : this.lines) {
            buffer.func_225582_a_(line.field_72450_a - x, line.field_72448_b - y, line.field_72449_c - z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225587_b_(240, 240).func_181675_d();
        }
    }

    public IParticleRenderType func_217558_b() {
        return new IParticleRenderType(){

            public void func_217600_a(BufferBuilder builder, TextureManager manager) {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.lineWidth((float)2.0f);
                RenderSystem.disableTexture();
                builder.func_181668_a(3, DefaultVertexFormats.field_227850_m_);
            }

            public void func_217599_a(Tessellator tessellator) {
                tessellator.func_78381_a();
                RenderSystem.disableBlend();
                RenderSystem.enableTexture();
            }
        };
    }

    private Direction getRandomFacing(Random random, Direction opposite) {
        Direction facing = Direction.func_239631_a_((Random)random);
        while (facing.func_176734_d().equals((Object)opposite)) {
            facing = Direction.func_239631_a_((Random)random);
        }
        return facing;
    }

    private void calculateLines() {
        this.lines = new ArrayList<Vector3d>();
        if (this.directions.size() == 0) {
            return;
        }
        Direction prev = this.directions.get(0);
        int currentPosition = 0;
        Vector3d prevBlockPos = new Vector3d(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        this.lines.add(prevBlockPos);
        for (int i = 1; i < this.directions.size(); ++i) {
            if (this.directions.get(i).equals((Object)prev) && i != this.directions.size() - 1) continue;
            Vector3d directionVector = new Vector3d((double)prev.func_176730_m().func_177958_n(), (double)prev.func_176730_m().func_177956_o(), (double)prev.func_176730_m().func_177952_p()).func_186678_a(0.01);
            Vector3d endBlockPos = new Vector3d(prevBlockPos.field_72450_a + directionVector.field_72450_a * (double)(i - currentPosition), prevBlockPos.field_72448_b + directionVector.field_72448_b * (double)(i - currentPosition), prevBlockPos.field_72449_c + directionVector.field_72449_c * (double)(i - currentPosition));
            this.lines.add(endBlockPos);
            prev = this.directions.get(i);
            currentPosition = i;
            prevBlockPos = endBlockPos;
        }
    }
}

